/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.voucher;

import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Fundsource;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.Vouchermis;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.egf.commons.VoucherSearchUtil;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.bills.EgBillregistermis;
import org.egov.services.payment.PaymentService;
import org.egov.utils.FinancialConstants;
import org.egov.utils.VoucherHelper;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"search"}, location="cancelVoucher-search.jsp")})
public class CancelVoucherAction
extends BaseFormAction {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private static final long serialVersionUID = -8065315728701853083L;
    private static final Logger LOGGER = Logger.getLogger(CancelVoucherAction.class);
    public static final Locale LOCALE = new Locale("en", "IN");
    public static final SimpleDateFormat DDMMYYYYFORMATS = new SimpleDateFormat("dd/MM/yyyy", LOCALE);
    private final List<String> headerFields = new ArrayList();
    private final List<String> mandatoryFields = new ArrayList();
    private CVoucherHeader voucherHeader = new CVoucherHeader();
    private Map<String, String> nameMap;
    private VoucherSearchUtil voucherSearchUtil;
    private PaymentService paymentService;
    private Date fromDate;
    private Date toDate;
    private Long[] selectedVhs;
    protected static final String SEARCH = "search";
    Integer loggedInUser;
    public List<CVoucherHeader> voucherSearchList = new ArrayList();
    private PersistenceService<CVoucherHeader, Long> cVoucherHeaderPersistanceService;
    List<CVoucherHeader> voucherList;
    List<String> voucherTypes = VoucherHelper.VOUCHER_TYPES;
    Map<String, List<String>> voucherNames = VoucherHelper.VOUCHER_TYPE_NAMES;
    private FinancialYearDAO financialYearDAO;
    @Autowired
    private AppConfigValueService appConfigValueService;

    public CancelVoucherAction() {
        this.voucherHeader.setVouchermis(new Vouchermis());
        this.addRelatedEntity("vouchermis.departmentid", Department.class);
        this.addRelatedEntity("fundId", Fund.class);
        this.addRelatedEntity("vouchermis.schemeid", Scheme.class);
        this.addRelatedEntity("vouchermis.subschemeid", SubScheme.class);
        this.addRelatedEntity("vouchermis.functionary", Functionary.class);
        this.addRelatedEntity("vouchermis.divisionid", Boundary.class);
        this.addRelatedEntity("fundsourceId", Fundsource.class);
    }

    public Object getModel() {
        return this.voucherHeader;
    }

    public void prepare() {
        this.loggedInUser = ApplicationThreadLocals.getUserId().intValue();
        super.prepare();
        this.getHeaderFields();
        this.loadDropDowns();
    }

    @SkipValidation
    @Action(value="/voucher/cancelVoucher-beforeSearch")
    public String beforeSearch() {
        this.voucherHeader.reset();
        this.setFromDate(null);
        this.setToDate(null);
        return SEARCH;
    }

    @ValidationErrorPage(value="search")
    @Action(value="/voucher/cancelVoucher-search")
    public String search() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("...Searching for voucher of type " + this.voucherHeader.getType()));
        }
        this.voucherSearchList = this.getVouchersForCancellation();
        return SEARCH;
    }

    private boolean isSuperUser() {
        SQLQuery queryFnd = this.persistenceService.getSession().createSQLQuery(" SELECT usrr.USERID FROM EG_USERROLE usrr,  EG_ROLE r WHERE  usrr.ROLEID=r.ID and  usrr.userid     =" + this.loggedInUser + " AND  lower(r.NAME)='" + "super user" + "'");
        List superUserList = queryFnd.list();
        return superUserList != null && superUserList.size() > 0;
    }

    private List<CVoucherHeader> getVouchersForCancellation() {
        String filterQry = "";
        boolean validateFinancialYearForPosting = this.voucherSearchUtil.validateFinancialYearForPosting(this.fromDate, this.toDate);
        if (!validateFinancialYearForPosting) {
            throw new ValidationException(Arrays.asList(new ValidationError("Financial Year  Not active for Posting(either year or date within selected date range)", "Financial Year  Not active for Posting(either year or date within selected date range)")));
        }
        String filter = this.voucherSearchUtil.voucherFilterQuery(this.voucherHeader, this.fromDate, this.toDate, "");
        String userCond = "";
        this.voucherList = new ArrayList();
        ArrayList toBeRemovedList = new ArrayList();
        userCond = this.isSuperUser() ? " " : " and vh.createdBy=" + this.loggedInUser;
        filterQry = filter + userCond + "  order by vh.voucherNumber";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"......Searching voucher for cancelllation...");
        }
        if (this.voucherHeader.getType().equalsIgnoreCase("Journal Voucher")) {
            String voucheerWithNoPayment = "from CVoucherHeader vh where vh not in ( select billVoucherHeader from Miscbilldetail) and vh.status in (" + FinancialConstants.CREATEDVOUCHERSTATUS + ")  and (vh.isConfirmed != 1 or vh.isConfirmed is null)";
            String allPayment = "select distinct(vh) from  Miscbilldetail misc left join misc.billVoucherHeader vh where misc.billVoucherHeader is not null and (vh.isConfirmed != 1  or  vh.isConfirmed  is null )and vh.status in (" + FinancialConstants.CREATEDVOUCHERSTATUS + ")";
            this.voucherList.addAll(this.persistenceService.findAllBy(voucheerWithNoPayment + filterQry, new Object[0]));
            this.voucherList.addAll(this.persistenceService.findAllBy(allPayment + filterQry, new Object[0]));
            String editModeQuery3 = " select misc.billVoucherHeader.id from CVoucherHeader ph, Miscbilldetail misc,CVoucherHeader vh  where  misc.payVoucherHeader=ph and   misc.billVoucherHeader is not null and misc.billVoucherHeader=vh  and ph.status  in (" + FinancialConstants.CREATEDVOUCHERSTATUS + "," + FinancialConstants.PREAPPROVEDVOUCHERSTATUS + ") and (vh.isConfirmed != 1 or  vh.isConfirmed is null) ";
            List vouchersHavingActivePayments = this.persistenceService.findAllBy(editModeQuery3 + filterQry, new Object[0]);
            String uncancelledRemittances = " SELECT distinct(vh.id) FROM EgRemittanceDetail r, EgRemittanceGldtl rgd, Generalledgerdetail gld,  CGeneralLedger gl, EgRemittance rd, CVoucherHeader vh ,Vouchermis billmis, CVoucherHeader remittedvh  WHERE  r.egRemittanceGldtl=rgd AND rgd.generalledgerdetail=gld AND gld.generalledger=gl AND r.egRemittance=rd AND rd.voucherheader=remittedvh AND gl.voucherHeaderId =vh  AND  remittedvh =billmis.voucherheaderid and remittedvh.status!=" + FinancialConstants.CANCELLEDVOUCHERSTATUS + " ";
            List remittanceBillVhIdList = this.persistenceService.findAllBy(uncancelledRemittances + filter + userCond, new Object[0]);
            remittanceBillVhIdList.addAll(vouchersHavingActivePayments);
            if (this.voucherList != null && this.voucherList.size() != 0 && remittanceBillVhIdList != null && remittanceBillVhIdList.size() != 0) {
                for (int i = 0; i < this.voucherList.size(); ++i) {
                    if (!remittanceBillVhIdList.contains(((CVoucherHeader)this.voucherList.get(i)).getId())) continue;
                    toBeRemovedList.add(this.voucherList.get(i));
                }
                for (CVoucherHeader vh : toBeRemovedList) {
                    this.voucherList.remove(vh);
                }
            }
        } else if (this.voucherHeader.getType().equalsIgnoreCase("Payment")) {
            String qryStr = filter;
            String filterQuerySql = "";
            String misTab = "";
            String VoucherMisJoin = "";
            if (qryStr.contains(" and vh.vouchermis")) {
                misTab = ", vouchermis mis ";
                VoucherMisJoin = " and vh.id=mis.voucherheaderid";
                filterQuerySql = qryStr.replace("and vh.vouchermis.", " and mis.");
            } else {
                filterQuerySql = filter;
            }
            String noChequePaymentQry = "from CVoucherHeader vh where vh.status not in (" + FinancialConstants.PREAPPROVEDVOUCHERSTATUS + "," + FinancialConstants.CANCELLEDVOUCHERSTATUS + ")  " + filter + "  and not Exists(select 'true' from InstrumentVoucher iv where iv.voucherHeaderId=vh.id) order by vh.voucherNumber)";
            this.voucherList.addAll(this.persistenceService.findAllBy(noChequePaymentQry, new Object[0]));
            SQLQuery query1 = this.persistenceService.getSession().createSQLQuery("SELECT distinct vh.id FROM egw_status status" + misTab + ", voucherheader vh \t LEFT JOIN EGF_INSTRUMENTVOUCHER IV ON VH.ID=IV.VOUCHERHEADERID\tLEFT JOIN EGF_INSTRUMENTHEADER IH ON IV.INSTRUMENTHEADERID=IH.ID INNER JOIN (SELECT MAX(iv1.instrumentheaderid) AS maxihid, iv1.voucherheaderid               AS iv1vhid   FROM egf_instrumentvoucher iv1 GROUP BY iv1.voucherheaderid)as INST ON maxihid=IH.ID  WHERE\tIV.VOUCHERHEADERID  IS NOT NULL\tAND status.description   IN ('" + "Cancelled" + "','" + "Surrendered" + "','" + "Surrender_For_Reassign" + "') and status.id=ih.id_status and vh.status not in (" + FinancialConstants.PREAPPROVEDVOUCHERSTATUS + "," + FinancialConstants.CANCELLEDVOUCHERSTATUS + ") " + VoucherMisJoin + filterQuerySql);
            List list = query1.list();
            for (BigInteger b : list) {
                this.voucherList.add((CVoucherHeader)this.persistenceService.find("from CVoucherHeader  where id=?", new Object[]{b.longValue()}));
            }
        } else if (this.voucherHeader.getType().equalsIgnoreCase("Contra")) {
            String contraVoucherQry = "from CVoucherHeader vh where vh.status =" + FinancialConstants.CREATEDVOUCHERSTATUS + " and ( vh.isConfirmed != 1 or vh.isConfirmed is null) ";
            this.persistenceService.findAllBy(contraVoucherQry + filterQry, new Object[0]);
            this.voucherList.addAll(this.persistenceService.findAllBy(contraVoucherQry + filterQry, new Object[0]));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("......No of voucher found in search for is cancellation ..." + this.voucherList.size()));
        }
        return this.voucherList;
    }

    @SkipValidation
    public void validateBeforeCancel(CVoucherHeader voucherObj) {
        try {
            this.financialYearDAO.getFinancialYearByDate(voucherObj.getVoucherDate());
        }
        catch (Exception e) {
            this.addActionError("Voucher Cancellation failed for " + voucherObj.getVoucherNumber());
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
    }

    @ValidationErrorPage(value="search")
    @SkipValidation
    @Action(value="/voucher/cancelVoucher-update")
    public String update() {
        Date modifiedDate = new Date();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Inside CancelVoucher| cancelVoucherSubmit | Selected No of Vouchers for cancellation  =" + this.selectedVhs.length));
        }
        String cancelVhQuery = "Update CVoucherHeader vh set vh.status=" + FinancialConstants.CANCELLEDVOUCHERSTATUS + ",vh.lastModifiedBy.id=:modifiedby, vh.lastModifiedDate=:modifiedDate   where vh.id=:vhId";
        String cancelVhByCGNQuery = "Update CVoucherHeader vh set vh.status=" + FinancialConstants.CANCELLEDVOUCHERSTATUS + ",vh.lastModifiedBy.id=:modifiedby , vh.lastModifiedDate=:modifiedDate where vh.refvhId=:vhId";
        String cancelVhByRefCGNQuery = "Update CVoucherHeader vh set vh.status=" + FinancialConstants.CANCELLEDVOUCHERSTATUS + ",vh.lastModifiedBy.id=:modifiedby , vh.lastModifiedDate=:modifiedDate where vh.voucherNumber=:vhNum";
        Session session = this.persistenceService.getSession();
        for (int i = 0; i < this.selectedVhs.length; ++i) {
            Query query;
            CVoucherHeader voucherObj = (CVoucherHeader)this.persistenceService.find("from CVoucherHeader vh where vh.id=?", new Object[]{this.selectedVhs[i]});
            this.validateBeforeCancel(voucherObj);
            if ("Journal Voucher".equalsIgnoreCase(voucherObj.getType())) {
                query = session.createQuery(cancelVhQuery);
                query.setLong("modifiedby", (long)this.loggedInUser.intValue());
                query.setDate("modifiedDate", modifiedDate);
                query.setLong("vhId", this.selectedVhs[i].longValue());
                query.executeUpdate();
                if (voucherObj.getState() == null && !voucherObj.getName().equals("JVGeneral")) {
                    this.cancelBill(this.selectedVhs[i]);
                    continue;
                }
                if (voucherObj.getState() == null || voucherObj.getName().equals("JVGeneral")) continue;
                this.cancelBill(this.selectedVhs[i]);
                continue;
            }
            if ("Payment".equalsIgnoreCase(voucherObj.getType())) {
                query = session.createQuery(cancelVhQuery);
                query.setLong("vhId", this.selectedVhs[i].longValue());
                query.setLong("modifiedby", (long)this.loggedInUser.intValue());
                query.setDate("modifiedDate", modifiedDate);
                query.executeUpdate();
                if (!"Remittance Payment".equalsIgnoreCase(voucherObj.getName())) continue;
                int n = this.paymentService.backUpdateRemittanceDateInGL(this.voucherHeader.getId());
                continue;
            }
            if ("Contra".equalsIgnoreCase(voucherObj.getType())) {
                query = session.createQuery(cancelVhQuery);
                query.setLong("vhId", this.selectedVhs[i].longValue());
                query.setLong("modifiedby", (long)this.loggedInUser.intValue());
                query.setDate("modifiedDate", modifiedDate);
                query.executeUpdate();
                if (!"InterFundTransfer".equalsIgnoreCase(voucherObj.getName())) continue;
                Long vhId = voucherObj.getId();
                Query queryFnd = session.createQuery(cancelVhByCGNQuery);
                queryFnd.setLong("vhId", vhId.longValue());
                queryFnd.setLong("modifiedby", (long)this.loggedInUser.intValue());
                queryFnd.setDate("modifiedDate", modifiedDate);
                queryFnd.executeUpdate();
                continue;
            }
            if (!"Receipt".equalsIgnoreCase(voucherObj.getType())) continue;
            query = session.createQuery(cancelVhQuery);
            query.setLong("vhId", this.selectedVhs[i].longValue());
            query.setLong("modifiedby", (long)this.loggedInUser.intValue());
            query.setDate("modifiedDate", modifiedDate);
            query.executeUpdate();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)" Cancel Voucher | CancelVoucher | Vouchers Cancelled ");
        }
        this.addActionMessage(this.getText("Vouchers Cancelled Succesfully"));
        return SEARCH;
    }

    private void cancelBill(Long vhId) {
        StringBuffer billQuery = new StringBuffer();
        String statusQuery = "(select stat.id from  egw_status  stat where stat.moduletype=:module and stat.description=:description)";
        String cancelQuery = "Update eg_billregister set billstatus=:billstatus , statusid =(select stat.id from  egw_status  stat where stat.moduletype=:module and stat.description=:description) where  id=:billId";
        String moduleType = "";
        String description = "";
        String billstatus = "";
        EgBillregistermis billMis = (EgBillregistermis)this.persistenceService.find("from  EgBillregistermis  mis where voucherHeader.id=?", new Object[]{vhId});
        if (billMis != null && billMis.getEgBillregister().getState() == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"....Cancelling Bill Associated with the Voucher....");
            }
            billQuery.append("select bill.expendituretype,bill.id,bill.state.id from CVoucherHeader vh,EgBillregister bill ,EgBillregistermis mis").append(" where vh.id=mis.voucherHeader and bill.id=mis.egBillregister and vh.id=" + vhId);
            Object[] bill = (Object[])this.persistenceService.find(billQuery.toString());
            if ("Salary".equalsIgnoreCase(bill[0].toString())) {
                billstatus = "SALBILL";
                description = "Cancelled";
                moduleType = "SALBILL";
            } else if ("Expense".equalsIgnoreCase(bill[0].toString())) {
                for (String retval : "'TNEB'".split(",")) {
                    retval = retval.replace("'", "");
                    if (billMis.getEgBillSubType() == null || !billMis.getEgBillSubType().getName().equalsIgnoreCase(retval)) continue;
                    return;
                }
                billstatus = "Cancelled";
                description = "Cancelled";
                moduleType = "EXPENSEBILL";
            } else if ("Purchase".equalsIgnoreCase(bill[0].toString())) {
                billstatus = "Cancelled";
                description = "Cancelled";
                moduleType = "PURCHBILL";
            } else if ("Works".equalsIgnoreCase(bill[0].toString())) {
                billstatus = "Cancelled";
                description = "Cancelled";
                moduleType = "WORKSBILL";
            } else if ("Pension".equalsIgnoreCase(bill[0].toString()) && (Integer)bill[2] == null) {
                billstatus = "Cancelled";
                description = "Cancelled";
                moduleType = "PENSIONBILL";
            }
            SQLQuery billQry = this.persistenceService.getSession().createSQLQuery("Update eg_billregister set billstatus=:billstatus , statusid =(select stat.id from  egw_status  stat where stat.moduletype=:module and stat.description=:description) where  id=:billId".toString());
            billQry.setString("module", moduleType);
            billQry.setString("description", description);
            billQry.setString("billstatus", billstatus);
            billQry.setLong("billId", ((Long)bill[1]).longValue());
            billQry.executeUpdate();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Bill Cancelled Successfully" + bill[1]));
            }
        }
    }

    private void loadDropDowns() {
        if (this.headerFields.contains("department")) {
            this.addDropdownData("departmentList", this.persistenceService.findAllBy("from Department order by name", new Object[0]));
        }
        if (this.headerFields.contains("functionary")) {
            this.addDropdownData("functionaryList", this.persistenceService.findAllBy(" from Functionary where isactive=true order by name", new Object[0]));
        }
        if (this.headerFields.contains("fund")) {
            this.addDropdownData("fundList", this.persistenceService.findAllBy(" from Fund where isactive=true and isnotleaf=false order by name", new Object[0]));
        }
        if (this.headerFields.contains("fundsource")) {
            this.addDropdownData("fundsourceList", this.persistenceService.findAllBy(" from Fundsource where isactive=true order by name", new Object[0]));
        }
        if (this.headerFields.contains("field")) {
            this.addDropdownData("fieldList", this.persistenceService.findAllBy(" from Boundary b where lower(b.boundaryType.name)='ward' ", new Object[0]));
        }
        if (this.headerFields.contains("scheme")) {
            this.addDropdownData("schemeList", Collections.EMPTY_LIST);
        }
        if (this.headerFields.contains("subscheme")) {
            this.addDropdownData("subschemeList", Collections.EMPTY_LIST);
        }
        this.addDropdownData("typeList", VoucherHelper.VOUCHER_TYPES);
        this.nameMap = new LinkedHashMap();
    }

    public void validate() {
        if (this.fromDate == null) {
            this.addFieldError("From Date", this.getText("Please Enter From Date"));
        }
        if (this.toDate == null) {
            this.addFieldError("To Date", this.getText("Please Enter To Date"));
        }
        if (this.voucherHeader.getType() == null || this.voucherHeader.getType().equals("-1")) {
            this.addFieldError("Voucher Type", this.getText("Please Select Voucher Type"));
        }
        if (this.voucherHeader.getName() == null || this.voucherHeader.getName().equals("-1") || this.voucherHeader.getName().equals("0")) {
            this.addFieldError("Voucher Type", this.getText("Please Select Voucher Name"));
        }
        int checKDate = 0;
        if (this.fromDate != null && this.toDate != null) {
            checKDate = this.fromDate.compareTo(this.toDate);
        }
        if (checKDate > 0) {
            this.addFieldError("To Date", this.getText("Please Enter To Date Greater than From Date"));
        }
        this.checkMandatoryField("fundId", "fund", (Object)this.voucherHeader.getFundId(), "voucher.fund.mandatory");
        this.checkMandatoryField("vouchermis.departmentid", "department", (Object)this.voucherHeader.getVouchermis().getDepartmentid(), "voucher.department.mandatory");
        this.checkMandatoryField("vouchermis.schemeid", "scheme", (Object)this.voucherHeader.getVouchermis().getSchemeid(), "voucher.scheme.mandatory");
        this.checkMandatoryField("vouchermis.subschemeid", "subscheme", (Object)this.voucherHeader.getVouchermis().getSubschemeid(), "voucher.subscheme.mandatory");
        this.checkMandatoryField("vouchermis.functionary", "functionary", (Object)this.voucherHeader.getVouchermis().getFunctionary(), "voucher.functionary.mandatory");
        this.checkMandatoryField("fundsourceId", "fundsource", (Object)this.voucherHeader.getVouchermis().getFundsource(), "voucher.fundsource.mandatory");
        this.checkMandatoryField("vouchermis.divisionId", "field", (Object)this.voucherHeader.getVouchermis().getDivisionid(), "voucher.field.mandatory");
    }

    protected void getHeaderFields() {
        List appConfigList = this.appConfigValueService.getConfigValuesByModuleAndKey("EGF", "DEFAULT_SEARCH_MISATTRRIBUTES");
        for (AppConfigValues appConfigVal : appConfigList) {
            String value = appConfigVal.getValue();
            String header = value.substring(0, value.indexOf(124));
            this.headerFields.add(header);
            String mandate = value.substring(value.indexOf(124) + 1);
            if (!mandate.equalsIgnoreCase("M")) continue;
            this.mandatoryFields.add(header);
        }
    }

    protected void checkMandatoryField(String objectName, String fieldName, Object value, String errorKey) {
        if (this.mandatoryFields.contains(fieldName) && (value == null || value.equals(-1))) {
            this.addFieldError(objectName, this.getText(errorKey));
        }
    }

    public boolean isFieldMandatory(String field) {
        return this.mandatoryFields.contains(field);
    }

    public boolean shouldShowHeaderField(String field) {
        return this.headerFields.contains(field);
    }

    public CVoucherHeader getVoucherHeader() {
        return this.voucherHeader;
    }

    public void setVoucherHeader(CVoucherHeader voucherHeader) {
        this.voucherHeader = voucherHeader;
    }

    public Map<String, String> getNameMap() {
        return this.nameMap;
    }

    public void setNameMap(Map<String, String> nameMap) {
        this.nameMap = nameMap;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public VoucherSearchUtil getVoucherSearchUtil() {
        return this.voucherSearchUtil;
    }

    public void setVoucherSearchUtil(VoucherSearchUtil voucherSearchUtil) {
        this.voucherSearchUtil = voucherSearchUtil;
    }

    public List<CVoucherHeader> getVoucherSearchList() {
        return this.voucherSearchList;
    }

    public void setVoucherSearchList(List<CVoucherHeader> voucherSearchList) {
        this.voucherSearchList = voucherSearchList;
    }

    public Long[] getSelectedVhs() {
        return this.selectedVhs;
    }

    public void setSelectedVhs(Long[] selectedVhs) {
        this.selectedVhs = selectedVhs;
    }

    public List<CVoucherHeader> getVoucherList() {
        return this.voucherList;
    }

    public void setVoucherList(List<CVoucherHeader> voucherList) {
        this.voucherList = voucherList;
    }

    public List<String> getVoucherTypes() {
        return this.voucherTypes;
    }

    public void setVoucherTypes(List<String> voucherTypes) {
        this.voucherTypes = voucherTypes;
    }

    public Map<String, List<String>> getVoucherNames() {
        return this.voucherNames;
    }

    public void setVoucherNames(Map<String, List<String>> voucherNames) {
        this.voucherNames = voucherNames;
    }

    public PaymentService getPaymentService() {
        return this.paymentService;
    }

    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    public void setFinancialYearDAO(FinancialYearDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }
}

