/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.masters;

import com.google.gson.GsonBuilder;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.egov.commons.Bank;
import org.egov.commons.Bankbranch;
import org.egov.egf.web.actions.masters.JQueryGridActionSupport;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.services.PersistenceService;

@ParentPackage(value="egov")
public class BankBranchAction
extends JQueryGridActionSupport {
    private static final long serialVersionUID = 1L;
    private String mode;
    private Integer bankId;
    private PersistenceService<Bankbranch, Integer> bankBranchService;
    private boolean isActive;

    public String execute() {
        if ("CRUD".equals(this.mode)) {
            try {
                if (this.oper.equals("add")) {
                    this.addBankBranch();
                } else if (this.oper.equals("edit")) {
                    this.editBankBranch();
                } else if (this.oper.equals("del")) {
                    this.deleteBankBranch();
                }
                this.sendAJAXResponse("success");
            }
            catch (RuntimeException e) {
                this.sendAJAXResponse("failed");
                throw new ApplicationRuntimeException("Error occurred in Bank Branch.", (Throwable)e);
            }
        } else if ("LIST_BRANCH".equals(this.mode)) {
            this.listAllBankBranches();
        } else if ("CHECK_UNQ_MICR".equals(this.mode)) {
            this.sendAJAXResponse(String.valueOf(this.checkIsUniqueMicr()));
        } else if ("CHECK_BANK_ACC".equals(this.mode)) {
            this.sendAJAXResponse(String.valueOf(this.checkBankAccountsExists()));
        }
        return null;
    }

    private void addBankBranch() {
        Bank bank = (Bank)this.bankBranchService.getSession().load(Bank.class, (Serializable)this.bankId);
        Date currentDate = new Date();
        Bankbranch bankBranch = new Bankbranch();
        bankBranch.setBank(bank);
        bankBranch.setCreated(currentDate);
        this.populateBankBranchDetail(bankBranch);
        this.bankBranchService.persist((Object)bankBranch);
    }

    private void editBankBranch() {
        Bankbranch bankBranch = (Bankbranch)this.bankBranchService.getSession().get(Bankbranch.class, (Serializable)this.id);
        this.populateBankBranchDetail(bankBranch);
        this.bankBranchService.update((Object)bankBranch);
    }

    private void deleteBankBranch() {
        Bankbranch bankBranch = (Bankbranch)this.bankBranchService.getSession().load(Bankbranch.class, (Serializable)this.id);
        this.bankBranchService.delete((Object)bankBranch);
    }

    private void populateBankBranchDetail(Bankbranch bankBranch) {
        HttpServletRequest request = ServletActionContext.getRequest();
        bankBranch.setModifiedby(BigDecimal.valueOf(ApplicationThreadLocals.getUserId()));
        bankBranch.setLastmodified(new Date());
        bankBranch.setBranchcode(request.getParameter("branchcode"));
        bankBranch.setBranchname(request.getParameter("branchname"));
        bankBranch.setBranchaddress1(request.getParameter("branchaddress1"));
        bankBranch.setIsactive(Boolean.valueOf(request.getParameter("isActive").equals("Y")));
        this.isActive = bankBranch.getIsactive() != false;
        bankBranch.setBranchaddress2(request.getParameter("branchaddress2"));
        bankBranch.setBranchcity(request.getParameter("branchcity"));
        bankBranch.setBranchstate(request.getParameter("branchstate"));
        bankBranch.setBranchpin(request.getParameter("branchpin"));
        bankBranch.setBranchphone(request.getParameter("branchphone"));
        bankBranch.setBranchfax(request.getParameter("branchfax"));
        bankBranch.setContactperson(request.getParameter("contactperson"));
        bankBranch.setNarration(request.getParameter("narration"));
        if (StringUtils.isNotBlank((String)request.getParameter("branchMICR"))) {
            bankBranch.setBranchMICR(BigDecimal.valueOf(Long.valueOf(request.getParameter("branchMICR"))).toString());
        }
    }

    private void listAllBankBranches() {
        List bankBranches = this.getPagedResult(Bankbranch.class, "bank.id", (Object)this.bankId).getList();
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        for (Bankbranch bankbranch : bankBranches) {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put((Object)"id", (Object)bankbranch.getId());
                jsonObject.put((Object)"branchname", (Object)bankbranch.getBranchname());
                jsonObject.put((Object)"branchcode", (Object)bankbranch.getBranchcode());
                jsonObject.put((Object)"branchMICR", (Object)bankbranch.getBranchMICR());
                jsonObject.put((Object)"branchaddress1", (Object)bankbranch.getBranchaddress1());
                jsonObject.put((Object)"contactperson", (Object)bankbranch.getContactperson());
                jsonObject.put((Object)"branchphone", (Object)bankbranch.getBranchphone());
                jsonObject.put((Object)"narration", (Object)bankbranch.getNarration());
                jsonObject.put((Object)"isActive", (Object)(bankbranch.getIsactive() != false ? "Y" : "N"));
                jsonObjects.add(jsonObject);
            }
            catch (JSONException e) {
                this.sendAJAXResponse("error");
            }
        }
        String jsonString = new GsonBuilder().create().toJson(jsonObjects);
        this.sendAJAXResponse(this.constructJqGridResponse(jsonString));
    }

    private boolean checkBankAccountsExists() {
        Bankbranch branch = null;
        if (this.id != null) {
            branch = (Bankbranch)this.bankBranchService.find("from Bankbranch where id=?", new Object[]{this.id});
        }
        return branch != null && branch.isAccountsExist();
    }

    private boolean checkIsUniqueMicr() {
        boolean isUnique = true;
        String branchMICR = ServletActionContext.getRequest().getParameter("branchMICR");
        if (branchMICR != null && this.id != null) {
            isUnique = null == this.bankBranchService.find("from Bankbranch where branchMICR=? and id!=?", new Object[]{branchMICR, this.id});
        } else if (branchMICR != null) {
            isUnique = null == this.bankBranchService.find("from Bankbranch where branchMICR=?", new Object[]{branchMICR});
        }
        return isUnique;
    }

    public PersistenceService<Bankbranch, Integer> getBankBranchService() {
        return this.bankBranchService;
    }

    public void setBankBranchService(PersistenceService<Bankbranch, Integer> bankBranchService) {
        this.bankBranchService = bankBranchService;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setBankId(Integer bankId) {
        this.bankId = bankId;
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }
}

