/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.deduction;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.dao.recoveries.TdsHibernateDAO;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.deduction.DepartmentDOMapping;
import org.egov.model.recoveries.Recovery;
import org.egov.model.recoveries.RemittanceSchedulerLog;
import org.egov.services.deduction.ScheduledRemittanceService;
import org.egov.utils.FinancialConstants;
import org.hibernate.HibernateException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name={"manual"}, location="autoRemittance-manual.jsp")})
public class AutoRemittanceAction
extends BaseFormAction {
    private static final long serialVersionUID = 453551610004473622L;
    private static final Logger LOGGER = Logger.getLogger(AutoRemittanceAction.class);
    private ScheduledRemittanceService scheduledRemittanceService;
    private String glcode;
    private Integer dept;
    private String drawingOfficer;
    private Date lastRunDate;
    private Map<String, String> coaMap;
    private List<DepartmentDOMapping> deptDOList;
    private RemittanceSchedulerLog remittanceScheduler;
    private Map<String, String> lastRunDateMap;
    private TdsHibernateDAO tdsDAO;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;

    public Object getModel() {
        return null;
    }

    @Action(value="/deduction/autoRemittance-manualSchedule")
    public String manualSchedule() {
        try {
            this.coaMap = new LinkedHashMap();
            List allActiveAutoRemitTds = this.tdsDAO.getAllActiveAutoRemitTds();
            for (Recovery r : allActiveAutoRemitTds) {
                this.coaMap.put(r.getChartofaccounts().getGlcode(), r.getChartofaccounts().getGlcode() + "-" + r.getChartofaccounts().getName());
            }
            this.addDropdownData("departmentList", this.masterDataCache.get("egi-department"));
            this.deptDOList = this.persistenceService.findAllBy("from DepartmentDOMapping where department is not null  ", new Object[0]);
            List list = this.persistenceService.getSession().createSQLQuery("select glcode, to_char(max(lastrundate),'dd/mm/yyyy') from egf_remittance_scheduler where glcode is not null and sch_type='A'  GROUP by glcode order by glcode").list();
            this.lastRunDateMap = new HashMap();
            for (Object[] ob : list) {
                this.lastRunDateMap.put((String)ob[0], (String)ob[1]);
            }
        }
        catch (ApplicationRuntimeException e) {
            this.addActionError("failed");
        }
        catch (HibernateException e) {
            this.addActionError("failed");
        }
        catch (Exception e) {
            this.addActionError("failed");
        }
        return "manual";
    }

    @ValidationErrorPage(value="messages")
    public String schedule() {
        try {
            LOGGER.info((Object)"Inside RemittanceJob");
            this.remittanceScheduler = new RemittanceSchedulerLog();
            this.remittanceScheduler.setGlcode(this.glcode);
            this.remittanceScheduler.setSchType(FinancialConstants.REMITTANCE_SCHEDULER_SCHEDULAR_TYPE_MANUAL);
            this.remittanceScheduler.setSchJobName("Manual");
            this.remittanceScheduler.setLastRunDate(new Date());
            this.remittanceScheduler.setCreatedDate(new Date());
            this.remittanceScheduler.setCreatedBy(Integer.valueOf(ApplicationThreadLocals.getUserId().intValue()));
            this.remittanceScheduler.setStatus("Started");
            this.scheduledRemittanceService.getRemittanceSchedulerLogService().persist((Object)this.remittanceScheduler);
            Long schedularLogId = this.remittanceScheduler.getId();
            boolean searchRecovery = this.scheduledRemittanceService.searchRecovery(this.glcode, "Manual", schedularLogId, this.dept, this.lastRunDate);
            if (!searchRecovery) {
                this.addActionMessage(this.getText("schedular.failed"));
                this.addActionMessage(this.scheduledRemittanceService.getErrorMessage().toString());
            } else {
                this.addActionMessage(this.getText("schedular.succeful"));
            }
        }
        catch (ValidationException e) {
            this.addActionMessage(this.getText("schedular.failed"));
            throw new ValidationException(Arrays.asList(new ValidationError(this.scheduledRemittanceService.getErrorMessage().toString(), this.scheduledRemittanceService.getErrorMessage().toString())));
        }
        catch (Exception e) {
            this.addActionMessage(this.getText("schedular.failed"));
            throw new ValidationException(Arrays.asList(new ValidationError(this.scheduledRemittanceService.getErrorMessage().toString(), this.scheduledRemittanceService.getErrorMessage().toString())));
        }
        List findAllBy = this.persistenceService.findAllBy("select voucherheaderId.voucherNumber from RemittanceSchedulePayment  where schId.id=?", new Object[]{this.remittanceScheduler.getId()});
        if (findAllBy.isEmpty()) {
            this.addActionMessage(" No Payments Created ");
        } else {
            this.addActionMessage(" Payment vouchernumbers listed below");
            this.addActionMessage(findAllBy.toString().replace('[', ' ').replace(']', ' '));
        }
        return "messages";
    }

    public void setScheduledRemittanceService(ScheduledRemittanceService scheduledRemittanceService) {
        this.scheduledRemittanceService = scheduledRemittanceService;
    }

    public String getGlcode() {
        return this.glcode;
    }

    public void setGlcode(String glcode) {
        this.glcode = glcode;
    }

    public Integer getDept() {
        return this.dept;
    }

    public void setDept(Integer dept) {
        this.dept = dept;
    }

    public String getDrawingOfficer() {
        return this.drawingOfficer;
    }

    public void setDrawingOfficer(String drawingOfficer) {
        this.drawingOfficer = drawingOfficer;
    }

    public Date getLastRunDate() {
        return this.lastRunDate;
    }

    public void setLastRunDate(Date lastRunDate) {
        this.lastRunDate = lastRunDate;
    }

    public Map<String, String> getCoaMap() {
        return this.coaMap;
    }

    public void setCoaMap(Map<String, String> coaMap) {
        this.coaMap = coaMap;
    }

    public RemittanceSchedulerLog getRemittanceScheduler() {
        return this.remittanceScheduler;
    }

    public void setRemittanceScheduler(RemittanceSchedulerLog remittanceScheduler) {
        this.remittanceScheduler = remittanceScheduler;
    }

    public List<DepartmentDOMapping> getDeptDOList() {
        return this.deptDOList;
    }

    public void setDeptDOList(List<DepartmentDOMapping> deptDOList) {
        this.deptDOList = deptDOList;
    }

    public Map<String, String> getLastRunDateMap() {
        return this.lastRunDateMap;
    }

    public void setLastRunDateMap(Map<String, String> lastRunDateMap) {
        this.lastRunDateMap = lastRunDateMap;
    }

    public void setTdsDAO(TdsHibernateDAO tdsDAO) {
        this.tdsDAO = tdsDAO;
    }
}

