/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.voucher;

import com.exilant.exility.common.TaskFailedException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.billsaccounting.services.CreateVoucher;
import org.egov.commons.CVoucherHeader;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.State;
import org.egov.model.voucher.WorkflowBean;
import org.egov.services.voucher.JournalVoucherActionHelper;
import org.egov.services.voucher.VoucherService;
import org.egov.utils.FinancialConstants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class PreApprovedActionHelper {
    @Autowired
    @Qualifier(value="journalVoucherActionHelper")
    private JournalVoucherActionHelper journalVoucherActionHelper;
    @Autowired
    @Qualifier(value="voucherService")
    private VoucherService voucherService;
    @Autowired
    @Qualifier(value="createVoucher")
    private CreateVoucher createVoucher;
    @Autowired
    PositionMasterService positionMasterService;
    @Autowired
    SecurityUtils securityUtils;

    @Transactional
    public CVoucherHeader createVoucherFromBill(CVoucherHeader voucherHeader, WorkflowBean workflowBean, Long billId, String voucherNumber, Date voucherDate) throws ApplicationRuntimeException, SQLException, TaskFailedException {
        try {
            Long voucherHeaderId = this.createVoucher.createVoucherFromBill(billId.intValue(), null, voucherNumber, voucherDate);
            voucherHeader = (CVoucherHeader)this.voucherService.findById(voucherHeaderId, false);
            voucherHeader = this.sendForApproval(voucherHeader, workflowBean);
        }
        catch (ValidationException e) {
            if (((ValidationError)e.getErrors().get(0)).getMessage() != null && !((ValidationError)e.getErrors().get(0)).getMessage().equals("")) {
                throw new ValidationException(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage(), new String[0]);
            }
            throw new ValidationException("Voucher creation failed", "Voucher creation failed", new String[0]);
        }
        catch (Exception e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        return voucherHeader;
    }

    @Transactional
    public CVoucherHeader sendForApproval(CVoucherHeader voucherHeader, WorkflowBean workflowBean) {
        if (!this.validateOwner(voucherHeader.getState()).booleanValue()) {
            throw new ValidationException("exp", "Application does not belongs to this inbox", new String[0]);
        }
        try {
            if ("Create And Approve".equalsIgnoreCase(workflowBean.getWorkFlowAction()) && voucherHeader.getState() == null) {
                voucherHeader.setStatus(FinancialConstants.CREATEDVOUCHERSTATUS);
            } else {
                voucherHeader = this.journalVoucherActionHelper.transitionWorkFlow(voucherHeader, workflowBean);
                this.voucherService.applyAuditing((AbstractAuditable)voucherHeader.getState());
            }
            this.voucherService.persist(voucherHeader);
        }
        catch (ValidationException e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        return voucherHeader;
    }

    private Boolean validateOwner(State state) {
        List positionsForUser = this.positionMasterService.getPositionsForEmployee(this.securityUtils.getCurrentUser().getId());
        return positionsForUser.contains(state.getOwnerPosition());
    }
}

