/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.report;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.report.FundFlowBean;
import org.hibernate.Query;
import org.hibernate.transform.Transformers;
import org.hibernate.type.BooleanType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;

public class FundFlowService
extends PersistenceService {
    private static Logger LOGGER = Logger.getLogger(FundFlowService.class);
    private static final SimpleDateFormat sqlformat = new SimpleDateFormat("dd-MMM-yyyy");
    private static final String START_FINANCIALYEAR_DATE = "01-Apr-2012";
    @Autowired
    private AppConfigValueService appConfigValuesService;

    public FundFlowService() {
        super(null);
    }

    public FundFlowService(Class type) {
        super(type);
    }

    public List<FundFlowBean> getOutStandingPayments(Date asPerDate, Long fundId) {
        String voucherDate = sqlformat.format(asPerDate);
        List appConfig = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "VOUCHER_STATUS_TO_CHECK_BANK_BALANCE");
        if (appConfig == null || appConfig.isEmpty()) {
            throw new ValidationException("", "VOUCHER_STATUS_TO_CHECK_BANK_BALANCE is not defined in AppConfig", new String[0]);
        }
        String appConfigValue = "";
        boolean condtitionalAppConfigIsPresent = false;
        String designationName = null;
        String functionaryName = null;
        String stateWithoutCondition = "";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Before Appconfig Check ------");
        }
        for (AppConfigValues app : appConfig) {
            appConfigValue = app.getValue();
            if (appConfigValue.contains(",")) {
                condtitionalAppConfigIsPresent = true;
                String[] array = appConfigValue.split(",");
                if (array.length != 2) {
                    throw new ValidationException("", "VOUCHER_STATUS_TO_CHECK_BANK_BALANCE is invalid", new String[0]);
                }
                designationName = array[0];
                functionaryName = array[1];
                continue;
            }
            stateWithoutCondition = appConfigValue;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"After Appconfig Check ------");
        }
        StringBuffer outstandingPaymentQryStr = new StringBuffer(500);
        if (condtitionalAppConfigIsPresent) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"condtitionalAppConfigIsPresent ------");
            }
            outstandingPaymentQryStr = outstandingPaymentQryStr.append("SELECT DISTINCT( ba.accountnumber)      AS accountNumber ,  ROUND(SUM(ph.paymentamount)/100000,2) AS outStandingBPV FROM voucherheader vh,paymentheader ph,bankaccount ba,eg_wf_states state, eg_eis_employeeinfo empinfo,  eg_designation desg, functionary func  where ph.state_id =state.id and empinfo.pos_id= state.owner and empinfo.functionary_id=func.id  and empinfo.isactive=true  and empinfo.DESIGNATIONID=desg.DESIGNATIONID and vh.id =ph.voucherheaderid and  ba.id=ph.bankaccountnumberid and desg.DESIGNATION_NAME like '" + designationName + "' and func.NAME like '" + functionaryName + "' ");
            if (fundId != null && fundId != -1L) {
                outstandingPaymentQryStr.append(" and vh.fundid =" + fundId);
                outstandingPaymentQryStr.append(" and ba.fundid =" + fundId);
            }
            outstandingPaymentQryStr.append(" and vh.voucherdate <='").append(voucherDate).append("'  and vh.voucherdate >='01-Apr-2012").append("' group by accountNumber  ");
        } else {
            outstandingPaymentQryStr = outstandingPaymentQryStr.append("SELECT DISTINCT( ba.accountnumber)      AS accountNumber ,  ROUND(SUM(ph.paymentamount)/100000,2) AS outStandingBPV FROM voucherheader vh,paymentheader ph,bankaccount ba,eg_wf_states state where ph.state_id     =state.id \tand vh.id =ph.voucherheaderid and  ba.id=ph.bankaccountnumberid");
            if (fundId != null && fundId != -1L) {
                outstandingPaymentQryStr.append(" and vh.fundid =" + fundId);
                outstandingPaymentQryStr.append(" and ba.fundid =" + fundId);
            }
            outstandingPaymentQryStr.append(" and vh.voucherdate <='").append(voucherDate).append("'  and vh.voucherdate >='01-Apr-2012").append("' and state.value like '").append(stateWithoutCondition).append("' group by accountNumber  ");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Out Standing Payment Query " + outstandingPaymentQryStr.toString()));
        }
        Query outstandingQry = this.getSession().createSQLQuery(outstandingPaymentQryStr.toString()).addScalar("accountNumber").addScalar("outStandingBPV").setResultTransformer(Transformers.aliasToBean(FundFlowBean.class));
        return outstandingQry.list();
    }

    public List<FundFlowBean> getConcurrancePayments(Date asPerDate, Long fundId) {
        String voucherDate = sqlformat.format(asPerDate);
        List appConfig = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "PAYMENT_WF_STATUS_FOR_BANK_BALANCE_CHECK");
        if (appConfig == null || appConfig.isEmpty()) {
            throw new ValidationException("", "PAYMENT_WF_STATUS_FOR_BANK_BALANCE_CHECK is not defined in AppConfig", new String[0]);
        }
        String voucherStatus = "";
        StringBuffer values = new StringBuffer(200);
        for (AppConfigValues app : appConfig) {
            values.append("'");
            values.append(app.getValue());
            values.append("',");
        }
        voucherStatus = values.substring(0, values.length() - 1);
        StringBuffer conCurrancePaymentQryStr = new StringBuffer(500);
        conCurrancePaymentQryStr = conCurrancePaymentQryStr.append("SELECT DISTINCT( ba.accountnumber)      AS accountNumber ,  ROUND(SUM(ph.paymentamount)/100000,2) AS concurranceBPV FROM voucherheader vh,paymentheader ph,bankaccount ba,eg_wf_states state where ph.state_id     =state.id \tand vh.id =ph.voucherheaderid and  ba.id=ph.bankaccountnumberid and  vh.voucherdate >='01-Apr-2012'");
        if (fundId != null && fundId != -1L) {
            conCurrancePaymentQryStr.append(" and vh.fundid =" + fundId);
            conCurrancePaymentQryStr.append(" and ba.fundid =" + fundId);
        }
        conCurrancePaymentQryStr.append(" and to_char(created_date,'dd-Mon-yyyy') ='").append(voucherDate).append("' and ( state.value in (").append(voucherStatus).append(")OR vh.status=0 ) group by accountNumber  ");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Concurrancey payment " + conCurrancePaymentQryStr.toString()));
        }
        Query conCurranceQry = this.getSession().createSQLQuery(conCurrancePaymentQryStr.toString()).addScalar("accountNumber").addScalar("concurranceBPV").setResultTransformer(Transformers.aliasToBean(FundFlowBean.class));
        return conCurranceQry.list();
    }

    public List<FundFlowBean> getAllpaymentAccounts(Long fundId) {
        StringBuffer allPaymentAccounts = new StringBuffer(500);
        allPaymentAccounts.append("select ba.id as bankAccountId, ba.accountnumber as accountNumber, coa.glcode as glcode,b.code as bankName ,fd.name as fundName from Chartofaccounts  coa,  fund fd, bankaccount ba left outer join bankbranch bb  on ba.branchid=bb.id left outer join bank b on bb.bankid=b.id where  coa.id=ba.glcodeid and ba.fundid= fd.id and ba.isactive=true and ba.type in ('PAYMENTS','RECEIPTS_PAYMENTS') ");
        if (fundId != null && fundId != -1L) {
            allPaymentAccounts.append("and ba.fundid=" + fundId);
        } else {
            allPaymentAccounts.append(" order by fd.code,b.code,coa.glcode,ba.accountnumber");
        }
        Query allPaymentAccountsQry = this.getSession().createSQLQuery(allPaymentAccounts.toString()).addScalar("bankAccountId").addScalar("accountNumber").addScalar("glcode").addScalar("bankName").addScalar("fundName").setResultTransformer(Transformers.aliasToBean(FundFlowBean.class));
        return allPaymentAccountsQry.list();
    }

    public List<FundFlowBean> getAllReceiptAccounts(Long fundId) {
        StringBuffer allAccounts = new StringBuffer(500);
        allAccounts.append("select ba.id as bankAccountId, ba.accountnumber as accountNumber, coa.glcode as glcode,b.code as bankName ,fd.name as fundName,  case when ba.narration = null then 0 else (case when instr(ba.narration,'Walkin payment account',1)  = 1 then 1 else 0 end ) end as walkinPaymentAccount  from Chartofaccounts  coa, fund fd, bankaccount ba left outer join bankbranch bb  on ba.branchid=bb.id left outer  join bank b on bb.bankid=b.id where coa.id=ba.glcodeid and ba.fundid= fd.id and ba.isactive=true and ba.type in ('RECEIPTS') ");
        if (fundId != null && fundId != -1L) {
            allAccounts.append(" and ba.fundid=" + fundId);
        } else {
            allAccounts.append(" order by fd.code, walkinPaymentAccount, b.code,coa.glcode,ba.accountnumber");
        }
        Query allAccountsQry = this.getSession().createSQLQuery(allAccounts.toString()).addScalar("bankAccountId").addScalar("accountNumber").addScalar("glcode").addScalar("bankName").addScalar("fundName").addScalar("walkinPaymentAccount", (Type)BooleanType.INSTANCE).setResultTransformer(Transformers.aliasToBean(FundFlowBean.class));
        List allAccountslist = allAccountsQry.list();
        return allAccountslist;
    }

    public List<FundFlowBean> getContraReceiptsForTheDay(Date asPerDate, Long fundId) {
        String voucherDate = sqlformat.format(asPerDate);
        StringBuffer temp = new StringBuffer(1000);
        temp = temp.append(" SELECT gl.glcodeid as codeId, ba.accountnumber as accountNumber, b.name as bankName,round(SUM(case when gl.debitamount = NULL then 0 else gl.debitamount end)/100000,2) AS btbReceipt FROM contrajournalvoucher CV  , voucherheader vh ,  generalledger gl, bankaccount ba, bankbranch bb,bank b WHERE ");
        if (fundId != null && fundId != -1L) {
            temp.append(" vh.fundid =" + fundId + " AND ba.fundid         =" + fundId + " and");
        }
        temp.append(" vh.voucherdate    ='" + voucherDate + "'and gl.voucherheaderid= vh.id   and vh.name in ('" + "BankToBank" + "','" + "InterFundTransfer" + "')   and cv.voucherheaderid=vh.id and ba.id= cv.tobankaccountid and ba.glcodeid= gl.glcodeid AND vh.status =0     and bb.bankid= b.id and ba.branchid=bb.id GROUP BY GL.GLCODEID,ba.accountnumber,b.name");
        Query tempQry = this.getSession().createSQLQuery(temp.toString()).addScalar("accountNumber").addScalar("bankName").addScalar("btbReceipt").setResultTransformer(Transformers.aliasToBean(FundFlowBean.class));
        List tempPayList = tempQry.list();
        return tempPayList;
    }

    public List<FundFlowBean> getContraPaymentsForTheDay(Date asPerDate, Long fundId) {
        String voucherDate = sqlformat.format(asPerDate);
        StringBuffer qry = new StringBuffer(1000);
        qry = qry.append(" SELECT gl.glcodeid as codeId, ba.accountnumber as accountNumber, b.name as bankName, round(SUM(case when gl.creditamount = NULL then 0 else gl.creditamount end)/100000,2) AS btbPayment FROM contrajournalvoucher CV  , voucherheader vh ,  generalledger gl, bankaccount ba, bankbranch bb,bank b WHERE ");
        if (fundId != null && fundId != -1L) {
            qry.append(" vh.fundid =" + fundId + " AND ba.fundid         =" + fundId + " and ");
        }
        qry.append("vh.voucherdate    ='" + voucherDate + "'and gl.voucherheaderid= vh.id   and vh.name in ('" + "BankToBank" + "','" + "InterFundTransfer" + "')   and cv.voucherheaderid=vh.id and ba.id= cv.frombankaccountid and ba.glcodeid= gl.glcodeid AND vh.status =0  and ba.fundid=vh.fundid    and bb.bankid= b.id and ba.branchid=bb.id GROUP BY gl.glcodeId,ba.accountnumber,b.name ");
        Query q = this.getSession().createSQLQuery(qry.toString()).addScalar("accountNumber").addScalar("bankName").addScalar("btbPayment").setResultTransformer(Transformers.aliasToBean(FundFlowBean.class));
        List tempList = q.list();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("account containg transactions ------" + tempList.size()));
        }
        return tempList;
    }

    public List<FundFlowBean> getContraPaymentsForTheDayFromPaymentBanks(Date asPerDate, Long fundId) {
        String voucherDate = sqlformat.format(asPerDate);
        StringBuffer qry = new StringBuffer(1000);
        qry = qry.append(" SELECT gl.glcodeid as codeId, ba.accountnumber as accountNumber, b.name as bankName, round(SUM(case when gl.creditamount = NULL then 0 else gl.creditamount end)/100000,2) AS btbPayment FROM contrajournalvoucher CV  , voucherheader vh ,  generalledger gl, bankaccount ba, bankbranch bb,bank b WHERE  ");
        if (fundId != null && fundId != -1L) {
            qry = qry.append(" vh.fundid =" + fundId + " AND ba.fundid =" + fundId + " and ");
        }
        qry = qry.append(" vh.voucherdate    ='" + voucherDate + "'and gl.voucherheaderid= vh.id   and vh.name in ('" + "BankToBank" + "','" + "InterFundTransfer" + "')   and cv.voucherheaderid=vh.id and ba.id= cv.frombankaccountid and ba.glcodeid= gl.glcodeid AND vh.status =0 and ba.fundid=vh.fundid    and bb.bankid= b.id and ba.branchid=bb.id GROUP BY gl.glcodeId,ba.accountnumber,b.name");
        Query q = this.getSession().createSQLQuery(qry.toString()).addScalar("accountNumber").addScalar("bankName").addScalar("btbPayment").setResultTransformer(Transformers.aliasToBean(FundFlowBean.class));
        List tempList = q.list();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("account containg transactions ------" + tempList.size()));
        }
        return tempList;
    }

    public BigDecimal getBankBalance(Long bankaccountId, Date asPerDate, Long bankAccGlcodeId) {
        try {
            asPerDate = sqlformat.parse(sqlformat.format(asPerDate));
            Calendar calfrom = Calendar.getInstance();
            calfrom.setTime(asPerDate);
            calfrom.set(10, 0);
            calfrom.set(12, 0);
            calfrom.set(13, 0);
            calfrom.set(9, 0);
            asPerDate = calfrom.getTime();
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError("cannot.format.date", "Failed during date Formatting ")));
        }
        if (bankaccountId == null) {
            throw new ValidationException(Arrays.asList(new ValidationError("bankaccount.id.is.null", "BankAccountId is not provided")));
        }
        FundFlowBean fundFlowBean = (FundFlowBean)((Object)this.find("from FundFlowBean where bankAccountId=? and to_date(reportDate)=?", new Object[]{BigDecimal.valueOf(bankaccountId), asPerDate}));
        if (fundFlowBean == null) {
            throw new ValidationException(Arrays.asList(new ValidationError("fund.flow.report.not.generated.for.the.day", "Fund Flow Report is not Generated Balance check Failed")));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Querying and getting the bank balance");
        }
        BigDecimal bankBalance = fundFlowBean.getOpeningBalance().add(fundFlowBean.getCurrentReceipt());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("value from fundflow = " + bankBalance));
        }
        bankBalance = bankBalance.multiply(new BigDecimal(100000));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("value from fundflow*1lakh = " + bankBalance));
        }
        bankBalance = bankBalance.subtract(this.getContraPayment(bankaccountId, asPerDate, bankAccGlcodeId));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("after contra payment = " + bankBalance));
        }
        bankBalance = bankBalance.add(this.getContraReceipt(bankaccountId, asPerDate, bankAccGlcodeId));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("after adding contra Receipt = " + bankBalance));
        }
        bankBalance = bankBalance.subtract(this.getOutStandingPayment(bankaccountId, asPerDate));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(" BankBalance for " + bankaccountId + " is " + bankBalance));
        }
        return bankBalance;
    }

    private BigDecimal getContraPayment(Long bankaccountId, Date asPerDate, Long accountGlcodeId) {
        StringBuffer qry = new StringBuffer(100);
        if (accountGlcodeId != null) {
            qry.append(" select case when SUM(case when gl.creditamount = NULL then 0 else gl.creditamount end) = null then 0 else SUM(case when gl.creditamount = NULL then 0 else gl.creditamount end) end as payment from   voucherheader vh, generalledger gl where vh.id=gl.voucherheaderid and gl.glcodeId=" + accountGlcodeId + "  and vh.name in ('" + "BankToBank" + "','" + "InterFundTransfer" + "')   and vh.fiscalperiodid in (select id from fiscalperiod where financialyearid=(select f.id from financialyear f where CURRENT_DATE between f.startingdate and f.endingdate)) and vh.voucherdate='" + sqlformat.format(asPerDate) + "'   and vh.status =0");
        } else {
            qry.append(" select case when SUM(case when gl.creditamount = NULL then 0 else gl.creditamount end) = null then 0 else SUM(case when gl.creditamount = NULL then 0 else gl.creditamount end) end as payment from BankAccount  acc, voucherheader vh, generalledger gl where vh.id=gl.voucherheaderid and acc.glcodeId= gl.glcodeId   and vh.name in ('BankToBank','InterFundTransfer')  and vh.voucherdate='" + sqlformat.format(asPerDate) + "'  and acc.id=" + bankaccountId + " and vh.status =0");
        }
        List list = this.getSession().createSQLQuery(qry.toString()).list();
        BigDecimal contraPayment = (BigDecimal)list.get(0);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Contra Payments For BankId " + accountGlcodeId + " And Date " + sqlformat.format(asPerDate) + " is : " + contraPayment));
        }
        return contraPayment;
    }

    private BigDecimal getContraReceipt(Long bankaccountId, Date asPerDate, Long accountGlcodeId) {
        StringBuffer qry = new StringBuffer(100);
        if (accountGlcodeId != null) {
            qry.append(" select case when SUM(case when gl.debitamount = NULL then 0 else gl.debitamount end) = null then 0 else SUM(case when gl.debitamount = NULL then 0 else gl.debitamount end) end as receipt from  voucherheader vh, generalledger gl where vh.id=gl.voucherheaderid and gl.glcodeId=" + accountGlcodeId + "  and vh.name in ('" + "BankToBank" + "','" + "InterFundTransfer" + "')   and vh.fiscalperiodid in (select id from fiscalperiod where financialyearid=(select f.id from financialyear f where CURRENT_DATE between f.startingdate and f.endingdate)) and vh.voucherdate='" + sqlformat.format(asPerDate) + "'  and vh.status =0");
        } else {
            qry.append(" select case when SUM(case when gl.debitamount = NULL then 0 else gl.debitamount end) = null then 0 else SUM(case when gl.debitamount = NULL then 0 else gl.debitamount end) end as receipt from BankAccount acc, voucherheader vh, generalledger gl where vh.id=gl.voucherheaderid and acc.glcodeid= gl.glcodeid   and vh.name in ('BankToBank','InterFundTransfer')  and vh.voucherdate='" + sqlformat.format(asPerDate) + "'  and acc.id=" + bankaccountId + " and vh.status =0");
        }
        List list = this.getSession().createSQLQuery(qry.toString()).list();
        BigDecimal contraReceipt = (BigDecimal)list.get(0);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Contra Receipt For BankId " + accountGlcodeId + " And Date " + sqlformat.format(asPerDate) + " is : " + contraReceipt));
        }
        return contraReceipt;
    }

    private BigDecimal getOutStandingPayment(Long bankaccountId, Date asPerDate) {
        List list;
        List appConfig = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "PAYMENT_WF_STATUS_FOR_BANK_BALANCE_CHECK");
        if (appConfig == null || appConfig.isEmpty()) {
            throw new ValidationException("", "PAYMENT_WF_STATUS_FOR_BANK_BALANCE_CHECK is not defined in AppConfig", new String[0]);
        }
        String voucherStatus = "";
        StringBuffer values = new StringBuffer(200);
        for (AppConfigValues app : appConfig) {
            values.append("'");
            values.append(app.getValue());
            values.append("',");
        }
        voucherStatus = values.substring(0, values.length() - 1);
        StringBuffer outstandingPaymentQryStr = new StringBuffer(500);
        outstandingPaymentQryStr = outstandingPaymentQryStr.append("SELECT case when SUM(case when ph.paymentamount = null then 0 else ph.paymentamount end ) = null then 0 else SUM(case when ph.paymentamount = null then 0 else ph.paymentamount) end AS concurranceBPV FROM voucherheader vh right join  paymentheader ph on vh.id=ph.voucherheaderid,bankaccount ba,eg_wf_states state where ph.state_id     =state.id \tand vh.id =ph.voucherheaderid and  ba.id=ph.bankaccountnumberid and ba.id=" + bankaccountId + "").append(" and vh.fiscalperiodid in (select id from fiscalperiod where financialyearid=(select f.id from financialyear f where CURRENT_DATE between f.startingdate and f.endingdate))").append(" and vh.voucherdate >= '").append("01-Apr-2012' ").append(" and to_char(created_date,'dd-Mon-yyyy') ='").append(sqlformat.format(asPerDate)).append("' and ( state.value in (").append(voucherStatus).append(")OR vh.status=0 ) group by accountNumber  ");
        BigDecimal outStandingPayment = BigDecimal.ZERO;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Executing outstandingPaymentQryStr query----------------------------------------------" + outstandingPaymentQryStr));
        }
        if (!(list = this.getSession().createSQLQuery(outstandingPaymentQryStr.toString()).list()).isEmpty()) {
            outStandingPayment = (BigDecimal)list.get(0);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("OutStanding payments for BankId " + bankaccountId + " And Date " + sqlformat.format(asPerDate) + " is : " + outStandingPayment));
        }
        return outStandingPayment;
    }
}

