/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.deduction;

import java.util.Date;
import org.apache.log4j.Logger;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.scheduler.quartz.AbstractQuartzJob;
import org.egov.model.recoveries.RemittanceSchedulerLog;
import org.egov.services.deduction.ScheduledRemittanceService;
import org.egov.utils.FinancialConstants;
import org.quartz.StatefulJob;

public class RemittanceJob
extends AbstractQuartzJob
implements StatefulJob {
    private static final long serialVersionUID = 7924161445986076249L;
    private static final Logger LOGGER = Logger.getLogger(RemittanceJob.class);
    private String glcode;
    private ScheduledRemittanceService scheduledRemittanceService;
    private String jobName;
    private Long schedularLogId;

    public void executeJob() {
        LOGGER.info((Object)"Inside RemittanceJob");
        RemittanceSchedulerLog remittanceScheduler = new RemittanceSchedulerLog();
        remittanceScheduler = this.buildRemittanceScheduler(remittanceScheduler);
        remittanceScheduler.setCreatedBy(ApplicationThreadLocals.getUserId().intValue());
        this.scheduledRemittanceService.getRemittanceSchedulerLogService().persist((Object)remittanceScheduler);
        this.schedularLogId = remittanceScheduler.getId();
        this.scheduledRemittanceService.searchRecovery(this.glcode, this.jobName, this.schedularLogId, null, null);
    }

    private RemittanceSchedulerLog buildRemittanceScheduler(RemittanceSchedulerLog remittanceScheduler) {
        remittanceScheduler.setGlcode(null);
        remittanceScheduler.setSchType(FinancialConstants.REMITTANCE_SCHEDULER_SCHEDULAR_TYPE_AUTO);
        remittanceScheduler.setSchJobName(this.getJobName());
        remittanceScheduler.setLastRunDate(new Date());
        remittanceScheduler.setCreatedDate(new Date());
        remittanceScheduler.setCreatedBy(ApplicationThreadLocals.getUserId().intValue());
        remittanceScheduler.setStatus("Started");
        return remittanceScheduler;
    }

    public String getGlcode() {
        return this.glcode;
    }

    public void setGlcode(String glcode) {
        this.glcode = glcode;
    }

    public void setScheduledRemittanceService(ScheduledRemittanceService scheduledRemittanceService) {
        this.scheduledRemittanceService = scheduledRemittanceService;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }
}

