/*
 * Decompiled with CFR 0.152.
 */
package org.egov.model.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.CChartOfAccounts;
import org.egov.model.recoveries.Recovery;
import org.egov.model.repository.RecoveryRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="remittanceRecoveryService")
@Transactional(readOnly=true)
public class RecoveryService {
    private final RecoveryRepository recoveryRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public RecoveryService(RecoveryRepository recoveryRepository) {
        this.recoveryRepository = recoveryRepository;
    }

    @Transactional
    public Recovery create(Recovery recovery) {
        return (Recovery)((Object)this.recoveryRepository.save((Object)recovery));
    }

    @Transactional
    public Recovery update(Recovery recovery) {
        return (Recovery)((Object)this.recoveryRepository.save((Object)recovery));
    }

    public List<Recovery> findAll() {
        return this.recoveryRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public Recovery findOne(Long id) {
        return (Recovery)((Object)this.recoveryRepository.findOne(id));
    }

    public List<Recovery> search(Recovery recovery) {
        if (recovery != null && recovery.getChartofaccounts() != null && recovery.getChartofaccounts().getId() != null) {
            return this.recoveryRepository.findByChartofaccounts(recovery.getChartofaccounts());
        }
        return this.recoveryRepository.findAll();
    }

    public List<Recovery> getAllActiveRecoverys() {
        return this.recoveryRepository.findByIsactive(true);
    }

    public List<Recovery> getByAccountCode(CChartOfAccounts chartOfAccounts) {
        return this.recoveryRepository.findByChartofaccounts(chartOfAccounts);
    }

    public List<Recovery> getAllActiveAutoRemitTds() {
        return this.recoveryRepository.findByIsactiveAndRemittanceModeOrderByType(true, Character.valueOf('A'));
    }
}

