/*
 * Decompiled with CFR 0.152.
 */
package org.egov.model.service;

import java.util.List;
import org.egov.commons.CFinancialYear;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.service.CFinancialYearService;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.budget.Budget;
import org.egov.services.budget.BudgetDetailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BudgetApprovalService {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernate;
    @Autowired
    private CFinancialYearService cFinancialYearService;
    @Autowired
    private BudgetDetailService budgetDetailService;

    public EgwStatus getBudgetStatus(String moduleType, String code) {
        return this.egwStatusHibernate.getStatusByModuleAndCode(moduleType, code);
    }

    public List<CFinancialYear> financialYearList() {
        return this.cFinancialYearService.getFinancialYears(this.financialYear());
    }

    public List<Long> financialYear() {
        String query = "select bd.financialYear.id from Budget bd where bd.isbere='RE' and bd.status.id=:statusId";
        List budgetDetailsList = this.persistenceService.getSession().createQuery("select bd.financialYear.id from Budget bd where bd.isbere='RE' and bd.status.id=:statusId").setParameter("statusId", (Object)this.getBudgetStatus("BUDGET", "Created").getId()).list();
        return budgetDetailsList;
    }

    public List<Budget> search(Long financialYearId) {
        return this.budgetDetailService.getBudgetByStatusAndFinancialYearId(this.getBudgetStatus("BUDGETDETAIL", "VERIFIED").getId(), financialYearId);
    }
}

