/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.voucher.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.egf.contract.model.ErrorDetail;
import org.egov.egf.contract.model.VoucherContract;
import org.egov.egf.contract.model.VoucherRequest;
import org.springframework.stereotype.Service;

@Service
public class ContractVoucherService {
    public List<ErrorDetail> validateVoucherReuest(VoucherContract request) {
        VoucherRequest VoucherRequest2;
        ArrayList<ErrorDetail> errors = new ArrayList<ErrorDetail>();
        ErrorDetail errorDetails = new ErrorDetail();
        if (request == null) {
            errorDetails.setErrorCode("EGF-VOUCHER-1");
            errorDetails.setErrorMessage("Please send valid JSON request");
            errors.add(errorDetails);
        }
        if ((VoucherRequest2 = request.getVouchers().get(0)).getLedgers().size() > 100) {
            errorDetails.setErrorCode("EGF-VOUCHER-2");
            errorDetails.setErrorMessage("Account Details size cannot be greater then 30");
            errors.add(errorDetails);
        }
        if (request != null && VoucherRequest2.getLedgers().isEmpty()) {
            errorDetails.setErrorCode("EGF-VOUCHER-5");
            errorDetails.setErrorMessage("Account Details List cannot be empty");
            errors.add(errorDetails);
        }
        this.validateVoucherDate(request, errors, errorDetails, VoucherRequest2);
        return errors;
    }

    private void validateVoucherDate(VoucherContract request, List<ErrorDetail> errors, ErrorDetail errorDetails, VoucherRequest VoucherRequest2) {
        if (VoucherRequest2.getVoucherDate().isEmpty()) {
            errorDetails.setErrorCode("EGF-VOUCHER-3");
            errorDetails.setErrorMessage("Voucher Date cannot be empty");
            errors.add(errorDetails);
        }
        if (request != null && !VoucherRequest2.getVoucherDate().isEmpty()) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");
            Date voucherDate = null;
            try {
                voucherDate = formatter.parse(VoucherRequest2.getVoucherDate());
            }
            catch (ParseException e) {
                errorDetails.setErrorCode("EGF-VOUCHER-3");
                errorDetails.setErrorMessage("Please send the Voucher Date in DD-MM-YYYY format");
                errors.add(errorDetails);
            }
            if (voucherDate != null && voucherDate.after(new Date())) {
                errorDetails.setErrorCode("EGF-VOUCHER-4");
                errorDetails.setErrorMessage("Voucher date cannot be future date");
                errors.add(errorDetails);
            }
        }
    }
}

