/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.expensebill.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.script.ScriptContext;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.CChartOfAccountDetail;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.service.ChartOfAccountDetailService;
import org.egov.commons.service.CheckListService;
import org.egov.commons.service.FundService;
import org.egov.egf.autonumber.ExpenseBillNumberGenerator;
import org.egov.egf.autonumber.WorksBillNumberGenerator;
import org.egov.egf.billsubtype.service.EgBillSubTypeService;
import org.egov.egf.expensebill.repository.ExpenseBillRepository;
import org.egov.egf.utils.FinancialUtils;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.models.EgChecklists;
import org.egov.model.bills.EgBillPayeedetails;
import org.egov.model.bills.EgBillregister;
import org.egov.services.masters.SchemeService;
import org.egov.services.masters.SubSchemeService;
import org.egov.services.voucher.VoucherService;
import org.hibernate.Session;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ExpenseBillService {
    private static final Logger LOG = LoggerFactory.getLogger(ExpenseBillService.class);
    @PersistenceContext
    private EntityManager entityManager;
    private final ExpenseBillRepository expenseBillRepository;
    @Autowired
    private EgBillSubTypeService egBillSubTypeService;
    @Autowired
    private SchemeService schemeService;
    @Autowired
    private SubSchemeService subSchemeService;
    @Autowired
    private FinancialUtils financialUtils;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    protected AppConfigValueService appConfigValuesService;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    private final ScriptService scriptExecutionService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    @Qualifier(value="voucherService")
    private VoucherService voucherService;
    @Autowired
    private CheckListService checkListService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<EgBillregister> egBillregisterRegisterWorkflowService;
    @Autowired
    private FundService fundService;
    @Autowired
    private ChartOfAccountDetailService chartOfAccountDetailService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public ExpenseBillService(ExpenseBillRepository expenseBillRepository, ScriptService scriptExecutionService) {
        this.expenseBillRepository = expenseBillRepository;
        this.scriptExecutionService = scriptExecutionService;
    }

    public EgBillregister getById(Long id) {
        return (EgBillregister)this.expenseBillRepository.findOne(id);
    }

    public EgBillregister getByBillnumber(String billNumber) {
        return this.expenseBillRepository.findByBillnumber(billNumber);
    }

    @Transactional
    public EgBillregister create(EgBillregister egBillregister) {
        return (EgBillregister)this.expenseBillRepository.save(egBillregister);
    }

    @Transactional
    public EgBillregister create(EgBillregister egBillregister, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        if (StringUtils.isBlank((String)egBillregister.getBilltype())) {
            egBillregister.setBilltype("Final Bill");
        }
        if (StringUtils.isBlank((String)egBillregister.getExpendituretype())) {
            egBillregister.setExpendituretype("Expense");
        }
        egBillregister.setPassedamount(egBillregister.getBillamount());
        egBillregister.getEgBillregistermis().setEgBillregister(egBillregister);
        egBillregister.getEgBillregistermis().setLastupdatedtime(new Date());
        if (egBillregister.getEgBillregistermis().getFund() != null && egBillregister.getEgBillregistermis().getFund().getId() != null) {
            egBillregister.getEgBillregistermis().setFund(this.fundService.findOne(egBillregister.getEgBillregistermis().getFund().getId()));
        }
        if (egBillregister.getEgBillregistermis().getEgBillSubType() != null && egBillregister.getEgBillregistermis().getEgBillSubType().getId() != null) {
            egBillregister.getEgBillregistermis().setEgBillSubType(this.egBillSubTypeService.getById(egBillregister.getEgBillregistermis().getEgBillSubType().getId()));
        }
        if (egBillregister.getEgBillregistermis().getSchemeId() != null) {
            egBillregister.getEgBillregistermis().setScheme((Scheme)this.schemeService.findById(Integer.valueOf(egBillregister.getEgBillregistermis().getSchemeId().intValue()), false));
        } else {
            egBillregister.getEgBillregistermis().setScheme(null);
        }
        if (egBillregister.getEgBillregistermis().getSubSchemeId() != null) {
            egBillregister.getEgBillregistermis().setSubScheme((SubScheme)this.subSchemeService.findById(Integer.valueOf(egBillregister.getEgBillregistermis().getSubSchemeId().intValue()), false));
        } else {
            egBillregister.getEgBillregistermis().setSubScheme(null);
        }
        if (this.isBillNumberGenerationAuto()) {
            egBillregister.setBillnumber(this.getNextBillNumber(egBillregister));
        }
        try {
            this.checkBudgetAndGenerateBANumber(egBillregister);
        }
        catch (ValidationException e) {
            throw new ValidationException(e.getErrors());
        }
        List<EgChecklists> checkLists = egBillregister.getCheckLists();
        EgBillregister savedEgBillregister = (EgBillregister)this.expenseBillRepository.save(egBillregister);
        this.createCheckList(savedEgBillregister, checkLists);
        if (workFlowAction.equals("Create And Approve")) {
            if ("Expense".equals(egBillregister.getExpendituretype())) {
                savedEgBillregister.setStatus(this.financialUtils.getStatusByModuleAndCode("EXPENSEBILL", "Approved"));
            }
        } else {
            savedEgBillregister.setStatus(this.financialUtils.getStatusByModuleAndCode("EXPENSEBILL", "CREATED"));
            this.createExpenseBillRegisterWorkflowTransition(savedEgBillregister, approvalPosition, approvalComent, additionalRule, workFlowAction);
        }
        savedEgBillregister.getEgBillregistermis().setSourcePath("/EGF/expensebill/view/" + savedEgBillregister.getId().toString());
        return (EgBillregister)this.expenseBillRepository.save(savedEgBillregister);
    }

    @Transactional
    public void deleteCheckList(EgBillregister egBillregister) {
        List checkLists = this.checkListService.getByObjectId(egBillregister.getId());
        for (EgChecklists check : checkLists) {
            this.checkListService.delete(check);
        }
    }

    @Transactional
    public void createCheckList(EgBillregister egBillregister, List<EgChecklists> checkLists) {
        for (EgChecklists check : checkLists) {
            check.setObjectid(egBillregister.getId());
            AppConfigValues configValue = this.appConfigValuesService.getById(check.getAppconfigvalue().getId());
            check.setAppconfigvalue(configValue);
            this.checkListService.create(check);
        }
    }

    public void checkBudgetAndGenerateBANumber(EgBillregister egBillregister) {
        ScriptContext scriptContext = ScriptService.createContext((Object[])new Object[]{"voucherService", this.voucherService, "bill", egBillregister});
        this.scriptExecutionService.executeScript("egf.bill.budgetcheck", scriptContext);
    }

    @Transactional
    public EgBillregister update(EgBillregister egBillregister, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, String mode) throws ValidationException, IOException {
        EgBillregister updatedegBillregister = null;
        if ("edit".equals(mode)) {
            egBillregister.setPassedamount(egBillregister.getBillamount());
            egBillregister.getEgBillregistermis().setLastupdatedtime(new Date());
            if (egBillregister.getEgBillregistermis().getFund() != null && egBillregister.getEgBillregistermis().getFund().getId() != null) {
                egBillregister.getEgBillregistermis().setFund(this.fundService.findOne(egBillregister.getEgBillregistermis().getFund().getId()));
            }
            if (egBillregister.getEgBillregistermis().getSchemeId() != null) {
                egBillregister.getEgBillregistermis().setScheme((Scheme)this.schemeService.findById(Integer.valueOf(egBillregister.getEgBillregistermis().getSchemeId().intValue()), false));
            } else {
                egBillregister.getEgBillregistermis().setScheme(null);
            }
            if (egBillregister.getEgBillregistermis().getSubSchemeId() != null) {
                egBillregister.getEgBillregistermis().setSubScheme((SubScheme)this.subSchemeService.findById(Integer.valueOf(egBillregister.getEgBillregistermis().getSubSchemeId().intValue()), false));
            } else {
                egBillregister.getEgBillregistermis().setSubScheme(null);
            }
            if (this.isBillNumberGenerationAuto()) {
                egBillregister.setBillnumber(this.getNextBillNumber(egBillregister));
            }
            List<EgChecklists> checkLists = egBillregister.getCheckLists();
            updatedegBillregister = (EgBillregister)this.expenseBillRepository.save(egBillregister);
            this.deleteCheckList(updatedegBillregister);
            this.createCheckList(updatedegBillregister, checkLists);
            egBillregister.getEgBillregistermis().setBudgetaryAppnumber(null);
            try {
                this.checkBudgetAndGenerateBANumber(egBillregister);
            }
            catch (ValidationException e) {
                throw new ValidationException(e.getErrors());
            }
        }
        if (updatedegBillregister != null) {
            if (workFlowAction.equals("Create And Approve")) {
                updatedegBillregister.setStatus(this.financialUtils.getStatusByModuleAndCode("EXPENSEBILL", "Approved"));
            } else {
                this.expenseBillRegisterStatusChange(updatedegBillregister, workFlowAction);
                this.createExpenseBillRegisterWorkflowTransition(updatedegBillregister, approvalPosition, approvalComent, additionalRule, workFlowAction);
            }
            updatedegBillregister = (EgBillregister)this.expenseBillRepository.save(updatedegBillregister);
        } else {
            if (workFlowAction.equals("Create And Approve")) {
                egBillregister.setStatus(this.financialUtils.getStatusByModuleAndCode("EXPENSEBILL", "Approved"));
            } else {
                this.expenseBillRegisterStatusChange(egBillregister, workFlowAction);
                this.createExpenseBillRegisterWorkflowTransition(egBillregister, approvalPosition, approvalComent, additionalRule, workFlowAction);
            }
            updatedegBillregister = (EgBillregister)this.expenseBillRepository.save(egBillregister);
        }
        return updatedegBillregister;
    }

    public void expenseBillRegisterStatusChange(EgBillregister egBillregister, String workFlowAction) throws ValidationException {
        if (null != egBillregister && null != egBillregister.getStatus() && null != egBillregister.getStatus().getCode()) {
            if ("CREATED".equals(egBillregister.getStatus().getCode()) && egBillregister.getState() != null && workFlowAction.equalsIgnoreCase("Approve")) {
                egBillregister.setStatus(this.financialUtils.getStatusByModuleAndCode("EXPENSEBILL", "Approved"));
            } else if (workFlowAction.equals("Reject")) {
                egBillregister.setStatus(this.financialUtils.getStatusByModuleAndCode("EXPENSEBILL", "Rejected"));
            } else if ("Rejected".equals(egBillregister.getStatus().getCode()) && workFlowAction.equals("Cancel")) {
                egBillregister.setStatus(this.financialUtils.getStatusByModuleAndCode("EXPENSEBILL", "Cancelled"));
            } else if ("Rejected".equals(egBillregister.getStatus().getCode()) && workFlowAction.equals("Forward")) {
                egBillregister.setStatus(this.financialUtils.getStatusByModuleAndCode("EXPENSEBILL", "CREATED"));
            }
        }
    }

    @Transactional(readOnly=true)
    public boolean isBillNumberGenerationAuto() {
        List configValuesByModuleAndKey = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "Bill_Number_Geneartion_Auto");
        if (!configValuesByModuleAndKey.isEmpty()) {
            return "Y".equals(((AppConfigValues)configValuesByModuleAndKey.get(0)).getValue());
        }
        return false;
    }

    private String getNextBillNumber(EgBillregister bill) {
        if ("Works".equals(bill.getExpendituretype())) {
            WorksBillNumberGenerator b = (WorksBillNumberGenerator)this.beanResolver.getAutoNumberServiceFor(WorksBillNumberGenerator.class);
            return b.getNextNumber(bill);
        }
        ExpenseBillNumberGenerator b = (ExpenseBillNumberGenerator)this.beanResolver.getAutoNumberServiceFor(ExpenseBillNumberGenerator.class);
        return b.getNextNumber(bill);
    }

    public void validateSubledgeDetails(EgBillregister egBillregister) {
        ArrayList<EgBillPayeedetails> payeeDetails = new ArrayList<EgBillPayeedetails>();
        for (EgBillPayeedetails payeeDetail : egBillregister.getBillPayeedetails()) {
            CChartOfAccountDetail coaDetail = this.chartOfAccountDetailService.getByGlcodeIdAndDetailTypeId(Long.valueOf(payeeDetail.getEgBilldetailsId().getGlcodeid().longValue()), Integer.valueOf(payeeDetail.getAccountDetailTypeId()));
            if (coaDetail == null) continue;
            payeeDetails.add(payeeDetail);
        }
        egBillregister.getBillPayeedetails().clear();
        egBillregister.setBillPayeedetails(payeeDetails);
    }

    public void createExpenseBillRegisterWorkflowTransition(EgBillregister egBillregister, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Create WorkFlow Transition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Assignment wfInitiator = null;
        HashMap<String, String> finalDesignationNames = new HashMap<String, String>();
        String currState = "";
        String stateValue = "";
        if (null != egBillregister.getId()) {
            wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(egBillregister.getCreatedBy().getId());
        }
        if ("Reject".toString().equalsIgnoreCase(workFlowAction)) {
            stateValue = "Rejected";
            egBillregister.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(stateValue).withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("").withNatureOfTask("Expense Bill");
        } else {
            WorkFlowMatrix wfmatrix;
            if (null != approvalPosition && approvalPosition != -1L && !approvalPosition.equals(0L)) {
                wfInitiator = (Assignment)this.assignmentService.getAssignmentsForPosition(approvalPosition).get(0);
            }
            if ((wfmatrix = this.egBillregisterRegisterWorkflowService.getWfMatrix(egBillregister.getStateType(), null, null, additionalRule, "Final Approval Pending", null)) != null && wfmatrix.getCurrentDesignation() != null) {
                List<String> finalDesignationName = Arrays.asList(wfmatrix.getCurrentDesignation().split(","));
                for (String desgName : finalDesignationName) {
                    if (desgName == null || "".equals(desgName.trim())) continue;
                    finalDesignationNames.put(desgName.toUpperCase(), desgName.toUpperCase());
                }
            }
            if (null == egBillregister.getState()) {
                if (wfInitiator.getDesignation() != null && finalDesignationNames.get(wfInitiator.getDesignation().getName().toUpperCase()) != null) {
                    stateValue = "Final Approval Pending";
                }
                wfmatrix = this.egBillregisterRegisterWorkflowService.getWfMatrix(egBillregister.getStateType(), null, null, additionalRule, "", null);
                if (stateValue.isEmpty()) {
                    stateValue = wfmatrix.getNextState();
                }
                egBillregister.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(stateValue).withDateInfo(new Date()).withOwner(wfInitiator.getPosition()).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Expense Bill");
            } else if ("Cancel".toString().equalsIgnoreCase(workFlowAction)) {
                stateValue = "Cancelled";
                wfmatrix = this.egBillregisterRegisterWorkflowService.getWfMatrix(egBillregister.getStateType(), null, null, additionalRule, egBillregister.getCurrentState().getValue(), null);
                egBillregister.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(stateValue).withDateInfo(currentDate.toDate()).withNextAction("").withNatureOfTask("Expense Bill");
            } else if ("Approve".toString().equalsIgnoreCase(workFlowAction)) {
                wfmatrix = this.egBillregisterRegisterWorkflowService.getWfMatrix(egBillregister.getStateType(), null, null, additionalRule, egBillregister.getCurrentState().getValue(), null);
                if (stateValue.isEmpty()) {
                    stateValue = wfmatrix.getNextState();
                }
                egBillregister.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(stateValue).withDateInfo(new Date()).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Expense Bill");
            } else {
                if (wfInitiator.getDesignation() != null && finalDesignationNames.get(wfInitiator.getDesignation().getName().toUpperCase()) != null) {
                    stateValue = "Final Approval Pending";
                }
                wfmatrix = this.egBillregisterRegisterWorkflowService.getWfMatrix(egBillregister.getStateType(), null, null, additionalRule, egBillregister.getCurrentState().getValue(), null);
                if (stateValue.isEmpty()) {
                    stateValue = wfmatrix.getNextState();
                }
                egBillregister.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(stateValue).withDateInfo(new Date()).withOwner(wfInitiator.getPosition()).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Expense Bill");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" WorkFlow Transition Completed  ...");
        }
    }

    public Long getApprovalPositionByMatrixDesignation(EgBillregister egBillregister, String additionalRule, String mode, String workFlowAction) {
        Long approvalPosition = null;
        WorkFlowMatrix wfmatrix = this.egBillregisterRegisterWorkflowService.getWfMatrix(egBillregister.getStateType(), null, null, additionalRule, egBillregister.getCurrentState().getValue(), null);
        if (egBillregister.getState() != null && !egBillregister.getState().getHistory().isEmpty() && egBillregister.getState().getOwnerPosition() != null) {
            approvalPosition = egBillregister.getState().getOwnerPosition().getId();
        } else if (wfmatrix != null) {
            approvalPosition = this.financialUtils.getApproverPosition(wfmatrix.getNextDesignation(), egBillregister.getState(), egBillregister.getCreatedBy().getId());
        }
        if (workFlowAction.equals("Cancel")) {
            approvalPosition = null;
        }
        return approvalPosition;
    }

    public boolean isBillNumUnique(String billnumber) {
        EgBillregister bill = this.getByBillnumber(billnumber);
        return bill == null;
    }
}

