/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.es.utils;

import org.apache.commons.lang3.StringUtils;
import org.egov.egf.bean.dashboard.FinancialsBudgetDetailResponse;
import org.egov.egf.bean.dashboard.FinancialsDetailResponse;
import org.egov.egf.bean.dashboard.FinancialsDetailsRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class FinancialsDashBoardUtils {
    public static final String FUND = "fund";
    public static final String FUNCTION = "function";
    private static final String ADM_WARD = "admWard";
    private static final String REGION = "regname";
    private static final String DISTRICT = "distname";
    private static final String GRADE = "ulbgrade";
    private static final String ULBCODE = "ulbcode";
    private static final String ULBNAME = "ulbname";
    private static final String VOUCHER_DATE = "vouchereffectivedate";
    private static final String ADM_ZONE = "admZone";
    private static final String FUND_NAME = "voucherfundname";
    private static final String DEPARTMENT_CODE = "vouchermisdepartmentname";
    private static final String FUNCTION_CODE = "vouchermisfunctionname";
    private static final String FUNDSOURCE_CODE = "vouchermisfundsourcename";
    private static final String SCHEME_CODE = "vouchermisschemename";
    private static final String SUBSCHEME_CODE = "vouchermissubschemename";
    private static final String MAJOR_CODE = "majorcode";
    private static final String MINOR_CODE = "minorcode";
    private static final String DETAILED_CODE = "glcode";
    private static final String DEPARTMENT = "department";

    public static String getAggregationGroupingField(FinancialsDetailsRequest financialsDetailsRequest) {
        String aggregationField = "";
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getAggregationLevel())) {
            aggregationField = FinancialsDashBoardUtils.setAggregateLevel(financialsDetailsRequest);
            if (FUND.equalsIgnoreCase(financialsDetailsRequest.getAggregationLevel())) {
                aggregationField = FUND_NAME;
            }
            if (DEPARTMENT.equalsIgnoreCase(financialsDetailsRequest.getAggregationLevel())) {
                aggregationField = DEPARTMENT_CODE;
            }
            if (FUNCTION.equalsIgnoreCase(financialsDetailsRequest.getAggregationLevel())) {
                aggregationField = FUNCTION_CODE;
            }
            if ("fundsource".equalsIgnoreCase(financialsDetailsRequest.getAggregationLevel())) {
                aggregationField = FUNDSOURCE_CODE;
            }
            if ("scheme".equalsIgnoreCase(financialsDetailsRequest.getAggregationLevel())) {
                aggregationField = SCHEME_CODE;
            }
            if ("subscheme".equalsIgnoreCase(financialsDetailsRequest.getAggregationLevel())) {
                aggregationField = SUBSCHEME_CODE;
            }
        }
        return aggregationField;
    }

    public static BoolQueryBuilder prepareWhereClause(FinancialsDetailsRequest financialsDetailsRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery = FinancialsDashBoardUtils.prepareWhereCluase(financialsDetailsRequest, boolQuery);
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getDepartmentCode())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)DEPARTMENT_CODE, (Object)financialsDetailsRequest.getDepartmentCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getFromDate()) || StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getToDate())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)VOUCHER_DATE).from(financialsDetailsRequest.getFromDate()).to(financialsDetailsRequest.getToDate()));
        }
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getFunctionCode())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)FUNCTION_CODE, (Object)financialsDetailsRequest.getFunctionCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getFundCode())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)FUND_NAME, (Object)financialsDetailsRequest.getFundCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getFundSource())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)FUNDSOURCE_CODE, (Object)financialsDetailsRequest.getFundSource()));
        }
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getSchemeCode())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)SCHEME_CODE, (Object)financialsDetailsRequest.getSchemeCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getSubschemeCode())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)SUBSCHEME_CODE, (Object)financialsDetailsRequest.getSubschemeCode()));
        }
        return boolQuery;
    }

    public static BoolQueryBuilder prepareOpeningBlncWhereClause(FinancialsDetailsRequest financialsDetailsRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery = FinancialsDashBoardUtils.prepareWhereCluase(financialsDetailsRequest, boolQuery);
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getFundCode())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"fundname", (Object)financialsDetailsRequest.getFundCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getDepartmentCode())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"departmentname", (Object)financialsDetailsRequest.getDepartmentCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getFunctionCode())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"functionname", (Object)financialsDetailsRequest.getFunctionCode()));
        }
        return boolQuery;
    }

    private static BoolQueryBuilder prepareWhereCluase(FinancialsDetailsRequest financialsDetailsRequest, BoolQueryBuilder boolQuery) {
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getUlbCode())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)ULBCODE, (Object)financialsDetailsRequest.getUlbCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getUlbName())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)ULBNAME, (Object)financialsDetailsRequest.getUlbName()));
        }
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getDistrict())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)DISTRICT, (Object)financialsDetailsRequest.getDistrict()));
        }
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getRegion())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)REGION, (Object)financialsDetailsRequest.getRegion()));
        }
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getGrade())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)GRADE, (Object)financialsDetailsRequest.getGrade()));
        }
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getDetailedCode())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)DETAILED_CODE, (Object)financialsDetailsRequest.getDetailedCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getMajorCode())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)MAJOR_CODE, (Object)financialsDetailsRequest.getMajorCode().toLowerCase()));
        }
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getMinorCode())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)MINOR_CODE, (Object)financialsDetailsRequest.getMinorCode().toLowerCase()));
        }
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getAdmWard())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)ADM_WARD, (Object)financialsDetailsRequest.getAdmWard()));
        }
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getAdmZone())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)ADM_ZONE, (Object)financialsDetailsRequest.getAdmZone()));
        }
        return boolQuery;
    }

    public static String getOpeningBlncAggrGroupingField(FinancialsDetailsRequest financialsDetailsRequest) {
        String aggregationField = "";
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getAggregationLevel())) {
            aggregationField = FinancialsDashBoardUtils.setAggregateLevel(financialsDetailsRequest);
            if (FUND.equalsIgnoreCase(financialsDetailsRequest.getAggregationLevel())) {
                aggregationField = "fundname";
            }
            if (DEPARTMENT.equalsIgnoreCase(financialsDetailsRequest.getAggregationLevel())) {
                aggregationField = "departmentname";
            }
            if (FUNCTION.equalsIgnoreCase(financialsDetailsRequest.getAggregationLevel())) {
                aggregationField = "functionname";
            }
        }
        return aggregationField;
    }

    private static String setAggregateLevel(FinancialsDetailsRequest financialsDetailsRequest) {
        String aggregationField = "";
        if ("district".equalsIgnoreCase(financialsDetailsRequest.getAggregationLevel())) {
            aggregationField = DISTRICT;
        }
        if ("region".equalsIgnoreCase(financialsDetailsRequest.getAggregationLevel())) {
            aggregationField = REGION;
        }
        if ("grade".equalsIgnoreCase(financialsDetailsRequest.getAggregationLevel())) {
            aggregationField = GRADE;
        }
        if ("ulb".equalsIgnoreCase(financialsDetailsRequest.getAggregationLevel())) {
            aggregationField = ULBCODE;
        }
        if ("majorCode".equalsIgnoreCase(financialsDetailsRequest.getAggregationLevel())) {
            aggregationField = MAJOR_CODE;
        }
        if ("minorCode".equalsIgnoreCase(financialsDetailsRequest.getAggregationLevel())) {
            aggregationField = MINOR_CODE;
        }
        if ("detailedCode".equalsIgnoreCase(financialsDetailsRequest.getAggregationLevel())) {
            aggregationField = DETAILED_CODE;
        }
        if ("admz".equalsIgnoreCase(financialsDetailsRequest.getAggregationLevel())) {
            aggregationField = ADM_ZONE;
        }
        if ("admw".equalsIgnoreCase(financialsDetailsRequest.getAggregationLevel())) {
            aggregationField = ADM_WARD;
        }
        return aggregationField;
    }

    public static void setValues(String keyName, FinancialsDetailResponse financialsDetail, String aggrField, FinancialsDetailResponse finResponse) {
        if (DISTRICT.equalsIgnoreCase(aggrField)) {
            financialsDetail.setDistrict(keyName);
            financialsDetail.setRegion(finResponse.getRegion());
        }
        if (REGION.equalsIgnoreCase(aggrField)) {
            financialsDetail.setRegion(keyName);
        }
        if (GRADE.equalsIgnoreCase(aggrField)) {
            financialsDetail.setGrade(keyName);
        }
        if (ULBCODE.equalsIgnoreCase(aggrField)) {
            financialsDetail.setUlbCode(keyName);
            financialsDetail.setUlbName(finResponse.getUlbName());
            financialsDetail.setDistrict(finResponse.getDistrict());
            financialsDetail.setGrade(finResponse.getGrade());
            financialsDetail.setRegion(finResponse.getRegion());
        }
        if (MAJOR_CODE.equalsIgnoreCase(aggrField)) {
            financialsDetail.setMajorCode(keyName);
            financialsDetail.setMajorCodeDescription(finResponse.getMajorCodeDescription());
        }
        if (MINOR_CODE.equalsIgnoreCase(aggrField)) {
            financialsDetail.setMinorCode(keyName);
            financialsDetail.setMinorCodeDescription(finResponse.getMinorCodeDescription());
        }
        if (DETAILED_CODE.equalsIgnoreCase(aggrField)) {
            financialsDetail.setDetailedCode(keyName);
            financialsDetail.setDetailedCodeDescription(finResponse.getDetailedCodeDescription());
        }
        if (ADM_ZONE.equalsIgnoreCase(aggrField)) {
            financialsDetail.setAdmZoneName(keyName);
        }
        if (ADM_WARD.equalsIgnoreCase(aggrField)) {
            financialsDetail.setAdmWardName(keyName);
        }
        if (FUND_NAME.equalsIgnoreCase(aggrField)) {
            financialsDetail.setFundCode(keyName);
        }
        if (DEPARTMENT_CODE.equalsIgnoreCase(aggrField)) {
            financialsDetail.setDepartmentCode(keyName);
        }
        if (FUNCTION_CODE.equalsIgnoreCase(aggrField)) {
            financialsDetail.setFunctionCode(keyName);
        }
        if (FUNDSOURCE_CODE.equalsIgnoreCase(aggrField)) {
            financialsDetail.setFundSource(keyName);
        }
        if (SCHEME_CODE.equalsIgnoreCase(aggrField)) {
            financialsDetail.setSchemeCode(keyName);
        }
        if (SUBSCHEME_CODE.equalsIgnoreCase(aggrField)) {
            financialsDetail.setSubschemeCode(keyName);
        }
    }

    public static BoolQueryBuilder prepareWhereClauseForBudget(FinancialsDetailsRequest financialsDetailsRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery = FinancialsDashBoardUtils.prepareWhereCluase(financialsDetailsRequest, boolQuery);
        FinancialsDashBoardUtils.prepairWhereClauseForScheme(financialsDetailsRequest, boolQuery);
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getDepartmentCode())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"departmentName", (Object)financialsDetailsRequest.getDepartmentCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getFromDate()) || StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getToDate())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"budgetdetailcreateddate").from(financialsDetailsRequest.getFromDate()).to(financialsDetailsRequest.getToDate()));
        }
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getFunctionCode())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"functionName", (Object)financialsDetailsRequest.getFunctionCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getFundCode())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"fundName", (Object)financialsDetailsRequest.getFundCode()));
        }
        return boolQuery;
    }

    private static void prepairWhereClauseForScheme(FinancialsDetailsRequest financialsDetailsRequest, BoolQueryBuilder boolQuery) {
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getSchemeCode())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"schemeName", (Object)financialsDetailsRequest.getSchemeCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getSubschemeCode())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"subSchemeName", (Object)financialsDetailsRequest.getSubschemeCode()));
        }
    }

    public static void setValuesForBudget(String keyName, FinancialsBudgetDetailResponse financialsBudgetDetailResponse, String aggrField, FinancialsBudgetDetailResponse finResponse) {
        FinancialsDashBoardUtils.setCommonDataToResponse(keyName, financialsBudgetDetailResponse, aggrField, finResponse);
        FinancialsDashBoardUtils.setFinancialsDataToResponse(keyName, financialsBudgetDetailResponse, aggrField);
        FinancialsDashBoardUtils.setChartOfAccountToResponse(keyName, financialsBudgetDetailResponse, aggrField, finResponse);
        if (ADM_ZONE.equalsIgnoreCase(aggrField)) {
            financialsBudgetDetailResponse.setAdmZoneName(keyName);
        }
        if (ADM_WARD.equalsIgnoreCase(aggrField)) {
            financialsBudgetDetailResponse.setAdmWardName(keyName);
        }
        if (DEPARTMENT_CODE.equalsIgnoreCase(aggrField)) {
            financialsBudgetDetailResponse.setDepartmentCode(keyName);
        }
        if (SCHEME_CODE.equalsIgnoreCase(aggrField)) {
            financialsBudgetDetailResponse.setSchemeCode(keyName);
        }
    }

    private static void setFinancialsDataToResponse(String keyName, FinancialsBudgetDetailResponse financialsBudgetDetailResponse, String aggrField) {
        if (FUND_NAME.equalsIgnoreCase(aggrField)) {
            financialsBudgetDetailResponse.setFundCode(keyName);
        }
        if (FUNCTION_CODE.equalsIgnoreCase(aggrField)) {
            financialsBudgetDetailResponse.setFunctionCode(keyName);
        }
        if (FUNDSOURCE_CODE.equalsIgnoreCase(aggrField)) {
            financialsBudgetDetailResponse.setFundSource(keyName);
        }
        if (SUBSCHEME_CODE.equalsIgnoreCase(aggrField)) {
            financialsBudgetDetailResponse.setSubschemeCode(keyName);
        }
    }

    private static void setChartOfAccountToResponse(String keyName, FinancialsBudgetDetailResponse financialsBudgetDetailResponse, String aggrField, FinancialsBudgetDetailResponse finBudResponse) {
        if (MAJOR_CODE.equalsIgnoreCase(aggrField)) {
            financialsBudgetDetailResponse.setMajorCode(keyName);
            financialsBudgetDetailResponse.setMajorCodeDescription(finBudResponse.getMajorCodeDescription());
        }
        if (MINOR_CODE.equalsIgnoreCase(aggrField)) {
            financialsBudgetDetailResponse.setMinorCode(keyName);
            financialsBudgetDetailResponse.setMinorCodeDescription(finBudResponse.getMinorCodeDescription());
        }
        if (DETAILED_CODE.equalsIgnoreCase(aggrField)) {
            financialsBudgetDetailResponse.setDetailedCode(keyName);
            financialsBudgetDetailResponse.setDetailedCodeDescription(finBudResponse.getDetailedCodeDescription());
        }
    }

    private static void setCommonDataToResponse(String keyName, FinancialsBudgetDetailResponse financialsBudgetDetailResponse, String aggrField, FinancialsBudgetDetailResponse finResponse) {
        if (DISTRICT.equalsIgnoreCase(aggrField)) {
            financialsBudgetDetailResponse.setDistrict(keyName);
            financialsBudgetDetailResponse.setRegion(finResponse.getRegion());
        }
        if (REGION.equalsIgnoreCase(aggrField)) {
            financialsBudgetDetailResponse.setRegion(keyName);
        }
        if (GRADE.equalsIgnoreCase(aggrField)) {
            financialsBudgetDetailResponse.setGrade(keyName);
        }
        if (ULBCODE.equalsIgnoreCase(aggrField)) {
            financialsBudgetDetailResponse.setUlbCode(keyName);
            financialsBudgetDetailResponse.setUlbName(finResponse.getUlbName());
            financialsBudgetDetailResponse.setDistrict(finResponse.getDistrict());
            financialsBudgetDetailResponse.setGrade(finResponse.getGrade());
            financialsBudgetDetailResponse.setRegion(finResponse.getRegion());
        }
    }

    public static String getAggregationGroupingFieldForBudget(FinancialsDetailsRequest financialsDetailsRequest) {
        String aggregationField = "";
        if (StringUtils.isNotBlank((CharSequence)financialsDetailsRequest.getAggregationLevel())) {
            aggregationField = FinancialsDashBoardUtils.setAggregateLevel(financialsDetailsRequest);
            if ("departmentName".equalsIgnoreCase(financialsDetailsRequest.getAggregationLevel())) {
                aggregationField = DEPARTMENT_CODE;
            }
            aggregationField = FinancialsDashBoardUtils.aggregateFinancialFields(financialsDetailsRequest, aggregationField);
        }
        return aggregationField;
    }

    private static String aggregateFinancialFields(FinancialsDetailsRequest financialsDetailsRequest, String aggregationField) {
        if ("fundName".equalsIgnoreCase(financialsDetailsRequest.getAggregationLevel())) {
            aggregationField = FUND_NAME;
        }
        if ("functionName".equalsIgnoreCase(financialsDetailsRequest.getAggregationLevel())) {
            aggregationField = FUNCTION_CODE;
        }
        if ("schemeName".equalsIgnoreCase(financialsDetailsRequest.getAggregationLevel())) {
            aggregationField = SCHEME_CODE;
        }
        if ("subSchemeName".equalsIgnoreCase(financialsDetailsRequest.getAggregationLevel())) {
            aggregationField = SUBSCHEME_CODE;
        }
        return aggregationField;
    }
}

