/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.commons.bankbranch.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.egov.commons.Bankbranch;
import org.egov.egf.commons.bankbranch.repository.BankBranchRepository;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CreateBankBranchService {
    @PersistenceContext
    private EntityManager entityManager;
    private final BankBranchRepository bankBranchRepository;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public CreateBankBranchService(BankBranchRepository bankBranchRepository) {
        this.bankBranchRepository = bankBranchRepository;
    }

    public Bankbranch getById(Integer id) {
        return (Bankbranch)this.bankBranchRepository.findOne(id);
    }

    public List<Bankbranch> getByBankId(Integer bankId) {
        return this.bankBranchRepository.findByBank_Id(bankId);
    }

    public List<Bankbranch> getByIsActive(Boolean isActive) {
        return this.bankBranchRepository.findByIsactive(isActive);
    }

    public List<Bankbranch> getByIsActiveTrueOrderByBranchname() {
        return this.bankBranchRepository.findByIsactiveTrueOrderByBranchnameAsc();
    }

    @Transactional
    public Bankbranch create(Bankbranch bankBranch) {
        bankBranch.setCreatedDate(new Date());
        bankBranch.setCreatedBy((User)this.getCurrentSession().load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
        return (Bankbranch)this.bankBranchRepository.save(bankBranch);
    }

    @Transactional
    public Bankbranch update(Bankbranch bankbranch) {
        bankbranch.setLastModifiedDate(new Date());
        bankbranch.setLastModifiedBy((User)this.getCurrentSession().load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
        return (Bankbranch)this.bankBranchRepository.save(bankbranch);
    }

    public List<Bankbranch> search(Bankbranch bankBranch) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery createQuery = cb.createQuery(Bankbranch.class);
        Root bankBranchs = createQuery.from(Bankbranch.class);
        createQuery.select((Selection)bankBranchs);
        Metamodel m = this.entityManager.getMetamodel();
        EntityType tempBankBranch = m.entity(Bankbranch.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (bankBranch.getBranchcode() != null) {
            String code = "%" + bankBranch.getBranchcode().toLowerCase() + "%";
            predicates.add(cb.isNotNull((Expression)bankBranchs.get("branchcode")));
            predicates.add(cb.like(cb.lower((Expression)bankBranchs.get(tempBankBranch.getDeclaredSingularAttribute("branchcode", String.class))), code));
        }
        if (bankBranch.getBranchMICR() != null) {
            predicates.add(cb.equal((Expression)bankBranchs.get("branchMICR"), (Object)bankBranch.getBranchMICR()));
        }
        if (bankBranch.getBranchaddress1() != null) {
            predicates.add(cb.equal((Expression)bankBranchs.get("branchaddress1"), (Object)bankBranch.getBranchaddress1()));
        }
        if (bankBranch.getContactperson() != null) {
            predicates.add(cb.equal((Expression)bankBranchs.get("contactperson"), (Object)bankBranch.getContactperson()));
        }
        if (bankBranch.getBranchphone() != null) {
            predicates.add(cb.equal((Expression)bankBranchs.get("branchphone"), (Object)bankBranch.getBranchphone()));
        }
        if (bankBranch.getNarration() != null) {
            predicates.add(cb.equal((Expression)bankBranchs.get("narration"), (Object)bankBranch.getNarration()));
        }
        if (bankBranch.getIsactive().booleanValue()) {
            predicates.add(cb.equal((Expression)bankBranchs.get("isactive"), (Object)true));
        }
        if (bankBranch.getBank() != null && bankBranch.getBank().getId() != null) {
            predicates.add(cb.equal((Expression)bankBranchs.get("bank").get("id"), (Object)bankBranch.getBank().getId()));
        }
        if (bankBranch.getId() != null) {
            predicates.add(cb.equal((Expression)bankBranchs.get("id"), (Object)bankBranch.getId()));
        }
        createQuery.where(predicates.toArray(new Predicate[0]));
        TypedQuery query = this.entityManager.createQuery(createQuery);
        return query.getResultList();
    }
}

