/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dao.recoveries;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.EgPartytype;
import org.egov.commons.EgwTypeOfWork;
import org.egov.model.recoveries.EgDeductionDetails;
import org.egov.model.recoveries.Recovery;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class EgDeductionDetailsHibernateDAO {
    @PersistenceContext
    private EntityManager entityManager;
    private Session session;

    @Transactional
    public EgDeductionDetails update(EgDeductionDetails entity) {
        this.getCurrentSession().update((Object)entity);
        return entity;
    }

    @Transactional
    public EgDeductionDetails create(EgDeductionDetails entity) {
        this.getCurrentSession().persist((Object)entity);
        return entity;
    }

    @Transactional
    public void delete(EgDeductionDetails entity) {
        this.getCurrentSession().delete((Object)entity);
    }

    public EgDeductionDetails findById(Number id, boolean lock) {
        return (EgDeductionDetails)this.getCurrentSession().load(EgDeductionDetails.class, (Serializable)id);
    }

    public List<EgDeductionDetails> findAll() {
        return this.getCurrentSession().createCriteria(EgDeductionDetails.class).list();
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List findByTds(Recovery tds) {
        this.session = this.getCurrentSession();
        Query qry = this.session.createQuery("from EgDeductionDetails ded where ded.recovery=:tds order by ded.id");
        qry.setEntity("tds", (Object)tds);
        return qry.list();
    }

    public List<EgDeductionDetails> getEgDeductionDetailsFilterBy(Recovery tds, BigDecimal amount, String date, EgwTypeOfWork egwTypeOfWork, EgwTypeOfWork egwSubTypeOfWork) {
        this.session = this.getCurrentSession();
        StringBuffer qryStr = new StringBuffer();
        List egDeductionDetailsList = null;
        qryStr.append("from EgDeductionDetails ed where ed.recovery=:tds ");
        Query qry = this.session.createQuery(qryStr.toString());
        if (amount != null) {
            qryStr.append(" and ((ed.lowlimit<=:amount and ed.highlimit>=:amount and ed.highlimit is not null) or (ed.lowlimit<=:amount and ed.highlimit is null)) ");
            qry = this.session.createQuery(qryStr.toString());
        }
        if (date != null && !date.equals("")) {
            qryStr.append(" and ((ed.datefrom<=:date and ed.dateto>=:date and ed.dateto is not null) or(ed.datefrom<=:date and ed.dateto is null))");
            qry = this.session.createQuery(qryStr.toString());
        }
        if (egwTypeOfWork != null) {
            qryStr.append(" and ed.workDocType =:egwTypeOfWork");
            qry = this.session.createQuery(qryStr.toString());
        }
        if (egwSubTypeOfWork != null) {
            qryStr.append("  and ed.workDocSubType =:egwSubTypeOfWork");
            qry = this.session.createQuery(qryStr.toString());
        }
        qryStr.append(" order by id");
        qry = this.session.createQuery(qryStr.toString());
        if (tds != null) {
            qry.setEntity("tds", (Object)tds);
        }
        if (date != null && !date.equals("")) {
            qry.setString("date", date);
        }
        if (amount != null) {
            qry.setBigDecimal("amount", amount);
        }
        if (egwTypeOfWork != null) {
            qry.setEntity("egwTypeOfWork", (Object)egwTypeOfWork);
        }
        if (egwSubTypeOfWork != null) {
            qry.setEntity("egwSubTypeOfWork", (Object)egwSubTypeOfWork);
        }
        egDeductionDetailsList = qry.list();
        return egDeductionDetailsList;
    }

    public EgDeductionDetails findEgDeductionDetailsForDeduAmt(Recovery recovery, EgPartytype egPartyType, EgPartytype egPartySubType, EgwTypeOfWork docType, Date date) {
        EgDeductionDetails egDeductionDetails = null;
        this.session = this.getCurrentSession();
        StringBuffer qryStr = new StringBuffer();
        qryStr.append("from EgDeductionDetails ed where ed.recovery=:recovery ");
        if (null != egPartySubType) {
            qryStr.append(" and ed.egpartytype =:egPartySubType ");
        }
        if (null != docType) {
            qryStr.append(" and ed.workDocType =:docType ");
        }
        if (null != date) {
            qryStr.append(" and ((ed.datefrom <=:date and ed.dateto>=:date and ed.dateto is not null) or (ed.datefrom<=:date and ed.dateto is null)) ");
        }
        Query qry = this.session.createQuery(qryStr.toString());
        if (null != recovery) {
            qry.setEntity("recovery", (Object)recovery);
        }
        if (null != egPartySubType) {
            qry.setEntity("egPartySubType", (Object)egPartySubType);
        }
        if (null != docType) {
            qry.setEntity("docType", (Object)docType);
        }
        if (null != date) {
            qry.setDate("date", date);
        }
        egDeductionDetails = (EgDeductionDetails)qry.uniqueResult();
        return egDeductionDetails;
    }
}

