/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.exility.updateservice;

import com.exilant.exility.common.DataCollection;
import com.exilant.exility.common.TaskFailedException;
import com.exilant.exility.updateservice.ColumnDefinition;
import com.exilant.exility.updateservice.PrimaryKeyGenerator;
import org.apache.log4j.Logger;

public class TableDefinition {
    private static final Logger LOGGER = Logger.getLogger(TableDefinition.class);
    public String name;
    boolean hasSurrogateKey = true;
    boolean hasCreatedTimestamp = true;
    boolean hasModifiedTimestamp = true;
    boolean hasCreatedUser = false;
    boolean hasModifiedUser = true;
    boolean hasActiveField = true;
    public String keyColumnName;
    public boolean keyRequiresQuote = false;
    public ColumnDefinition[] columnDefinitions;
    public boolean okToDelete = false;
    private final String USER_ID_NAME = "current_UserID";
    private final String COMMA = ",";
    private final String QUOTE = "'";
    private final char CONNECTOR = (char)95;
    private final char EQUAL = (char)61;
    private final String now = "CURRENT_DATE";

    public String getUpdateSQL(DataCollection dc) throws TaskFailedException {
        return this.getUpdateSQL(dc, -1);
    }

    public String getDeleteSQL(DataCollection dc) throws TaskFailedException {
        return this.getDeleteSQL(dc, -1);
    }

    public String getDeleteSQL(DataCollection dc, int rowid) throws TaskFailedException {
        if (!this.okToDelete) {
            dc.addMessage("exilDeleteNotAllowed", this.name);
            throw new TaskFailedException();
        }
        String nameInDC = this.name + '_' + this.keyColumnName;
        String keyValue = null;
        if (rowid == -1) {
            keyValue = dc.getValue(nameInDC);
        } else {
            String[] keyValues = dc.getValueList(nameInDC);
            if (null != keyValues && rowid < keyValues.length) {
                keyValue = keyValues[rowid];
            }
        }
        if (null == keyValue || keyValue.length() == 0 || keyValue.equals("0")) {
            dc.addMessage("exilNoKeyForUpdate", this.name, this.keyColumnName, this.name + '_' + this.keyColumnName);
            throw new TaskFailedException();
        }
        StringBuffer sbf = new StringBuffer();
        sbf.append("DELETE ").append(this.name).append(" WHERE ").append(this.keyColumnName).append("=");
        if (this.keyRequiresQuote) {
            sbf.append("'").append(keyValue).append("'");
        } else {
            sbf.append(keyValue);
        }
        return sbf.toString();
    }

    public String getUpdateSQL(DataCollection dc, int rowid) throws TaskFailedException {
        if (this.columnDefinitions == null) {
            dc.addMessage("exilNoColumns", this.name);
            throw new TaskFailedException();
        }
        StringBuffer sbf = new StringBuffer("UPDATE ").append(this.name).append(" SET ");
        boolean valid = true;
        String columnValue = null;
        int nbrColumns = 0;
        String prefix = "";
        ColumnDefinition[] columnDefinitionArray = this.columnDefinitions;
        int n = columnDefinitionArray.length;
        for (int i = 0; i < n; ++i) {
            ColumnDefinition columnDefinition;
            ColumnDefinition column = columnDefinition = columnDefinitionArray[i];
            String nameInDC = this.name + '_' + column.name;
            if (rowid >= 0) {
                String[] valueList = dc.getValueList(nameInDC);
                if (null != valueList && valueList.length > rowid) {
                    columnValue = valueList[rowid];
                }
            } else {
                if (!dc.hasName(nameInDC)) continue;
                columnValue = dc.getValue(nameInDC);
            }
            ++nbrColumns;
            sbf.append(prefix).append(column.name).append('=');
            if (null == columnValue || columnValue.length() == 0) {
                sbf.append("null");
            } else if (column.requiresQuote) {
                sbf.append("'").append(columnValue.replaceAll("'", "''")).append("'");
            } else {
                sbf.append(columnValue);
            }
            prefix = ",";
        }
        if (nbrColumns == 0) {
            valid = false;
            dc.addMessage("exilNothingToUpdate", this.name);
        }
        if (!valid) {
            throw new TaskFailedException();
        }
        this.appendStandardUpdateValues(sbf, dc, rowid);
        return sbf.toString();
    }

    public String getInsertSQL(DataCollection dc) throws TaskFailedException {
        return this.getInsertSQL(dc, -1);
    }

    public String getInsertSQL(DataCollection dc, int rowid) throws TaskFailedException {
        if (this.columnDefinitions == null || this.columnDefinitions.length == 0) {
            dc.addMessage("exilNoColumns", this.name);
            throw new TaskFailedException();
        }
        StringBuffer sbfNames = new StringBuffer();
        sbfNames.append("INSERT INTO ").append(this.name).append('(');
        StringBuffer sbfValues = new StringBuffer();
        sbfValues.append(" VALUES ").append('(');
        boolean valid = true;
        String columnValue = null;
        int nbrColumns = 0;
        String prefix = "";
        for (int i = 0; i < this.columnDefinitions.length; ++i) {
            ColumnDefinition column = this.columnDefinitions[i];
            String nameInDC = this.name + '_' + column.name;
            if (rowid >= 0) {
                String[] valueList = dc.getValueList(nameInDC);
                if (null != valueList && valueList.length > rowid) {
                    columnValue = valueList[rowid];
                }
            } else {
                columnValue = dc.getValue(nameInDC);
            }
            if (null == columnValue || columnValue.length() == 0) {
                columnValue = column.defaultValue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("column =========== " + i));
            }
            ++nbrColumns;
            sbfNames.append(prefix).append(column.name);
            sbfValues.append(prefix);
            if (column.requiresQuote) {
                sbfValues.append("'").append(columnValue.replaceAll("'", "''")).append("'");
            } else {
                sbfValues.append(columnValue);
            }
            prefix = ",";
        }
        if (nbrColumns == 0) {
            dc.addMessage("exilNothingToInsert", this.name);
            throw new TaskFailedException();
        }
        this.appendStandardInsertNames(sbfNames);
        this.appendStandardInsertValues(sbfValues, dc);
        sbfNames.append(')');
        sbfValues.append(')');
        return sbfNames.append(sbfValues).toString();
    }

    private StringBuffer appendStandardInsertNames(StringBuffer sbfNames) {
        if (this.hasSurrogateKey) {
            sbfNames.append(",").append("ID");
        }
        if (this.hasCreatedTimestamp) {
            sbfNames.append(",").append("created");
        }
        if (this.hasCreatedUser) {
            sbfNames.append(",").append("");
        }
        if (this.hasModifiedTimestamp) {
            sbfNames.append(",").append("lastModified");
        }
        if (this.hasModifiedUser) {
            sbfNames.append(",").append("modifiedBy");
        }
        if (this.hasActiveField) {
            sbfNames.append(",").append("isActive");
        }
        return sbfNames;
    }

    private StringBuffer appendStandardInsertValues(StringBuffer sbfValues, DataCollection dc) {
        String user = dc.getValue("current_UserID");
        if (this.hasSurrogateKey) {
            sbfValues.append(",").append(PrimaryKeyGenerator.getNextKey(this.name));
        }
        if (this.hasCreatedTimestamp) {
            sbfValues.append(",").append("CURRENT_DATE");
        }
        if (this.hasCreatedUser) {
            sbfValues.append(",").append(user);
        }
        if (this.hasModifiedTimestamp) {
            sbfValues.append(",").append("CURRENT_DATE");
        }
        if (this.hasModifiedUser) {
            sbfValues.append(",").append(user);
        }
        if (this.hasActiveField) {
            sbfValues.append(",").append(1);
        }
        return sbfValues;
    }

    private StringBuffer appendStandardUpdateValues(StringBuffer sbf, DataCollection dc, int rowid) throws TaskFailedException {
        String key = null;
        String nameInDC = this.name + '_' + this.keyColumnName;
        if (rowid < 0) {
            key = dc.getValue(nameInDC);
        } else {
            String[] keys = dc.getValueList(nameInDC);
            if (null != keys && keys.length > rowid) {
                key = keys[rowid];
            }
        }
        if (key == null || key.length() == 0 || key.equals("0")) {
            dc.addMessage("exilNoKeyForUpdate", this.name, this.keyColumnName, this.name + '_' + this.keyColumnName);
            throw new TaskFailedException();
        }
        String user = dc.getValue("current_UserID");
        if (this.hasModifiedTimestamp) {
            sbf.append(",").append("lastModified").append('=').append("CURRENT_DATE");
        }
        if (this.hasModifiedUser) {
            sbf.append(",").append("modifiedBy").append('=').append(user);
        }
        if (this.hasActiveField) {
            String fieldName = this.name + '_' + "isActive";
            if (dc.hasName(fieldName)) {
                sbf.append(",").append("isActive").append('=').append(dc.getValue(fieldName));
            } else {
                sbf.append(",").append("isActive").append('=').append('0');
            }
        }
        sbf.append(" WHERE ").append(this.keyColumnName).append('=');
        if (this.keyRequiresQuote) {
            sbf.append("'").append(key).append("'");
        } else {
            sbf.append(key);
        }
        if (this.hasModifiedTimestamp) {
            String stamp = null;
            String stampName = this.name + '_' + "lastModified";
            if (rowid < 0) {
                stamp = dc.getValue(stampName);
            } else {
                String[] stamps = dc.getValueList(stampName);
                if (null != stamps && stamps.length > rowid) {
                    stamp = stamps[rowid];
                }
            }
            if (stamp == null || stamp.length() == 0 || stamp.equals("0")) {
                dc.addMessage("exilNoTimeStamp", this.name, "lastModified", this.name + '_' + "lastModified");
                throw new TaskFailedException();
            }
            stamp = "to_date('" + stamp + "'" + "," + "'" + "mm/dd/yyyy HH24:MI:SS" + "'" + ")";
            sbf.append(" AND ").append("lastModified").append('=');
            sbf.append(stamp);
        }
        return sbf;
    }

    public void optimize() {
        int length = this.columnDefinitions.length;
        for (int i = 0; i < length; ++i) {
            this.columnDefinitions[i].optimize();
        }
    }
}

