/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.exility.updateservice;

import com.exilant.exility.common.DataCollection;
import com.exilant.exility.common.TaskFailedException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class DataUpdater {
    private static final Logger LOGGER = Logger.getLogger(DataUpdater.class);
    private static DataUpdater singletonInstance;

    public static DataUpdater getUpdater() {
        if (singletonInstance == null) {
            singletonInstance = new DataUpdater();
        }
        return singletonInstance;
    }

    private DataUpdater() {
    }

    public int update(String sql, Connection con, DataCollection dc, boolean errorOnNoUpdate) throws TaskFailedException {
        if (sql == null || sql.length() == 0) {
            return 0;
        }
        int i = dc.getInt("sqlCount");
        dc.addValue("sqlCount", ++i);
        if (null == con) {
            return 0;
        }
        int noOfRowsEffected = 0;
        try {
            Statement statement = con.createStatement();
            PreparedStatement pstmt = con.prepareStatement(sql);
            noOfRowsEffected = pstmt.executeUpdate();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("SSSSSSSS>>>>>>>>>>>>>>>>>>>>>>>>" + sql));
            }
            if (noOfRowsEffected == 0 && errorOnNoUpdate) {
                throw new TaskFailedException();
            }
            dc.addMessage("masterInsertUpdate");
            statement.close();
        }
        catch (SQLException e) {
            LOGGER.error((Object)("err Message  " + e.getErrorCode()), (Throwable)e);
            if (e.getErrorCode() == 1) {
                dc.addMessage("exilDuplicate");
            } else {
                dc.addMessage("exilSQLException", e.getMessage());
            }
            throw new TaskFailedException();
        }
        return noOfRowsEffected;
    }
}

