/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.exility.common;

import com.exilant.exility.common.MessageList;
import com.exilant.exility.common.XMLGenerator;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class DataCollection {
    private static final Logger LOGGER = Logger.getLogger(DataCollection.class);
    public HashMap values = new HashMap();
    protected HashMap valueLists = new HashMap();
    protected HashMap grids = new HashMap();
    protected MessageList messageList = new MessageList();

    public void addValue(String name, String value) {
        this.addValueHelper(name, value);
    }

    public void addValue(String name, int value) {
        this.addValueHelper(name, value);
    }

    public void addValue(String name, long value) {
        this.addValueHelper(name, value);
    }

    public void addValue(String name, float value) {
        this.addValueHelper(name, new Float(value));
    }

    public void addValue(String name, double value) {
        this.addValueHelper(name, new Double(value));
    }

    public void addValue(String name, boolean value) {
        this.addValueHelper(name, value);
    }

    private void addValueHelper(String name, Object value) {
        if (null == this.values) {
            this.values = new HashMap();
        }
        this.values.put(name, value);
    }

    public String getValue(String name) {
        Object obj = this.values.get(name);
        if (null == obj) {
            return "";
        }
        return obj.toString();
    }

    public float getFloat(String name) {
        Object obj = this.values.get(name);
        if (obj instanceof Number) {
            return ((Number)obj).floatValue();
        }
        try {
            return Float.parseFloat(obj.toString());
        }
        catch (Exception e1) {
            LOGGER.error((Object)("Inside getFloat" + e1.getMessage()));
            return 0.0f;
        }
    }

    public double getDouble(String name) {
        Object obj = this.values.get(name);
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        try {
            return Double.parseDouble(obj.toString());
        }
        catch (Exception e1) {
            LOGGER.error((Object)("Inside getDouble" + e1.getMessage()));
            return 0.0;
        }
    }

    public int getInt(String name) {
        Object obj = this.values.get(name);
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        try {
            return Integer.parseInt(obj.toString());
        }
        catch (Exception e1) {
            LOGGER.error((Object)("Inside getInt" + e1.getMessage()));
            return 0;
        }
    }

    public long getLong(String name) {
        Object obj = this.values.get(name);
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        try {
            return Long.parseLong(obj.toString());
        }
        catch (Exception e1) {
            LOGGER.error((Object)("Inside getLong" + e1.getMessage()));
            return 0L;
        }
    }

    public boolean getBoolean(String name) {
        Object obj = this.values.get(name);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return obj.toString().equalsIgnoreCase("true") || obj.toString().equalsIgnoreCase("yes") || obj.toString().equals("1");
    }

    public void addValueList(String name, String[] anArray) {
        this.valueLists.put(name, anArray);
    }

    public String[] getValueList(String name) {
        try {
            return (String[])this.valueLists.get(name);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Inside getValueList" + e.getMessage()));
            String[] arr = new String[]{};
            return arr;
        }
    }

    public void addGrid(String name, String[][] grid) {
        this.grids.put(name, grid);
    }

    public String[][] getGrid(String name) {
        Object obj = this.grids.get(name);
        try {
            return (String[][])obj;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Typecasting error in getGrid" + e.getMessage()));
            String[][] arr = new String[0][0];
            return arr;
        }
    }

    public boolean hasName(String name) {
        return this.values.containsKey(name);
    }

    public boolean hasList(String name) {
        return this.valueLists.containsKey(name);
    }

    public boolean hasgrid(String name) {
        return this.grids.containsKey(name);
    }

    public int addMessage(String code) {
        return this.messageList.add(code);
    }

    public int addMessage(String code, String p1) {
        return this.messageList.add(code, p1);
    }

    public int addMessage(String code, String p1, String p2) {
        return this.messageList.add(code, p1, p2);
    }

    public int addMessage(String code, String p1, String p2, String p3) {
        return this.messageList.add(code, p1, p2, p3);
    }

    public int addMessage(String code, String p1, String p2, String p3, String p4) {
        return this.messageList.add(code, p1, p2, p3, p4);
    }

    public int addMessage(String code, String[] parms) {
        return this.messageList.add(code, parms);
    }

    public int getSevirity() {
        return this.messageList.getSevirity();
    }

    public String getMessageText() {
        return this.messageList.toString();
    }

    public MessageList getMessageList() {
        return this.messageList;
    }

    public Iterator getFieldNames() {
        return this.values.keySet().iterator();
    }

    public Iterator getListNames() {
        return this.valueLists.keySet().iterator();
    }

    public Iterator getGridNames() {
        return this.grids.keySet().iterator();
    }

    public String toString() {
        return XMLGenerator.getInstance().toXML(this, "DataCollection", "");
    }
}

