/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.eGov.src.reports;

import com.exilant.GLEngine.GeneralLedgerBean;
import com.exilant.eGov.src.chartOfAccounts.CodeValidator;
import com.exilant.eGov.src.common.EGovernCommon;
import com.exilant.eGov.src.reports.CashBook;
import com.exilant.eGov.src.reports.CommnFunctions;
import com.exilant.eGov.src.reports.GeneralLedgerReportBean;
import com.exilant.eGov.src.reports.ReportEngine;
import com.exilant.eGov.src.reports.ReportEngineBean;
import com.exilant.eGov.src.transactions.ExilPrecision;
import com.exilant.eGov.src.transactions.OpBal;
import com.exilant.exility.common.TaskFailedException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class GeneralLedgerReport {
    Query pstmt = null;
    List<Object[]> resultset = null;
    List<Object[]> resultset1 = null;
    String accEntityId = null;
    String accEntityKey = null;
    BigDecimal slDrAmount = new BigDecimal("0.00");
    BigDecimal slCrAmount = new BigDecimal("0.00");
    String engineQry = null;
    private static TaskFailedException taskExc;
    String startDate;
    String endDate;
    String effTime;
    String rType = "gl";
    private static final Logger LOGGER;
    OpBal OpBal = new OpBal();
    DecimalFormat dft = new DecimalFormat("##############0.00");
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    EGovernCommon eGovernCommon;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private ReportEngine engine;
    @Autowired
    private FinancialYearHibernateDAO financialYearDAO;
    @Autowired
    private CommnFunctions commnFunctions;

    public LinkedList getGeneralLedgerList(GeneralLedgerReportBean reportBean) throws TaskFailedException {
        LinkedList<GeneralLedgerBean> dataList = new LinkedList<GeneralLedgerBean>();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Indise the loop..........");
        }
        new CashBook(null);
        String isconfirmed = "";
        String glCode1 = "";
        glCode1 = reportBean.getGlCode1();
        try {
            String snapShotDateTime = reportBean.getSnapShotDateTime();
            this.effTime = snapShotDateTime.equalsIgnoreCase("") ? "" : this.eGovernCommon.getEffectiveDateFilter(snapShotDateTime);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw taskExc;
        }
        String fundId = reportBean.getFund_id();
        String deptId = reportBean.getDepartmentId();
        String fundSourceId = reportBean.getFundSource_id();
        reportBean.setFundName(this.getFundName(fundId));
        reportBean.setAccountCode(this.getAccountName(glCode1));
        String formstartDate = "";
        String formendDate = "";
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy");
        Date dt = new Date();
        String endDate1 = reportBean.getEndDate();
        this.isCurDate(endDate1);
        try {
            this.endDate = reportBean.getEndDate();
            dt = sdf.parse(this.endDate);
            formendDate = formatter1.format(dt);
        }
        catch (Exception e) {
            LOGGER.error((Object)("inside the try-startdate" + e), (Throwable)e);
            throw taskExc;
        }
        try {
            this.startDate = reportBean.getStartDate();
            if (!this.startDate.equalsIgnoreCase("null")) {
                dt = sdf.parse(this.startDate);
                formstartDate = formatter1.format(dt);
            }
            if (this.startDate.equalsIgnoreCase("null")) {
                CFinancialYear finYearByDate = this.financialYearDAO.getFinYearByDate(dt);
                if (finYearByDate != null) {
                    this.startDate = formatter1.format(finYearByDate.getStartingDate());
                }
                reportBean.setStartDate(this.startDate);
                Date dtOBj = sdf.parse(this.startDate);
                this.startDate = formatter1.format(dtOBj);
            } else {
                this.startDate = formstartDate;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("inside the try-startdate" + e), (Throwable)e);
            throw taskExc;
        }
        this.accEntityId = reportBean.getAccEntityId();
        this.accEntityKey = reportBean.getAccEntityKey();
        this.endDate = formendDate;
        String startDateformat = this.startDate;
        String startDateformat1 = "";
        try {
            dt = formatter1.parse(startDateformat);
            startDateformat1 = sdf.format(dt);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Parse Exception" + e), (Throwable)e);
            throw taskExc;
        }
        Date dd = new Date();
        String endDateformat = this.endDate;
        try {
            dd = formatter1.parse(endDateformat);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        CFinancialYear finYearByDate = this.financialYearDAO.getFinYearByDate(dd);
        String fyId = finYearByDate.getId().toString();
        if (fyId.equalsIgnoreCase("")) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Financial Year Not Valid");
            }
            throw taskExc;
        }
        CodeValidator.getInstance();
        double txnDrSum = 0.0;
        double txnCrSum = 0.0;
        double openingBalance = 0.0;
        double closingBalance = 0.0;
        ReportEngineBean reBean = this.engine.populateReportEngineBean(reportBean);
        this.engineQry = this.engine.getVouchersListQuery(reBean);
        String query = this.getQuery(glCode1, this.startDate, this.endDate, this.accEntityId, this.accEntityKey, reportBean.getFieldId(), reBean.getFunctionId());
        String functionId = reBean.getFunctionId();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("**************QUERY: " + query));
        }
        try {
            int i;
            List list;
            try {
                this.pstmt = this.persistenceService.getSession().createSQLQuery(query);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Exception in creating statement:" + this.pstmt), (Throwable)e);
                throw taskExc;
            }
            this.resultset1 = list = this.pstmt.list();
            list.toArray();
            ArrayList<String[]> data = new ArrayList<String[]>();
            String accCode = "";
            String vcNum = "";
            String vcDate = "";
            String narration = "";
            String vcTypeName = "";
            String voucherHeaderId = "";
            StringBuffer detail = new StringBuffer();
            StringBuffer amount = new StringBuffer();
            int vhId = 0;
            int curVHID = 0;
            boolean cout = false;
            int VhidPrevious = 0;
            boolean lenAfterAppend = false;
            boolean lenBeforeAppend = false;
            boolean lenDetailBefore = false;
            boolean lenDetailAfter = false;
            double txnDebit = 0.0;
            double txnCredit = 0.0;
            double previousDebit = 0.0;
            double previousCredit = 0.0;
            String code = "";
            String currCode = "";
            String accCodePrevious = "";
            String cgn = "";
            int totalCount = 0;
            int isConfirmedCount = 0;
            String vn2 = "";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("resultset1---------------------------->" + this.resultset1));
            }
            if (this.resultset1 == null || this.resultset1.size() == 0) {
                this.startDate = sdf.format(formatter1.parse(this.startDate));
                OpBal opbal = this.getOpeningBalance(glCode1, fundId, fundSourceId, fyId, this.accEntityId, this.accEntityKey, this.startDate, functionId, deptId);
                String[] arr = new String[15];
                openingBalance = opbal.dr - opbal.cr;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("openingBalance--------------->" + openingBalance));
                }
                String sqlString = "select name as \"glname\" from chartofaccounts where glcode=?";
                this.pstmt = this.persistenceService.getSession().createSQLQuery("select name as \"glname\" from chartofaccounts where glcode=?");
                this.pstmt.setString(0, glCode1);
                List res = this.pstmt.list();
                String aName = "";
                if (res != null) {
                    aName = res.get(0).toString();
                }
                arr[1] = "";
                arr[13] = "";
                arr[12] = "";
                arr[11] = "";
                arr[10] = "";
                arr[7] = "";
                arr[6] = "";
                arr[3] = "";
                arr[2] = "";
                arr[14] = "";
                if (vhId == 0) {
                    arr[8] = "";
                }
                arr[9] = glCode1 + "-" + aName;
                if (openingBalance > 0.0) {
                    arr[4] = "" + GeneralLedgerReport.numberToString(Double.valueOf(Math.abs(openingBalance)).toString()).toString() + "";
                    arr[5] = "";
                } else if (openingBalance < 0.0) {
                    arr[4] = "";
                    arr[5] = "" + GeneralLedgerReport.numberToString(Double.valueOf(Math.abs(openingBalance)).toString()).toString() + "";
                } else {
                    arr[4] = "";
                    arr[5] = "";
                }
                arr[0] = "Opening Balance";
                if (vhId == 0 && !(openingBalance > 0.0) && !(openingBalance < 0.0)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"Inside if condition");
                    }
                } else {
                    data.add(arr);
                }
                String[] arr2 = new String[15];
                closingBalance = openingBalance;
                if (closingBalance > 0.0) {
                    arr2[4] = "";
                    arr2[5] = "" + GeneralLedgerReport.numberToString(Double.valueOf(Math.abs(closingBalance)).toString()).toString() + "";
                } else if (closingBalance < 0.0) {
                    arr2[4] = "" + GeneralLedgerReport.numberToString(Double.valueOf(Math.abs(closingBalance)).toString()).toString() + "";
                    arr2[5] = "";
                } else {
                    arr2[4] = "";
                    arr2[5] = "";
                }
                arr2[2] = "";
                arr2[0] = "Closing Balance";
                arr2[1] = "";
                arr[13] = "";
                arr[12] = "";
                arr2[11] = "";
                arr2[10] = "";
                arr2[9] = "";
                arr2[8] = "";
                arr2[7] = "";
                arr2[6] = "";
                arr2[3] = "";
                arr2[14] = "";
                data.add(arr2);
            }
            for (Object[] element : this.resultset1) {
                String creditAmount;
                String debitAmount;
                String vhId1;
                double credit;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)" inside resultset");
                }
                try {
                    String vn1;
                    code = element[0].toString();
                    isconfirmed = element[14] == null ? "" : element[14].toString();
                    if (!(isconfirmed == null || isconfirmed.equalsIgnoreCase("") || isconfirmed.equalsIgnoreCase("9") || (vn1 = element[5].toString()).equalsIgnoreCase(vn2))) {
                        vn2 = vn1;
                        ++totalCount;
                        if (isconfirmed.equalsIgnoreCase("0")) {
                            ++isConfirmedCount;
                        }
                    }
                    vhId = Integer.parseInt(element[2].toString());
                    if (!code.equals(currCode)) {
                        String[] arr = new String[15];
                        this.startDate = sdf.format(formatter1.parse(this.startDate));
                        OpBal opbal = this.getOpeningBalance(code, fundId, fundSourceId, fyId, this.accEntityId, this.accEntityKey, this.startDate, functionId, deptId);
                        openingBalance = opbal.dr - opbal.cr;
                        String fundName = "";
                        if (element[13].toString() != null) {
                            fundName = element[13].toString();
                        }
                        String sqlString1 = "select name as \"glname\" from chartofaccounts where glcode=?";
                        this.pstmt = this.persistenceService.getSession().createSQLQuery("select name as \"glname\" from chartofaccounts where glcode=?");
                        this.pstmt.setString(0, code);
                        List res = this.pstmt.list();
                        String aName = "";
                        if (res != null) {
                            aName = res.get(0).toString();
                        }
                        arr[1] = "";
                        arr[13] = "";
                        arr[12] = "";
                        arr[11] = "";
                        arr[10] = "";
                        arr[7] = "";
                        arr[6] = "";
                        arr[3] = "";
                        arr[2] = "";
                        arr[14] = "";
                        arr[8] = vhId == 0 ? "" : fundName;
                        arr[9] = code + "-" + aName;
                        if (openingBalance > 0.0) {
                            arr[4] = "" + GeneralLedgerReport.numberToString(Double.valueOf(Math.abs(openingBalance)).toString()).toString() + "";
                            arr[5] = "";
                        } else if (openingBalance < 0.0) {
                            arr[4] = "";
                            arr[5] = "" + GeneralLedgerReport.numberToString(Double.valueOf(Math.abs(openingBalance)).toString()).toString() + "";
                        } else {
                            arr[4] = "";
                            arr[5] = "";
                        }
                        arr[0] = "Opening Balance";
                        if (vhId == 0 && !(openingBalance > 0.0) && !(openingBalance < 0.0)) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug((Object)"Inside if");
                            }
                        } else {
                            data.add(arr);
                        }
                        currCode = code;
                    }
                }
                catch (Exception ex) {
                    LOGGER.error((Object)"ERROR (not an error): ResultSet is Empty", (Throwable)ex);
                    throw taskExc;
                }
                if (curVHID > 0 && vhId != curVHID && !cout && vhId != 0) {
                    String[] arr9;
                    if (txnDebit > 0.0) {
                        previousDebit = 0.0;
                        previousCredit = 0.0;
                        arr9 = new String[15];
                        arr9[0] = vcDate;
                        arr9[1] = vcNum;
                        arr9[14] = voucherHeaderId;
                        arr9[2] = detail.toString();
                        arr9[3] = "";
                        arr9[4] = GeneralLedgerReport.numberToString(Double.valueOf(txnDebit).toString()) + "";
                        arr9[5] = "";
                        arr9[6] = narration != null ? "" + narration : "";
                        arr9[7] = cgn;
                        txnDrSum += txnDebit;
                        txnCrSum += txnCredit;
                        arr9[10] = "";
                        arr9[11] = "";
                        arr9[9] = "";
                        arr9[8] = "";
                        arr9[12] = vcTypeName;
                        arr9[13] = "";
                        data.add(arr9);
                    } else if (txnCredit > 0.0) {
                        previousDebit = 0.0;
                        previousCredit = 0.0;
                        arr9 = new String[15];
                        arr9[0] = "";
                        arr9[1] = "";
                        arr9[2] = "";
                        arr9[3] = detail.toString();
                        arr9[5] = GeneralLedgerReport.numberToString(Double.valueOf(txnCredit).toString()) + "";
                        arr9[4] = "";
                        arr9[6] = narration != null ? "" + narration : "";
                        arr9[7] = cgn;
                        txnDrSum += txnDebit;
                        txnCrSum += txnCredit;
                        arr9[10] = vcDate;
                        arr9[11] = vcNum;
                        arr9[12] = "";
                        arr9[13] = vcTypeName;
                        arr9[14] = voucherHeaderId;
                        arr9[9] = "";
                        arr9[8] = "";
                        data.add(arr9);
                    }
                    detail.delete(0, detail.length());
                    amount.delete(0, amount.length());
                    vcTypeName = "";
                    narration = "";
                    accCode = "";
                    voucherHeaderId = "";
                    vcNum = "";
                    vcDate = "";
                }
                curVHID = vhId;
                cout = false;
                accCode = element[6].toString();
                String detailId = null;
                if (!this.accEntityKey.equals("")) {
                    detailId = element[15].toString();
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("accEntityKey---->" + this.accEntityKey));
                }
                if (!accCode.equalsIgnoreCase(accCodePrevious)) {
                    previousDebit = 0.0;
                    previousCredit = 0.0;
                }
                if (accCode.equalsIgnoreCase(code)) {
                    if (detailId != null && !detailId.equals(this.accEntityKey)) {
                        this.slDrAmount = this.slDrAmount.add(new BigDecimal(element[11].toString()));
                        this.slCrAmount = this.slCrAmount.add(new BigDecimal(element[12].toString()));
                    }
                } else if (!this.accEntityKey.equals("")) {
                    this.slCrAmount = new BigDecimal("0.00");
                    this.slDrAmount = new BigDecimal("0.00");
                }
                if (vhId != 0 && (detailId == null || detailId.equals(this.accEntityKey)) && !this.accEntityKey.equals("")) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("detailId-->" + detailId + "accCode-->" + accCode + "::code:" + code));
                    }
                    if (accCode.equalsIgnoreCase(code)) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("accCode...................." + accCode));
                        }
                        double currentDebit = 0.0;
                        double currentCredit = 0.0;
                        double debit = 0.0;
                        credit = 0.0;
                        if (vhId == VhidPrevious && accCode.equalsIgnoreCase(accCodePrevious)) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug((Object)("vhId:::::::::::::::::" + vhId));
                            }
                            vcDate = element[4].toString();
                            vcNum = element[5].toString();
                            voucherHeaderId = element[2].toString();
                            vcTypeName = element[16].toString();
                            vhId1 = element[2].toString();
                            if (LOGGER.isInfoEnabled()) {
                                LOGGER.info((Object)("vhId1:::" + vhId1));
                            }
                            if (detailId != null) {
                                currentDebit = Double.parseDouble(element[11].toString());
                                debit = previousDebit + currentDebit - (previousCredit + (currentCredit = Double.parseDouble(element[12].toString())));
                                txnDebit = debit > 0.0 ? debit : 0.0;
                                credit = previousCredit + currentCredit - (previousDebit + currentDebit);
                                txnCredit = credit > 0.0 ? credit : 0.0;
                                previousDebit += currentDebit;
                                previousCredit += currentCredit;
                            }
                            narration = element[9].toString();
                        } else {
                            vcDate = element[4].toString();
                            vcNum = element[5].toString();
                            voucherHeaderId = element[2].toString();
                            vcTypeName = element[16].toString();
                            vhId1 = element[2].toString();
                            if (LOGGER.isInfoEnabled()) {
                                LOGGER.info((Object)("vhId1:::" + vhId1));
                            }
                            if (detailId != null) {
                                previousDebit = txnDebit = Double.parseDouble(element[11].toString());
                                previousCredit = txnCredit = Double.parseDouble(element[12].toString());
                            }
                            narration = element[9].toString();
                        }
                    } else if (vhId == VhidPrevious && accCode.equalsIgnoreCase(accCodePrevious)) {
                        double currentDebit = 0.0;
                        double currentCredit = 0.0;
                        double debit = 0.0;
                        credit = 0.0;
                        debitAmount = "";
                        creditAmount = "";
                        amount.delete(0, 0);
                        detail.delete(0, 0);
                        detail = detail.append(" " + element[6].toString() + "" + element[8].toString());
                        currentDebit = Double.parseDouble(element[11].toString());
                        currentCredit = Double.parseDouble(element[12].toString());
                        debit = previousDebit + currentDebit - (previousCredit + currentCredit);
                        if (debit > 0.0) {
                            debitAmount = "Dr." + ExilPrecision.convertToString(debit, 2) + "0";
                            amount = amount.append(" " + debitAmount);
                        }
                        if ((credit = previousCredit + currentCredit - (previousDebit + currentDebit)) > 0.0) {
                            creditAmount = "Cr." + ExilPrecision.convertToString(credit, 2) + "0";
                            amount = amount.append(" " + creditAmount);
                        }
                    } else {
                        detail = detail.append(" " + element[6].toString() + "" + element[8].toString());
                        previousDebit = Double.parseDouble(element[11].toString());
                        previousCredit = Double.parseDouble(element[12].toString());
                    }
                } else if (vhId != 0 && this.accEntityKey.equals("")) {
                    if (accCode.equalsIgnoreCase(code)) {
                        double currentDebit = 0.0;
                        double currentCredit = 0.0;
                        double debit = 0.0;
                        credit = 0.0;
                        if (vhId == VhidPrevious && accCode.equalsIgnoreCase(accCodePrevious)) {
                            vcDate = element[4].toString();
                            vcNum = element[5].toString();
                            voucherHeaderId = element[2].toString();
                            vcTypeName = element[16].toString();
                            vhId1 = element[2].toString();
                            if (LOGGER.isInfoEnabled()) {
                                LOGGER.info((Object)("vhId1:::" + vhId1));
                            }
                            txnDebit = (debit = previousDebit + (currentDebit = Double.parseDouble(element[11].toString())) - (previousCredit + (currentCredit = Double.parseDouble(element[12].toString())))) > 0.0 ? debit : 0.0;
                            credit = previousCredit + currentCredit - (previousDebit + currentDebit);
                            txnCredit = credit > 0.0 ? credit : 0.0;
                            narration = element[9].toString();
                            previousDebit = txnDebit;
                            previousCredit = txnCredit;
                        } else {
                            vcDate = element[4].toString();
                            vcNum = element[5].toString();
                            voucherHeaderId = element[2].toString();
                            vcTypeName = element[16].toString();
                            vhId1 = element[2].toString();
                            if (LOGGER.isInfoEnabled()) {
                                LOGGER.info((Object)("vhId1:::" + vhId1));
                            }
                            cgn = "";
                            previousDebit = txnDebit = Double.parseDouble(element[11].toString());
                            previousCredit = txnCredit = Double.parseDouble(element[12].toString());
                            narration = element[9].toString();
                        }
                    } else if (vhId == VhidPrevious && accCode.equalsIgnoreCase(accCodePrevious)) {
                        double currentDebit = 0.0;
                        double currentCredit = 0.0;
                        double debit = 0.0;
                        credit = 0.0;
                        debitAmount = "";
                        creditAmount = "";
                        amount.delete(0, 0);
                        detail.delete(0, 0);
                        detail = detail.append(" " + element[6].toString() + "" + element[8].toString());
                        currentDebit = Double.parseDouble(element[11].toString());
                        currentCredit = Double.parseDouble(element[12].toString());
                        debit = previousDebit + currentDebit - (previousCredit + currentCredit);
                        if (debit > 0.0) {
                            debitAmount = "Dr." + ExilPrecision.convertToString(debit, 2) + "0";
                            amount = amount.append(" " + debitAmount);
                        }
                        if ((credit = previousCredit + currentCredit - (previousDebit + currentDebit)) > 0.0) {
                            creditAmount = "Cr." + ExilPrecision.convertToString(credit, 2) + "0";
                            amount = amount.append(" " + creditAmount);
                        }
                    } else {
                        detail = detail.append(" " + element[6].toString() + "" + element[8].toString());
                        previousDebit = Double.parseDouble(element[11].toString());
                        previousCredit = Double.parseDouble(element[12].toString());
                    }
                } else if (vhId != 0 && !this.accEntityKey.equals("")) {
                    detail = detail.append(" " + element[6].toString() + "" + element[8].toString());
                }
                accCodePrevious = accCode;
                VhidPrevious = vhId;
                if (!element.equals(this.resultset1.get(this.resultset1.size() - 1))) continue;
                if (txnDebit > 0.0) {
                    String[] arr = new String[15];
                    arr[0] = vcDate;
                    arr[1] = vcNum;
                    arr[14] = voucherHeaderId;
                    arr[2] = detail.toString();
                    arr[3] = "";
                    arr[4] = GeneralLedgerReport.numberToString(Double.valueOf(txnDebit).toString()) + "";
                    arr[5] = "";
                    arr[6] = narration != null ? "" + narration : "";
                    txnDrSum += txnDebit;
                    txnCrSum += txnCredit;
                    arr[9] = "";
                    arr[8] = "";
                    arr[4] = arr[4].equalsIgnoreCase(".00") ? "" : arr[4];
                    arr[7] = cgn;
                    arr[10] = "";
                    arr[11] = "";
                    arr[12] = vcTypeName;
                    arr[13] = "";
                    data.add(arr);
                } else if (txnCredit > 0.0) {
                    String[] arr = new String[15];
                    arr[0] = "";
                    arr[1] = "";
                    arr[2] = "";
                    arr[3] = detail.toString();
                    arr[4] = "";
                    arr[5] = GeneralLedgerReport.numberToString(Double.valueOf(txnCredit).toString()) + "";
                    arr[6] = narration != null ? "" + narration : "";
                    txnDrSum += txnDebit;
                    txnCrSum += txnCredit;
                    arr[9] = "";
                    arr[8] = "";
                    arr[5] = arr[5].equalsIgnoreCase(".00") ? "" : arr[5];
                    arr[7] = cgn;
                    arr[10] = vcDate;
                    arr[11] = vcNum;
                    arr[12] = "";
                    arr[13] = vcTypeName;
                    arr[14] = voucherHeaderId;
                    data.add(arr);
                }
                detail.delete(0, detail.length());
                amount.delete(0, amount.length());
                narration = "";
                accCode = "";
                voucherHeaderId = "";
                vcNum = "";
                vcDate = "";
                String[] arr2 = new String[15];
                if (openingBalance > 0.0) {
                    txnDrSum += Math.abs(openingBalance);
                } else {
                    txnCrSum += Math.abs(openingBalance);
                }
                closingBalance = txnDrSum - txnCrSum;
                if (closingBalance > 0.0) {
                    txnCrSum += Math.abs(closingBalance);
                    arr2[4] = "";
                    arr2[5] = "" + GeneralLedgerReport.numberToString(Double.valueOf(Math.abs(closingBalance)).toString()).toString() + "";
                } else if (closingBalance < 0.0) {
                    txnDrSum += Math.abs(closingBalance);
                    arr2[4] = "" + GeneralLedgerReport.numberToString(Double.valueOf(Math.abs(closingBalance)).toString()).toString() + "";
                    arr2[5] = "";
                } else {
                    arr2[4] = "";
                    arr2[5] = "";
                }
                arr2[2] = "";
                arr2[0] = "Closing Balance";
                arr2[1] = "";
                arr2[13] = "";
                arr2[12] = "";
                arr2[11] = "";
                arr2[10] = "";
                arr2[9] = "";
                arr2[8] = "";
                arr2[7] = "";
                arr2[6] = "";
                arr2[3] = "";
                data.add(arr2);
                String[] arr1 = new String[15];
                arr1[4] = txnDrSum > 0.0 ? "" + GeneralLedgerReport.numberToString(Double.valueOf(txnDrSum).toString()) + "" : "";
                arr1[5] = txnCrSum > 0.0 ? "" + GeneralLedgerReport.numberToString(Double.valueOf(txnDrSum).toString()) + "" : "";
                arr1[2] = "";
                arr1[0] = "Total";
                arr1[1] = "";
                arr1[13] = "";
                arr1[12] = "";
                arr1[11] = "";
                arr1[10] = "";
                arr1[9] = "";
                arr1[8] = "";
                arr1[7] = "";
                arr1[6] = "";
                arr1[3] = "";
                data.add(arr1);
                txnDrSum = 0.0;
                txnCrSum = 0.0;
            }
            String[][] gridData = new String[data.size() + 1][15];
            gridData[0][0] = "voucherdate";
            gridData[0][1] = "vouchernumber";
            gridData[0][2] = "debitparticular";
            gridData[0][3] = "creditparticular";
            gridData[0][4] = "debitamount";
            gridData[0][5] = "creditamount";
            gridData[0][6] = "narration";
            gridData[0][7] = "cgn";
            gridData[0][8] = "fund";
            gridData[0][9] = "glcode";
            gridData[0][10] = "creditdate";
            gridData[0][11] = "creditvouchernumber";
            gridData[0][12] = "debitVoucherTypeName";
            gridData[0][13] = "creditVoucherTypeName";
            gridData[0][14] = "vhId";
            for (i = 1; i <= data.size(); ++i) {
                gridData[i] = (String[])data.get(i - 1);
            }
            for (i = 1; i <= data.size(); ++i) {
                GeneralLedgerBean generalLedgerBean = new GeneralLedgerBean();
                generalLedgerBean.setGlcode(gridData[i][9]);
                generalLedgerBean.setVoucherdate(gridData[i][0]);
                generalLedgerBean.setVouchernumber(gridData[i][1]);
                int counter = 0;
                String testTemp = gridData[i][2];
                char[] testArrayTemp = testTemp.toCharArray();
                for (counter = 0; counter < testArrayTemp.length && (testArrayTemp[counter] != '<' || testArrayTemp[counter + 1] != 'b' && testArrayTemp[counter + 1] != 'B'); ++counter) {
                }
                generalLedgerBean.setDebitparticular(gridData[i][2]);
                String test = gridData[i][7];
                char[] testArray = test.toCharArray();
                for (counter = 0; counter < testArray.length && testArray[counter] != 'r'; ++counter) {
                }
                generalLedgerBean.setNarration(gridData[i][6]);
                generalLedgerBean.setCreditparticular(gridData[i][3]);
                generalLedgerBean.setDebitamount(gridData[i][4]);
                generalLedgerBean.setCreditamount(gridData[i][5]);
                generalLedgerBean.setFund(gridData[i][8]);
                if (i == data.size()) {
                    generalLedgerBean.setCGN("");
                } else {
                    generalLedgerBean.setCGN(gridData[i][7]);
                }
                generalLedgerBean.setCreditdate(gridData[i][10]);
                generalLedgerBean.setCreditvouchernumber(gridData[i][11]);
                generalLedgerBean.setDebitVoucherTypeName(gridData[i][12]);
                generalLedgerBean.setCreditVoucherTypeName(gridData[i][13]);
                generalLedgerBean.setVhId(gridData[i][14]);
                reportBean.setStartDate(startDateformat1);
                reportBean.setTotalCount(Integer.toString(totalCount));
                reportBean.setIsConfirmedCount(Integer.toString(isConfirmedCount));
                dataList.add(generalLedgerBean);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("ERROR in getGeneralLedgerList " + ex.toString()), (Throwable)ex);
            throw taskExc;
        }
        return dataList;
    }

    private String getQuery(String glCode1, String startDate, String endDate, String accEntityId, String accEntityKey, String fieldId, String functionId) throws TaskFailedException {
        String addTableToQuery = "";
        String entityCondition = "";
        String functionCondition = "";
        if (!accEntityId.equalsIgnoreCase("") && !accEntityKey.equalsIgnoreCase("")) {
            entityCondition = " AND gl.id=gldet.generalledgerid  AND gldet.detailtypeid=" + accEntityId + " AND cdet.detailtypeid = " + accEntityId + " AND gldet.detailkeyid=" + accEntityKey + "";
        }
        if (addTableToQuery.trim().equals("") && null != fieldId && !fieldId.trim().equals("")) {
            addTableToQuery = ", vouchermis vmis ";
        }
        if (!StringUtils.isEmpty((String)functionId)) {
            functionCondition = " and gl.functionid=" + functionId;
        }
        if (!accEntityKey.equals("")) {
            return "SELECT  gl.glcode as \"code\",(select ca.type from chartofaccounts ca where glcode=gl.glcode) as \"glType\" , vh.id AS \"vhid\",vh.voucherDate AS \"vDate\",TO_CHAR(vh.voucherDate ,'dd-Mon-yyyy')  AS \"voucherdate\",vh.voucherNumber AS \"vouchernumber\",gl.glCode AS \"glcode\",coa.name|| (CASE WHEN (GLDET.GENERALLEDGERID=GL.ID) THEN '-['||(CASE WHEN gldet.detailtypeid = (select id from accountdetailtype where name='Creditor') THEN (select name from Supplier where id=gldet.detailkeyid ) ELSE (CASE WHEN gldet.detailtypeid = (select id from accountdetailtype where name='EMPLOYEE') THEN (select name from eg_user where id=gldet.detailkeyid) ELSE (select name from accountentitymaster where id=gldet.detailkeyid) END) END)||']' ELSE NULL END) as \"Name\",CASE WHEN gl.glcode = '" + glCode1 + "' THEN (CASE WHEN gl.DEBITAMOUNT = 0 THEN (gldet.amount||'.00cr') ELSE (gldet.amount||'.00dr') END)ELSE (CASE WHEN gl.DEBITAMOUNT = 0 THEN (gl.creditamount||'.00cr') ELSE (gl.debitamount||'.00dr') END) END as \"amount\",gl.description as \"narration\",vh .type || '-' || vh.name||CASE WHEN status = 1 THEN '(Reversed)' ELSE (CASE WHEN status = 2 THEN '(Reversal)' ELSE '' END) END AS \"type\", CASE WHEN gl.glcode = '" + glCode1 + "' THEN (CASE WHEN gl.debitAMOUNT = 0 THEN 0 ELSE gldet.amount END) ELSE (CASE WHEN gl.debitAMOUNT = 0 THEN 0 ELSE gl.debitamount END) END as \"debitamount\",CASE WHEN gl.glcode = '" + glCode1 + "' THEN (CASE WHEN gl.creditAMOUNT = 0 THEN 0 ELSE gldet.amount END) ELSE (CASE WHEN gl.debitAMOUNT = 0 THEN 0 ELSE gl.creditamount END) END as \"creditamount\", f.name as \"fundName\",vh.isconfirmed as \"isconfirmed\",case when (gldet.generalledgerid=gl.id)  then gldet.detailkeyid else null end as \"DetailKeyId\",vh.type||'-'||vh.name as \"vouchertypename\"  FROM generalLedger gl, voucherHeader vh, chartOfAccounts coa, generalledgerdetail gldet, chartofaccountdetail cdet , fund f WHERE coa.glCode = gl.glCode AND gl.voucherHeaderId = vh.id  and cdet.glcodeid=coa.id  and gl.glcode='" + glCode1 + "' AND f.id= vh.fundId " + entityCondition + " and vh.id in (" + this.engineQry + " ) AND (gl .debitamount>0 OR gl .creditamount>0)  order by vh.id asc ,gl.glCode";
        }
        StringBuffer sql = new StringBuffer("SELECT  gl.glcode as \"code\",(select ca.type from chartofaccounts ca where glcode=gl.glcode) as \"glType\",vh.id AS \"vhid\", vh.voucherDate AS \"vDate\", ").append(" TO_CHAR(vh.voucherDate, 'dd-Mon-yyyy') AS voucherdate, ").append(" vh.voucherNumber AS \"vouchernumber\", gl.glCode AS \"glcode\", ").append(" coa.name AS \"name\",CASE WHEN gl.debitAmount = 0 THEN (case (gl.creditamount) when 0 then gl.creditAmount||'.00cr' when floor(gl.creditamount) then gl.creditAmount||'.00cr' else  gl.creditAmount||'cr'  end ) ELSE (case (gl.debitamount) when 0 then gl.debitamount||'.00dr' when floor(gl.debitamount) then gl.debitamount||'.00dr' else  gl.debitamount||'dr' end ) END AS \"amount\", ").append(" gl.description AS \"narration\", vh.type || '-' || vh.name||CASE WHEN status = 1 THEN '(Reversed)' ELSE (CASE WHEN status = 2 THEN '(Reversal)' ELSE '' END) END AS \"type\", ").append(" gl.debitamount  AS \"debitamount\", gl.creditamount  AS \"creditamount\",f.name as \"fundName\",  vh.isconfirmed as \"isconfirmed\",gl.functionid as \"functionid\",vh.type||'-'||vh.name as \"vouchertypename\" ").append(" FROM generalLedger gl, voucherHeader vh, chartOfAccounts coa,  fund f " + addTableToQuery + "").append(" WHERE coa.glCode = gl.glCode AND gl.voucherHeaderId = vh.id  ").append(" AND\tf.id=vh.fundid ").append(" AND gl.glcode ='" + glCode1 + "'").append(" AND (gl.debitamount>0 OR gl.creditamount>0) ").append(functionCondition).append(" and vh.id in (" + this.engineQry + " )").append(" group by vh.id,gl.glcode,vh.voucherDate ,vh.voucherNumber,coa.name,gl.description,  vh.type || '-' || vh.name||CASE WHEN status = 1 THEN '(Reversed)' ELSE (CASE WHEN status = 2 THEN '(Reversal)' ELSE '' END) END, gl.debitamount , gl.creditamount  ,f.name, vh.isconfirmed, vh.type  ||'-'  ||vh.name, gl.functionid   ").append(" order by \"code\",\"vDate\" ");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("____________________________________________________________" + sql.toString()));
        }
        return sql.toString();
    }

    private OpBal getOpeningBalance(String glCode, String fundId, String fundSourceId, String fyId, String accEntityId, String accEntityKey, String tillDate, String functionId, String deptId) throws TaskFailedException {
        String fundCondition = "";
        String fundSourceCondition = "";
        String accEntityCondition = "";
        String functionCondition = "";
        String deptCondition = "";
        String deptFromCondition = "";
        String deptWhereCondition = "";
        double opDebit = 0.0;
        double opCredit = 0.0;
        if (!fundId.equalsIgnoreCase("")) {
            fundCondition = "fundId = ? AND ";
        }
        if (deptId != null && !deptId.equalsIgnoreCase("")) {
            deptCondition = "DEPARTMENTID = ? AND ";
            deptFromCondition = ", vouchermis mis";
            deptWhereCondition = " mis.voucherheaderid =vh.id   and mis.DepartmentId = ? and ";
        }
        if (!fundSourceId.equalsIgnoreCase("")) {
            fundSourceCondition = "fundSourceId = ? AND ";
        }
        if (!accEntityId.equalsIgnoreCase("")) {
            accEntityCondition = "accountDetailTypeid=? AND accountDetailKey=? AND ";
        }
        if (!StringUtils.isEmpty((String)functionId)) {
            functionCondition = " functionid=? AND ";
        }
        String queryYearOpBal = "SELECT CASE WHEN sum(openingDebitBalance) is null THEN 0 ELSE sum(openingDebitBalance) END AS \"openingDebitBalance\", CASE WHEN sum(openingCreditBalance) is null THEN 0 ELSE sum(openingCreditBalance) END AS \"openingCreditBalance\" FROM transactionSummary WHERE " + fundCondition + fundSourceCondition + functionCondition + accEntityCondition + deptCondition + " financialYearId=? AND glCodeId = (SELECT id FROM chartOfAccounts WHERE glCode in(?))";
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("**********************: OPBAL: " + queryYearOpBal));
        }
        try {
            List list;
            int i = 0;
            this.pstmt = this.persistenceService.getSession().createSQLQuery(queryYearOpBal);
            if (!fundId.equalsIgnoreCase("")) {
                this.pstmt.setLong(i++, Long.valueOf(fundId).longValue());
            }
            if (!fundSourceId.equalsIgnoreCase("")) {
                this.pstmt.setLong(i++, Long.valueOf(fundSourceId).longValue());
            }
            if (!StringUtils.isEmpty((String)functionId)) {
                this.pstmt.setLong(i++, Long.valueOf(functionId).longValue());
            }
            if (!accEntityId.equalsIgnoreCase("")) {
                this.pstmt.setLong(i++, Long.valueOf(accEntityId).longValue());
                this.pstmt.setLong(i++, Long.valueOf(accEntityKey).longValue());
            }
            if (deptId != null && !deptId.equalsIgnoreCase("")) {
                this.pstmt.setLong(i++, Long.valueOf(deptId).longValue());
            }
            this.pstmt.setLong(i++, Long.valueOf(fyId).longValue());
            this.pstmt.setString(i++, glCode);
            this.resultset = null;
            this.resultset = list = this.pstmt.list();
            for (Object[] element : this.resultset) {
                opDebit = Double.parseDouble(element[0] != null ? element[0].toString() : "0");
                opCredit = Double.parseDouble(element[1] != null ? element[1].toString() : "0");
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Error GeneralLedger->getOpeningBalance() For the year: " + ex.toString()), (Throwable)ex);
            throw taskExc;
        }
        String startDate = this.commnFunctions.getStartDate(Integer.parseInt(fyId));
        if (!fundId.equalsIgnoreCase("")) {
            fundCondition = "AND vh.fundId = ? ";
        }
        if (!fundSourceId.equalsIgnoreCase("")) {
            fundSourceCondition = "AND vh.fundId = ? ";
        }
        if (!StringUtils.isEmpty((String)functionId)) {
            functionCondition = " and gl.functionid=? ";
        }
        String queryTillDateOpBal = "";
        String defaultStatusExclude = null;
        List listAppConfVal = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "statusexcludeReport");
        if (null == listAppConfVal) {
            throw new ApplicationRuntimeException("Exlcude statusses not  are not defined for Reports");
        }
        defaultStatusExclude = ((AppConfigValues)listAppConfVal.get(0)).getValue();
        if (!accEntityId.equalsIgnoreCase("") && !accEntityKey.equalsIgnoreCase("")) {
            accEntityCondition = " AND gl.id=gldet.generalledgerid  AND gldet.detailtypeid=? AND gldet.detailkeyid=? ";
            queryTillDateOpBal = "SELECT coa.glcode,(SELECT SUM(gldet.amount) FROM generalLedger gl, voucherHeader vh " + deptFromCondition + " , generalledgerdetail gldet  WHERE vh.id = gl.voucherHeaderId AND gl.glcodeid IN (coa.id) " + fundCondition + fundSourceCondition + functionCondition + accEntityCondition + " AND " + deptWhereCondition + " vh.voucherDate >= to_date(?,'dd/mm/yyyy')  AND vh.voucherDate < to_date(?,'dd/mm/yyyy') AND vh.status not in (" + defaultStatusExclude + ") AND  gl.DEBITamount>0) AS \"debitAmount\",(SELECT SUM(gldet.amount) FROM generalLedger gl, voucherHeader vh " + deptFromCondition + " ,  generalledgerdetail gldet WHERE vh.id = gl.voucherHeaderId AND " + deptWhereCondition + "  gl.glcodeid IN (coa.id) " + fundCondition + fundSourceCondition + functionCondition + accEntityCondition + " AND vh.voucherDate >= to_date(?,'dd/mm/yyyy') AND vh.voucherDate <to_date(?,'dd/mm/yyyy') AND vh.status not in (" + defaultStatusExclude + ") AND gl.CREDITamount>0) AS \"creditAmount\" FROM chartofaccounts coa WHERE \tcoa.glcode IN (?)";
        } else {
            queryTillDateOpBal = "SELECT CASE WHEN sum(gl.debitAmount) is null THEN 0 ELSE sum(gl.debitAmount) END AS \"debitAmount\",  CASE WHEN sum(gl.creditAmount) is null THEN 0 ELSE sum(gl.creditAmount) END AS \"creditAmount\"  FROM generalLedger gl, voucherHeader vh " + deptFromCondition + " WHERE vh.id = gl.voucherHeaderId AND " + deptWhereCondition + " gl.glCode IN (?) " + fundCondition + fundSourceCondition + functionCondition + " AND vh.voucherDate >= to_date(?,'dd/MM/YYYY') AND vh.voucherDate <to_date(?,'dd/MM/YYYY') AND vh.status not in (" + defaultStatusExclude + ")";
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("***********: OPBAL: " + queryTillDateOpBal));
        }
        try {
            List list;
            this.pstmt = this.persistenceService.getSession().createSQLQuery(queryTillDateOpBal);
            int i = 0;
            if (!accEntityId.equalsIgnoreCase("") && !accEntityKey.equalsIgnoreCase("")) {
                if (!fundId.equalsIgnoreCase("")) {
                    this.pstmt.setLong(i++, Long.parseLong(fundId));
                }
                if (!fundSourceId.equalsIgnoreCase("")) {
                    this.pstmt.setLong(i++, Long.parseLong(fundSourceId));
                }
                if (!StringUtils.isEmpty((String)functionId)) {
                    this.pstmt.setLong(i++, Long.parseLong(functionId));
                }
                if (!accEntityId.equalsIgnoreCase("")) {
                    this.pstmt.setLong(i++, Long.parseLong(accEntityId));
                    this.pstmt.setLong(i++, Long.parseLong(accEntityKey));
                }
                if (deptId != null && !deptId.equalsIgnoreCase("")) {
                    this.pstmt.setLong(i++, Long.parseLong(deptId));
                }
                this.pstmt.setString(i++, startDate);
                this.pstmt.setString(i++, tillDate);
                if (deptId != null && !deptId.equalsIgnoreCase("")) {
                    this.pstmt.setLong(i++, Long.parseLong(deptId));
                }
                if (!fundId.equalsIgnoreCase("")) {
                    this.pstmt.setLong(i++, Long.parseLong(fundId));
                }
                if (!fundSourceId.equalsIgnoreCase("")) {
                    this.pstmt.setLong(i++, Long.parseLong(fundSourceId));
                }
                if (!StringUtils.isEmpty((String)functionId)) {
                    this.pstmt.setLong(i++, Long.parseLong(functionId));
                }
                if (!accEntityId.equalsIgnoreCase("")) {
                    this.pstmt.setLong(i++, Long.parseLong(accEntityId));
                    this.pstmt.setLong(i++, Long.parseLong(accEntityKey));
                }
                this.pstmt.setString(i++, startDate);
                this.pstmt.setString(i++, tillDate);
                this.pstmt.setString(i++, glCode);
            } else {
                if (deptId != null && !deptId.equalsIgnoreCase("")) {
                    this.pstmt.setLong(i++, Long.parseLong(deptId));
                }
                this.pstmt.setString(i++, glCode);
                if (!fundId.equalsIgnoreCase("")) {
                    this.pstmt.setLong(i++, Long.parseLong(fundId));
                }
                if (!fundSourceId.equalsIgnoreCase("")) {
                    this.pstmt.setLong(i++, Long.parseLong(fundSourceId));
                }
                if (!StringUtils.isEmpty((String)functionId)) {
                    this.pstmt.setLong(i++, Long.parseLong(functionId));
                }
                this.pstmt.setString(i++, startDate);
                this.pstmt.setString(i++, tillDate);
            }
            this.resultset = null;
            this.resultset = list = this.pstmt.list();
            if (!accEntityId.equalsIgnoreCase("") && !accEntityKey.equalsIgnoreCase("")) {
                for (Object[] element : this.resultset) {
                    if (element[1] != null) {
                        opDebit += Double.parseDouble(element[1].toString());
                    }
                    if (element[2] == null) continue;
                    opCredit += Double.parseDouble(element[2].toString());
                }
            } else {
                for (Object[] element : this.resultset) {
                    if (element[0] != null) {
                        opDebit += Double.parseDouble(element[0].toString());
                    }
                    if (element[1] == null) continue;
                    opCredit += Double.parseDouble(element[1].toString());
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Error GeneralLedger->getOpeningBalance() till the date: " + ex.toString()), (Throwable)ex);
            throw taskExc;
        }
        OpBal opBal = new OpBal();
        opBal.dr = opDebit;
        opBal.cr = opCredit;
        this.resultset = null;
        return opBal;
    }

    private String getAccountName(String glCode) throws TaskFailedException {
        String accountName = "";
        SQLQuery pst = null;
        try {
            String query = "select name as \"name\" from  CHARTOFACCOUNTS where GLCODE=?";
            pst = this.persistenceService.getSession().createSQLQuery("select name as \"name\" from  CHARTOFACCOUNTS where GLCODE=?");
            pst.setString(0, glCode);
            List list = pst.list();
            Object[] objects = list.toArray();
            accountName = objects[0].toString();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exp in getAccountName:" + e.getMessage()), (Throwable)e);
            throw taskExc;
        }
        return accountName;
    }

    private String getFundName(String fundId) throws TaskFailedException {
        String fundName = "";
        SQLQuery pst = null;
        try {
            String query = "select name  as \"name\" from fund where id=?";
            pst = this.persistenceService.getSession().createSQLQuery("select name  as \"name\" from fund where id=?");
            if (fundId.isEmpty()) {
                pst.setInteger(0, 0);
            } else {
                pst.setInteger(0, Integer.valueOf(fundId).intValue());
            }
            List list = pst.list();
            Object[] objects = list.toArray();
            fundName = objects.length == 0 ? "" : objects[0].toString();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exp in getFundName" + e.getMessage()), (Throwable)e);
            throw taskExc;
        }
        return fundName;
    }

    public static StringBuffer numberToString(String strNumberToConvert) {
        String strNumber = "";
        String signBit = "";
        if (strNumberToConvert.startsWith("-")) {
            strNumber = "" + strNumberToConvert.substring(1, strNumberToConvert.length());
            signBit = "-";
        } else {
            strNumber = "" + strNumberToConvert;
        }
        DecimalFormat dft = new DecimalFormat("##############0.00");
        String strtemp = "" + dft.format(Double.parseDouble(strNumber));
        StringBuffer strbNumber = new StringBuffer(strtemp);
        int intLen = strbNumber.length();
        for (int i = intLen - 6; i > 0; i -= 2) {
            strbNumber.insert(i, ',');
        }
        if (signBit.equals("-")) {
            strbNumber = strbNumber.insert(0, "-");
        }
        return strbNumber;
    }

    public void isCurDate(String VDate) throws TaskFailedException {
        try {
            int ret;
            String today = new SimpleDateFormat("dd/MM/yyyy").format(new Date());
            String[] dt2 = today.split("/");
            String[] dt1 = VDate.split("/");
            int n = Integer.parseInt(dt2[2]) > Integer.parseInt(dt1[2]) ? 1 : (Integer.parseInt(dt2[2]) < Integer.parseInt(dt1[2]) ? -1 : (Integer.parseInt(dt2[1]) > Integer.parseInt(dt1[1]) ? 1 : (Integer.parseInt(dt2[1]) < Integer.parseInt(dt1[1]) ? -1 : (Integer.parseInt(dt2[0]) > Integer.parseInt(dt1[0]) ? 1 : (ret = Integer.parseInt(dt2[0]) < Integer.parseInt(dt1[0]) ? -1 : 0)))));
            if (ret == -1) {
                throw taskExc;
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Exception in isCurDate():" + ex), (Throwable)ex);
            throw new TaskFailedException("Date Should be within the today's date");
        }
    }

    static {
        LOGGER = Logger.getLogger(GeneralLedgerReport.class);
    }
}

