/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.eGov.src.domain;

import com.exilant.eGov.src.common.EGovernCommon;
import com.exilant.exility.common.TaskFailedException;
import com.exilant.exility.updateservice.PrimaryKeyGenerator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class GeneralLedger {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private String id = null;
    private String voucherLineId = "0";
    private String effectiveDate = "1-Jan-1900";
    private String glCodeId = null;
    private String glCode = null;
    private String debitAmount = "0";
    private String creditAmount = "0";
    private String[] accountDetail = null;
    private String description = null;
    private String voucherHeaderId = null;
    private String created = "1-Jan-1900";
    private String functionId = null;
    private static final Logger LOGGER = Logger.getLogger(GeneralLedger.class);
    private static TaskFailedException taskExc;

    public void setId(String aId) {
        this.id = aId;
    }

    public void setAccountDetailSize(int length) {
        if (this.accountDetail != null) {
            return;
        }
        this.accountDetail = new String[length];
        for (int i = 0; i < length; ++i) {
            this.accountDetail[i] = "0";
        }
    }

    public int getId() {
        return Integer.valueOf(this.id);
    }

    @Transactional
    public void insert() throws SQLException, TaskFailedException {
        EGovernCommon commommethods = new EGovernCommon();
        SQLQuery pst = null;
        try {
            this.effectiveDate = String.valueOf(commommethods.getCurrentDate());
            Date dt = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
            dt = sdf.parse(this.effectiveDate);
            this.effectiveDate = formatter.format(dt);
            this.description = commommethods.formatString(this.description);
            this.setId(String.valueOf(PrimaryKeyGenerator.getNextKey("GeneralLedger")));
            if (this.functionId == null || this.functionId.equals("")) {
                this.functionId = null;
            }
            String insertQuery = "INSERT INTO generalledger (id, voucherLineID, effectiveDate, glCodeID, glCode, debitAmount, creditAmount,";
            insertQuery = insertQuery + "description,voucherHeaderId,functionId) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)insertQuery);
            }
            pst = this.persistenceService.getSession().createSQLQuery(insertQuery);
            pst.setBigInteger(0, BigInteger.valueOf(Long.valueOf(this.id)));
            pst.setBigInteger(1, this.voucherLineId == null ? BigInteger.ZERO : BigInteger.valueOf(Long.valueOf(this.voucherLineId)));
            pst.setTimestamp(2, dt);
            pst.setBigInteger(3, this.glCodeId.equalsIgnoreCase("null") ? null : BigInteger.valueOf(Long.valueOf(this.glCodeId)));
            pst.setString(4, this.glCode);
            pst.setDouble(5, (this.debitAmount.equalsIgnoreCase("null") ? null : Double.valueOf(Double.parseDouble(this.debitAmount))).doubleValue());
            pst.setDouble(6, (this.creditAmount.equalsIgnoreCase("null") ? null : Double.valueOf(Double.parseDouble(this.creditAmount))).doubleValue());
            pst.setString(7, this.description);
            pst.setBigInteger(8, this.voucherHeaderId.equalsIgnoreCase("null") ? null : BigInteger.valueOf(Long.valueOf(this.voucherHeaderId)));
            pst.setBigInteger(9, this.functionId == null ? null : BigInteger.valueOf(Long.valueOf(this.functionId)));
            pst.executeUpdate();
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw taskExc;
        }
    }

    @Transactional
    public void update() throws SQLException, TaskFailedException {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
            this.created = formatter.format(sdf.parse(this.created));
            this.newUpdate();
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw taskExc;
        }
    }

    public void newUpdate() throws TaskFailedException, SQLException {
        SQLQuery pstmt = null;
        StringBuilder query = new StringBuilder(500);
        query.append("update generalledger set ");
        if (this.voucherLineId != null) {
            query.append("VOUCHERLINEID=?,");
        }
        if (this.effectiveDate != null) {
            query.append("EFFECTIVEDATE=?,");
        }
        if (this.glCodeId != null) {
            query.append("GLCODEID=?,");
        }
        if (this.glCode != null) {
            query.append("GLCODE=?,");
        }
        if (this.debitAmount != null) {
            query.append("DEBITAMOUNT=?,");
        }
        if (this.creditAmount != null) {
            query.append("CREDITAMOUNT=?,");
        }
        if (this.description != null) {
            query.append("DESCRIPTION=?,");
        }
        if (this.voucherHeaderId != null) {
            query.append("VOUCHERHEADERID=?,");
        }
        if (this.functionId != null) {
            query.append("FUNCTIONID=?,");
        }
        int lastIndexOfComma = query.lastIndexOf(",");
        query.deleteCharAt(lastIndexOfComma);
        query.append(" where id=?");
        try {
            int i = 1;
            pstmt = this.persistenceService.getSession().createSQLQuery(query.toString());
            if (this.voucherLineId != null) {
                pstmt.setString(i++, this.voucherLineId);
            }
            if (this.effectiveDate != null) {
                pstmt.setString(i++, this.effectiveDate);
            }
            if (this.glCodeId != null) {
                pstmt.setString(i++, this.glCodeId);
            }
            if (this.glCode != null) {
                pstmt.setString(i++, this.glCode);
            }
            if (this.debitAmount != null) {
                pstmt.setString(i++, this.debitAmount);
            }
            if (this.creditAmount != null) {
                pstmt.setString(i++, this.creditAmount);
            }
            if (this.description != null) {
                pstmt.setString(i++, this.description);
            }
            if (this.voucherHeaderId != null) {
                pstmt.setString(i++, this.voucherHeaderId);
            }
            if (this.functionId != null) {
                pstmt.setString(i++, this.functionId);
            }
            pstmt.setString(i++, this.id);
            pstmt.executeUpdate();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exp in update: " + e.getMessage()));
            throw taskExc;
        }
    }

    public HashMap getRecoveryForSubLedgerNotInFund(Integer ACCOUNTDETAILTYPE, Integer ACCOUNTDETAILKEY, Integer FUND, Date date, int status) throws SQLException, TaskFailedException {
        Set setA;
        HashMap hmFinal;
        HashMap<String, BigDecimal> hmB;
        HashMap<String, BigDecimal> hmA;
        block17: {
            block16: {
                hmA = new HashMap<String, BigDecimal>();
                hmB = new HashMap<String, BigDecimal>();
                hmFinal = new HashMap();
                SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
                String vDate = formatter.format(date);
                SQLQuery pst = null;
                List rs = null;
                String selQuery = "SELECT GL.GLCODE as ACCOUNTCODE,SUM(GLD.AMOUNT) AS CREDITAMOUNT FROM VOUCHERHEADER VH,GENERALLEDGER GL,GENERALLEDGERDETAIL GLD  WHERE VH.FUNDID NOT IN (?) AND GLD.DETAILTYPEID= ? AND DETAILKEYID= ? AND VH.STATUS= ? AND GL.CREDITAMOUNT>0  AND VH.ID=GL.VOUCHERHEADERID AND GL.ID=GLD.GENERALLEDGERID AND VH.VOUCHERDATE<= ? GROUP BY GL.GLCODE";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("query (CreditAmount)--> " + selQuery));
                }
                pst = this.persistenceService.getSession().createSQLQuery(selQuery);
                pst.setInteger(0, FUND.intValue());
                pst.setInteger(1, ACCOUNTDETAILTYPE.intValue());
                pst.setInteger(2, ACCOUNTDETAILKEY.intValue());
                pst.setInteger(3, status);
                pst.setString(4, vDate);
                rs = pst.list();
                for (Object[] element : rs) {
                    hmA.put(element[0].toString(), new BigDecimal(element[1].toString()));
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("map size -------> " + hmA.size()));
                }
                selQuery = "SELECT GL.GLCODE AS GLCODE ,SUM(GLD.AMOUNT) AS DEBITAMOUNT FROM VOUCHERHEADER VH,GENERALLEDGER GL,GENERALLEDGERDETAIL GLD   WHERE VH.FUNDID NOT IN (?)\tAND GLD.DETAILTYPEID= ? AND DETAILKEYID= ? AND VH.STATUS= ? AND GL.DEBITAMOUNT>0 AND   VH.ID=GL.VOUCHERHEADERID AND GL.ID=GLD.GENERALLEDGERID AND VH.VOUCHERDATE<= ? GROUP BY GL.GLCODE";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("query (DebitAmount)--> " + selQuery));
                }
                pst = this.persistenceService.getSession().createSQLQuery(selQuery);
                pst.setInteger(0, FUND.intValue());
                pst.setInteger(1, ACCOUNTDETAILTYPE.intValue());
                pst.setInteger(2, ACCOUNTDETAILKEY.intValue());
                pst.setInteger(3, status);
                pst.setString(4, vDate);
                rs = pst.list();
                for (Object[] elementB : rs) {
                    hmB.put(elementB[0].toString(), new BigDecimal(elementB[1].toString()));
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("map size -------> " + hmB.size()));
                }
                if (hmA.size() != 0) break block16;
                HashMap<String, BigDecimal> hashMap = hmB;
                return hashMap;
            }
            if (hmB.size() != 0) break block17;
            setA = hmA.entrySet();
            for (Map.Entry entry : setA) {
                hmFinal.put(entry.getKey(), ((BigDecimal)entry.getValue()).multiply(new BigDecimal(-1)));
            }
            HashMap hashMap = hmFinal;
            return hashMap;
        }
        try {
            hmFinal = hmB;
            setA = hmA.entrySet();
            for (Map.Entry entry : setA) {
                if (hmFinal.containsKey(entry.getKey())) {
                    BigDecimal iC = ((BigDecimal)hmFinal.get(entry.getKey())).subtract((BigDecimal)entry.getValue());
                    hmFinal.put(entry.getKey(), iC);
                    continue;
                }
                hmFinal.put(entry.getKey(), ((BigDecimal)entry.getValue()).multiply(new BigDecimal(-1)));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("hmCopy------>" + hmFinal));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in getRecoveryForSubLedgerNotInFund():" + e));
            throw taskExc;
        }
        return hmFinal;
    }

    public HashMap getRecoveryForSubLedger(Integer ACCOUNTDETAILTYPE, Integer ACCOUNTDETAILKEY, Integer FUND, Date date, int status) throws SQLException, TaskFailedException {
        Set setA;
        HashMap hmFinal;
        HashMap<String, BigDecimal> hmB;
        HashMap<String, BigDecimal> hmA;
        block17: {
            block16: {
                hmA = new HashMap<String, BigDecimal>();
                hmB = new HashMap<String, BigDecimal>();
                hmFinal = new HashMap();
                SQLQuery pst = null;
                List rs = null;
                SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
                String vDate = formatter.format(date);
                String selQuery = " SELECT GL.GLCODE as ACCOUNTCODE, SUM(GLD.AMOUNT) as CREDITAMOUNT FROM VOUCHERHEADER VH,GENERALLEDGER GL,GENERALLEDGERDETAIL GLD  WHERE VH.FUNDID= ?\tAND GLD.DETAILTYPEID= ? AND DETAILKEYID= ? AND VH.STATUS= ? AND GL.CREDITAMOUNT>0  AND VH.ID=GL.VOUCHERHEADERID AND GL.ID=GLD.GENERALLEDGERID AND VH.VOUCHERDATE<= ? GROUP BY GL.GLCODE";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("query (CreditAmount)--> " + selQuery));
                }
                pst = this.persistenceService.getSession().createSQLQuery(selQuery);
                pst.setInteger(0, FUND.intValue());
                pst.setInteger(1, ACCOUNTDETAILTYPE.intValue());
                pst.setInteger(2, ACCOUNTDETAILKEY.intValue());
                pst.setInteger(3, status);
                pst.setString(4, vDate);
                rs = pst.list();
                for (Object[] element : rs) {
                    hmA.put(element[0].toString(), new BigDecimal(element[1].toString()));
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("map size -------> " + hmA.size()));
                }
                selQuery = "SELECT GL.GLCODE as GLCODE, SUM(GLD.AMOUNT) as DEBITAMOUNT FROM VOUCHERHEADER VH,GENERALLEDGER GL,GENERALLEDGERDETAIL GLD  WHERE VH.FUNDID= ? AND GLD.DETAILTYPEID= ? AND DETAILKEYID= ? AND VH.STATUS= ? AND GL.DEBITAMOUNT>0 AND VH.ID=GL.VOUCHERHEADERID AND GL.ID=GLD.GENERALLEDGERID AND VH.VOUCHERDATE<= ? GROUP BY GL.GLCODE";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("query (DebitAmount)--> " + selQuery));
                }
                pst = this.persistenceService.getSession().createSQLQuery(selQuery);
                pst.setInteger(0, FUND.intValue());
                pst.setInteger(1, ACCOUNTDETAILTYPE.intValue());
                pst.setInteger(2, ACCOUNTDETAILKEY.intValue());
                pst.setInteger(3, status);
                pst.setString(4, vDate);
                rs = pst.list();
                for (Object[] element : rs) {
                    hmB.put(element[0].toString(), new BigDecimal(element[1].toString()));
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("map size -------> " + hmB.size()));
                }
                if (hmA.size() != 0) break block16;
                HashMap<String, BigDecimal> hashMap = hmB;
                return hashMap;
            }
            if (hmB.size() != 0) break block17;
            setA = hmA.entrySet();
            for (Map.Entry entry : setA) {
                hmFinal.put(entry.getKey(), ((BigDecimal)entry.getValue()).multiply(new BigDecimal(-1)));
            }
            HashMap hashMap = hmFinal;
            return hashMap;
        }
        try {
            hmFinal = hmB;
            setA = hmA.entrySet();
            for (Map.Entry entry : setA) {
                if (hmFinal.containsKey(entry.getKey())) {
                    BigDecimal iC = ((BigDecimal)hmFinal.get(entry.getKey())).subtract((BigDecimal)entry.getValue());
                    hmFinal.put(entry.getKey(), iC);
                    continue;
                }
                hmFinal.put(entry.getKey(), ((BigDecimal)entry.getValue()).multiply(new BigDecimal(-1)));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("hmCopy------>" + hmFinal));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in getRecoveryForSubLedger():" + e));
            throw taskExc;
        }
        return hmFinal;
    }

    public String getVoucherLineId() {
        return this.voucherLineId;
    }

    public void setVoucherLineId(String voucherLineId) {
        this.voucherLineId = voucherLineId;
    }

    public String getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(String effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getGlCodeId() {
        return this.glCodeId;
    }

    public void setGlCodeId(String glCodeId) {
        this.glCodeId = glCodeId;
    }

    public String getGlCode() {
        return this.glCode;
    }

    public void setGlCode(String glCode) {
        this.glCode = glCode;
    }

    public String getDebitAmount() {
        return this.debitAmount;
    }

    public void setDebitAmount(String debitAmount) {
        this.debitAmount = debitAmount;
    }

    public String getCreditAmount() {
        return this.creditAmount;
    }

    public void setCreditAmount(String creditAmount) {
        this.creditAmount = creditAmount;
    }

    public String[] getAccountDetail() {
        return this.accountDetail;
    }

    public void setAccountDetail(String[] accountDetail) {
        this.accountDetail = accountDetail;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getVoucherHeaderId() {
        return this.voucherHeaderId;
    }

    public void setVoucherHeaderId(String voucherHeaderId) {
        this.voucherHeaderId = voucherHeaderId;
    }

    public String getFunctionId() {
        return this.functionId;
    }

    public void setFunctionId(String functionId) {
        this.functionId = functionId;
    }
}

