/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Fund;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.egf.model.Statement;
import org.egov.egf.model.StatementEntry;
import org.egov.egf.model.StatementResultObject;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.services.PersistenceService;
import org.egov.services.report.ReportService;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BalanceSheetService
extends ReportService {
    private static final String BS = "BS";
    private static final String L = "L";
    private static final BigDecimal NEGATIVE = new BigDecimal(-1);
    private String removeEntrysWithZeroAmount = "";
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private FinancialYearHibernateDAO financialYearDAO;

    @Override
    protected void addRowsToStatement(Statement balanceSheet, Statement assets, Statement liabilities) {
        if (liabilities.size() > 0) {
            balanceSheet.add(new StatementEntry(null, "LIABILITIES", "", null, null, true));
            balanceSheet.addAll(liabilities);
            balanceSheet.add(new StatementEntry(null, "Total LIABILITIES", "", null, null, true));
        }
        if (assets.size() > 0) {
            balanceSheet.add(new StatementEntry(null, "ASSETS", "", null, null, true));
            balanceSheet.addAll(assets);
            balanceSheet.add(new StatementEntry(null, "Total ASSETS", "", null, null, true));
        }
    }

    public void addCurrentOpeningBalancePerFund(Statement balanceSheet, List<Fund> fundList, String transactionQuery) {
        BigDecimal divisor = balanceSheet.getDivisor();
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select sum(openingdebitbalance)- sum(openingcreditbalance),ts.fundid,coa.majorcode,coa.type FROM transactionsummary ts,chartofaccounts coa  WHERE ts.glcodeid = coa.ID  AND ts.financialyearid=" + balanceSheet.getFinancialYear().getId() + transactionQuery + " GROUP BY ts.fundid,coa.majorcode,coa.type");
        List openingBalanceAmountList = query.list();
        for (Object[] obj : openingBalanceAmountList) {
            if (obj[0] == null || obj[1] == null) continue;
            BigDecimal total = (BigDecimal)obj[0];
            if (L.equals(obj[3].toString())) {
                total = total.multiply(NEGATIVE);
            }
            for (StatementEntry entry : balanceSheet.getEntries()) {
                if (!obj[2].toString().equals(entry.getGlCode())) continue;
                if (entry.getFundWiseAmount().isEmpty()) {
                    entry.getFundWiseAmount().put(this.getFundNameForId(fundList, new Integer(obj[1].toString())), this.divideAndRound(total, divisor));
                    continue;
                }
                boolean shouldAddNewFund = true;
                for (Map.Entry<String, BigDecimal> object : entry.getFundWiseAmount().entrySet()) {
                    if (!object.getKey().equalsIgnoreCase(this.getFundNameForId(fundList, new Integer(obj[1].toString())))) continue;
                    entry.getFundWiseAmount().put(object.getKey(), object.getValue().add(this.divideAndRound(total, divisor)));
                    shouldAddNewFund = false;
                }
                if (!shouldAddNewFund) continue;
                entry.getFundWiseAmount().put(this.getFundNameForId(fundList, new Integer(obj[1].toString())), this.divideAndRound(total, divisor));
            }
        }
    }

    public void addOpeningBalancePrevYear(Statement balanceSheet, String transactionQuery, Date fromDate) {
        try {
            BigDecimal divisor = balanceSheet.getDivisor();
            CFinancialYear prevFinancialYr = this.financialYearDAO.getPreviousFinancialYearByDate(fromDate);
            String prevFinancialYearId = prevFinancialYr.getId().toString();
            SQLQuery query = this.persistenceService.getSession().createSQLQuery("select sum(openingdebitbalance)- sum(openingcreditbalance),coa.majorcode,coa.type FROM transactionsummary ts,chartofaccounts coa  WHERE ts.glcodeid = coa.ID  AND ts.financialyearid=" + prevFinancialYearId + transactionQuery + " GROUP BY coa.majorcode,coa.type");
            List openingBalanceAmountList = query.list();
            for (Object[] obj : openingBalanceAmountList) {
                if (obj[0] == null || obj[1] == null) continue;
                BigDecimal total = (BigDecimal)obj[0];
                if (L.equals(obj[2].toString())) {
                    total = total.multiply(NEGATIVE);
                }
                for (StatementEntry entry : balanceSheet.getEntries()) {
                    if (!obj[1].toString().equals(entry.getGlCode())) continue;
                    BigDecimal prevYrTotal = entry.getPreviousYearTotal();
                    prevYrTotal = prevYrTotal == null ? BigDecimal.ZERO : prevYrTotal;
                    entry.setPreviousYearTotal(prevYrTotal.add(this.divideAndRound(total, divisor)));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addExcessIEForCurrentYear(Statement balanceSheet, List<Fund> fundList, String glCodeForExcessIE, String filterQuery, Date toDate, Date fromDate) {
        BigDecimal divisor = balanceSheet.getDivisor();
        String voucherStatusToExclude = this.getAppConfigValueFor("EGF", "statusexcludeReport");
        StringBuffer qry = new StringBuffer(256);
        qry = qry.append("select sum(g.creditamount)-sum(g.debitamount),v.fundid from voucherheader v,");
        if (balanceSheet.getDepartment() != null && balanceSheet.getDepartment().getId() != -1L) {
            qry.append("VoucherMis mis ,");
        }
        qry.append("generalledger g, chartofaccounts coa   where  v.ID=g.VOUCHERHEADERID and v.status not in(" + voucherStatusToExclude + ") and  v.voucherdate>='" + this.getFormattedDate(fromDate) + "' and v.voucherdate<='" + this.getFormattedDate(toDate) + "'");
        if (balanceSheet.getDepartment() != null && balanceSheet.getDepartment().getId() != -1L) {
            qry.append(" and v.id= mis.voucherheaderid  and mis.departmentid= " + balanceSheet.getDepartment().getId());
        }
        qry.append(" and coa.ID=g.glcodeid and coa.type in ('I','E') " + filterQuery + " group by v.fundid");
        SQLQuery query = this.persistenceService.getSession().createSQLQuery(qry.toString());
        List excessieAmountList = query.list();
        for (StatementEntry entry : balanceSheet.getEntries()) {
            if (entry.getGlCode() == null || !glCodeForExcessIE.equals(entry.getGlCode())) continue;
            for (Object[] obj : excessieAmountList) {
                if (obj[0] == null || obj[1] == null) continue;
                String fundNameForId = this.getFundNameForId(fundList, Integer.valueOf(obj[1].toString()));
                if (entry.getFundWiseAmount().containsKey(fundNameForId)) {
                    entry.getFundWiseAmount().put(fundNameForId, entry.getFundWiseAmount().get(fundNameForId).add(this.divideAndRound((BigDecimal)obj[0], divisor)));
                    continue;
                }
                entry.getFundWiseAmount().put(fundNameForId, this.divideAndRound((BigDecimal)obj[0], divisor));
            }
        }
    }

    public void addExcessIEForPreviousYear(Statement balanceSheet, List<Fund> fundList, String glCodeForExcessIE, String filterQuery, Date toDate, Date fromDate) {
        BigDecimal divisor = balanceSheet.getDivisor();
        BigDecimal sum = BigDecimal.ZERO;
        String formattedToDate = "";
        String voucherStatusToExclude = this.getAppConfigValueFor("EGF", "statusexcludeReport");
        if ("Yearly".equalsIgnoreCase(balanceSheet.getPeriod())) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(fromDate);
            cal.add(5, -1);
            formattedToDate = this.getFormattedDate(cal.getTime());
        } else {
            formattedToDate = this.getFormattedDate(this.getPreviousYearFor(toDate));
        }
        StringBuffer qry = new StringBuffer(256);
        qry = qry.append("\t\tselect sum(g.creditamount)-sum(g.debitamount),v.fundid  from voucherheader v,generalledger g, ");
        if (balanceSheet.getDepartment() != null && balanceSheet.getDepartment().getId() != -1L) {
            qry.append("  VoucherMis mis ,");
        }
        qry.append(" chartofaccounts coa   where  v.ID=g.VOUCHERHEADERID and v.status not in(" + voucherStatusToExclude + ") and  v.voucherdate>='" + this.getFormattedDate(this.getPreviousYearFor(fromDate)) + "' and v.voucherdate<='" + formattedToDate + "' and coa.ID=g.glcodeid ");
        if (balanceSheet.getDepartment() != null && balanceSheet.getDepartment().getId() != -1L) {
            qry.append(" and v.id= mis.voucherheaderid");
        }
        qry.append(" and coa.type in ('I','E') " + filterQuery + " group by v.fundid,g.functionid");
        SQLQuery query = this.persistenceService.getSession().createSQLQuery(qry.toString());
        List excessieAmountList = query.list();
        for (Object[] obj : excessieAmountList) {
            sum = sum.add((BigDecimal)obj[0]);
        }
        for (int index = 0; index < balanceSheet.size(); ++index) {
            if (balanceSheet.get(index).getGlCode() == null || !glCodeForExcessIE.equals(balanceSheet.get(index).getGlCode())) continue;
            BigDecimal prevYrTotal = balanceSheet.get(index).getPreviousYearTotal();
            prevYrTotal = prevYrTotal == null ? BigDecimal.ZERO : prevYrTotal;
            balanceSheet.get(index).setPreviousYearTotal(prevYrTotal.add(this.divideAndRound(sum, divisor)));
        }
    }

    public void populateBalanceSheet(Statement balanceSheet) {
        try {
            List configValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "Remove Entries With Zero Amount in Report");
            for (AppConfigValues appConfigVal : configValues) {
                this.removeEntrysWithZeroAmount = appConfigVal.getValue();
            }
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Appconfig value for remove entries with zero amount in report is not defined in the system");
        }
        this.minorCodeLength = Integer.valueOf(this.getAppConfigValueFor("EGF", "coa_minorcode_length"));
        this.coaType.add(Character.valueOf('A'));
        this.coaType.add(Character.valueOf('L'));
        Date fromDate = this.getFromDate(balanceSheet);
        Date toDate = this.getToDate(balanceSheet);
        String voucherStatusToExclude = this.getAppConfigValueFor("EGF", "statusexcludeReport");
        List<Fund> fundList = balanceSheet.getFunds();
        String filterQuery = this.getFilterQuery(balanceSheet);
        this.populateCurrentYearAmountPerFund(balanceSheet, fundList, filterQuery, toDate, fromDate, BS);
        this.populatePreviousYearTotals(balanceSheet, filterQuery, toDate, fromDate, BS, "'L','A'");
        this.addCurrentOpeningBalancePerFund(balanceSheet, fundList, this.getTransactionQuery(balanceSheet));
        this.addOpeningBalancePrevYear(balanceSheet, this.getTransactionQuery(balanceSheet), fromDate);
        String glCodeForExcessIE = this.getGlcodeForPurposeCode(7);
        this.addExcessIEForCurrentYear(balanceSheet, fundList, glCodeForExcessIE, filterQuery, toDate, fromDate);
        this.addExcessIEForPreviousYear(balanceSheet, fundList, glCodeForExcessIE, filterQuery, toDate, fromDate);
        this.computeCurrentYearTotals(balanceSheet, "LIABILITIES", "ASSETS");
        this.populateSchedule(balanceSheet, BS);
        this.removeFundsWithNoData(balanceSheet);
        this.groupBySubSchedule(balanceSheet);
        this.computeTotalAssetsAndLiabilities(balanceSheet);
        if (this.removeEntrysWithZeroAmount.equalsIgnoreCase("Yes")) {
            this.removeEntrysWithZeroAmount(balanceSheet);
        }
    }

    private void computeTotalAssetsAndLiabilities(Statement balanceSheet) {
        BigDecimal currentYearTotal = BigDecimal.ZERO;
        BigDecimal previousYearTotal = BigDecimal.ZERO;
        for (int index = 0; index < balanceSheet.size(); ++index) {
            if ("Total".equalsIgnoreCase(balanceSheet.get(index).getAccountName()) || "LIABILITIES".equals(balanceSheet.get(index).getAccountName()) || "ASSETS".equals(balanceSheet.get(index).getAccountName())) continue;
            if ("Total LIABILITIES".equalsIgnoreCase(balanceSheet.get(index).getAccountName()) || "Total ASSETS".equalsIgnoreCase(balanceSheet.get(index).getAccountName())) {
                balanceSheet.get(index).setCurrentYearTotal(currentYearTotal);
                currentYearTotal = BigDecimal.ZERO;
                balanceSheet.get(index).setPreviousYearTotal(previousYearTotal);
                previousYearTotal = BigDecimal.ZERO;
                continue;
            }
            if (balanceSheet.get(index).getCurrentYearTotal() != null) {
                currentYearTotal = currentYearTotal.add(balanceSheet.get(index).getCurrentYearTotal());
            }
            if (balanceSheet.get(index).getPreviousYearTotal() == null) continue;
            previousYearTotal = previousYearTotal.add(balanceSheet.get(index).getPreviousYearTotal());
        }
    }

    private void groupBySubSchedule(Statement balanceSheet) {
        LinkedList<StatementEntry> list = new LinkedList<StatementEntry>();
        Map<String, String> schedueNumberToNameMap = this.getSubSchedule(BS);
        HashSet<String> grouped = new HashSet<String>();
        BigDecimal previousTotal = BigDecimal.ZERO;
        BigDecimal currentTotal = BigDecimal.ZERO;
        HashMap<String, BigDecimal> fundTotals = new HashMap<String, BigDecimal>();
        boolean isLastEntryAHeader = true;
        for (StatementEntry entry : balanceSheet.getEntries()) {
            StatementEntry balanceSheetEntry;
            if (!grouped.contains(schedueNumberToNameMap.get(entry.getScheduleNo()))) {
                if (!isLastEntryAHeader) {
                    balanceSheetEntry = new StatementEntry(null, "Total", "", previousTotal, currentTotal, true);
                    balanceSheetEntry.setFundWiseAmount(fundTotals);
                    fundTotals = new HashMap();
                    list.add(balanceSheetEntry);
                }
                this.addTotalRowToPreviousGroup(list, schedueNumberToNameMap, entry);
                previousTotal = BigDecimal.ZERO;
                currentTotal = BigDecimal.ZERO;
                grouped.add(schedueNumberToNameMap.get(entry.getScheduleNo()));
            }
            if ("Total LIABILITIES".equalsIgnoreCase(entry.getAccountName())) {
                balanceSheetEntry = new StatementEntry(null, "Total", "", previousTotal, currentTotal, true);
                balanceSheetEntry.setFundWiseAmount(fundTotals);
                fundTotals = new HashMap();
                list.add(balanceSheetEntry);
            }
            list.add(entry);
            this.addFundAmount(entry, fundTotals);
            previousTotal = previousTotal.add(this.zeroOrValue(entry.getPreviousYearTotal()));
            currentTotal = currentTotal.add(this.zeroOrValue(entry.getCurrentYearTotal()));
            boolean bl = isLastEntryAHeader = entry.getGlCode() == null;
            if (!"Total LIABILITIES".equalsIgnoreCase(entry.getAccountName())) continue;
            previousTotal = BigDecimal.ZERO;
            currentTotal = BigDecimal.ZERO;
        }
        StatementEntry sheetEntry = new StatementEntry(null, "Total", "", previousTotal, currentTotal, true);
        sheetEntry.setFundWiseAmount(fundTotals);
        list.add(list.size() - 1, sheetEntry);
        balanceSheet.setEntries(list);
    }

    private void removeEntrysWithZeroAmount(Statement balanceSheet) {
        LinkedList<StatementEntry> list = new LinkedList<StatementEntry>();
        Map<Object, Object> FundWiseAmount = new HashMap();
        for (StatementEntry entry : balanceSheet.getEntries()) {
            if (entry.getGlCode() != null && !entry.getGlCode().equalsIgnoreCase("")) {
                FundWiseAmount = entry.getFundWiseAmount();
                if (FundWiseAmount != null) {
                    Boolean check = false;
                    for (String string : FundWiseAmount.keySet()) {
                        if (entry.getPreviousYearTotal() != null && ((BigDecimal)FundWiseAmount.get(string)).compareTo(BigDecimal.ZERO) == 0 && entry.getPreviousYearTotal().compareTo(BigDecimal.ZERO) == 0) continue;
                        check = true;
                        break;
                    }
                    if (!check.equals(true)) continue;
                    list.add(entry);
                    continue;
                }
                list.add(entry);
                continue;
            }
            list.add(entry);
        }
        balanceSheet.setEntries(new LinkedList<StatementEntry>());
        balanceSheet.setEntries(list);
    }

    public void removeScheduleEntrysWithZeroAmount(Statement balanceSheet) {
        ArrayList<StatementEntry> list = new ArrayList<StatementEntry>();
        for (StatementEntry entry : balanceSheet.getEntries()) {
            if (entry.getGlCode() != null && !entry.getGlCode().equalsIgnoreCase("")) {
                if (entry.getCurrentYearTotal() != null && entry.getPreviousYearTotal() != null && entry.getCurrentYearTotal().compareTo(BigDecimal.ZERO) == 0 && entry.getPreviousYearTotal().compareTo(BigDecimal.ZERO) == 0) continue;
                list.add(entry);
                continue;
            }
            list.add(entry);
        }
        balanceSheet.setEntries(new LinkedList<StatementEntry>());
        balanceSheet.setEntries(list);
    }

    public void populateCurrentYearAmountPerFund(Statement statement, List<Fund> fundList, String filterQuery, Date toDate, Date fromDate, String scheduleReportType) {
        Statement assets = new Statement();
        Statement liabilities = new Statement();
        BigDecimal divisor = statement.getDivisor();
        List<StatementResultObject> allGlCodes = this.getAllGlCodesFor(scheduleReportType);
        List<StatementResultObject> results = this.getTransactionAmount(filterQuery, toDate, fromDate, "'L','A'", BS);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"row.getGlCode()--row.getFundId()--row.getAmount()--row.getBudgetAmount()");
        }
        for (StatementResultObject queryObject : allGlCodes) {
            List<StatementResultObject> rows;
            if (queryObject.getGlCode() == null) {
                queryObject.setGlCode("");
            }
            if ((rows = this.getRowWithGlCode(results, queryObject.getGlCode())).isEmpty()) {
                if (queryObject.isLiability()) {
                    liabilities.add(new StatementEntry(queryObject.getGlCode(), queryObject.getScheduleName(), queryObject.getScheduleNumber(), BigDecimal.ZERO, BigDecimal.ZERO, false));
                    continue;
                }
                assets.add(new StatementEntry(queryObject.getGlCode(), queryObject.getScheduleName(), queryObject.getScheduleNumber(), BigDecimal.ZERO, BigDecimal.ZERO, false));
                continue;
            }
            for (StatementResultObject row : rows) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(row.getGlCode() + "--" + row.getFundId() + "--" + row.getAmount() + "--" + row.getBudgetAmount()));
                }
                if (row.isLiability()) {
                    row.negateAmount();
                }
                if (liabilities.containsBalanceSheetEntry(row.getGlCode()) || assets.containsBalanceSheetEntry(row.getGlCode())) {
                    if (row.isLiability()) {
                        this.addFundAmount(fundList, liabilities, divisor, row);
                        continue;
                    }
                    this.addFundAmount(fundList, assets, divisor, row);
                    continue;
                }
                StatementEntry balanceSheetEntry = new StatementEntry();
                if (row.getAmount() != null && row.getFundId() != null) {
                    balanceSheetEntry.getFundWiseAmount().put(this.getFundNameForId(fundList, (int)row.getFundId()), this.divideAndRound(row.getAmount(), divisor));
                }
                if (queryObject.getGlCode() != null) {
                    balanceSheetEntry.setGlCode(queryObject.getGlCode());
                    balanceSheetEntry.setAccountName(queryObject.getScheduleName());
                    balanceSheetEntry.setScheduleNo(queryObject.getScheduleNumber());
                }
                if (row.isLiability()) {
                    liabilities.add(balanceSheetEntry);
                    continue;
                }
                assets.add(balanceSheetEntry);
            }
        }
        this.addRowsToStatement(statement, assets, liabilities);
    }

    public void populatePreviousYearTotals(Statement balanceSheet, String filterQuery, Date toDate, Date fromDate, String reportSubType, String coaType) {
        Date formattedToDate;
        boolean newbalanceSheet = balanceSheet.size() <= 2;
        BigDecimal divisor = balanceSheet.getDivisor();
        Statement assets = new Statement();
        Statement liabilities = new Statement();
        Calendar cal = Calendar.getInstance();
        if ("Yearly".equalsIgnoreCase(balanceSheet.getPeriod())) {
            cal.setTime(fromDate);
            cal.add(5, -1);
            formattedToDate = cal.getTime();
        } else {
            formattedToDate = this.getPreviousYearFor(toDate);
        }
        List<StatementResultObject> results = this.getTransactionAmount(filterQuery, formattedToDate, this.getPreviousYearFor(fromDate), coaType, reportSubType);
        for (StatementResultObject row : results) {
            if (balanceSheet.containsBalanceSheetEntry(row.getGlCode())) {
                for (int index = 0; index < balanceSheet.size(); ++index) {
                    BigDecimal prevYrTotal;
                    if (balanceSheet.get(index).getGlCode() == null || !row.getGlCode().equals(balanceSheet.get(index).getGlCode())) continue;
                    if (row.isLiability()) {
                        row.negateAmount();
                    }
                    prevYrTotal = (prevYrTotal = balanceSheet.get(index).getPreviousYearTotal()) == null ? BigDecimal.ZERO : prevYrTotal;
                    balanceSheet.get(index).setPreviousYearTotal(prevYrTotal.add(this.divideAndRound(row.getAmount(), divisor)));
                }
                continue;
            }
            if (row.isLiability()) {
                row.negateAmount();
            }
            StatementEntry balanceSheetEntry = new StatementEntry();
            if (row.getAmount() != null && row.getFundId() != null) {
                balanceSheetEntry.setPreviousYearTotal(this.divideAndRound(row.getAmount(), divisor));
                balanceSheetEntry.setCurrentYearTotal(BigDecimal.ZERO);
            }
            if (row.getGlCode() != null) {
                balanceSheetEntry.setGlCode(row.getGlCode());
            }
            if (row.isLiability()) {
                liabilities.add(balanceSheetEntry);
                continue;
            }
            assets.add(balanceSheetEntry);
        }
        if (newbalanceSheet) {
            this.addRowsToStatement(balanceSheet, assets, liabilities);
        }
    }

    public String getRemoveEntrysWithZeroAmount() {
        return this.removeEntrysWithZeroAmount;
    }

    public void setRemoveEntrysWithZeroAmount(String removeEntrysWithZeroAmount) {
        this.removeEntrysWithZeroAmount = removeEntrysWithZeroAmount;
    }
}

