/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.budget;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.budget.Budget;
import org.egov.model.budget.BudgetDetail;
import org.egov.model.budget.BudgetProposalBean;
import org.egov.model.service.BudgetDefinitionService;
import org.egov.model.voucher.WorkflowBean;
import org.egov.pims.commons.Position;
import org.egov.services.budget.BudgetDetailHelperBean;
import org.egov.services.budget.BudgetDetailService;
import org.egov.services.budget.BudgetService;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class BudgetDetailActionHelper {
    @Autowired
    private BudgetDefinitionService budgetDefinitionService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    @Qualifier(value="budgetService")
    private BudgetService budgetService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    @Qualifier(value="budgetDetailService")
    private BudgetDetailService budgetDetailService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    private static Logger LOGGER = Logger.getLogger(BudgetDetailActionHelper.class);
    private static final String REFERENCEBUDGET = "no.reference.budget";

    @Transactional
    public void create(BudgetDetailHelperBean parameterObject) {
        if (!parameterObject.addNewDetails.booleanValue()) {
            this.deleteExisting(parameterObject.budgetDetail.getBudget(), parameterObject.searchFunctionId, parameterObject.budgetGroupId);
        }
        Position pos = this.positionMasterService.getPositionById(parameterObject.workflowBean.getApproverPositionId());
        this.saveBudgetDetails(true, parameterObject.budgetDetail.getBudget(), parameterObject.budgetDetailList, parameterObject.beAmounts, parameterObject.egwStatus, parameterObject.workflowBean, pos);
        if (parameterObject.budgetDetail.getBudget().getState() == null) {
            parameterObject.budgetDetail.getBudget().transition().start().withSenderName(this.securityUtils.getCurrentUser().getName()).withComments(parameterObject.workflowBean.getApproverComments()).withStateValue("Created").withDateInfo(new Date()).withOwner(pos);
        } else {
            parameterObject.budgetDetail.getBudget().transition().withSenderName(this.securityUtils.getCurrentUser().getName()).withComments(parameterObject.workflowBean.getApproverComments()).withStateValue("Created").withDateInfo(new Date()).withOwner(pos);
        }
        this.budgetDefinitionService.update(parameterObject.budgetDetail.getBudget());
    }

    public void saveBudgetDetails(Boolean addNewDetails, Budget budget, List<BudgetDetail> budgetDetailList, List<BigDecimal> beAmounts, EgwStatus egwStatus, WorkflowBean workflowBean, Position owner) {
        int index = 0;
        Budget refBudget = this.budgetService.getReferenceBudgetFor(budget);
        if (refBudget == null) {
            throw new ValidationException(Arrays.asList(new ValidationError(REFERENCEBUDGET, REFERENCEBUDGET)));
        }
        int i = 0;
        for (BudgetDetail detail : budgetDetailList) {
            if (detail != null) {
                detail.setId(null);
            }
            BudgetDetail reCurrentYear = this.budgetDetailService.setRelatedEntitesOn(detail);
            reCurrentYear.setUniqueNo(this.budgetDetailService.generateUniqueNo(reCurrentYear));
            this.budgetDetailService.applyAuditing((AbstractAuditable)reCurrentYear);
            reCurrentYear = this.budgetDetailService.transitionWorkFlow(reCurrentYear, workflowBean);
            this.budgetDetailService.applyAuditing((AbstractAuditable)reCurrentYear.getState());
            this.budgetDetailService.persist(reCurrentYear);
            BudgetDetail beNextYear = new BudgetDetail();
            beNextYear.copyFrom(detail);
            beNextYear.setBudget(refBudget);
            beNextYear.setOriginalAmount(beAmounts.get(index));
            beNextYear.setDocumentNumber(detail.getDocumentNumber());
            beNextYear.setAnticipatoryAmount(reCurrentYear.getAnticipatoryAmount());
            beNextYear = this.budgetDetailService.setRelatedEntitesOn(beNextYear);
            beNextYear.setUniqueNo(this.budgetDetailService.generateUniqueNo(beNextYear));
            if (workflowBean.getWorkFlowAction().equalsIgnoreCase("Save")) {
                beNextYear.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("BUDGETDETAIL", "NEW"));
            } else {
                beNextYear.setStatus(egwStatus);
            }
            this.budgetDetailService.applyAuditing((AbstractAuditable)beNextYear);
            this.budgetDetailService.persist(beNextYear);
            ++index;
            if (++i % 15 == 0) {
                this.persistenceService.getSession().flush();
                this.persistenceService.getSession().clear();
            }
            LOGGER.error((Object)("saved" + i + "Item"));
        }
    }

    public String generateUniqueNo(BudgetDetail detail) {
        return detail.getFund().getId() + "-" + detail.getExecutingDepartment().getId() + "-" + detail.getFunction().getId() + "-" + detail.getBudgetGroup().getId();
    }

    private void deleteExisting(Budget budget, Long searchfunctionid, Long searchbudgetGroupid) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Initiating deletion ..........");
        }
        Budget referenceBudgetFor = this.budgetService.getReferenceBudgetFor(budget);
        StringBuffer addlCondtion = new StringBuffer(150);
        addlCondtion.append("delete from egf_budgetdetail where budget=:budgetid ");
        addlCondtion.append("and status not in (SELECT id FROM egw_status   WHERE code ='NEW')");
        if (referenceBudgetFor != null) {
            addlCondtion.append(" or (budget=:referenceBudget and status not in (SELECT id FROM egw_status   WHERE code ='NEW'))");
        }
        if (searchfunctionid != null && searchfunctionid != 0L) {
            addlCondtion.append("and function.id=:functionid");
        }
        if (searchbudgetGroupid != null && searchbudgetGroupid != 0L) {
            addlCondtion.append("and budgetGroup.id=:budgetGroupid");
        }
        new ArrayList();
        SQLQuery qry = this.persistenceService.getSession().createSQLQuery(addlCondtion.toString());
        qry.setLong("budgetid", budget.getId().longValue());
        if (referenceBudgetFor != null) {
            qry.setLong("referenceBudget", referenceBudgetFor.getId().longValue());
        }
        if (searchfunctionid != null && searchfunctionid != 0L) {
            qry.setLong("functionid", searchfunctionid.longValue());
        }
        if (searchbudgetGroupid != null && searchbudgetGroupid != 0L) {
            qry.setLong("budgetGroupid", searchbudgetGroupid.longValue());
        }
        qry.executeUpdate();
    }

    @Transactional
    public void update(List<BudgetProposalBean> bpBeanList, WorkflowBean workflowBean) {
        for (BudgetProposalBean bpBean : bpBeanList) {
            if (bpBean == null || bpBean.getId() == null) continue;
            BudgetDetail bd = (BudgetDetail)((Object)this.budgetDetailService.find("from BudgetDetail where id=?", new Object[]{bpBean.getId()}));
            bd.setOriginalAmount(bpBean.getProposedRE());
            BudgetDetail be = (BudgetDetail)((Object)this.budgetDetailService.find("from BudgetDetail where id=?", new Object[]{bpBean.getNextYrId()}));
            be.setOriginalAmount(bpBean.getProposedBE());
            if (bpBean.getDocumentNumber() != null) {
                bd.setDocumentNumber(bpBean.getDocumentNumber());
            }
            bd = this.budgetDetailService.transitionWorkFlow(bd, workflowBean);
            if (workflowBean.getWorkFlowAction().contains("Verify")) {
                be.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("BUDGETDETAIL", "VERIFIED"));
            } else {
                be.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("BUDGETDETAIL", "Created"));
            }
            this.budgetDetailService.applyAuditing((AbstractAuditable)bd.getState());
            this.budgetDetailService.update((Object)bd);
            this.budgetDetailService.update((Object)be);
        }
    }
}

