/*
 * Decompiled with CFR 0.152.
 */
package org.egov.model.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.CFinancialYear;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.service.CFinancialYearService;
import org.egov.model.budget.Budget;
import org.egov.model.budget.BudgetDetail;
import org.egov.model.repository.BudgetDefinitionRepository;
import org.egov.services.budget.BudgetDetailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BudgetDefinitionService {
    private static final String RE = "RE";
    private final BudgetDefinitionRepository budgetDefinitionRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource messageSource;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernate;
    @Autowired
    private CFinancialYearService cFinancialYearService;
    @Autowired
    private BudgetDetailService budgetDetailService;

    @Autowired
    public BudgetDefinitionService(BudgetDefinitionRepository budgetDefinitionRepository) {
        this.budgetDefinitionRepository = budgetDefinitionRepository;
    }

    @Transactional
    public Budget create(Budget budget) {
        budget.setMaterializedPath(this.generateMaterializedPath(budget));
        return (Budget)((Object)this.budgetDefinitionRepository.save((Object)budget));
    }

    private String generateMaterializedPath(Budget budget) {
        return budget.getParent() == null ? String.valueOf(this.budgetDefinitionRepository.getRootBudgetsCount() + 1L) : budget.getParent().getMaterializedPath().concat(".").concat(String.valueOf(this.budgetDefinitionRepository.getChildBudgetsCount(budget.getParent()) + 1L));
    }

    @Transactional
    public Budget update(Budget budget) {
        return (Budget)((Object)this.budgetDefinitionRepository.save((Object)budget));
    }

    public List<Budget> findAll() {
        return this.budgetDefinitionRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public Budget findOne(Long id) {
        return (Budget)((Object)this.budgetDefinitionRepository.findOne(id));
    }

    public List<Budget> search(Budget budget) {
        if (budget.getFinancialYear() != null && budget.getSearchBere() != null) {
            return this.budgetDefinitionRepository.findByIsbereIsAndFinancialYearIdIsOrderByFinancialYearIdAscNameAsc(budget.getSearchBere(), budget.getFinancialYear().getId());
        }
        if (budget.getFinancialYear() != null && budget.getSearchBere() == null) {
            return this.budgetDefinitionRepository.findByFinancialYearIdIsOrderByFinancialYearIdAscNameAsc(budget.getFinancialYear().getId());
        }
        if (budget.getFinancialYear() == null && budget.getSearchBere() != null) {
            return this.budgetDefinitionRepository.findByIsbereIsOrderByFinancialYearIdAscNameAsc(budget.getSearchBere());
        }
        return this.budgetDefinitionRepository.findAll();
    }

    public List<Budget> getBudgetByFinancialYearId(Long financialYearId) {
        return this.budgetDefinitionRepository.findByFinancialYearIdOrderByFinancialYearIdAscNameAsc(financialYearId);
    }

    public List<Budget> getReferenceBudgetByFinancialYear() {
        Long financialYearId = null;
        return this.budgetDefinitionRepository.findByIsbereIsAndFinancialYearIdIsOrderByFinancialYearIdAscNameAsc(RE, financialYearId);
    }

    public List<Budget> getReferenceBudgetList(Long financialYearId, List<Long> referenceBudgetIdList) {
        return this.budgetDefinitionRepository.findReferenceBudget(RE, financialYearId, referenceBudgetIdList);
    }

    public List<Budget> getReferenceBudgetEmpty(Long financialYearId) {
        return this.budgetDefinitionRepository.findByIsActiveBudgetTrueAndIsbereIsAndFinancialYearIdIs(RE, financialYearId);
    }

    public List<Budget> getParentList(String isbere, Long financialYearId, List<Long> budgetIdList) {
        if (budgetIdList.isEmpty()) {
            return this.budgetDefinitionRepository.findByIsActiveBudgetTrueAndIsbereIsAndFinancialYearIdIs(isbere, financialYearId);
        }
        return this.budgetDefinitionRepository.findByIsbereIsAndFinancialYearIdIsAndIdNotIn(isbere, financialYearId, budgetIdList);
    }

    public String validate(Budget budget) {
        List<Budget> budgetList;
        Budget b;
        String validationMessage = "";
        if (budget.getParent() != null && budget.getParent().getId() != null && budget.getParent().getId() > 0L && !(b = (Budget)((Object)this.budgetDefinitionRepository.findOne(budget.getParent().getId()))).getIsbere().equals(budget.getIsbere())) {
            validationMessage = this.messageSource.getMessage("budget.invalid.parent", (Object[])new String[]{b.getName()}, null);
        }
        if (budget.getIsPrimaryBudget() && budget.getFinancialYear() != null && budget.getParent() == null && !(budgetList = this.budgetDefinitionRepository.findByIsbereIsAndFinancialYearIdIsAndIsPrimaryBudgetTrueAndParentIsNull(budget.getIsbere(), budget.getFinancialYear().getId())).isEmpty()) {
            validationMessage = this.messageSource.getMessage("budget.primary.invalid", (Object[])new String[]{budgetList.get(0).getName(), budgetList.get(0).getFinancialYear().getFinYearRange()}, null);
        }
        return validationMessage;
    }

    public EgwStatus getBudgetStatus(String code) {
        return this.egwStatusHibernate.getStatusByModuleAndCode("BUDGET", code);
    }

    public List<BudgetDetail> getBudgetDetailList(Long budgetId) {
        return this.budgetDetailService.getBudgetDetailsByBudgetId(budgetId);
    }

    public List<Budget> referenceBudgetList(Long financialYearId) {
        List<Long> referenceBudgetIdList = this.getReferenceBudgetList(financialYearId);
        CFinancialYear financialYear = this.cFinancialYearService.findOne(financialYearId);
        CFinancialYear previousYear = this.cFinancialYearService.getPreviousFinancialYearForDate(financialYear.getStartingDate());
        if (!referenceBudgetIdList.isEmpty()) {
            return this.getReferenceBudgetList(previousYear.getId(), referenceBudgetIdList);
        }
        return this.getReferenceBudgetEmpty(previousYear.getId());
    }

    public List<Budget> parentList(String isBere, Long financialYearId) {
        List<Long> budgetIdList = this.budgetDetailService.getBudgetIdList();
        return this.getParentList(isBere, financialYearId, budgetIdList);
    }

    public List<Long> getReferenceBudgetList(Long financialYearId) {
        return this.budgetDefinitionRepository.getReferenceBudgetIds(financialYearId);
    }

    public Long getApproved(Long financialYearId) {
        return this.budgetDefinitionRepository.countByIdNotInAndStatusIdInAndFinancialYearIdIsAndIsbereIs(this.budgetDefinitionRepository.findParentBudget(), this.getBudgetApprovedStatus().getId(), financialYearId, RE);
    }

    public Long getVerified(Long financialYearId) {
        List<Long> bb = this.budgetDetailService.getBudgetIdList();
        return this.budgetDefinitionRepository.countByStatusIdInAndFinancialYearIdIsAndIsbereIsAndIdIn(this.getBudgetStatus("Created").getId(), financialYearId, RE, bb);
    }

    public Long getNotInitalized(Long financialYearId) {
        List<Long> bb = this.budgetDetailService.getBudgetIdList();
        bb.addAll(this.budgetDefinitionRepository.findParentBudget());
        return this.budgetDefinitionRepository.countByIdNotInAndFinancialYearIdIsAndIsbereIs(bb, financialYearId, RE);
    }

    public Long getFinancialYearForBudget(Long budgetId) {
        return this.findOne(budgetId).getFinancialYear().getId();
    }

    public Long getNotApprovedBudgetCount(Long financialYearId) {
        List<Long> bb = this.budgetDefinitionRepository.findParentBudget();
        return this.budgetDefinitionRepository.countByStatusIdNotInAndFinancialYearIdIsAndIsbereIsAndIdNotIn(this.getBudgetStatus("Approved").getId(), financialYearId, RE, bb);
    }

    public EgwStatus getBudgetApprovedStatus() {
        return this.egwStatusHibernate.getStatusByModuleAndCode("BUDGET", "Approved");
    }

    public Budget getParentBudgetForApprovedChildBudgets(Budget budget) {
        String bgMaterializedPath = budget.getMaterializedPath().substring(0, budget.getMaterializedPath().lastIndexOf(46) + 1);
        return this.budgetDefinitionRepository.countNotApprovedBudgetByMaterializedPath(bgMaterializedPath) > 0L ? null : this.budgetDefinitionRepository.findByMaterializedPath(bgMaterializedPath.substring(0, bgMaterializedPath.length() - 1));
    }
}

