/*
 * Decompiled with CFR 0.152.
 */
package org.egov.model.repository;

import java.util.List;
import org.egov.model.budget.Budget;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface BudgetDefinitionRepository
extends JpaRepository<Budget, Long> {
    public List<Budget> findByFinancialYearIdOrderByFinancialYearIdAscNameAsc(Long var1);

    public List<Budget> findByIsbereIsOrderByFinancialYearIdAscNameAsc(String var1);

    public List<Budget> findByIsbereIsAndFinancialYearIdIsOrderByFinancialYearIdAscNameAsc(String var1, Long var2);

    @Query(value="from Budget be where isActiveBudget=true and isbere =:isbere and financialYear.id=:financialYearId and id not in :rbIds")
    public List<Budget> findReferenceBudget(@Param(value="isbere") String var1, @Param(value="financialYearId") Long var2, @Param(value="rbIds") List<Long> var3);

    public List<Budget> findByIsActiveBudgetTrueAndIsbereIsAndFinancialYearIdIs(String var1, Long var2);

    public List<Budget> findByIsbereIsAndFinancialYearIdIsAndIdNotIn(String var1, Long var2, List<Long> var3);

    public List<Budget> findByIsbereIsAndFinancialYearIdIsAndIsPrimaryBudgetTrueAndParentIsNull(String var1, Long var2);

    public List<Budget> findByFinancialYearIdIsOrderByFinancialYearIdAscNameAsc(Long var1);

    @Query(value="select count(b) from Budget b where b.status.id =:statusId")
    public Long countBudget(Integer var1);

    public Long countByIdNotInAndStatusIdInAndFinancialYearIdIsAndIsbereIs(List<Long> var1, Integer var2, Long var3, String var4);

    public Long countByStatusIdInAndFinancialYearIdIsAndIsbereIsAndIdIn(Integer var1, Long var2, String var3, List<Long> var4);

    public Long countByIdNotInAndFinancialYearIdIs(List<Long> var1, Long var2);

    @Query(value="select count(b) from Budget b where parent is null")
    public Long getRootBudgetsCount();

    @Query(value="select count(b) from Budget b where parent=:parent")
    public Long getChildBudgetsCount(@Param(value="parent") Budget var1);

    @Query(value="select bd.referenceBudget.id from Budget bd where bd.referenceBudget.id is not null and bd.financialYear.id=:financialYearId")
    public List<Long> getReferenceBudgetIds(@Param(value="financialYearId") Long var1);

    public Long countByIdNotInAndFinancialYearIdIsAndIsbereIs(List<Long> var1, Long var2, String var3);

    @Query(value="select distinct bg.parent.id from Budget bg, Budget bd where  bg.parent=bd.id and (bg.parent is not null)")
    public List<Long> findParentBudget();

    public Budget findByReferenceBudgetId(Long var1);

    public Long countByStatusIdNotInAndFinancialYearIdIsAndIsbereIsAndIdNotIn(Integer var1, Long var2, String var3, List<Long> var4);

    @Query(value="select count(b) from Budget b  where b.materializedPath like :path||'%' and b.status.code not in ('Approved')")
    public Long countNotApprovedBudgetByMaterializedPath(@Param(value="path") String var1);

    public Budget findByMaterializedPath(String var1);
}

