/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.budget.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.egf.budget.model.BudgetControlType;
import org.egov.egf.budget.repository.BudgetControlTypeRepository;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BudgetControlTypeService {
    private final BudgetControlTypeRepository budgetControlTypeRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public BudgetControlTypeService(BudgetControlTypeRepository budgetCheckConfigRepository) {
        this.budgetControlTypeRepository = budgetCheckConfigRepository;
    }

    @Transactional
    public BudgetControlType create(BudgetControlType budgetCheckConfig) {
        return (BudgetControlType)((Object)this.budgetControlTypeRepository.save((Object)budgetCheckConfig));
    }

    @Transactional
    public BudgetControlType update(BudgetControlType budgetCheckConfig) {
        return (BudgetControlType)((Object)this.budgetControlTypeRepository.saveAndFlush((Object)budgetCheckConfig));
    }

    public List<BudgetControlType> findAll() {
        return this.budgetControlTypeRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"value"}));
    }

    public BudgetControlType findOne(Long id) {
        return (BudgetControlType)((Object)this.budgetControlTypeRepository.findOne(id));
    }

    public List<BudgetControlType> search(BudgetControlType budgetCheckConfig) {
        return this.budgetControlTypeRepository.findAll();
    }

    public String getConfigValue() {
        List<BudgetControlType> configs = this.findAll();
        if (configs.size() == 1) {
            return configs.get(0).getValue();
        }
        if (configs.size() == 0) {
            throw new ApplicationRuntimeException("Budget Check Configuration not defined");
        }
        throw new ApplicationRuntimeException("Multiple Budget Check Configurations  defined");
    }
}

