/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.autonumber.impl;

import java.io.Serializable;
import java.util.Date;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.egf.autonumber.BanNumberGenerator;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BanNumberGeneratorImpl
implements BanNumberGenerator {
    @Autowired
    private FinancialYearDAO financialYearDAO;
    @Autowired
    private ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;

    @Override
    public String getNextNumber() {
        String banNumber = "";
        String sequenceName = "";
        Date date = new Date();
        CFinancialYear financialYear = this.financialYearDAO.getFinYearByDate(date);
        if (financialYear == null) {
            throw new ApplicationRuntimeException("Financial Year is not defined for the voucher date");
        }
        sequenceName = "budget_reappropriation";
        Serializable nextSequence = this.applicationSequenceNumberGenerator.getNextSequence(sequenceName);
        banNumber = String.format("%s:%03d/%s", "BANo", nextSequence, financialYear.getFinYearRange());
        return banNumber;
    }
}

