/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.exility.updateservice;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class DataType {
    private static final Logger LOGGER = Logger.getLogger(DataType.class);
    public static final int ANYCHAR = 0;
    public static final int ALPHA = 1;
    public static final int ALPHANUMERIC = 2;
    public static final int UNSIGNEDINT = 3;
    public static final int SIGNEDINT = 4;
    public static final int UNSIGNEDDECIMAL = 5;
    public static final int SIGNEDDECIMAL = 6;
    public static final int ANYDATE = 7;
    public static final int PASTDATE = 8;
    public static final int FUTUREDATE = 9;
    public static final int EMAIL = 10;
    public static final int BOOLEAN = 11;
    public static final int REGEX = 12;
    public static final Date unknownDate = new Date(0L);
    private static final String[] dataTypes = new String[]{"ANYCHAR", "ALPHA", "ALPHANUMERIC", "UNSIGNEDINT", "SIGNEDINT", "UNSIGNEDDECIMAL", "SIGNEDDECIMAL", "ANYDATE", "PASTDATE", "FUTUREDATE", "EMAIL", "BOOLEAN", "REGEX"};
    private static final String[] regexStrings = new String[]{"^.*$", "^[a-zA-Z]*$", "^\\w*$", "^\\+?\\d*$", "^[+-]?\\d*$", "^\\+?\\d*\\.?\\d*$", "^[+-]?\\d*\\.?\\d*$", "^\\d\\d?-\\w\\w\\w-\\d\\d\\d\\d$", "^\\d\\d?-\\w\\w\\w-\\d\\d\\d\\d$", "^\\d\\d?-\\w\\w\\w-\\d\\d\\d\\d$", "^.*^", "^\\w+(\\.?\\w+)?@[\\w-]+(\\.[\\w-]+)*$"};
    private static final Pattern[] dataTypePatterns = new Pattern[regexStrings.length];
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");

    private DataType() {
    }

    public static boolean isNumericType(String dataType) {
        return DataType.isNumericType(DataType.getTypeInt(dataType));
    }

    public static boolean isNumericType(int dataType) {
        return dataType > 2 && dataType < 7;
    }

    public static boolean isDateType(String dataType) {
        return DataType.isDateType(DataType.getTypeInt(dataType));
    }

    public static boolean isDateType(int dataType) {
        return dataType > 2 && dataType < 7;
    }

    public static boolean isValid(String dataType, String value) {
        return DataType.isValid(DataType.getTypeInt(dataType), value);
    }

    public static boolean isValid(int dataType, String value) {
        if (dataType < 0 || dataType >= dataTypes.length) {
            return false;
        }
        if (dataType == 11) {
            return (value = value.toUpperCase()).equals("Yes") || value.equals("NO") || value.equals("TRUE") || value.equals("FALSE") || value.equals("0") || value.equals("1");
        }
        Matcher matcher = dataTypePatterns[dataType].matcher(value);
        boolean valid = matcher.find();
        if (!valid) {
            return false;
        }
        if (dataType == 7 || dataType == 9 || dataType == 8) {
            Date date;
            try {
                date = simpleDateFormat.parse(value);
            }
            catch (ParseException e) {
                LOGGER.error((Object)"Error while simpleDateFormat.parse(value)", (Throwable)e);
                return false;
            }
            Date today = DataType.getToday();
            if (dataType == 9 && today.after(date)) {
                return false;
            }
            return dataType != 8 || !today.before(date);
        }
        return true;
    }

    public static int getTypeInt(String type) {
        type = type.toUpperCase();
        for (int i = 0; i < dataTypes.length; ++i) {
            if (!dataTypes[i].equals(type)) continue;
            return i;
        }
        return -1;
    }

    public static Date getToday() {
        Date date = new Date();
        try {
            date = simpleDateFormat.parse(simpleDateFormat.format(date));
        }
        catch (ParseException e) {
            LOGGER.error((Object)"Error in getToday", (Throwable)e);
        }
        return date;
    }

    public static Date getDate(String value) {
        if (null == value) {
            return null;
        }
        try {
            return simpleDateFormat.parse(value);
        }
        catch (ParseException e) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Error in getDate", (Throwable)e);
            }
            return null;
        }
    }

    public static String getDateString(Date value) {
        return simpleDateFormat.format(value);
    }

    static {
        for (int i = 0; i < regexStrings.length; ++i) {
            DataType.dataTypePatterns[i] = Pattern.compile(regexStrings[i]);
        }
        simpleDateFormat.setLenient(false);
    }
}

