/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.exility.dataservice;

import com.exilant.exility.common.AbstractTask;
import com.exilant.exility.common.DataCollection;
import com.exilant.exility.common.TaskFailedException;
import com.exilant.exility.dataservice.SQLTask;
import com.exilant.exility.updateservice.BulkTask;
import com.exilant.exility.updateservice.InsertTask;
import com.exilant.exility.updateservice.SQLExecutionTask;
import com.exilant.exility.updateservice.UpdateTask;
import java.sql.Connection;

public class JobStep {
    private static final String TYPE_USERTASK = "userTask";
    private static final String TYPE_SQLTASK = "sqlTask";
    private static final String TYPE_UPDATETASK = "updateTask";
    private static final String TYPE_INSERTTASK = "insertTask";
    private static final String TYPE_BULKTASK = "bulkTask";
    private static final String TYPE_SQLEXECUTIONTASK = "sqlExecutionTask";
    public String name;
    public String type;
    public String gridName;
    public boolean errorOnNoData;
    public boolean gridHasColumnHeading;
    public String prefix = "";
    private Class userTaskClass;

    public void execute(DataCollection dc, Connection con) throws TaskFailedException {
        AbstractTask task;
        if (this.type.equals(TYPE_USERTASK)) {
            if (this.userTaskClass == null) {
                try {
                    this.userTaskClass = Class.forName(this.name);
                }
                catch (ClassNotFoundException e) {
                    dc.addMessage("exilNoClass", this.name);
                    throw new TaskFailedException();
                }
            }
            try {
                task = (AbstractTask)this.userTaskClass.newInstance();
            }
            catch (Exception e) {
                dc.addMessage("exilNoInstance", this.name);
                throw new TaskFailedException();
            }
        }
        if (this.type.equals(TYPE_SQLTASK)) {
            task = SQLTask.getTask();
        } else if (this.type.equals(TYPE_SQLEXECUTIONTASK)) {
            task = SQLExecutionTask.getTask();
        } else if (this.type.equals(TYPE_UPDATETASK)) {
            task = UpdateTask.getTask();
        } else if (this.type.equals(TYPE_INSERTTASK)) {
            task = InsertTask.getTask();
        } else if (this.type.equals(TYPE_BULKTASK)) {
            task = BulkTask.getTask();
        } else {
            dc.addMessage("exilNoTaskType", this.type);
            throw new TaskFailedException();
        }
        ((AbstractTask)task).execute(this.name, this.gridName, dc, con, this.errorOnNoData, this.gridHasColumnHeading, this.prefix);
    }
}

