/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.egf.model.DepartmentwiseExpenditureReport;
import org.egov.egf.model.DepartmentwiseExpenditureResult;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.DateUtils;
import org.egov.infstr.services.PersistenceService;
import org.egov.utils.Constants;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;

public class DEReportService {
    static final Logger LOGGER = Logger.getLogger(DEReportService.class);
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private FinancialYearHibernateDAO financialYearDAO;
    private PersistenceService persistenceService;

    public Date getPreviousYearFor(Date date) {
        GregorianCalendar previousYearToDate = new GregorianCalendar();
        previousYearToDate.setTime(date);
        int prevYear = previousYearToDate.get(1) - 1;
        previousYearToDate.set(1, prevYear);
        return previousYearToDate.getTime();
    }

    public Integer getNumberOfDays(Date fromDate, Date toDate) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into getNumberOfDays");
        }
        Calendar fromDateCalendar = Calendar.getInstance();
        Calendar toDateCalendar = Calendar.getInstance();
        fromDateCalendar.setTime(fromDate);
        toDateCalendar.setTime(toDate);
        Integer days = 0;
        while (fromDateCalendar.before(toDateCalendar)) {
            fromDateCalendar.add(5, 1);
            Integer n = days;
            Integer n2 = days = Integer.valueOf(days + 1);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("getNumberOfDays - days: " + days + " between " + fromDate + " and " + toDate));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Exiting from getNumberOfDays");
        }
        return days;
    }

    public Date getFinancialYearStartDate(Date date) {
        CFinancialYear cFinancialYear = null;
        Query query = this.persistenceService.getSession().createQuery(" from CFinancialYear cfinancialyear where cfinancialyear.startingDate <=:sDate and cfinancialyear.endingDate >=:eDate");
        query.setDate("sDate", date);
        query.setDate("eDate", date);
        ArrayList list = (ArrayList)query.list();
        if (list.size() > 0) {
            cFinancialYear = (CFinancialYear)list.get(0);
        }
        if (null == cFinancialYear) {
            throw new ApplicationRuntimeException("Financial Year Id does not exist.");
        }
        return cFinancialYear.getStartingDate();
    }

    public boolean validateDateRange(DepartmentwiseExpenditureReport deObject) {
        return this.financialYearDAO.isSameFinancialYear(deObject.getFromDate(), deObject.getToDate());
    }

    public Date getPreviousDateFor(Date date) {
        GregorianCalendar previousDate = new GregorianCalendar();
        previousDate.setTime(date);
        int prevDt = previousDate.get(5) - 1;
        previousDate.set(5, prevDt);
        return previousDate.getTime();
    }

    public Query getConcurrenceDateForPeriod(DepartmentwiseExpenditureReport deObject) {
        StringBuffer stringQry = new StringBuffer();
        String fundcondition = " ";
        String fmDate = "";
        String toDate = "";
        SQLQuery query = null;
        if (!deObject.getFundId().equals("") || deObject.getFundId().equals("0")) {
            fundcondition = " and vh.fundId=" + deObject.getFundId();
        }
        if (deObject.getPeriod().equalsIgnoreCase("current")) {
            fmDate = this.getFormattedDate(deObject.getFromDate());
            toDate = this.getFormattedDate(deObject.getToDate());
        } else if (deObject.getPeriod().equalsIgnoreCase("previous")) {
            fmDate = this.getFormattedDate(this.getPreviousYearFor(deObject.getFromDate()));
            toDate = this.getFormattedDate(this.getPreviousYearFor(deObject.getToDate()));
        }
        if (deObject.getAssetCode() == null || !deObject.getAssetCode().equals("0")) {
            stringQry = stringQry.append(" SELECT dept.dept_name as departmentName,   ROUND(SUM(gl.debitamount)/100000,2) AS concurrenceAmount,    TO_date(ph.concurrenceDate)  as concurrenceDate   FROM voucherheader vh,  generalledger gl, vouchermis mis,  eg_department dept,  paymentheader ph     WHERE vh.id   = gl.voucherheaderid AND vh.id   =mis.voucherheaderid  AND vh.id   = ph.voucherheaderid AND dept.id_dept = mis.departmentid  ").append(" and TO_date(ph.concurrenceDate) >= TO_date('" + fmDate + "','dd-Mon-yyyy') and  TO_date(ph.concurrenceDate)" + "<=TO_date('" + toDate + "','dd-Mon-yyyy') and gl.glcode like '" + deObject.getAssetCode() + "%'").append(fundcondition + " AND vh.status  =0 AND vh.name!='" + "Direct Bank Payment" + "' AND vh.type ='" + "Payment" + "' group by  TO_date(ph.concurrenceDate)" + " order by  TO_date(ph.concurrenceDate) ");
            query = this.persistenceService.getSession().createSQLQuery(stringQry.toString()).addScalar("departmentName").addScalar("concurrenceAmount").addScalar("concurrenceDate");
        } else {
            stringQry = stringQry.append(" SELECT dept.dept_name as departmentName,   ROUND(SUM(gl.debitamount)/100000,2) AS concurrenceAmount,  TO_date(ph.concurrenceDate) as concurrenceDate   FROM voucherheader vh,  generalledger gl,  vouchermis mis,  eg_department dept,  paymentheader ph     WHERE vh.id   = gl.voucherheaderid AND vh.id   =mis.voucherheaderid  AND vh.id   = ph.voucherheaderid AND dept.id_dept = mis.departmentid  ").append(" and TO_date(ph.concurrenceDate) >= TO_date('" + fmDate + "','dd-Mon-yyyy') and  TO_date(ph.concurrenceDate)" + "<=TO_date('" + toDate + "','dd-Mon-yyyy') ").append(fundcondition + " AND vh.status  =0 AND vh.name!='" + "Direct Bank Payment" + "' AND vh.type ='" + "Payment" + "' group by  TO_date(ph.concurrenceDate)" + " order by  TO_date(ph.concurrenceDate) ");
            query = this.persistenceService.getSession().createSQLQuery(stringQry.toString()).addScalar("departmentName").addScalar("concurrenceAmount").addScalar("concurrenceDate");
        }
        return query;
    }

    public List<DepartmentwiseExpenditureReport> getConcurrenceGivenFortheFinancialYearTillGivenDate(DepartmentwiseExpenditureReport deObject) {
        ArrayList<DepartmentwiseExpenditureReport> departmentwiseExpList = new ArrayList<DepartmentwiseExpenditureReport>();
        StringBuffer stringQry = new StringBuffer();
        String fundcondition = "";
        String fmDate = "";
        String toDate = "";
        SQLQuery query = null;
        if (!deObject.getFundId().equals("") || deObject.getFundId().equals("0")) {
            fundcondition = " and vh.fundId=" + deObject.getFundId();
        }
        if (deObject.getPeriod().equalsIgnoreCase("current")) {
            fmDate = this.getFormattedDate(this.getFinancialYearStartDate(deObject.getFromDate()));
            toDate = this.getFormattedDate(deObject.getFromDate());
        } else if (deObject.getPeriod().equalsIgnoreCase("previous")) {
            fmDate = this.getFormattedDate(this.getFinancialYearStartDate(this.getPreviousYearFor(deObject.getFromDate())));
            toDate = this.getFormattedDate(this.getPreviousYearFor(deObject.getFromDate()));
        }
        if (deObject.getAssetCode() == null || !deObject.getAssetCode().equals("0")) {
            stringQry = stringQry.append(" SELECT dept.dept_name as departmentName,   ROUND(SUM(gl.debitamount)/100000,2) AS concurrenceAmount   FROM voucherheader vh,  generalledger gl, vouchermis mis,eg_department dept, paymentheader ph   WHERE vh.id= gl.voucherheaderid   AND vh.id  =mis.voucherheaderid AND vh.id  = ph.voucherheaderid AND dept.id_dept =mis.departmentid ").append(" and TO_date(ph.concurrenceDate) >= TO_date('" + fmDate + "','dd-Mon-yyyy') and  TO_date(ph.concurrenceDate)" + "<TO_date('" + toDate + "','dd-Mon-yyyy') and gl.debitamount!=0  and gl.glcode like '" + deObject.getAssetCode() + "%'").append(fundcondition + " AND vh.status  =0 AND vh.name!='" + "Direct Bank Payment" + "' AND vh.type ='" + "Payment" + "' group by dept.dept_name" + "  order by dept.dept_name ");
            query = this.persistenceService.getSession().createSQLQuery(stringQry.toString()).addScalar("departmentName").addScalar("concurrenceAmount");
        } else {
            stringQry = stringQry.append(" SELECT dept.dept_name as departmentName,   ROUND(SUM(gl.debitamount)/100000,2) AS concurrenceAmount   FROM voucherheader vh,  generalledger gl,  vouchermis mis,eg_department dept,paymentheader ph   WHERE vh.id= gl.voucherheaderid   AND vh.id  =mis.voucherheaderid AND vh.id  = ph.voucherheaderid AND dept.id_dept =mis.departmentid ").append(" and TO_date(ph.concurrenceDate) >= TO_date('" + fmDate + "','dd-Mon-yyyy') and  TO_date(ph.concurrenceDate)" + " <=TO_date('" + toDate + "','dd-Mon-yyyy')").append(fundcondition + " AND vh.status  =0 AND vh.name!='" + "Direct Bank Payment" + "' AND vh.type ='" + "Payment" + "' group by dept.dept_name" + "  order by dept.dept_name ");
            query = this.persistenceService.getSession().createSQLQuery(stringQry.toString()).addScalar("departmentName").addScalar("concurrenceAmount");
        }
        query.setResultTransformer(Transformers.aliasToBean(DepartmentwiseExpenditureReport.class));
        departmentwiseExpList.addAll(query.list());
        return departmentwiseExpList;
    }

    public List<DepartmentwiseExpenditureReport> getConcurrenceGivenForthePeriodQuery(DepartmentwiseExpenditureReport deObject) {
        ArrayList<DepartmentwiseExpenditureReport> deList = new ArrayList<DepartmentwiseExpenditureReport>();
        StringBuffer stringQry = new StringBuffer();
        String fundcondition = " ";
        String fmDate = "";
        String toDate = "";
        SQLQuery query = null;
        if (!deObject.getFundId().equals("") || deObject.getFundId().equals("0")) {
            fundcondition = " and vh.fundId=" + deObject.getFundId();
        }
        if (deObject.getPeriod().equalsIgnoreCase("current")) {
            fmDate = this.getFormattedDate(deObject.getFromDate());
            toDate = this.getFormattedDate(deObject.getToDate());
        } else if (deObject.getPeriod().equalsIgnoreCase("previous")) {
            fmDate = this.getFormattedDate(this.getPreviousYearFor(deObject.getFromDate()));
            toDate = this.getFormattedDate(this.getPreviousYearFor(deObject.getToDate()));
        }
        if (deObject.getAssetCode() == null || !deObject.getAssetCode().equals("0")) {
            stringQry = stringQry.append(" SELECT dept.dept_name as departmentName,  ROUND(SUM(gl.debitamount)/100000,2) AS concurrenceAmount ,  TO_date(ph.concurrenceDate)  as concurrenceDate   FROM voucherheader vh,  generalledger gl, vouchermis mis,  eg_department dept,  paymentheader ph  WHERE vh.id   = gl.voucherheaderid AND vh.id   =mis.voucherheaderid AND vh.id   = ph.voucherheaderid AND dept.id_dept = mis.departmentid  and gl.glcode like '" + deObject.getAssetCode() + "%' and gl.debitamount!=0 ").append(" and TO_date(ph.concurrenceDate) >= TO_date('" + fmDate + "','dd-Mon-yyyy') and  TO_date(ph.concurrenceDate)" + " <=TO_date('" + toDate + "','dd-Mon-yyyy')").append(fundcondition + " AND vh.status  =0 AND vh.name!='" + "Direct Bank Payment" + "' AND vh.type ='" + "Payment" + "' group by dept.dept_name,  TO_date(ph.concurrenceDate)" + " order by  TO_date(ph.concurrenceDate) ");
            query = this.persistenceService.getSession().createSQLQuery(stringQry.toString()).addScalar("departmentName").addScalar("concurrenceAmount").addScalar("concurrenceDate");
            query.setResultTransformer(Transformers.aliasToBean(DepartmentwiseExpenditureReport.class));
        } else {
            stringQry = stringQry.append(" SELECT dept.dept_name as departmentName,  ROUND(SUM(gl.debitamount)/100000,2) AS concurrenceAmount ,  TO_date(ph.concurrenceDate) as concurrenceDate   FROM voucherheader vh,  generalledger gl,  vouchermis mis,  eg_department dept,  paymentheader ph WHERE vh.id   = gl.voucherheaderid AND vh.id   =mis.voucherheaderid  AND vh.id   = ph.voucherheaderid AND dept.id_dept = mis.departmentid  ").append(" and TO_date(ph.concurrenceDate) >= TO_date('" + fmDate + "','dd-Mon-yyyy') and  TO_date(ph.concurrenceDate)" + " <=TO_date('" + toDate + "','dd-Mon-yyyy')").append(fundcondition + " AND vh.status  =0 AND vh.name!='" + "Direct Bank Payment" + "' AND vh.type ='" + "Payment" + "' group by dept.dept_name, TO_date(ph.concurrenceDate)" + " order by  TO_date(ph.concurrenceDate) ");
            query = this.persistenceService.getSession().createSQLQuery(stringQry.toString()).addScalar("departmentName").addScalar("concurrenceAmount").addScalar("concurrenceDate");
            query.setResultTransformer(Transformers.aliasToBean(DepartmentwiseExpenditureReport.class));
        }
        deList.addAll(query.list());
        return deList;
    }

    public void populateDepartment(DepartmentwiseExpenditureReport deptReport) {
        List departmentList = new ArrayList();
        departmentList = deptReport.getPeriod().equalsIgnoreCase("current") ? (DateUtils.compareDates((Date)deptReport.getFinyearObj().getStartingDate(), (Date)deptReport.getRestrictedDepartmentDate()) ? this.persistenceService.findAllBy("from Department where deptCode not like 'F%' order by deptName  ", new Object[0]) : this.persistenceService.findAllBy("from Department order by deptName  ", new Object[0])) : (DateUtils.compareDates((Date)this.getPreviousYearFor(deptReport.getFinyearObj().getStartingDate()), (Date)deptReport.getRestrictedDepartmentDate()) ? this.persistenceService.findAllBy("from Department where deptCode not like 'F%' order by deptName  ", new Object[0]) : this.persistenceService.findAllBy("from Department order by deptName  ", new Object[0]));
        int index = 0;
        for (Department dept : departmentList) {
            deptReport.addDepartmentToResultSet(new DepartmentwiseExpenditureResult(dept.getName(), BigDecimal.ZERO, ++index, Boolean.TRUE));
        }
    }

    public Query getConcurrenceDaywiseTotalQuery(DepartmentwiseExpenditureReport deObject) {
        StringBuffer stringQry = new StringBuffer();
        String fundcondition = " ";
        String fmDate = "";
        String toDate = "";
        if (deObject.getPeriod().equalsIgnoreCase("current")) {
            fmDate = this.getFormattedDate(deObject.getFromDate());
            toDate = this.getFormattedDate(deObject.getToDate());
        } else if (deObject.getPeriod().equalsIgnoreCase("previous")) {
            fmDate = this.getFormattedDate(this.getPreviousYearFor(deObject.getFromDate()));
            toDate = this.getFormattedDate(this.getPreviousYearFor(deObject.getToDate()));
        }
        if (!deObject.getFundId().equals("") || deObject.getFundId().equals("0")) {
            fundcondition = " and vh.fundId=" + deObject.getFundId();
        }
        stringQry = deObject.getAssetCode() == null || !deObject.getAssetCode().equals("0") ? stringQry.append(" SELECT dept.dept_name as departmentName,  SUM(gl.debitamount) AS concurrenceAmount   FROM voucherheader vh,  generalledger gl,  vouchermis mis,eg_department dept,paymentheader ph   WHERE vh.id= gl.voucherheaderid  AND vh.id  =mis.voucherheaderid AND vh.id  = ph.voucherheaderid AND dept.id_dept =mis.departmentid ").append(" and TO_date(ph.concurrenceDate) >= TO_date('" + fmDate + "','dd-Mon-yyyy') and  TO_date(ph.concurrenceDate)" + " <=TO_date('" + toDate + "','dd-Mon-yyyy')").append(" and gl.glcode like '" + deObject.getAssetCode() + "%' and gl.debitamount!=0").append(fundcondition + " AND vh.status  =0 AND vh.name!='" + "Direct Bank Payment" + "' AND vh.type ='" + "Payment" + "' group by dept.dept_name" + " order by dept.dept_name") : stringQry.append(" SELECT dept.dept_name as departmentName,  SUM(gl.debitamount)  AS concurrenceAmount   FROM voucherheader vh,  generalledger gl,  vouchermis mis,eg_department dept,paymentheader ph   WHERE vh.id= gl.voucherheaderid  AND vh.id  =mis.voucherheaderid AND vh.id  = ph.voucherheaderid AND dept.id_dept =mis.departmentid ").append(" and TO_date(ph.concurrenceDate) >= TO_date('" + fmDate + "','dd-Mon-yyyy') and  TO_date(ph.concurrenceDate)" + " <=TO_date('" + toDate + "','dd-Mon-yyyy')").append(fundcondition + " AND vh.status  =0 AND vh.name!='" + "Direct Bank Payment" + "' AND vh.type ='" + "Payment" + "' group by dept.dept_name" + " order by dept.dept_name");
        SQLQuery query = this.persistenceService.getSession().createSQLQuery(stringQry.toString()).addScalar("departmentName").addScalar("concurrenceAmount");
        return query;
    }

    public List<DepartmentwiseExpenditureReport> getConcurrenceReportDateWise() {
        ArrayList<DepartmentwiseExpenditureReport> deptReport = new ArrayList<DepartmentwiseExpenditureReport>();
        return deptReport;
    }

    public Date getStartDayOfMonth(DepartmentwiseExpenditureReport deObject) {
        String yearStr = "";
        Calendar calendar = Calendar.getInstance();
        yearStr = deObject.getMonth().equals("01") || deObject.getMonth().equals("02") || deObject.getMonth().equals("03") ? deObject.getFinyearObj().getEndingDate().toString().substring(0, 4) : deObject.getFinyearObj().getStartingDate().toString().substring(0, 4);
        calendar.set(1, Integer.parseInt(yearStr));
        calendar.set(2, Integer.parseInt(deObject.getMonth()) - 1);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public Date getLastDayOfMonth(DepartmentwiseExpenditureReport deObject) {
        String yearStr = "";
        Calendar calendar = Calendar.getInstance();
        yearStr = deObject.getMonth().equals("01") || deObject.getMonth().equals("02") || deObject.getMonth().equals("03") ? deObject.getFinyearObj().getEndingDate().toString().substring(0, 4) : deObject.getFinyearObj().getStartingDate().toString().substring(0, 4);
        int mapLastDay = 0;
        int month = Integer.parseInt(deObject.getMonth());
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                mapLastDay = 31;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                mapLastDay = 30;
                break;
            }
            case 2: {
                mapLastDay = 0 == Integer.parseInt(yearStr) % 4 && 0 != Integer.parseInt(yearStr) % 100 || 0 == Integer.parseInt(yearStr) % 400 ? 29 : 28;
            }
        }
        calendar.set(1, Integer.parseInt(yearStr));
        calendar.set(2, Integer.parseInt(deObject.getMonth()) - 1);
        calendar.set(5, mapLastDay);
        return calendar.getTime();
    }

    public String getFormattedDate(Date date) {
        return Constants.DDMMYYYYFORMAT1.format(date);
    }

    public FinancialYearHibernateDAO getFinancialYearDAO() {
        return this.financialYearDAO;
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setFinancialYearDAO(FinancialYearHibernateDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }
}

