/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.contra;

import com.exilant.GLEngine.Transaxtion;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.commons.Bankaccount;
import org.egov.commons.Bankreconciliation;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.BankaccountDAO;
import org.egov.commons.dao.ChartOfAccountsDAO;
import org.egov.egf.commons.EgovCommon;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.contra.ContraBean;
import org.egov.model.contra.ContraJournalVoucher;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.model.instrument.InstrumentOtherDetails;
import org.egov.model.instrument.InstrumentVoucher;
import org.egov.model.voucher.PayInBean;
import org.egov.pims.commons.Position;
import org.egov.pims.service.EmployeeServiceOld;
import org.egov.services.instrument.BankReconciliationService;
import org.egov.services.instrument.InstrumentService;
import org.egov.services.voucher.ContraJournalVoucherService;
import org.egov.utils.Constants;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

public class ContraService
extends PersistenceService<ContraJournalVoucher, Long> {
    private static final Logger LOGGER = Logger.getLogger(ContraService.class);
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    @Qualifier(value="contraJournalVoucherService")
    private ContraJournalVoucherService contraJournalVoucherService;
    @Autowired
    @Qualifier(value="bankReconciliationService")
    private BankReconciliationService bankReconciliationService;
    @Autowired
    private ChartOfAccountsDAO coaDAO;
    @Autowired
    private BankaccountDAO bankAccountDAO;
    private InstrumentService instrumentService;
    private static SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy", Locale.ENGLISH);
    @Autowired
    protected EisCommonService eisCommonService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    private EmployeeServiceOld employeeServiceOld;
    private int preapprovalStatus = 0;
    @Autowired
    private EgovCommon egovCommon;

    public ContraService() {
        super(ContraJournalVoucher.class);
    }

    public ContraService(Class<ContraJournalVoucher> type) {
        super(type);
    }

    public Position getPositionForWfItem(ContraJournalVoucher rv) {
        return this.eisCommonService.getPositionByUserId(rv.getCreatedBy().getId());
    }

    public Department getDepartmentForUser(User user) {
        return this.egovCommon.getDepartmentForUser(user, this.eisCommonService, this.employeeServiceOld, this.persistenceService);
    }

    public ContraJournalVoucher updateIntoContraJournal(CVoucherHeader voucherHeader, ContraBean contraBean) {
        ContraJournalVoucher existingCJV;
        try {
            existingCJV = (ContraJournalVoucher)((Object)this.contraJournalVoucherService.find("from ContraJournalVoucher where voucherHeaderId=?", new Object[]{voucherHeader}));
            existingCJV.setToBankAccountId(this.bankAccountDAO.getBankaccountById(Integer.valueOf(contraBean.getAccountNumberId()).intValue()));
            this.contraJournalVoucherService.update((Object)existingCJV);
        }
        catch (HibernateException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Exception occuerd while postiong into contractorJournal");
            }
            throw new HibernateException((Throwable)e);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Exception occuerd while postiong into contractorJournal");
            }
            throw new HibernateException((Throwable)e);
        }
        return existingCJV;
    }

    public Bankreconciliation updateBankreconciliation(InstrumentHeader instrHeader, ContraBean contraBean) {
        Bankreconciliation existingBR;
        try {
            Long iHeaderId = instrHeader.getId();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("instrHeader.getId() = " + iHeaderId));
            }
            existingBR = (Bankreconciliation)this.bankReconciliationService.find("from Bankreconciliation where instrumentHeaderId=?", new Object[]{iHeaderId});
            existingBR.setAmount(contraBean.getAmount());
            existingBR.setBankaccount(this.bankAccountDAO.getBankaccountById(Integer.valueOf(contraBean.getAccountNumberId()).intValue()));
            this.bankReconciliationService.update(existingBR);
        }
        catch (HibernateException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Exception occuerd while updateBankreconciliation" + (Object)((Object)e)));
            }
            throw new HibernateException((Throwable)e);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Exception occuerd while updateBankreconciliation" + e));
            }
            throw new HibernateException((Throwable)e);
        }
        return existingBR;
    }

    public List<Transaxtion> postInTransaction(CVoucherHeader voucherHeader, ContraBean contraBean) {
        ArrayList<Transaxtion> transaxtionList = new ArrayList<Transaxtion>();
        Transaxtion transactionBank = new Transaxtion();
        CChartOfAccounts bankAccountCode = this.bankAccountDAO.getBankaccountById(Integer.valueOf(contraBean.getAccountNumberId()).intValue()).getChartofaccounts();
        transactionBank.setVoucherLineId("1");
        transactionBank.setGlCode(bankAccountCode.getGlcode());
        transactionBank.setGlName(bankAccountCode.getName());
        transactionBank.setVoucherHeaderId(voucherHeader.getId().toString());
        transactionBank.setDrAmount(contraBean.getAmount().toString());
        transactionBank.setCrAmount("0");
        Transaxtion transactionCash = new Transaxtion();
        CChartOfAccounts cashAccountCode = this.coaDAO.getCChartOfAccountsByGlCode(contraBean.getCashInHand());
        transactionCash.setVoucherLineId("2");
        transactionCash.setGlCode(cashAccountCode.getGlcode());
        transactionCash.setGlName(cashAccountCode.getName());
        transactionCash.setVoucherHeaderId(voucherHeader.getId().toString());
        transactionCash.setDrAmount("0");
        transactionCash.setCrAmount(contraBean.getAmount().toString());
        transaxtionList.add(transactionBank);
        transaxtionList.add(transactionCash);
        return transaxtionList;
    }

    public Map<String, Object> getCTBVoucher(String voucherId, ContraBean contraBean) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"ContraService | getCTBVoucher | Start");
        }
        HashMap<String, Object> voucherMap = new HashMap<String, Object>();
        CVoucherHeader voucherHeader = (CVoucherHeader)this.persistenceService.find("from CVoucherHeader where id=?", new Object[]{Long.valueOf(voucherId)});
        voucherMap.put("voucherHeader", voucherHeader);
        InstrumentVoucher iVoucher = (InstrumentVoucher)((Object)this.persistenceService.find("from InstrumentVoucher where voucherHeaderId=?", new Object[]{voucherHeader}));
        Bankaccount bankAccount = iVoucher.getInstrumentHeaderId().getBankAccountId();
        contraBean.setAccountNumberId(bankAccount.getId().toString());
        contraBean.setAccnumnar(bankAccount.getNarration());
        contraBean.setBankBranchId(bankAccount.getBankbranch().getBank().getId() + "-" + bankAccount.getBankbranch().getId().toString());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Cash amount = " + iVoucher.getInstrumentHeaderId().getInstrumentAmount()));
        }
        contraBean.setAmount(iVoucher.getInstrumentHeaderId().getInstrumentAmount());
        contraBean.setChequeNumber(iVoucher.getInstrumentHeaderId().getTransactionNumber());
        if (iVoucher.getInstrumentHeaderId().getTransactionDate() != null) {
            contraBean.setChequeDate(Constants.DDMMYYYYFORMAT2.format(iVoucher.getInstrumentHeaderId().getTransactionDate()));
        }
        voucherMap.put("contrabean", contraBean);
        return voucherMap;
    }

    public Map<String, Object> getpayInSlipVoucher(Long voucherId, ContraBean contraBean, List<PayInBean> iHeaderList) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"ContraService | getpayInSlipVoucher | Start");
        }
        SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
        HashMap<String, Object> voucherMap = new HashMap<String, Object>();
        iHeaderList = new ArrayList<PayInBean>();
        CVoucherHeader voucherHeader = (CVoucherHeader)this.persistenceService.find("from CVoucherHeader where id=?", new Object[]{voucherId});
        voucherMap.put("voucherHeader", voucherHeader);
        List iOther = this.persistenceService.findAllBy("from InstrumentOtherDetails where payinslipId=?", new Object[]{voucherHeader});
        Bankaccount bankAccount = ((InstrumentOtherDetails)((Object)iOther.get(0))).getInstrumentHeaderId().getBankAccountId();
        contraBean.setAccountNumberId(bankAccount.getId().toString());
        contraBean.setAccnumnar(bankAccount.getNarration());
        contraBean.setBankBranchId(bankAccount.getBankbranch().getBank().getId() + "-" + bankAccount.getBankbranch().getId().toString());
        voucherMap.put("contraBean", contraBean);
        BigDecimal totalInstrAmt = BigDecimal.ZERO;
        for (InstrumentOtherDetails instrumentOtherDetails : iOther) {
            InstrumentHeader iHeader = instrumentOtherDetails.getInstrumentHeaderId();
            int index = 0;
            PayInBean payInBean = new PayInBean();
            payInBean.setInstId(Long.valueOf(iHeader.getId().toString()));
            payInBean.setInstrumentNumber(iHeader.getInstrumentNumber());
            try {
                payInBean.setInstrumentDate(formatter.format(formatter1.parse(iHeader.getInstrumentDate().toString())));
                InstrumentVoucher iVoucher = (InstrumentVoucher)((Object)this.persistenceService.find("from InstrumentVoucher where instrumentHeaderId=?", new Object[]{iHeader}));
                payInBean.setVoucherDate(formatter.format(formatter1.parse(iVoucher.getVoucherHeaderId().getVoucherDate().toString())));
            }
            catch (ParseException e) {
                LOGGER.error((Object)("Exception Occured while Parsing instrument date" + e.getMessage()));
            }
            payInBean.setInstrumentAmount(iHeader.getInstrumentAmount().toString());
            payInBean.setVoucherNumber(instrumentOtherDetails.getPayinslipId().getVoucherNumber());
            payInBean.setSelectChq(true);
            payInBean.setSerialNo(++index);
            iHeaderList.add(payInBean);
            totalInstrAmt = totalInstrAmt.add(iHeader.getInstrumentAmount());
        }
        voucherMap.put("iHeaderList", iHeaderList);
        voucherMap.put("totalInstrAmt", totalInstrAmt.toString());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"ContraService | getpayInSlipVoucher | End");
        }
        return voucherMap;
    }

    public void updateCheque_DD_Card_Deposit(Long payInId, String toBankaccountGlcode, InstrumentHeader instrumentHeader, Map valuesMap) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)" updateCheque_DD_Card_Deposit | Start");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(" updateCheque_DD_Card_Deposit for" + (Object)((Object)instrumentHeader) + "and payin id" + payInId));
        }
        CVoucherHeader payIn = (CVoucherHeader)this.persistenceService.find("from CVoucherHeader where id=?", new Object[]{payInId});
        this.updateInstrumentAndPayin(payIn, (Bankaccount)valuesMap.get("depositedBankAccount"), instrumentHeader, (EgwStatus)this.persistenceService.find("from EgwStatus where id = ?", new Object[]{Integer.valueOf(valuesMap.get("instrumentDepositedStatus").toString())}));
        ContraJournalVoucher cjv = this.addToContra(payIn, (Bankaccount)valuesMap.get("depositedBankAccount"), instrumentHeader);
        this.addToBankRecon(payIn, instrumentHeader, (EgwStatus)this.persistenceService.find("from EgwStatus where id = ?", new Object[]{Integer.valueOf(valuesMap.get("instrumentReconciledStatus").toString())}));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)" updateCheque_DD_Card_Deposit | End");
        }
    }

    public Map prepareForUpdateInstrumentDeposit(String toBankaccountGlcode) {
        HashMap<String, Integer> valuesMap = new HashMap<String, Integer>();
        List configValuesByModuleAndKey = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "PREAPPROVEDVOUCHERSTATUS");
        this.preapprovalStatus = Integer.valueOf(((AppConfigValues)configValuesByModuleAndKey.get(0)).getValue());
        EgwStatus instrumentDepositedStatus = (EgwStatus)this.persistenceService.find("from EgwStatus where upper(moduletype)=upper('Instrument') and upper(description)=upper(?)", new Object[]{"Deposited"});
        EgwStatus instrumentReconciledStatus = (EgwStatus)this.persistenceService.find("from EgwStatus where upper(moduletype)=upper('Instrument') and upper(description)=upper(?)", new Object[]{"Reconciled"});
        Bankaccount depositedBankAccount = (Bankaccount)this.persistenceService.find("from Bankaccount where chartofaccounts.glcode=?", new Object[]{toBankaccountGlcode});
        valuesMap.put("preapprovalStatus", this.preapprovalStatus);
        valuesMap.put("instrumentDepositedStatus", (Integer)instrumentDepositedStatus);
        valuesMap.put("instrumentReconciledStatus", (Integer)instrumentReconciledStatus);
        valuesMap.put("depositedBankAccount", (Integer)depositedBankAccount);
        return valuesMap;
    }

    @Transactional
    public void updateCheque_DD_Card_Deposit_Receipt(Long receiptId, String toBankaccountGlcode, InstrumentHeader instrumentHeader, Map valuesMap) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)" updateCheque_DD_Card_Deposit_Receipt | Start");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(" updateCheque_DD_Card_Deposit_Receipt for" + (Object)((Object)instrumentHeader) + "and receiptId" + receiptId));
        }
        CVoucherHeader payIn = (CVoucherHeader)this.persistenceService.find("from CVoucherHeader where id=?", new Object[]{receiptId});
        this.updateInstrumentAndPayin(payIn, (Bankaccount)valuesMap.get("depositedBankAccount"), instrumentHeader, (EgwStatus)valuesMap.get("instrumentDepositedStatus"));
        this.addToBankRecon(payIn, instrumentHeader, (EgwStatus)valuesMap.get("instrumentReconciledStatus"));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)" updateCheque_DD_Card_Deposit_Receipt | End");
        }
    }

    @Transactional
    public void updateCashDeposit(Long payInId, String toBankaccountGlcode, InstrumentHeader instrumentHeader, Map valuesMap) {
        List appConfigList;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Contra Service | updateCashDeposit | Start");
        }
        if (null != (appConfigList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "PREAPPROVEDVOUCHERSTATUS")) && !appConfigList.isEmpty()) {
            for (AppConfigValues appConfigVal : appConfigList) {
                this.preapprovalStatus = Integer.valueOf(appConfigVal.getValue());
            }
        } else {
            throw new ApplicationRuntimeException("Appconfig value for PREAPPROVEDVOUCHERSTATUS is not defined in the system");
        }
        CVoucherHeader payIn = (CVoucherHeader)this.persistenceService.find("from CVoucherHeader where id=?", new Object[]{payInId});
        this.updateInstrumentAndPayin(payIn, (Bankaccount)valuesMap.get("depositedBankAccount"), instrumentHeader, (EgwStatus)this.persistenceService.find("from EgwStatus where id = ?", new Object[]{Integer.valueOf(valuesMap.get("instrumentReconciledStatus").toString())}));
        ContraJournalVoucher cjv = this.addToContra(payIn, (Bankaccount)valuesMap.get("depositedBankAccount"), instrumentHeader);
        this.addToBankRecon(payIn, instrumentHeader, (EgwStatus)this.persistenceService.find("from EgwStatus where id = ?", new Object[]{Integer.valueOf(valuesMap.get("instrumentReconciledStatus").toString())}));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Contra Service | updateCashDeposit | End");
        }
    }

    public void createVoucherfromPreApprovedVoucher(ContraJournalVoucher cjv) {
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "APPROVEDVOUCHERSTATUS");
        String approvedVoucherStatus = ((AppConfigValues)appList.get(0)).getValue();
        cjv.getVoucherHeaderId().setStatus(Integer.valueOf(approvedVoucherStatus));
    }

    public void cancelVoucher(ContraJournalVoucher cjv) {
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "cancelledstatus");
        String approvedVoucherStatus = ((AppConfigValues)appList.get(0)).getValue();
        cjv.getVoucherHeaderId().setStatus(Integer.valueOf(approvedVoucherStatus));
    }

    public String getDesginationName() {
        Assignment assignment = this.eisCommonService.getLatestAssignmentForEmployeeByToDate(ApplicationThreadLocals.getUserId(), new Date());
        return assignment.getDesignation().getName();
    }

    public Department getDepartmentForWfItem(ContraJournalVoucher cjv) {
        Assignment assignment = this.eisCommonService.getLatestAssignmentForEmployeeByToDate(cjv.getCreatedBy().getId(), new Date());
        return assignment.getDepartment();
    }

    public Boundary getBoundaryForUser(ContraJournalVoucher rv) {
        return this.egovCommon.getBoundaryForUser(rv.getCreatedBy());
    }

    public Position getPositionForEmployee(Employee emp) throws ApplicationRuntimeException {
        return this.eisCommonService.getPrimaryAssignmentPositionForEmp(emp.getId());
    }

    @Transactional
    public void addToBankRecon(CVoucherHeader payIn, InstrumentHeader instrumentHeader, EgwStatus instrumentReconciledStatus) {
        this.instrumentService.addToBankReconcilationWithLoop(payIn, instrumentHeader, instrumentReconciledStatus);
    }

    @Transactional
    public ContraJournalVoucher addToContra(CVoucherHeader payIn, Bankaccount depositedBank, InstrumentHeader instrumentHeader) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Adding to contra");
        }
        ContraJournalVoucher cjv = new ContraJournalVoucher();
        cjv.setToBankAccountId(depositedBank);
        cjv.setInstrumentHeaderId(instrumentHeader);
        cjv.setVoucherHeaderId(payIn);
        this.contraJournalVoucherService.applyAuditing((AbstractAuditable)cjv);
        this.contraJournalVoucherService.persist((Object)cjv);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Adding to contra completed");
        }
        return cjv;
    }

    @Transactional
    private void updateInstrumentAndPayin(CVoucherHeader payIn, Bankaccount account, InstrumentHeader instrumentHeader, EgwStatus status) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"updateInstrumentAndPayin | Start");
        }
        HashMap<String, Object> iMap = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> iList = new ArrayList<Map<String, Object>>();
        iMap.put("Instrument header", (Object)instrumentHeader);
        iMap.put("Payin slip id", payIn);
        iMap.put("Instrument status date", payIn.getVoucherDate());
        iMap.put("Status id", status);
        iMap.put("Bank account id", account);
        iList.add(iMap);
        this.instrumentService.updateInstrumentOtherDetails(iList);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"updateInstrumentAndPayin | End");
        }
    }

    public Map prepareForUpdateInstrumentDepositSQL() {
        HashMap<String, Number> valuesMap = new HashMap<String, Number>();
        List configValuesByModuleAndKey = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "PREAPPROVEDVOUCHERSTATUS");
        this.preapprovalStatus = Integer.valueOf(((AppConfigValues)configValuesByModuleAndKey.get(0)).getValue());
        Integer instrumentDepositedStatusId = (Integer)this.persistenceService.find("select id from EgwStatus where upper(moduletype)=upper('Instrument') and upper(description)=upper(?)", new Object[]{"Deposited"});
        Integer instrumentReconciledStatusId = (Integer)this.persistenceService.find("select id from EgwStatus where upper(moduletype)=upper('Instrument') and upper(description)=upper(?)", new Object[]{"Reconciled"});
        valuesMap.put("preapprovalStatus", this.preapprovalStatus);
        valuesMap.put("instrumentDepositedStatus", instrumentDepositedStatusId.longValue());
        valuesMap.put("instrumentReconciledStatus", instrumentReconciledStatusId.longValue());
        return valuesMap;
    }

    public void updateCheque_DD_Card_Deposit_Receipt(Map instrumentDetailsMap) {
        this.updateInstrumentAndPayinSql(instrumentDetailsMap);
        this.addToBankReconcilationSQL(instrumentDetailsMap);
    }

    public void updateCheque_DD_Card_Deposit(Map instrumentDetailsMap) {
        this.updateInstrumentAndPayinSql(instrumentDetailsMap);
        this.addToBankReconcilationSQL(instrumentDetailsMap);
        this.addToContraSql(instrumentDetailsMap);
    }

    public void updateCheque_DD_Card_Deposit(Map instrumentDetailsMap, CVoucherHeader cVoucherHeader, InstrumentHeader instrumentHeader, Bankaccount bankaccount) {
        this.updateInstrumentAndPayinSql(instrumentDetailsMap);
        this.addToBankReconcilationSQL(instrumentDetailsMap);
        this.addToContraJournal(cVoucherHeader, instrumentHeader, bankaccount);
    }

    public void updateCashDeposit(Map instrumentDetailsMap) {
        this.updateInstrumentAndPayinSql(instrumentDetailsMap);
        this.addToBankReconcilationSQL(instrumentDetailsMap);
        this.addToContraSql(instrumentDetailsMap);
    }

    @Transactional
    public void updateCashDeposit(Map instrumentDetailsMap, CVoucherHeader cVoucherHeader, InstrumentHeader instrumentHeader, Bankaccount bankaccount) {
        this.updateInstrumentAndPayinSql(instrumentDetailsMap);
        this.addToBankReconcilationSQL(instrumentDetailsMap);
        this.addToContraJournal(cVoucherHeader, instrumentHeader, bankaccount);
    }

    private void updateInstrumentAndPayinSql(Map instrumentDetailsMap) {
        String ioSql = "update EGF_INSTRUMENTOTHERDETAILS set PAYINSLIPID=:payinId,INSTRUMENTSTATUSDATE=:ihStatusDate, LASTMODIFIEDBY=:modifiedBy, LASTMODIFIEDDATE =:modifiedDate where INSTRUMENTHEADERID=:ihId";
        SQLQuery ioSQLQuery = this.getSession().createSQLQuery("update EGF_INSTRUMENTOTHERDETAILS set PAYINSLIPID=:payinId,INSTRUMENTSTATUSDATE=:ihStatusDate, LASTMODIFIEDBY=:modifiedBy, LASTMODIFIEDDATE =:modifiedDate where INSTRUMENTHEADERID=:ihId");
        ioSQLQuery.setLong("payinId", ((Long)instrumentDetailsMap.get("payinid")).longValue()).setLong("ihId", ((Long)instrumentDetailsMap.get("instrumentheader")).longValue()).setDate("ihStatusDate", (Date)instrumentDetailsMap.get("depositdate")).setDate("modifiedDate", new Date()).setLong("modifiedBy", ((Long)instrumentDetailsMap.get("createdby")).longValue());
        ioSQLQuery.executeUpdate();
        String ihSql = "update EGF_instrumentheader  set ID_STATUS=:statusId,BANKACCOUNTID=:bankAccId,LASTMODIFIEDBY=:modifiedBy, LASTMODIFIEDDATE =:modifiedDate where id=:ihId";
        SQLQuery ihSQLQuery = this.getSession().createSQLQuery("update EGF_instrumentheader  set ID_STATUS=:statusId,BANKACCOUNTID=:bankAccId,LASTMODIFIEDBY=:modifiedBy, LASTMODIFIEDDATE =:modifiedDate where id=:ihId");
        ihSQLQuery.setLong("statusId", ((Long)instrumentDetailsMap.get("instrumentDepositedStatus")).longValue()).setLong("ihId", ((Long)instrumentDetailsMap.get("instrumentheader")).longValue()).setLong("bankAccId", ((Long)instrumentDetailsMap.get("bankaccountid")).longValue()).setDate("modifiedDate", new Date()).setLong("modifiedBy", ((Long)instrumentDetailsMap.get("createdby")).longValue());
        ihSQLQuery.executeUpdate();
    }

    public void addToBankReconcilationSQL(Map instrumentDetailsMap) throws ApplicationRuntimeException {
        String brsSql = "Insert into bankreconciliation (ID,BANKACCOUNTID,AMOUNT,TRANSACTIONTYPE,INSTRUMENTHEADERID) values  (nextVal('seq_bankreconciliation'),:bankAccId,:amount,:trType,:ihId)";
        SQLQuery brsSQLQuery = this.getSession().createSQLQuery("Insert into bankreconciliation (ID,BANKACCOUNTID,AMOUNT,TRANSACTIONTYPE,INSTRUMENTHEADERID) values  (nextVal('seq_bankreconciliation'),:bankAccId,:amount,:trType,:ihId)");
        brsSQLQuery.setLong("bankAccId", ((Long)instrumentDetailsMap.get("bankaccountid")).longValue()).setBigDecimal("amount", (BigDecimal)instrumentDetailsMap.get("instrumentamount")).setString("trType", "1".equalsIgnoreCase((String)instrumentDetailsMap.get("ispaycheque")) ? "Cr" : "Dr").setLong("ihId", ((Long)instrumentDetailsMap.get("instrumentheader")).longValue());
        brsSQLQuery.executeUpdate();
        if ("cash".equalsIgnoreCase((String)instrumentDetailsMap.get("instrumenttype")) || "bankchallan".equalsIgnoreCase((String)instrumentDetailsMap.get("instrumenttype")) || "banktobank".equalsIgnoreCase((String)instrumentDetailsMap.get("instrumenttype")) || "ecs".equalsIgnoreCase((String)instrumentDetailsMap.get("instrumenttype"))) {
            String ioSql = "update EGF_instrumentOtherdetails set reconciledamount=:reconciledAmt,INSTRUMENTSTATUSDATE=:ihStatusDate,LASTMODIFIEDBY=:modifiedBy, LASTMODIFIEDDATE =:modifiedDate where INSTRUMENTHEADERID=:ihId";
            SQLQuery ioSQLQuery = this.getSession().createSQLQuery("update EGF_instrumentOtherdetails set reconciledamount=:reconciledAmt,INSTRUMENTSTATUSDATE=:ihStatusDate,LASTMODIFIEDBY=:modifiedBy, LASTMODIFIEDDATE =:modifiedDate where INSTRUMENTHEADERID=:ihId");
            ioSQLQuery.setLong("ihId", ((Long)instrumentDetailsMap.get("instrumentheader")).longValue()).setBigDecimal("reconciledAmt", (BigDecimal)instrumentDetailsMap.get("instrumentamount")).setDate("ihStatusDate", (Date)instrumentDetailsMap.get("depositdate")).setDate("modifiedDate", new Date()).setLong("modifiedBy", ((Long)instrumentDetailsMap.get("createdby")).longValue());
            ioSQLQuery.executeUpdate();
            String ihSql = "update EGF_instrumentheader  set ID_STATUS=:statusId,LASTMODIFIEDBY=:modifiedBy, LASTMODIFIEDDATE =:modifiedDate where id=:ihId";
            SQLQuery ihSQLQuery = this.getSession().createSQLQuery("update EGF_instrumentheader  set ID_STATUS=:statusId,LASTMODIFIEDBY=:modifiedBy, LASTMODIFIEDDATE =:modifiedDate where id=:ihId");
            ihSQLQuery.setLong("statusId", ((Long)instrumentDetailsMap.get("instrumentReconciledStatus")).longValue()).setLong("ihId", ((Long)instrumentDetailsMap.get("instrumentheader")).longValue()).setDate("modifiedDate", new Date()).setLong("modifiedBy", ((Long)instrumentDetailsMap.get("createdby")).longValue());
            ihSQLQuery.executeUpdate();
        }
    }

    private void addToContraSql(Map instrumentDetailsMap) {
        String ioSql = "Insert into contrajournalvoucher (ID,VOUCHERHEADERID,FROMBANKACCOUNTID,TOBANKACCOUNTID,INSTRUMENTHEADERID ,STATE_ID,CREATEDBY,LASTMODIFIEDBY) values  (nextVal('seq_contrajournalvoucher'),:vhId,null,:depositedBankId,:ihId,null,:createdBy,:createdBy)";
        SQLQuery ioSQLQuery = this.getSession().createSQLQuery("Insert into contrajournalvoucher (ID,VOUCHERHEADERID,FROMBANKACCOUNTID,TOBANKACCOUNTID,INSTRUMENTHEADERID ,STATE_ID,CREATEDBY,LASTMODIFIEDBY) values  (nextVal('seq_contrajournalvoucher'),:vhId,null,:depositedBankId,:ihId,null,:createdBy,:createdBy)");
        ioSQLQuery.setLong("vhId", ((Long)instrumentDetailsMap.get("payinid")).longValue()).setLong("ihId", ((Long)instrumentDetailsMap.get("instrumentheader")).longValue()).setLong("depositedBankId", ((Long)instrumentDetailsMap.get("bankaccountid")).longValue()).setLong("createdBy", ((Long)instrumentDetailsMap.get("createdby")).longValue());
        ioSQLQuery.executeUpdate();
    }

    @Transactional
    public void addToContraJournal(CVoucherHeader cVoucherHeader, InstrumentHeader instrumentHeader, Bankaccount bankaccount) {
        ContraJournalVoucher contraJournalVoucher = new ContraJournalVoucher();
        contraJournalVoucher.setVoucherHeaderId(cVoucherHeader);
        contraJournalVoucher.setInstrumentHeaderId(instrumentHeader);
        contraJournalVoucher.setToBankAccountId(bankaccount);
        this.persistenceService.persist((Object)contraJournalVoucher);
    }

    public void editInstruments(Long voucherId) {
        List iOtherdetails = this.persistenceService.findAllBy("from InstrumentOtherDetails  io where payinslipId.id=?", new Object[]{voucherId});
        for (InstrumentOtherDetails instrumentOtherDetails : iOtherdetails) {
            this.instrumentService.editInstruments(instrumentOtherDetails);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("Modifying " + (Object)((Object)instrumentOtherDetails)));
        }
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public InstrumentService getInstrumentService() {
        return this.instrumentService;
    }

    public void setInstrumentService(InstrumentService instrumentService) {
        this.instrumentService = instrumentService;
    }

    public void setEmployeeServiceOld(EmployeeServiceOld employeeServiceOld) {
        this.employeeServiceOld = employeeServiceOld;
    }
}

