/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.budget;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import org.apache.log4j.Logger;
import org.egov.commons.CFinancialYear;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.dao.budget.BudgetDetailsHibernateDAO;
import org.egov.egf.autonumber.BudgetReAppropriationSequenceNumberGenerator;
import org.egov.egf.model.BudgetReAppropriationView;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.service.WorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.budget.Budget;
import org.egov.model.budget.BudgetDetail;
import org.egov.model.budget.BudgetReAppropriation;
import org.egov.model.budget.BudgetReAppropriationMisc;
import org.egov.pims.commons.Position;
import org.egov.services.budget.BudgetDetailService;
import org.egov.services.budget.BudgetReAppropriationMiscService;
import org.egov.utils.BudgetDetailConfig;
import org.egov.utils.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

public class BudgetReAppropriationService
extends PersistenceService<BudgetReAppropriation, Long> {
    private static final Logger LOGGER = Logger.getLogger(BudgetReAppropriationService.class);
    WorkflowService<BudgetReAppropriationMisc> miscWorkflowService;
    @Autowired
    @Qualifier(value="budgetDetailService")
    private BudgetDetailService budgetDetailService;
    protected WorkflowService<BudgetDetail> budgetDetailWorkflowService;
    @Autowired
    private BudgetDetailConfig budgetDetailConfig;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private ApplicationSequenceNumberGenerator sequenceGenerator;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private BudgetDetailsHibernateDAO budgetDetailsDAO;
    @Autowired
    protected ScriptService scriptService;
    @Autowired
    @Qualifier(value="budgetReAppropriationMiscService")
    private BudgetReAppropriationMiscService budgetReAppropriationMiscService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusDAO;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;

    public BudgetReAppropriationService() {
        super(BudgetReAppropriation.class);
    }

    public BudgetReAppropriationService(Class<BudgetReAppropriation> type) {
        super(type);
    }

    public ApplicationSequenceNumberGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    public void setSequenceGenerator(ApplicationSequenceNumberGenerator sequenceGenerator) {
        this.sequenceGenerator = sequenceGenerator;
    }

    public void setBudgetDetailWorkflowService(WorkflowService<BudgetDetail> budgetDetailWorkflowService) {
        this.budgetDetailWorkflowService = budgetDetailWorkflowService;
    }

    public void setBudgetDetailService(BudgetDetailService budgetDetailService) {
        this.budgetDetailService = budgetDetailService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setMiscWorkflowService(WorkflowService<BudgetReAppropriationMisc> miscWorkflowService) {
        this.miscWorkflowService = miscWorkflowService;
    }

    public boolean checkRowEmpty(BudgetReAppropriationView appropriation) {
        return !(appropriation.getBudget() != null && appropriation.getBudget().getId() != 0L || appropriation.getBudgetDetail().getBudgetGroup() != null && appropriation.getBudgetDetail().getBudgetGroup().getId() != 0L || !this.isMandatoryGridFieldEmpty(appropriation));
    }

    @Transactional
    public BudgetDetail createApprovedBudgetDetail(BudgetReAppropriationView appropriation, Position position) {
        BudgetDetail detail = new BudgetDetail();
        BudgetDetail budgetDetail = appropriation.getBudgetDetail();
        detail.copyFrom(budgetDetail);
        BudgetDetail savedBudgetDetail = this.budgetDetailService.createBudgetDetail(detail, position, this.persistenceService);
        this.budgetDetailService.applyAuditing((AbstractAuditable)savedBudgetDetail);
        this.budgetDetailService.persist(savedBudgetDetail);
        return savedBudgetDetail;
    }

    public void validateMandatoryFields(List<BudgetReAppropriationView> reAppropriationList) {
        for (BudgetReAppropriationView entry : reAppropriationList) {
            entry.setBudgetDetail(this.setRelatedValues(entry.getBudgetDetail()));
            if (entry.getBudgetDetail().getBudgetGroup() == null || entry.getBudgetDetail().getBudgetGroup().getId() == 0L) {
                throw new ValidationException(Arrays.asList(new ValidationError("budgetDetail.budgetGroup.mandatory", "budgetDetail.budgetGroup.mandatory")));
            }
            Map<String, Object> valueMap = this.constructValueMap(entry.getBudgetDetail());
            this.budgetDetailConfig.checkHeaderMandatoryField(valueMap);
            this.budgetDetailConfig.checkGridMandatoryField(valueMap);
        }
    }

    public BudgetDetail setRelatedValues(BudgetDetail detail) {
        if (detail.getExecutingDepartment() != null && detail.getExecutingDepartment().getId() == 0L) {
            detail.setExecutingDepartment(null);
        }
        if (detail.getFunction() != null && detail.getFunction().getId() == 0L) {
            detail.setFunction(null);
        }
        if (detail.getScheme() != null && detail.getScheme().getId() == 0) {
            detail.setScheme(null);
        }
        if (detail.getSubScheme() != null && detail.getSubScheme().getId() == 0) {
            detail.setSubScheme(null);
        }
        if (detail.getFunctionary() != null && detail.getFunctionary().getId() == 0) {
            detail.setFunctionary(null);
        }
        if (detail.getBoundary() != null && detail.getBoundary().getId() == 0L) {
            detail.setBoundary(null);
        }
        if (detail.getFund() != null && detail.getFund().getId() == 0) {
            detail.setFund(null);
        }
        return detail;
    }

    private Map<String, Object> constructValueMap(BudgetDetail budgetDetail) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("executingDepartment", budgetDetail.getExecutingDepartment());
        valueMap.put("function", budgetDetail.getFunction());
        valueMap.put("functionary", budgetDetail.getFunctionary());
        valueMap.put("scheme", budgetDetail.getScheme());
        valueMap.put("subScheme", budgetDetail.getSubScheme());
        valueMap.put("boundary", budgetDetail.getBoundary());
        valueMap.put("fund", budgetDetail.getFund());
        return valueMap;
    }

    private boolean isMandatoryGridFieldEmpty(BudgetReAppropriationView appropriation) {
        for (String entry : this.budgetDetailConfig.getGridFields()) {
            if ("function".equalsIgnoreCase(entry) && this.budgetDetailConfig.getMandatoryFields().contains("function") && (appropriation.getBudgetDetail().getFunction() == null || appropriation.getBudgetDetail().getFunction().getId() == 0L)) {
                return true;
            }
            if ("executingDepartment".equalsIgnoreCase(entry) && this.budgetDetailConfig.getMandatoryFields().contains("executingDepartment") && (appropriation.getBudgetDetail().getExecutingDepartment() == null || appropriation.getBudgetDetail().getExecutingDepartment().getId() == 0L)) {
                return true;
            }
            if ("fund".equalsIgnoreCase(entry) && this.budgetDetailConfig.getMandatoryFields().contains("fund") && (appropriation.getBudgetDetail().getExecutingDepartment() == null || appropriation.getBudgetDetail().getExecutingDepartment().getId() == 0L)) {
                return true;
            }
            if ("scheme".equalsIgnoreCase(entry) && this.budgetDetailConfig.getMandatoryFields().contains("scheme") && (appropriation.getBudgetDetail().getScheme() == null || appropriation.getBudgetDetail().getScheme().getId() == 0)) {
                return true;
            }
            if ("subScheme".equalsIgnoreCase(entry) && this.budgetDetailConfig.getMandatoryFields().contains("subScheme") && (appropriation.getBudgetDetail().getSubScheme() == null || appropriation.getBudgetDetail().getSubScheme().getId() == 0)) {
                return true;
            }
            if ("boundary".equalsIgnoreCase(entry) && this.budgetDetailConfig.getMandatoryFields().contains("boundary") && (appropriation.getBudgetDetail().getBoundary() == null || appropriation.getBudgetDetail().getBoundary().getBndryId() == 0L)) {
                return true;
            }
            if ("functionary".equalsIgnoreCase(entry) && this.budgetDetailConfig.getMandatoryFields().contains("functionary") && (appropriation.getBudgetDetail().getFunctionary() == null || appropriation.getBudgetDetail().getFunctionary().getId() == 0)) {
                return true;
            }
            if (!"fund".equalsIgnoreCase(entry) || !this.budgetDetailConfig.getMandatoryFields().contains("fund") || appropriation.getBudgetDetail().getFund() != null && appropriation.getBudgetDetail().getFund().getId() != 0) continue;
            return true;
        }
        return false;
    }

    public boolean rowsToAddExists(List<BudgetReAppropriationView> reAppropriationList) {
        for (BudgetReAppropriationView budgetReAppropriationView : reAppropriationList) {
            if (this.checkRowEmpty(budgetReAppropriationView)) {
                return false;
            }
            BudgetDetail budgetDetail = budgetReAppropriationView.getBudgetDetail();
            this.setRelatedValues(budgetDetail);
            if (budgetDetail.getBudgetGroup() != null && budgetDetail.getBudgetGroup().getId() == 0L) {
                budgetDetail.setBudgetGroup(null);
            }
            if (this.checkRowEmpty(budgetReAppropriationView)) continue;
            return true;
        }
        return false;
    }

    public void validateDuplicates(List<BudgetReAppropriationView> budgetReAppropriationList, BudgetReAppropriationView appropriation) {
        for (BudgetReAppropriationView budgetReAppropriationView : budgetReAppropriationList) {
            if (!appropriation.getBudgetDetail().compareTo(budgetReAppropriationView.getBudgetDetail())) continue;
            throw new ValidationException(Arrays.asList(new ValidationError("reApp.duplicate.entry", "reApp.duplicate.entry")));
        }
    }

    public boolean rowsToAddForExistingDetails(List<BudgetReAppropriationView> reAppropriationList) {
        for (BudgetReAppropriationView budgetReAppropriationView : reAppropriationList) {
            BudgetDetail budgetDetail = budgetReAppropriationView.getBudgetDetail();
            this.setRelatedValues(budgetDetail);
            if (budgetDetail.getBudgetGroup() != null && budgetDetail.getBudgetGroup().getId() == 0L) {
                budgetDetail.setBudgetGroup(null);
            }
            if (budgetReAppropriationView.getBudgetDetail().getBudgetGroup() == null && this.isMandatoryGridFieldEmpty(budgetReAppropriationView)) continue;
            return true;
        }
        return false;
    }

    public void validateDeductionAmount(BudgetReAppropriation appropriation) {
        BigDecimal deductionAmount;
        BigDecimal multiplicationFactor;
        if (appropriation.getBudgetDetail().getPlanningPercent() != null) {
            multiplicationFactor = appropriation.getBudgetDetail().getPlanningPercent().divide(new BigDecimal(String.valueOf(100)));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Calculating multiplicationFactor from PlanningPercent : " + multiplicationFactor));
            }
        } else {
            multiplicationFactor = new BigDecimal(Double.parseDouble(this.getAppConfigFor("EGF", "planning_budget_multiplication_factor")));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("MultiplicationFactor from AppConfig(planning_budget_multiplication_factor) : " + multiplicationFactor));
            }
        }
        if (!((deductionAmount = appropriation.getOriginalDeductionAmount()) == null || BigDecimal.ZERO.compareTo(deductionAmount) != -1 || deductionAmount.compareTo(appropriation.getBudgetDetail().getBudgetAvailable().divide(multiplicationFactor)) != 1 && this.canDeduct(appropriation))) {
            throw new ValidationException(Arrays.asList(new ValidationError("budget.deduction.greater.than.available", "budget.deduction.greater.than.available")));
        }
    }

    private boolean canDeduct(BudgetReAppropriation appropriation) {
        if (appropriation == null || appropriation.getOriginalDeductionAmount() == null || BigDecimal.ZERO.compareTo(appropriation.getOriginalDeductionAmount()) == 0) {
            return true;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        BudgetDetail budgetDetail = appropriation.getBudgetDetail();
        if (budgetDetail.getFund() != null && budgetDetail.getFund().getId() != null) {
            paramMap.put("fundid", budgetDetail.getFund().getId());
        }
        if (budgetDetail.getExecutingDepartment() != null && budgetDetail.getExecutingDepartment().getId() != null) {
            paramMap.put("deptid", budgetDetail.getExecutingDepartment().getId());
        }
        if (budgetDetail.getFunction() != null && budgetDetail.getFunction().getId() != null) {
            paramMap.put("functionid", budgetDetail.getFunction().getId());
        }
        if (budgetDetail.getFunctionary() != null && budgetDetail.getFunctionary().getId() != null) {
            paramMap.put("functionaryid", budgetDetail.getFunctionary().getId());
        }
        if (budgetDetail.getScheme() != null && budgetDetail.getScheme().getId() != null) {
            paramMap.put("schemeid", budgetDetail.getScheme().getId());
        }
        if (budgetDetail.getSubScheme() != null && budgetDetail.getSubScheme().getId() != null) {
            paramMap.put("subschemeid", budgetDetail.getSubScheme().getId());
        }
        if (budgetDetail.getBoundary() != null && budgetDetail.getBoundary().getId() != null) {
            paramMap.put("boundaryid", budgetDetail.getBoundary().getId());
        }
        paramMap.put("budgetheadid", budgetDetail.getBudgetGroup().getId());
        paramMap.put("glcodeid", budgetDetail.getBudgetGroup().getMinCode().getId());
        paramMap.put("asondate", appropriation.getAsOnDate());
        BigDecimal actualBudgetUtilized = this.budgetDetailsDAO.getActualBudgetUtilized(paramMap);
        BigDecimal billAmount = this.budgetDetailsDAO.getBillAmountForBudgetCheck(paramMap);
        BigDecimal approvedAmount = appropriation.getBudgetDetail().getApprovedAmount();
        approvedAmount = approvedAmount == null ? BigDecimal.ZERO : approvedAmount;
        BigDecimal reAppropriationsTotal = budgetDetail.getApprovedReAppropriationsTotal();
        reAppropriationsTotal = reAppropriationsTotal == null ? BigDecimal.ZERO : reAppropriationsTotal;
        approvedAmount = approvedAmount.add(reAppropriationsTotal);
        return appropriation.getOriginalDeductionAmount().compareTo(approvedAmount.subtract(actualBudgetUtilized == null ? BigDecimal.ZERO : actualBudgetUtilized).subtract(billAmount == null ? BigDecimal.ZERO : billAmount)) <= 0;
    }

    @Transactional
    public BudgetReAppropriationMisc createReAppropriationMisc(String actionName, BudgetReAppropriationMisc appropriationMisc, BudgetDetail detail, Position position) {
        BudgetReAppropriationMisc misc = new BudgetReAppropriationMisc();
        misc.setReAppropriationDate(appropriationMisc.getReAppropriationDate());
        misc.setRemarks(appropriationMisc.getRemarks());
        misc.setSequenceNumber(this.getSequenceNumber(detail));
        misc.setStatus(this.egwStatusDAO.getStatusByModuleAndCode("REAPPROPRIATIONMISC", "Approved"));
        this.budgetReAppropriationMiscService.applyAuditing((AbstractAuditable)misc);
        this.budgetReAppropriationMiscService.persist((Object)misc);
        return misc;
    }

    protected String getSequenceNumber(BudgetDetail detail) {
        BudgetReAppropriationSequenceNumberGenerator b = (BudgetReAppropriationSequenceNumberGenerator)this.beanResolver.getAutoNumberServiceFor(BudgetReAppropriationSequenceNumberGenerator.class);
        String sequenceNumber = b.getNextNumber(detail);
        ScriptContext scriptContext = ScriptService.createContext((Object[])new Object[]{"wfItem", detail, "sequenceGenerator", this.sequenceGenerator});
        return sequenceNumber;
    }

    public BudgetReAppropriation findBySequenceNumberAndBudgetDetail(String sequenceNumber, Long budgetDetailId) {
        return (BudgetReAppropriation)((Object)this.persistenceService.find("from BudgetReAppropriation b where b.reAppropriationMisc.sequenceNumber=? and b.budgetDetail.id=?", new Object[]{sequenceNumber, budgetDetailId}));
    }

    public BudgetReAppropriationMisc performActionOnMisc(String action, BudgetReAppropriationMisc reApp, String comment) {
        BudgetReAppropriationMisc misc = (BudgetReAppropriationMisc)this.miscWorkflowService.transition(action, (StateAware)reApp, comment);
        this.getSession().flush();
        return misc;
    }

    @Transactional
    public void updatePlanningBudget(BudgetReAppropriation reAppropriation) {
        this.getSession().flush();
        BudgetDetail budgetDetail = (BudgetDetail)((Object)this.budgetDetailService.find("from BudgetDetail where id=?", new Object[]{reAppropriation.getBudgetDetail().getId()}));
        BigDecimal budgetAvailable = budgetDetail.getBudgetAvailable() == null ? BigDecimal.ZERO : budgetDetail.getBudgetAvailable();
        BigDecimal Budgetapproved = BigDecimal.ZERO;
        BigDecimal planningBudgetApproved = BigDecimal.ZERO;
        BigDecimal planningBudgetUsage = BigDecimal.ZERO;
        Budgetapproved = budgetDetail.getApprovedAmount().add(budgetDetail.getApprovedReAppropriationsTotal());
        if (reAppropriation.getAdditionAmount() != null && reAppropriation.getAdditionAmount().compareTo(BigDecimal.ZERO) == 1) {
            Budgetapproved = Budgetapproved.add(reAppropriation.getAdditionAmount());
        } else if (reAppropriation.getDeductionAmount() != null && reAppropriation.getDeductionAmount().compareTo(BigDecimal.ZERO) == 1) {
            Budgetapproved = Budgetapproved.subtract(reAppropriation.getDeductionAmount());
        }
        planningBudgetApproved = budgetDetail.getPlanningPercent() == null ? Budgetapproved : Budgetapproved.multiply(budgetDetail.getPlanningPercent()).divide(new BigDecimal(String.valueOf(100)));
        planningBudgetUsage = this.budgetDetailsDAO.getPlanningBudgetUsage(budgetDetail);
        budgetAvailable = planningBudgetApproved.subtract(planningBudgetUsage);
        budgetDetail.setBudgetAvailable(budgetAvailable);
        this.budgetDetailService.update((Object)budgetDetail);
        this.getSession().flush();
    }

    protected BigDecimal zeroOrValue(BigDecimal value) {
        return value == null ? BigDecimal.ZERO : value;
    }

    private String getAppConfigFor(String module, String key) {
        try {
            List list = this.appConfigValuesService.getConfigValuesByModuleAndKey(module, key);
            return ((AppConfigValues)list.get(0)).getValue().toString();
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(key + " not defined in appconfig", key + " not defined in appconfig")));
        }
    }

    public List<BudgetReAppropriation> getNonApprovedReAppByUser(Long userId, BudgetDetail budgetDetail, CFinancialYear financialYear) {
        StringBuffer query = new StringBuffer();
        query.append("from BudgetReAppropriation where state.value='NEW' and createdBy.id=" + userId + " and budgetDetail.budget.financialYear.id=" + financialYear.getId());
        if (budgetDetail.getExecutingDepartment() != null && budgetDetail.getExecutingDepartment().getId() != null && budgetDetail.getExecutingDepartment().getId() != 0L) {
            query.append(" and budgetDetail.executingDepartment.id=" + budgetDetail.getExecutingDepartment().getId());
        }
        if (budgetDetail.getFund() != null && budgetDetail.getFund().getId() != null && budgetDetail.getFund().getId() != 0) {
            query.append(" and budgetDetail.fund.id=" + budgetDetail.getFund().getId());
        }
        if (budgetDetail.getFunction() != null && budgetDetail.getFunction().getId() != null && budgetDetail.getFunction().getId() != 0L) {
            query.append(" and budgetDetail.function.id=" + budgetDetail.getFunction().getId());
        }
        if (budgetDetail.getFunctionary() != null && budgetDetail.getFunctionary().getId() != null && budgetDetail.getFunctionary().getId() != 0) {
            query.append(" and budgetDetail.functionary.id=" + budgetDetail.getFunctionary().getId());
        }
        if (budgetDetail.getScheme() != null && budgetDetail.getScheme().getId() != null && budgetDetail.getScheme().getId() != 0) {
            query.append(" and budgetDetail.scheme.id=" + budgetDetail.getScheme().getId());
        }
        if (budgetDetail.getSubScheme() != null && budgetDetail.getSubScheme().getId() != null && budgetDetail.getSubScheme().getId() != 0) {
            query.append(" and budgetDetail.subScheme.id=" + budgetDetail.getSubScheme().getId());
        }
        if (budgetDetail.getBoundary() != null && budgetDetail.getBoundary().getId() != null && budgetDetail.getBoundary().getId() != 0L) {
            query.append(" and budgetDetail.boundary.id=" + budgetDetail.getBoundary().getId());
        }
        query = query.append(" order by budgetDetail.budgetGroup ");
        return this.findAllBy(query.toString(), new Object[0]);
    }

    public void setBudgetDetailsDAO(BudgetDetailsHibernateDAO budgetDetailsDAO) {
        this.budgetDetailsDAO = budgetDetailsDAO;
    }

    @Transactional
    public boolean createReAppropriation(String actionName, List<BudgetReAppropriationView> budgetReAppropriationList, Position position, CFinancialYear financialYear, String beRe, BudgetReAppropriationMisc misc, String asOnDate) {
        try {
            if (budgetReAppropriationList.isEmpty() || !this.rowsToAddForExistingDetails(budgetReAppropriationList)) {
                return false;
            }
            this.validateMandatoryFields(budgetReAppropriationList);
            ArrayList<BudgetReAppropriationView> addedList = new ArrayList<BudgetReAppropriationView>();
            for (BudgetReAppropriationView appropriation : budgetReAppropriationList) {
                this.validateDuplicates(addedList, appropriation);
                this.saveAndStartWorkFlowForExistingdetails(actionName, appropriation, position, financialYear, beRe, misc, asOnDate);
                addedList.add(appropriation);
            }
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        return true;
    }

    @Transactional
    public void saveAndStartWorkFlowForExistingdetails(String actionName, BudgetReAppropriationView reAppView, Position position, CFinancialYear financialYear, String beRe, BudgetReAppropriationMisc misc, String asOnDate) {
        BudgetReAppropriation appropriation = new BudgetReAppropriation();
        EgwStatus status = this.egwStatusDAO.getStatusByModuleAndCode("BUDGETDETAIL", "Approved");
        reAppView.getBudgetDetail().setStatus(status);
        List<BudgetDetail> searchBy = this.budgetDetailService.searchByCriteriaWithTypeAndFY(financialYear.getId(), beRe, reAppView.getBudgetDetail());
        if (searchBy.size() != 1) {
            throw new ValidationException(Arrays.asList(new ValidationError("budget.reappropriation.invalid.combination", "budget.reappropriation.invalid.combination")));
        }
        appropriation.setBudgetDetail(searchBy.get(0));
        appropriation.setReAppropriationMisc(misc);
        appropriation.setAnticipatoryAmount(reAppView.getAnticipatoryAmount());
        try {
            appropriation.setAsOnDate(Constants.DDMMYYYYFORMAT2.parse(asOnDate));
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while parsing date");
        }
        if ("Addition".equalsIgnoreCase(reAppView.getChangeRequestType())) {
            appropriation.setAdditionAmount(reAppView.getDeltaAmount());
        } else {
            appropriation.setDeductionAmount(reAppView.getDeltaAmount());
        }
        appropriation.setStatus(this.egwStatusDAO.getStatusByModuleAndCode("BudgetReAppropriation", "Approved"));
        this.validateDeductionAmount(appropriation);
        this.applyAuditing((AbstractAuditable)appropriation);
        this.persist((Object)appropriation);
        this.updatePlanningBudget(appropriation);
    }

    @Transactional
    public BudgetReAppropriationMisc createBudgetReAppropriationMisc(String actionName, String beRe, CFinancialYear financialYear, BudgetReAppropriationMisc appropriationMisc, Position position) {
        Budget budget = new Budget();
        budget.setIsbere(beRe);
        budget.setFinancialYear(financialYear);
        BudgetDetail budgetDetail = new BudgetDetail();
        budgetDetail.setBudget(budget);
        return this.createReAppropriationMisc(actionName, appropriationMisc, budgetDetail, position);
    }

    @Transactional
    public boolean createReAppropriationForNewBudgetDetail(String actionName, List<BudgetReAppropriationView> newBudgetReAppropriationList, Position position, BudgetReAppropriationMisc misc) {
        try {
            BudgetDetail detail = null;
            if (newBudgetReAppropriationList.isEmpty() || !newBudgetReAppropriationList.isEmpty() && !this.rowsToAddExists(newBudgetReAppropriationList)) {
                return false;
            }
            try {
                ArrayList<BudgetReAppropriationView> addedList = new ArrayList<BudgetReAppropriationView>();
                for (BudgetReAppropriationView appropriation : newBudgetReAppropriationList) {
                    if (this.budgetDetailService.getBudgetDetail(appropriation.getBudgetDetail().getFund().getId(), appropriation.getBudgetDetail().getFunction().getId(), appropriation.getBudgetDetail().getExecutingDepartment().getId(), appropriation.getBudgetDetail().getBudgetGroup().getId()) == null) {
                        detail = this.createApprovedBudgetDetail(appropriation, position);
                        if (this.checkRowEmpty(appropriation)) continue;
                        this.validateMandatoryFields(newBudgetReAppropriationList);
                        this.validateDuplicates(addedList, appropriation);
                        this.saveAndStartWorkFlowForNewDetail(actionName, detail, appropriation, position, misc);
                        addedList.add(appropriation);
                        continue;
                    }
                    throw new ValidationException(Arrays.asList(new ValidationError("budgetDetail.duplicate", "budgetdetail.exists")));
                }
            }
            catch (Exception e) {
                throw new ValidationException(Arrays.asList(new ValidationError("budgetDetail.duplicate", "budgetdetail.exists")));
            }
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        return true;
    }

    @Transactional
    public void saveAndStartWorkFlowForNewDetail(String actionName, BudgetDetail detail, BudgetReAppropriationView appropriation, Position position, BudgetReAppropriationMisc misc) {
        BudgetReAppropriation reAppropriation = new BudgetReAppropriation();
        detail.setPlanningPercent(appropriation.getPlanningPercent());
        detail.setBudgetAvailable(appropriation.getDeltaAmount().multiply(detail.getPlanningPercent()).divide(new BigDecimal(String.valueOf(100))));
        reAppropriation.setBudgetDetail(detail);
        reAppropriation.setReAppropriationMisc(misc);
        reAppropriation.setAnticipatoryAmount(appropriation.getAnticipatoryAmount());
        reAppropriation.setAdditionAmount(appropriation.getDeltaAmount());
        reAppropriation.setStatus(this.egwStatusDAO.getStatusByModuleAndCode("BudgetReAppropriation", "Approved"));
        this.applyAuditing((AbstractAuditable)reAppropriation);
        this.persist((Object)reAppropriation);
    }
}

