/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EisCommonService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.model.masters.AccountCodePurpose;
import org.egov.pims.commons.Position;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class FinancialUtils {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private AppConfigService appConfigService;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    public static final Map<String, String> VOUCHER_SUBTYPES = new HashMap<String, String>(){
        private static final long serialVersionUID = -2168753508482839041L;
        {
            this.put("JVGeneral", "General");
            this.put("Works", "Works");
            this.put("Purchase", "Purchase");
            this.put("Fixed Asset", "Fixed Asset");
            this.put("Expense", "Expense");
        }
    };

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public EgwStatus getStatusByModuleAndCode(String moduleType, String code) {
        return this.egwStatusHibernateDAO.getStatusByModuleAndCode(moduleType, code);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public List<EgwStatus> getStatusByModule(String moduleType) {
        return this.egwStatusHibernateDAO.getStatusByModule(moduleType);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public EgwStatus getStatusById(Integer id) {
        return this.egwStatusHibernateDAO.findById(id, true);
    }

    public String getApproverDetails(String workFlowAction, State state, Long id, Long approvalPosition) {
        Assignment currentUserAssignment = this.assignmentService.getPrimaryAssignmentForGivenRange(this.securityUtils.getCurrentUser().getId(), new Date(), new Date());
        Assignment assignObj = null;
        List<Object> asignList = null;
        if (approvalPosition != null) {
            assignObj = this.assignmentService.getPrimaryAssignmentForPositon(approvalPosition);
        }
        if (assignObj != null) {
            asignList = new ArrayList<Assignment>();
            asignList.add(assignObj);
        } else if (assignObj == null && approvalPosition != null) {
            asignList = this.assignmentService.getAssignmentsForPosition(approvalPosition, new Date());
        }
        String nextDesign = "";
        if (asignList != null) {
            String string = nextDesign = !asignList.isEmpty() ? ((Assignment)asignList.get(0)).getDesignation().getName() : "";
        }
        String approverDetails = !"Reject".toString().equalsIgnoreCase(workFlowAction) ? id + "," + this.getApproverName(approvalPosition) + "," + (currentUserAssignment != null ? currentUserAssignment.getDesignation().getName() : "") + "," + (nextDesign != null ? nextDesign : "") : id + "," + this.getApproverName(state.getOwnerPosition().getId()) + "," + (currentUserAssignment != null ? currentUserAssignment.getDesignation().getName() : "") + "," + (nextDesign != null ? state.getOwnerPosition().getDeptDesig().getDesignation().getName() : "");
        return approverDetails;
    }

    public String getApproverName(Long approvalPosition) {
        Assignment assignment = null;
        List<Object> asignList = null;
        if (approvalPosition != null) {
            assignment = this.assignmentService.getPrimaryAssignmentForPositionAndDate(approvalPosition, new Date());
        }
        if (assignment != null) {
            asignList = new ArrayList<Assignment>();
            asignList.add(assignment);
        } else if (assignment == null) {
            asignList = this.assignmentService.getAssignmentsForPosition(approvalPosition, new Date());
        }
        return !asignList.isEmpty() ? ((Assignment)asignList.get(0)).getEmployee().getName() : "";
    }

    public Long getApproverPosition(String designationName, State state, Long createdById) {
        String[] desgnArray;
        Set stateHistoryList = state.getHistory();
        Long approverPosition = 0L;
        String[] stringArray = desgnArray = designationName != null ? designationName.split(",") : null;
        if (stateHistoryList != null && !stateHistoryList.isEmpty()) {
            for (StateHistory stateHistory : stateHistoryList) {
                if (stateHistory.getOwnerPosition() == null) continue;
                List assignmentList = this.assignmentService.getAssignmentsForPosition(stateHistory.getOwnerPosition().getId(), new Date());
                block1: for (Assignment assgn : assignmentList) {
                    if (desgnArray == null) continue;
                    String[] stringArray2 = desgnArray;
                    int n = stringArray2.length;
                    for (int i = 0; i < n; ++i) {
                        String str = stringArray2[i];
                        if (!assgn.getDesignation().getName().equalsIgnoreCase(str)) continue;
                        approverPosition = stateHistory.getOwnerPosition().getId();
                        continue block1;
                    }
                }
            }
            if (approverPosition == 0L) {
                State stateObj = state;
                List assignmentList = this.assignmentService.getAssignmentsForPosition(stateObj.getOwnerPosition().getId(), new Date());
                block3: for (Assignment assgn : assignmentList) {
                    if (desgnArray == null) continue;
                    for (String str : desgnArray) {
                        if (!assgn.getDesignation().getName().equalsIgnoreCase(str)) continue;
                        approverPosition = stateObj.getOwnerPosition().getId();
                        continue block3;
                    }
                }
            }
        } else {
            Position posObjToClerk = this.positionMasterService.getCurrentPositionForUser(createdById);
            approverPosition = posObjToClerk.getId();
        }
        return approverPosition;
    }

    public boolean isBillEditable(State state) {
        boolean isEditable = false;
        if (state.getOwnerPosition() != null && state.getOwnerPosition().getDeptDesig() != null && state.getOwnerPosition().getDeptDesig().getDesignation() != null) {
            String designationName = state.getOwnerPosition().getDeptDesig().getDesignation().getName();
            AppConfig appConfig = this.appConfigService.getAppConfigByKeyName("BILL_EDIT_DESIGNATIONS");
            for (AppConfigValues appConfigValues : appConfig.getConfValues()) {
                if (!designationName.equals(appConfigValues.getValue())) continue;
                isEditable = true;
            }
        }
        return isEditable;
    }

    public List<HashMap<String, Object>> getHistory(State state, List<StateHistory> history) {
        User user = null;
        ArrayList<HashMap<String, Object>> historyTable = new ArrayList<HashMap<String, Object>>();
        HashMap<String, Object> map = new HashMap<String, Object>(0);
        if (null != state) {
            if (!history.isEmpty() && history != null) {
                Collections.reverse(history);
            }
            for (StateHistory stateHistory : history) {
                HashMap<String, Object> HistoryMap = new HashMap<String, Object>(0);
                HistoryMap.put("date", stateHistory.getDateInfo());
                HistoryMap.put("comments", stateHistory.getComments());
                HistoryMap.put("updatedBy", stateHistory.getLastModifiedBy().getUsername() + "::" + stateHistory.getLastModifiedBy().getName());
                HistoryMap.put("status", stateHistory.getValue());
                Position owner = stateHistory.getOwnerPosition();
                user = stateHistory.getOwnerUser();
                if (null != user) {
                    HistoryMap.put("user", user.getUsername() + "::" + user.getName());
                    HistoryMap.put("department", null != this.eisCommonService.getDepartmentForUser(user.getId()) ? this.eisCommonService.getDepartmentForUser(user.getId()).getName() : "");
                } else if (null != owner && null != owner.getDeptDesig()) {
                    user = this.eisCommonService.getUserForPosition(owner.getId(), new Date());
                    HistoryMap.put("user", null != user.getUsername() ? user.getUsername() + "::" + user.getName() : "");
                    HistoryMap.put("department", null != owner.getDeptDesig().getDepartment() ? owner.getDeptDesig().getDepartment().getName() : "");
                }
                historyTable.add(HistoryMap);
            }
            map.put("date", state.getDateInfo());
            map.put("comments", state.getComments() != null ? state.getComments() : "");
            map.put("updatedBy", state.getLastModifiedBy().getUsername() + "::" + state.getLastModifiedBy().getName());
            map.put("status", state.getValue());
            Position ownerPosition = state.getOwnerPosition();
            user = state.getOwnerUser();
            if (null != user) {
                map.put("user", user.getUsername() + "::" + user.getName());
                map.put("department", null != this.eisCommonService.getDepartmentForUser(user.getId()) ? this.eisCommonService.getDepartmentForUser(user.getId()).getName() : "");
            } else if (null != ownerPosition && null != ownerPosition.getDeptDesig()) {
                user = this.eisCommonService.getUserForPosition(ownerPosition.getId(), new Date());
                map.put("user", null != user.getUsername() ? user.getUsername() + "::" + user.getName() : "");
                map.put("department", null != ownerPosition.getDeptDesig().getDepartment() ? ownerPosition.getDeptDesig().getDepartment().getName() : "");
            }
            historyTable.add(map);
        }
        return historyTable;
    }

    public AccountCodePurpose getAccountCodePurposeById(Long id) {
        return (AccountCodePurpose)((Object)this.getCurrentSession().load(AccountCodePurpose.class, (Serializable)id));
    }
}

