/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.commons.bank.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.egov.commons.Bank;
import org.egov.egf.commons.bank.repository.BankRepository;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CreateBankService {
    @PersistenceContext
    private EntityManager entityManager;
    private final BankRepository bankRepository;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public CreateBankService(BankRepository bankRepository) {
        this.bankRepository = bankRepository;
    }

    public Bank getById(Integer id) {
        return (Bank)this.bankRepository.findOne(id);
    }

    public List<Bank> getByIsActive(Boolean isActive) {
        return this.bankRepository.findByIsactive(isActive);
    }

    public List<Bank> getByIsActiveTrueOrderByName() {
        return this.bankRepository.findByIsactiveTrueOrderByNameAsc();
    }

    @Transactional
    public Bank create(Bank bank) {
        bank.setCreatedDate(new Date());
        bank.setCreatedBy((User)this.getCurrentSession().load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
        return (Bank)this.bankRepository.save(bank);
    }

    @Transactional
    public Bank update(Bank bank) {
        bank.setLastModifiedDate(new Date());
        bank.setLastModifiedBy((User)this.getCurrentSession().load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
        return (Bank)this.bankRepository.save(bank);
    }

    public List<Bank> search(Bank bank) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery createQuery = cb.createQuery(Bank.class);
        Root banks = createQuery.from(Bank.class);
        createQuery.select((Selection)banks);
        Metamodel m = this.entityManager.getMetamodel();
        EntityType tempBank = m.entity(Bank.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (bank.getName() != null) {
            String name = "%" + bank.getName().toLowerCase() + "%";
            predicates.add(cb.isNotNull((Expression)banks.get("name")));
            predicates.add(cb.like(cb.lower((Expression)banks.get(tempBank.getDeclaredSingularAttribute("name", String.class))), name));
        }
        if (bank.getCode() != null) {
            String code = "%" + bank.getCode().toLowerCase() + "%";
            predicates.add(cb.isNotNull((Expression)banks.get("code")));
            predicates.add(cb.like(cb.lower((Expression)banks.get(tempBank.getDeclaredSingularAttribute("code", String.class))), code));
        }
        if (bank.getIsactive().booleanValue()) {
            predicates.add(cb.equal((Expression)banks.get("isactive"), (Object)true));
        }
        if (bank.getNarration() != null) {
            predicates.add(cb.equal((Expression)banks.get("narration"), (Object)bank.getNarration()));
        }
        createQuery.where(predicates.toArray(new Predicate[0]));
        TypedQuery query = this.entityManager.createQuery(createQuery);
        return query.getResultList();
    }

    public List<Bank> getAll() {
        return this.bankRepository.findAll();
    }
}

