/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.exility.service;

import com.exilant.exility.common.DataCollection;
import com.exilant.exility.common.ExilServiceInterface;
import com.exilant.exility.common.TaskFailedException;
import com.exilant.exility.dataservice.SQLTask;
import java.sql.Connection;
import org.apache.log4j.Logger;

public class TreeService
implements ExilServiceInterface {
    private static TreeService singletonInstance;
    private static final Logger LOGGER;

    public static TreeService getService() {
        if (singletonInstance == null) {
            singletonInstance = new TreeService();
        }
        return singletonInstance;
    }

    private TreeService() {
    }

    @Override
    public void doService(DataCollection dc) {
        String treeName = dc.getValue("treeName");
        if (treeName == null) {
            dc.addMessage("exilNoKeyValue");
            return;
        }
        Connection con = null;
        SQLTask task = SQLTask.getTask();
        try {
            task.execute(treeName, treeName, dc, con, true, true, "");
        }
        catch (TaskFailedException e) {
            LOGGER.error((Object)("SQLTask execution failed" + e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error((Object)("SQLTask execution failed" + e.getMessage()), (Throwable)e);
            dc.addMessage("exilServerError", e.getMessage());
        }
    }

    static {
        LOGGER = Logger.getLogger(TreeService.class);
    }
}

