/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.exility.dataservice;

import com.exilant.exility.common.DataCollection;
import com.exilant.exility.common.ObjectGetSetter;
import com.exilant.exility.common.TaskFailedException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DataExtractor {
    private static final Logger LOGGER = Logger.getLogger(DataExtractor.class);
    private static DataExtractor singletonInstance;

    public static DataExtractor getExtractor() {
        if (singletonInstance == null) {
            singletonInstance = new DataExtractor();
        }
        return singletonInstance;
    }

    private DataExtractor() {
    }

    public void extract(String sql, String gridName, DataCollection dc, Connection con, boolean errorOnNoData, boolean addColumnHeading, String prefix) throws TaskFailedException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)(sql + "sqllll"));
        }
        if (sql == null || sql.length() == 0) {
            return;
        }
        int i = dc.getInt("sqlCount");
        dc.addValue("sqlCount", ++i);
        if (null == con) {
            return;
        }
        int rowCount = 0;
        int columnCount = 0;
        ResultSetMetaData metaData = null;
        String[][] dataValues = null;
        try {
            ResultSet rs;
            PreparedStatement pststement;
            block31: {
                int rowid;
                int m;
                pststement = con.prepareStatement(sql, 1004, 1007);
                rs = null;
                String[] columnNames = null;
                try {
                    rs = pststement.executeQuery();
                    metaData = rs.getMetaData();
                    columnCount = metaData.getColumnCount();
                    columnNames = new String[columnCount];
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Exception while analysing Result set in extract", (Throwable)e);
                    return;
                }
                for (m = 0; m < columnCount; ++m) {
                    columnNames[m] = prefix + metaData.getColumnName(m + 1);
                }
                if (null == gridName || gridName.length() == 0) {
                    try {
                        if (rs.next()) {
                            for (m = 0; m < columnCount; ++m) {
                                String mText = rs.getString(m + 1);
                                if (mText == null) {
                                    mText = "";
                                }
                                if (mText.indexOf("\r") > 0) {
                                    mText = mText.replaceAll("\r", " ");
                                    mText = mText.replaceAll("\n", " ");
                                    mText = mText.replaceAll("\f", " ");
                                }
                                dc.addValue(columnNames[m], mText);
                            }
                            break block31;
                        }
                        return;
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)"Exception while analysing Result set in extract", (Throwable)e);
                        return;
                    }
                }
                rowCount = -1;
                try {
                    rs.next();
                    rs.getString(1);
                }
                catch (Exception eee) {
                    LOGGER.error((Object)"Error while analysing Result set in extract", (Throwable)eee);
                    rowCount = 0;
                }
                try {
                    if (rowCount == -1) {
                        rs.last();
                        rowCount = rs.getRow();
                        rs.beforeFirst();
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Error while analysing Result set in extract", (Throwable)e);
                    rowCount = 0;
                }
                if (addColumnHeading) {
                    dataValues = new String[rowCount + 1][columnCount];
                    for (int k = 0; k < columnCount; ++k) {
                        dataValues[0][k] = columnNames[k];
                    }
                    rowid = 1;
                } else {
                    dataValues = new String[rowCount][columnCount];
                    rowid = 0;
                }
                try {
                    while (rs.next()) {
                        for (int j = 0; j < columnCount; ++j) {
                            String mText = rs.getString(j + 1);
                            if (mText == null) {
                                mText = "";
                            }
                            dataValues[rowid][j] = mText;
                        }
                        ++rowid;
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Inside extract", (Throwable)e);
                    try {
                        if (gridName != null && dataValues != null && addColumnHeading) {
                            dc.addGrid(gridName, dataValues);
                        }
                    }
                    catch (Exception ee) {
                        LOGGER.error((Object)"Error while adding grid in extract", (Throwable)ee);
                    }
                    return;
                }
                dc.addGrid(gridName, dataValues);
            }
            rs.close();
            pststement.close();
        }
        catch (SQLException e) {
            dc.addMessage("exilSQLException", e.getMessage());
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new TaskFailedException();
        }
    }

    public HashMap extractIntoMap(String sql, String keyName, Class collectionMemberClass) throws TaskFailedException {
        Connection con = null;
        HashMap map = this.extractIntoMap(sql, con, keyName, collectionMemberClass);
        return map;
    }

    public HashMap extractIntoMap(String sql, Connection con, String keyName, Class collectionMemberClass) throws TaskFailedException {
        HashMap map = new HashMap();
        int columnCount = 0;
        ResultSetMetaData metaData = null;
        try {
            PreparedStatement pststement = con.prepareStatement(sql, 1004, 1007);
            ResultSet rs = pststement.executeQuery();
            metaData = rs.getMetaData();
            columnCount = metaData.getColumnCount();
            String val = null;
            while (rs.next()) {
                Object object = collectionMemberClass.newInstance();
                for (int m = 0; m < columnCount; ++m) {
                    String mText = rs.getString(m + 1);
                    if (mText == null) {
                        mText = "";
                    }
                    if (metaData.getColumnName(m + 1).equalsIgnoreCase(keyName)) {
                        val = mText;
                    }
                    ObjectGetSetter.set(object, metaData.getColumnName(m + 1), mText);
                }
                map.put(val, object);
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"Inside extractIntoMap", (Throwable)e);
            return new HashMap();
        }
        catch (InstantiationException e) {
            LOGGER.error((Object)"Inside extractIntoMap", (Throwable)e);
            throw new TaskFailedException("Object could not be instantiated for " + collectionMemberClass.getName());
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)"Inside extractIntoMap", (Throwable)e);
            throw new TaskFailedException("Object could not be instantiated due to access issues " + collectionMemberClass.getName());
        }
        return map;
    }
}

