/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.eGov.src.reports;

import com.exilant.eGov.src.reports.GeneralLedgerReportBean;
import com.exilant.eGov.src.reports.ReportEngineBean;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportEngine {
    private static final Logger LOGGER = Logger.getLogger(ReportEngine.class);
    @Autowired
    private AppConfigValueService appConfigValuesService;

    public String getVouchersListQuery(ReportEngineBean reBean) throws ApplicationRuntimeException {
        boolean includeVouchermis = false;
        boolean includeGeneralLedger = false;
        String firstParam = "";
        String andParam = " and ";
        StringBuffer reportEngineQry = new StringBuffer("");
        try {
            if (reBean.getSchemeId() != null || reBean.getSubSchemeId() != null || reBean.getFundsourceId() != null || reBean.getDivisionId() != null || reBean.getDepartmentId() != null || reBean.getFunctionaryId() != null) {
                includeVouchermis = true;
            }
            if (reBean.getFunctionId() != null) {
                includeGeneralLedger = true;
            }
            reportEngineQry.append("select ");
            reportEngineQry.append("voucher.id as \"vocherId\" ");
            reportEngineQry.append(" from ");
            if (includeVouchermis && includeGeneralLedger) {
                reportEngineQry.append(" ( voucherheader voucher left join vouchermis mis on voucher.id=mis.voucherheaderid)left join generalledger ledger on voucher.id=ledger.voucherheaderid ");
            } else if (includeVouchermis) {
                reportEngineQry.append(" voucherheader voucher left join vouchermis mis on voucher.id=mis.voucherheaderid ");
            } else if (includeGeneralLedger) {
                reportEngineQry.append(" voucherheader voucher left join generalledger ledger on voucher.id=ledger.voucherheaderid ");
            } else {
                reportEngineQry.append(" voucherheader voucher ");
            }
            if (reBean.getFiltersCount() >= 1) {
                reportEngineQry.append(" where ");
            }
            if (this.checkNullandEmpty(reBean.getFundId())) {
                reportEngineQry.append(firstParam + " voucher.fundId=" + reBean.getFundId());
                firstParam = " and ";
            }
            if (this.checkNullandEmpty(reBean.getFundsourceId())) {
                reportEngineQry.append(firstParam + " mis.fundsourceId=" + reBean.getFundsourceId());
                firstParam = " and ";
            }
            if (this.checkNullandEmpty(reBean.getFromDate())) {
                reportEngineQry.append(firstParam + " voucher.voucherDate>=to_date('" + reBean.getFromDate() + "','dd/MM/yyyy')");
                firstParam = " and ";
            }
            if (this.checkNullandEmpty(reBean.getToDate())) {
                reportEngineQry.append(firstParam + " voucher.voucherDate<=to_date('" + reBean.getToDate() + "','dd/MM/yyyy')");
                firstParam = " and ";
            }
            if (this.checkNullandEmpty(reBean.getFromVoucherNumber())) {
                reportEngineQry.append(firstParam + " voucher.fromVouchernumber>=" + reBean.getFromVoucherNumber());
                firstParam = " and ";
            }
            if (this.checkNullandEmpty(reBean.getToVoucherNumber())) {
                reportEngineQry.append(firstParam + " voucher.toVouchernumber<=" + reBean.getToVoucherNumber());
                firstParam = " and ";
            }
            if (this.checkNullandEmpty(reBean.getSchemeId())) {
                reportEngineQry.append(firstParam + " mis.schemeId=" + reBean.getSchemeId());
                firstParam = " and ";
            }
            if (this.checkNullandEmpty(reBean.getSubSchemeId())) {
                reportEngineQry.append(firstParam + " mis.subSchemeId=" + reBean.getSubSchemeId());
                firstParam = " and ";
            }
            if (this.checkNullandEmpty(reBean.getDivisionId())) {
                reportEngineQry.append(firstParam + " mis.divisionId=" + reBean.getDivisionId());
                firstParam = " and ";
            }
            if (this.checkNullandEmpty(reBean.getDepartmentId())) {
                reportEngineQry.append(firstParam + " mis.departmentId=" + reBean.getDepartmentId());
                firstParam = " and ";
            }
            if (this.checkNullandEmpty(reBean.getFunctionaryId())) {
                reportEngineQry.append(firstParam + " mis.functionaryId=" + reBean.getFunctionaryId());
                firstParam = " and ";
            }
            if (this.checkNullandEmpty(reBean.getFunctionId())) {
                reportEngineQry.append(firstParam + " ledger.functionid=" + reBean.getFunctionId());
                firstParam = " and ";
            }
            new ArrayList();
            String defaultStatusExclude = null;
            List listAppConfVal = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "statusexcludeReport");
            if (null == listAppConfVal) {
                throw new ApplicationRuntimeException("Exlcude statusses not  are not defined for Reports");
            }
            defaultStatusExclude = ((AppConfigValues)listAppConfVal.get(0)).getValue();
            reportEngineQry.append(firstParam + "voucher.status not in(" + defaultStatusExclude);
            if (reBean.getExcludeStatuses() != null && reBean.getExcludeStatuses().size() > 0) {
                reportEngineQry.append("," + reBean.getCommaSeperatedValues(reBean.getExcludeStatuses()) + " )");
                firstParam = " and ";
            } else {
                reportEngineQry.append(")");
                firstParam = " and ";
            }
            if (reBean.getIncludeStatuses() != null && reBean.getIncludeStatuses().size() > 0) {
                reportEngineQry.append(firstParam + " voucher.status in( " + reBean.getCommaSeperatedValues(reBean.getIncludeStatuses()) + " )");
                firstParam = " and ";
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            throw new ApplicationRuntimeException(e.getMessage());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"-----------------------Engine Query-------------------");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)reportEngineQry.toString());
        }
        return reportEngineQry.toString();
    }

    private boolean checkNullandEmpty(String column) {
        return column != null && !column.isEmpty();
    }

    public ReportEngineBean populateReportEngineBean(GeneralLedgerReportBean reportBean) {
        ReportEngineBean reBean = new ReportEngineBean();
        reBean.setDepartmentId(reportBean.getDepartmentId());
        reBean.setDivisionId(reportBean.getFieldId());
        reBean.setFundId(reportBean.getFund_id());
        reBean.setFundsourceId(reportBean.getFundSource_id());
        reBean.setFunctionaryId(reportBean.getFunctionaryId());
        reBean.setFinacialYearId(null);
        reBean.setFiscalPeriodId(null);
        reBean.setFromDate(reportBean.getStartDate());
        reBean.setFromVoucherNumber(null);
        reBean.setFunctionId(reportBean.getFunctionCodeId());
        reBean.setSchemeId(null);
        reBean.setSubSchemeId(null);
        reBean.setToDate(reportBean.getEndDate());
        reBean.setToVoucherNumber(null);
        return reBean;
    }

    public AppConfigValueService getAppConfigValuesService() {
        return this.appConfigValuesService;
    }

    public void setAppConfigValuesService(AppConfigValueService appConfigValuesService) {
        this.appConfigValuesService = appConfigValuesService;
    }
}

