/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.eGov.src.common;

import com.exilant.exility.common.AbstractTask;
import com.exilant.exility.common.DataCollection;
import com.exilant.exility.common.TaskFailedException;
import com.exilant.exility.updateservice.PrimaryKeyGenerator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.CFiscalPeriod;
import org.egov.infra.persistence.utils.DBSequenceGenerator;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.utils.VoucherHelper;
import org.hibernate.SQLQuery;
import org.hibernate.exception.SQLGrammarException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service(value="eGovernCommon")
public class EGovernCommon
extends AbstractTask {
    private final SimpleDateFormat dtFormat = new SimpleDateFormat("dd-MMM-yyyy");
    private static final Logger LOGGER = Logger.getLogger(EGovernCommon.class);
    private static TaskFailedException taskExc;
    private static final String EXILRPERROR = "exilRPError";
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private DBSequenceGenerator dbSequenceGenerator;
    @Autowired
    private SequenceNumberGenerator sequenceNumberGenerator;

    @Override
    public void execute(String taskName, String gridName, DataCollection datacol, Connection con, boolean errorData, boolean gridHasCol, String prefix) throws TaskFailedException {
        datacol.addValue("voucherHeader_cgn", this.getCGNumber());
        if (datacol.getValue("hasSecondCGN").equalsIgnoreCase("true")) {
            datacol.addValue("jv_cgn", this.getCGNumber());
        }
        datacol.addValue("databaseDate", this.getCurrentDate());
    }

    public long getCGNumber() {
        return PrimaryKeyGenerator.getNextKey("voucherheader");
    }

    public String getCurrentDate() throws TaskFailedException {
        return new SimpleDateFormat("dd/MM/yyyy").format(new java.util.Date());
    }

    public List getFormFields(DataCollection datacol) {
        Set formSet = datacol.values.keySet();
        ArrayList formList = new ArrayList();
        Iterator itr = formSet.iterator();
        while (itr.hasNext()) {
            formList.add(itr.next());
        }
        return formList;
    }

    public String formatString(String strToFormat) {
        if (strToFormat != null) {
            if (strToFormat.equalsIgnoreCase("")) {
                return " ";
            }
            String valn1 = strToFormat.replaceAll("\n", " ");
            String formtStr = valn1.replaceAll("\r", " ");
            return formtStr.replaceAll("'", "''");
        }
        return " ";
    }

    @Deprecated
    public String getCurrentDateTime() throws TaskFailedException {
        return new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(Calendar.getInstance().getTime());
    }

    public String getEg_Voucher(String vouType, String fiscalPeriodIdStr) throws TaskFailedException, Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)" In EGovernCommon :getEg_Voucher method ");
        }
        CFiscalPeriod fiscalPeriod = (CFiscalPeriod)this.persistenceService.find("from CFiscalPeriod where id=?", new Object[]{Long.parseLong(fiscalPeriodIdStr)});
        BigInteger cgvn = null;
        String sequenceName = "";
        try {
            sequenceName = VoucherHelper.sequenceNameFor(vouType, fiscalPeriod.getName());
            cgvn = (BigInteger)this.sequenceNumberGenerator.getNextSequence(sequenceName);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("----- CGVN : " + cgvn));
            }
        }
        catch (SQLGrammarException e) {
            cgvn = (BigInteger)this.dbSequenceGenerator.createAndGetNextSequence(sequenceName);
            LOGGER.error((Object)("Error in generating CGVN" + (Object)((Object)e)));
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error in generating CGVN" + e));
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        return cgvn.toString();
    }

    public String getEffectiveDateFilter(String val) throws TaskFailedException, Exception {
        String returnVal = "";
        if (val == null) {
            returnVal = this.getCurrentDateTime();
            returnVal = " and TO_DATE(TO_CHAR(vh.effectivedate,'dd-Mon-yyyy HH24:MI:SS'),'dd-Mon-yyyy HH24:MI:SS')< TO_DATE('" + returnVal + "','dd-Mon-yyyy HH24:MI:SS')";
        } else {
            returnVal = " and TO_DATE(TO_CHAR(vh.effectivedate,'dd-Mon-yyyy HH24:MI:SS'),'dd-Mon-yyyy HH24:MI:SS')< TO_DATE('" + val + "','dd-Mon-yyyy HH24:MI:SS')";
        }
        return returnVal;
    }

    public String getCurDateTime() throws TaskFailedException, Exception {
        return new SimpleDateFormat("dd-Mon-yyyy HH:mm:ss").format(new java.util.Date());
    }

    public String getBillNumber() throws TaskFailedException, Exception {
        throw new TaskFailedException("Method Not Supported Exception");
    }

    public String getFiscalPeriod(String vDate) throws TaskFailedException {
        BigInteger fiscalPeriod = null;
        String sql = "select id from fiscalperiod  where '" + vDate + "' between startingdate and endingdate";
        try {
            SQLQuery pst = this.persistenceService.getSession().createSQLQuery(sql);
            List rset = pst.list();
            fiscalPeriod = rset != null ? (BigInteger)rset.get(0) : BigInteger.ZERO;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception..." + e.getMessage()));
            throw new TaskFailedException(e.getMessage());
        }
        return fiscalPeriod.toString();
    }

    public boolean isUniqueVN(String vcNum, String vcDate, DataCollection datacol) throws TaskFailedException, Exception {
        boolean isUnique = false;
        vcNum = vcNum.toUpperCase();
        SQLQuery pst = null;
        List rs = null;
        String fyEndDate = "";
        try {
            String query1 = "SELECT to_char(startingDate, 'DD-Mon-YYYY') AS \"startingDate\", to_char(endingDate, 'DD-Mon-YYYY') AS \"endingDate\" FROM financialYear WHERE startingDate <= '" + vcDate + "' AND endingDate >= '" + vcDate + "'";
            pst = this.persistenceService.getSession().createSQLQuery(query1);
            rs = pst.list();
            for (Object[] element : rs) {
                element[0].toString();
                fyEndDate = element[1].toString();
            }
            String query2 = "SELECT id FROM voucherHeader WHERE voucherNumber = '" + vcNum + "' AND voucherDate>='" + vcDate + "' AND voucherDate<='" + fyEndDate + "' and status!=4";
            pst = this.persistenceService.getSession().createSQLQuery(query2);
            rs = pst.list();
            for (Object[] element : rs) {
                datacol.addMessage(EXILRPERROR, "duplicate voucher number");
            }
            if (rs == null || rs.size() == 0) {
                isUnique = true;
            }
        }
        catch (Exception ex) {
            datacol.addMessage(EXILRPERROR, "DataBase Error(isUniqueVN) : " + ex.toString());
            throw new TaskFailedException();
        }
        return isUnique;
    }

    public boolean isUniqueVN(String vcNum, String vcDate) throws Exception, TaskFailedException {
        boolean isUnique = false;
        String fyStartDate = "";
        String fyEndDate = "";
        vcNum = vcNum.toUpperCase();
        SQLQuery pst = null;
        List rs = null;
        try {
            String query1 = "SELECT to_char(startingDate, 'DD-Mon-YYYY') AS \"startingDate\", to_char(endingDate, 'DD-Mon-YYYY') AS \"endingDate\" FROM financialYear WHERE startingDate <= '" + vcDate + "' AND endingDate >= '" + vcDate + "'";
            pst = this.persistenceService.getSession().createSQLQuery(query1);
            rs = pst.list();
            if (rs != null && rs.size() > 0) {
                for (Object[] element : rs) {
                    fyStartDate = element[0].toString();
                    fyEndDate = element[1].toString();
                }
            }
            String query2 = "SELECT id FROM voucherHeader WHERE voucherNumber = '" + vcNum + "' AND voucherDate>='" + fyStartDate + "' AND voucherDate<='" + fyEndDate + "' and status!=4";
            pst = this.persistenceService.getSession().createSQLQuery(query2);
            rs = pst.list();
            if (rs != null && rs.size() > 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Duplicate Voucher Number");
                }
            } else {
                isUnique = true;
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"error in finding unique VoucherNumber");
            throw taskExc;
        }
        return isUnique;
    }

    public BigDecimal getAccountBalance(java.util.Date VoucherDate, String bankAccountId) throws TaskFailedException {
        BigDecimal totalAvailable = BigDecimal.ZERO;
        BigDecimal opeAvailable = BigDecimal.ZERO;
        SQLQuery pst = null;
        List resultset = null;
        List resultset1 = null;
        try {
            SimpleDateFormat formatter = this.dtFormat;
            String vcDate = formatter.format(VoucherDate);
            String str = "SELECT case when sum(openingDebitBalance) = null then 0 else sum(openingDebitBalance) end-  case when sum(openingCreditBalance) = null  then 0 else sum(openingCreditBalance) end AS \"openingBalance\" FROM transactionSummary WHERE financialYearId=( SELECT id FROM financialYear WHERE startingDate <=?AND endingDate >= ?)  AND glCodeId =(select glcodeid from bankaccount where id=?)";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"getAccountBalance(EGovernCommon.java): SELECT case when sum(openingDebitBalance) = null then 0 else sum(openingDebitBalance) end-  case when sum(openingCreditBalance) = null  then 0 else sum(openingCreditBalance) end AS \"openingBalance\" FROM transactionSummary WHERE financialYearId=( SELECT id FROM financialYear WHERE startingDate <=?AND endingDate >= ?)  AND glCodeId =(select glcodeid from bankaccount where id=?)");
            }
            pst = this.persistenceService.getSession().createSQLQuery("SELECT case when sum(openingDebitBalance) = null then 0 else sum(openingDebitBalance) end-  case when sum(openingCreditBalance) = null  then 0 else sum(openingCreditBalance) end AS \"openingBalance\" FROM transactionSummary WHERE financialYearId=( SELECT id FROM financialYear WHERE startingDate <=?AND endingDate >= ?)  AND glCodeId =(select glcodeid from bankaccount where id=?)");
            pst.setString(0, vcDate);
            pst.setString(1, vcDate);
            pst.setString(2, bankAccountId);
            resultset = pst.list();
            for (Object[] element : resultset) {
                opeAvailable = new BigDecimal(element[0].toString());
            }
            if ((resultset == null || resultset.size() == 0) && LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Else resultset in getbalance");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("opening balance  " + opeAvailable));
            }
            String str1 = "SELECT (case when sum(gl.debitAmount) = null then 0 else sum(gl.debitAmount) end) - (case when sum(gl.creditAmount) = null then 0 else sum(gl.creditAmount) end) + " + opeAvailable + " as \"totalAmount\" FROM   generalLedger gl, voucherHeader vh WHERE vh.id = gl.voucherHeaderId AND gl.glCodeid = (select glcodeid from bankaccount where id=?) AND  " + " vh.voucherDate >=( SELECT TO_CHAR(startingDate, 'dd-Mon-yyyy') FROM financialYear WHERE startingDate <= ? AND endingDate >= ?) AND vh.voucherDate <= ? and vh.status!=4";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Curr Yr Bal: " + str1));
            }
            pst = this.persistenceService.getSession().createSQLQuery(str1);
            pst.setString(0, bankAccountId);
            pst.setString(1, vcDate);
            pst.setString(2, vcDate);
            pst.setString(3, vcDate);
            resultset1 = pst.list();
            for (Object[] element : resultset1) {
                totalAvailable = new BigDecimal(element[0].toString());
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("total balance  " + totalAvailable));
            }
            if ((resultset1 == null || resultset1.size() == 0) && LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Else resultset in getbalance...");
            }
            totalAvailable = totalAvailable.setScale(2, 4);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("total balance before return " + totalAvailable));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw taskExc;
        }
        return totalAvailable;
    }

    public String assignValue(String data, String defaultValue) {
        if (StringUtils.isNotBlank((String)data)) {
            return "'" + this.trimChar(this.formatString(data), "'".charAt(0)) + "'";
        }
        if (StringUtils.isNotBlank((String)defaultValue)) {
            return "'" + this.trimChar(defaultValue, "'".charAt(0)) + "'";
        }
        return defaultValue;
    }

    public BigDecimal getAccountBalance(String recDate, String bankAccountId) throws TaskFailedException {
        BigDecimal opeAvailable = BigDecimal.ZERO;
        BigDecimal totalAvailable = BigDecimal.ZERO;
        SQLQuery pst = null;
        Object resultset = null;
        List resultset1 = null;
        try {
            String str = "SELECT case when sum(openingDebitBalance) is null then 0 else sum(openingDebitBalance) end - case when sum(openingCreditBalance) is null then 0 else sum(openingCreditBalance) end AS \"openingBalance\"  FROM transactionSummary WHERE financialYearId=( SELECT id FROM financialYear WHERE startingDate <=?  AND endingDate >=? )  AND glCodeId =(select glcodeid from bankaccount where id=? )";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"getAccountBalance(EGovernCommon.java): SELECT case when sum(openingDebitBalance) is null then 0 else sum(openingDebitBalance) end - case when sum(openingCreditBalance) is null then 0 else sum(openingCreditBalance) end AS \"openingBalance\"  FROM transactionSummary WHERE financialYearId=( SELECT id FROM financialYear WHERE startingDate <=?  AND endingDate >=? )  AND glCodeId =(select glcodeid from bankaccount where id=? )");
            }
            pst = this.persistenceService.getSession().createSQLQuery("SELECT case when sum(openingDebitBalance) is null then 0 else sum(openingDebitBalance) end - case when sum(openingCreditBalance) is null then 0 else sum(openingCreditBalance) end AS \"openingBalance\"  FROM transactionSummary WHERE financialYearId=( SELECT id FROM financialYear WHERE startingDate <=?  AND endingDate >=? )  AND glCodeId =(select glcodeid from bankaccount where id=? )");
            SimpleDateFormat dtSlashFormat = new SimpleDateFormat("dd/MMM/yyyy");
            java.util.Date reconDate = dtSlashFormat.parse(recDate);
            Date sDate = new Date(reconDate.getTime());
            pst.setDate(0, (java.util.Date)sDate);
            pst.setDate(1, (java.util.Date)sDate);
            pst.setInteger(2, Integer.valueOf(bankAccountId).intValue());
            List list = pst.list();
            if ((list == null || list.size() == 0) && LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Else resultset in getAccountBalance...");
            }
            if (list != null || list.size() > 0) {
                opeAvailable = new BigDecimal(list.get(0).toString());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("opening balance  " + opeAvailable));
            }
            String str1 = "SELECT (case when sum(gl.debitAmount) is null then 0 else sum(gl.debitAmount) end - case when sum(gl.creditAmount)  is null then 0 else sum(gl.creditAmount) end ) + " + opeAvailable + " as \"totalAmount\" FROM   generalLedger gl, voucherHeader vh WHERE vh.id = gl.voucherHeaderId and gl.glCodeid = (select glcodeid from bankaccount where id=?) AND  " + " vh.voucherDate >=( SELECT startingDate FROM financialYear WHERE startingDate <= ? AND endingDate >= ?) AND vh.voucherDate <= ? and vh.status!=4";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Curr Yr Bal: " + str1));
            }
            pst = this.persistenceService.getSession().createSQLQuery(str1);
            pst.setInteger(0, Integer.valueOf(bankAccountId).intValue());
            pst.setDate(1, reconDate);
            pst.setDate(2, reconDate);
            pst.setDate(3, reconDate);
            List list2 = pst.list();
            if (list2 != null) {
                totalAvailable = new BigDecimal(list2.get(0).toString());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("total balance  " + totalAvailable));
            }
            if ((resultset1 == null || resultset1.size() == 0) && LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Else resultset in getAccountBalance...");
            }
            totalAvailable = totalAvailable.setScale(2, 4);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("total balance before return " + totalAvailable));
            }
            return totalAvailable;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw taskExc;
        }
    }

    public String trimChar(String str, char ch) {
        Boolean b = true;
        Boolean e = true;
        str = str.trim();
        while (str.length() > 0 && (b.booleanValue() || e.booleanValue())) {
            if (str.charAt(0) == ch) {
                str = str.substring(1, str.length());
            } else {
                b = false;
            }
            if (str.charAt(str.length() - 1) == ch) {
                str = str.substring(0, str.length() - 1);
                continue;
            }
            e = false;
        }
        return str;
    }

    public String getEGWStatusId(String moduleType, String description) throws TaskFailedException {
        String statusId = "0";
        SQLQuery pstmt = null;
        List rs = null;
        try {
            String sql = " select distinct id from egw_status where upper(moduletype)= ? and upper(description)= ? ";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"statement select distinct id from egw_status where upper(moduletype)= ? and upper(description)= ? ");
            }
            pstmt = this.persistenceService.getSession().createSQLQuery(" select distinct id from egw_status where upper(moduletype)= ? and upper(description)= ? ");
            pstmt.setString(0, moduleType.toUpperCase());
            pstmt.setString(1, description.toUpperCase());
            rs = pstmt.list();
            for (Object[] element : rs) {
                statusId = element[0].toString();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("$$$$$$$$$$$$$$$$$$$statusId===" + statusId));
            }
            if (statusId == null || statusId.equals("0")) {
                throw taskExc;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in getEGWStatusId=====:" + e.getMessage()));
            throw taskExc;
        }
        return statusId;
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }
}

