/*
 * Decompiled with CFR 0.152.
 */
package org.egov.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BudgetDetailConfig {
    private static final String DELIMITER = ",";
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    List<String> headerFields = new ArrayList<String>();
    List<String> gridFields = new ArrayList<String>();
    List<String> mandatoryFields = new ArrayList<String>();
    @Autowired
    private AppConfigValueService appConfigValueService;

    public final List<String> getGridFields() {
        return this.fetchAppConfigValues("budgetDetail.grid.component");
    }

    public final List<String> getMandatoryFields() {
        return this.fetchAppConfigValues("budgetDetail_mandatory_fields");
    }

    public final List<String> getHeaderFields() {
        return this.fetchAppConfigValues("budgetDetail.header.component");
    }

    final List<String> fetchAppConfigValues(String keyName) {
        Iterator iterator;
        List appConfigValues = this.appConfigValueService.getConfigValuesByModuleAndKey("EGF", keyName);
        if (appConfigValues != null && !appConfigValues.isEmpty() && (iterator = appConfigValues.iterator()).hasNext()) {
            AppConfigValues app = (AppConfigValues)iterator.next();
            return Arrays.asList(app.getValue().split(DELIMITER));
        }
        return new ArrayList<String>();
    }

    public final boolean shouldShowField(List<String> fieldList, String field) {
        return fieldList.isEmpty() || fieldList.contains(field);
    }

    public void checkHeaderMandatoryField(Map<String, Object> valuesToBeChecked) {
        for (Map.Entry<String, Object> entry : valuesToBeChecked.entrySet()) {
            if (!this.headerFields.contains(entry.getKey()) || !this.mandatoryFields.contains(entry.getKey()) || entry.getValue() != null) continue;
            throw new ValidationException(Arrays.asList(new ValidationError("budgetDetail." + entry.getKey() + ".mandatory", "budgetDetail." + entry.getKey() + ".mandatory")));
        }
    }

    public void checkGridMandatoryField(Map<String, Object> valuesToBeChecked) {
        for (Map.Entry<String, Object> entry : valuesToBeChecked.entrySet()) {
            if (!this.gridFields.contains(entry.getKey()) || !this.mandatoryFields.contains(entry.getKey()) || entry.getValue() != null) continue;
            throw new ValidationException(Arrays.asList(new ValidationError("budgetDetail." + entry.getKey() + ".mandatory", "budgetDetail." + entry.getKey() + ".mandatory")));
        }
    }
}

