/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.report;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Fund;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.egf.model.Statement;
import org.egov.egf.model.StatementEntry;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.services.PersistenceService;
import org.egov.services.report.BalanceSheetService;
import org.egov.services.report.ChartOfAccount;
import org.egov.services.report.ScheduleService;
import org.egov.services.report.Schedules;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BalanceSheetScheduleService
extends ScheduleService {
    private static final String BS = "BS";
    private static final String L = "L";
    private BalanceSheetService balanceSheetService;
    private String removeEntrysWithZeroAmount = "";
    private static final Logger LOGGER = Logger.getLogger(BalanceSheetScheduleService.class);
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private FinancialYearHibernateDAO financialYearDAO;

    public void setBalanceSheetService(BalanceSheetService balanceSheetService) {
        this.balanceSheetService = balanceSheetService;
    }

    public void populateDataForSchedule(Statement balanceSheet, String majorCode) {
        this.getAppConfigValueForRemoveEntrysWithZeroAmount();
        this.voucherStatusToExclude = this.getAppConfigValueFor("EGF", "statusexcludeReport");
        this.minorCodeLength = Integer.valueOf(this.balanceSheetService.getAppConfigValueFor("EGF", "coa_minorcode_length"));
        this.majorCodeLength = Integer.valueOf(this.balanceSheetService.getAppConfigValueFor("EGF", "coa_majorcode_length"));
        Date fromDate = this.balanceSheetService.getFromDate(balanceSheet);
        Date toDate = this.balanceSheetService.getToDate(balanceSheet);
        CChartOfAccounts coa = (CChartOfAccounts)this.find("from CChartOfAccounts where glcode=?", new Object[]{majorCode});
        List<Fund> fundList = balanceSheet.getFunds();
        this.populateCurrentYearAmountForSchedule(balanceSheet, fundList, this.balanceSheetService.getFilterQuery(balanceSheet), toDate, fromDate, majorCode, coa.getType());
        this.addCurrentOpeningBalancePerFund(balanceSheet, fundList, this.balanceSheetService.getTransactionQuery(balanceSheet));
        this.populatePreviousYearTotalsForSchedule(balanceSheet, this.balanceSheetService.getFilterQuery(balanceSheet), toDate, fromDate, majorCode, coa.getType());
        this.addOpeningBalanceForPreviousYear(balanceSheet, this.balanceSheetService.getTransactionQuery(balanceSheet), fromDate);
        this.balanceSheetService.addExcessIEForCurrentYear(balanceSheet, fundList, this.getGlcodeForPurposeCode7(), this.balanceSheetService.getFilterQuery(balanceSheet), toDate, fromDate);
        this.balanceSheetService.addExcessIEForPreviousYear(balanceSheet, fundList, this.getGlcodeForPurposeCode7(), this.balanceSheetService.getFilterQuery(balanceSheet), toDate, fromDate);
        this.balanceSheetService.removeFundsWithNoData(balanceSheet);
        this.balanceSheetService.computeCurrentYearTotals(balanceSheet, "LIABILITIES", "ASSETS");
        this.computeAndAddTotals(balanceSheet);
        if (this.removeEntrysWithZeroAmount.equalsIgnoreCase("Yes")) {
            this.balanceSheetService.removeScheduleEntrysWithZeroAmount(balanceSheet);
        }
    }

    public void addCurrentOpeningBalancePerFund(Statement balanceSheet, List<Fund> fundList, String transactionQuery) {
        BigDecimal divisor = balanceSheet.getDivisor();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"addCurrentOpeningBalancePerFund");
        }
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select sum(openingdebitbalance)- sum(openingcreditbalance),ts.fundid,coa.glcode,coa.type FROM transactionsummary ts,chartofaccounts coa  WHERE ts.glcodeid = coa.ID  AND ts.financialyearid=" + balanceSheet.getFinancialYear().getId() + transactionQuery + " GROUP BY ts.fundid,coa.glcode,coa.type");
        List openingBalanceAmountList = query.list();
        for (Object[] obj : openingBalanceAmountList) {
            if (obj[0] == null || obj[1] == null) continue;
            BigDecimal total = (BigDecimal)obj[0];
            if (L.equals(obj[3].toString())) {
                total = total.multiply(NEGATIVE);
            }
            for (StatementEntry entry : balanceSheet.getEntries()) {
                if (!obj[2].toString().equals(entry.getGlCode())) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(entry.getGlCode() + "==================" + total));
                }
                if (entry.getFundWiseAmount().isEmpty()) {
                    entry.getFundWiseAmount().put(this.balanceSheetService.getFundNameForId(fundList, new Integer(obj[1].toString())), this.balanceSheetService.divideAndRound(total, divisor));
                    continue;
                }
                boolean shouldAddNewFund = true;
                for (Map.Entry<String, BigDecimal> object : entry.getFundWiseAmount().entrySet()) {
                    if (!object.getKey().equalsIgnoreCase(this.balanceSheetService.getFundNameForId(fundList, new Integer(obj[1].toString())))) continue;
                    entry.getFundWiseAmount().put(object.getKey(), object.getValue().add(this.balanceSheetService.divideAndRound(total, divisor)));
                    shouldAddNewFund = false;
                }
                if (!shouldAddNewFund) continue;
                entry.getFundWiseAmount().put(this.balanceSheetService.getFundNameForId(fundList, new Integer(obj[1].toString())), this.balanceSheetService.divideAndRound(total, divisor));
            }
        }
    }

    public void addOpeningBalanceForPreviousYear(Statement balanceSheet, String transactionQuery, Date fromDate) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"addOpeningBalanceForPreviousYear");
        }
        BigDecimal divisor = balanceSheet.getDivisor();
        CFinancialYear prevFinanciaYr = this.financialYearDAO.getPreviousFinancialYearByDate(fromDate);
        String prevFinancialYrId = prevFinanciaYr.getId().toString();
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select sum(openingdebitbalance)- sum(openingcreditbalance),coa.glcode,coa.type FROM transactionsummary ts,chartofaccounts coa  WHERE ts.glcodeid = coa.ID  AND ts.financialyearid=" + prevFinancialYrId + transactionQuery + " GROUP BY coa.glcode,coa.type");
        List openingBalanceAmountList = query.list();
        for (Object[] obj : openingBalanceAmountList) {
            if (obj[0] == null || obj[1] == null) continue;
            BigDecimal total = (BigDecimal)obj[0];
            if (L.equals(obj[2].toString())) {
                total = total.multiply(NEGATIVE);
            }
            for (StatementEntry entry : balanceSheet.getEntries()) {
                BigDecimal prevYrTotal;
                if (!obj[1].toString().equals(entry.getGlCode())) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(entry.getGlCode() + "==================" + total));
                }
                prevYrTotal = (prevYrTotal = entry.getPreviousYearTotal()) == null ? BigDecimal.ZERO : prevYrTotal;
                entry.setPreviousYearTotal(prevYrTotal.add(this.balanceSheetService.divideAndRound(total, divisor)));
            }
        }
    }

    private String getGlcodeForPurposeCode7() {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select glcode from chartofaccounts where purposeid=7");
        List list = query.list();
        String glCode = "";
        if (list.get(0) != null) {
            glCode = list.get(0).toString();
        }
        return glCode;
    }

    private String getGlcodeForPurposeCode7MinorCode() {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select substr(glcode,1," + this.minorCodeLength + ") from chartofaccounts where purposeid=7");
        List list = query.list();
        String glCode = "";
        if (list.get(0) != null) {
            glCode = list.get(0).toString();
        }
        return glCode;
    }

    private String getGlcodeForPurposeCode7DetailedCode() {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select substr(glcode,1," + this.detailCodeLength + ") from chartofaccounts where purposeid=7");
        List list = query.list();
        String glCode = "";
        if (list.get(0) != null) {
            glCode = list.get(0).toString();
        }
        return glCode;
    }

    private void populatePreviousYearTotalsForSchedule(Statement balanceSheet, String filterQuery, Date toDate, Date fromDate, String majorCode, Character type) {
        String formattedToDate = "";
        if ("Yearly".equalsIgnoreCase(balanceSheet.getPeriod())) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(fromDate);
            cal.add(5, -1);
            formattedToDate = this.balanceSheetService.getFormattedDate(cal.getTime());
        } else {
            formattedToDate = this.balanceSheetService.getFormattedDate(this.balanceSheetService.getPreviousYearFor(toDate));
        }
        StringBuffer qry = new StringBuffer(512);
        qry.append("select sum(debitamount)-sum(creditamount),c.glcode from generalledger g,chartofaccounts c,voucherheader v   ");
        if (balanceSheet.getDepartment() != null && balanceSheet.getDepartment().getId() != -1L) {
            qry.append(", VoucherMis mis ");
        }
        qry.append(" where  v.id=g.voucherheaderid and c.id=g.glcodeid and v.status not in(" + this.voucherStatusToExclude + ") ");
        if (balanceSheet.getDepartment() != null && balanceSheet.getDepartment().getId() != -1L) {
            qry.append(" and v.id= mis.voucherheaderid ");
        }
        qry.append(" AND v.voucherdate <= '" + formattedToDate + "' and v.voucherdate >='" + this.balanceSheetService.getFormattedDate(this.balanceSheetService.getPreviousYearFor(fromDate)) + "' and c.glcode in (select distinct coad.glcode from chartofaccounts coa2, schedulemapping s ,chartofaccounts coad where s.id=coa2.scheduleid and coa2.classification=2 and s.reporttype = 'BS' and coa2.glcode=SUBSTR(coad.glcode,1," + this.minorCodeLength + ") and coad.classification=4 and coad.majorcode='" + majorCode + "')  and c.majorcode='" + majorCode + "' and c.classification=4 " + filterQuery + " group by c.glcode");
        SQLQuery query = this.persistenceService.getSession().createSQLQuery(qry.toString());
        List result = query.list();
        for (Object[] row : result) {
            for (int index = 0; index < balanceSheet.size(); ++index) {
                if (balanceSheet.get(index).getGlCode() == null || !row[1].toString().equalsIgnoreCase(balanceSheet.get(index).getGlCode())) continue;
                BigDecimal previousYearTotal = new BigDecimal(row[0].toString());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(row[1] + "-----------------------------------" + previousYearTotal));
                }
                if (L.equalsIgnoreCase(type.toString())) {
                    previousYearTotal = previousYearTotal.multiply(NEGATIVE);
                }
                previousYearTotal = this.balanceSheetService.divideAndRound(previousYearTotal, balanceSheet.getDivisor());
                balanceSheet.get(index).setPreviousYearTotal(previousYearTotal);
            }
        }
    }

    private void populateCurrentYearAmountForSchedule(Statement balanceSheet, List<Fund> fundList, String filterQuery, Date toDate, Date fromDate, String majorCode, Character type) {
        BigDecimal divisor = balanceSheet.getDivisor();
        List<Object[]> allGlCodes = this.getAllDetailGlCodesForSubSchedule(majorCode, type, BS);
        List<Object[]> resultMap = this.currentYearAmountQuery(filterQuery, toDate, fromDate, majorCode, BS);
        for (Object[] obj : allGlCodes) {
            if (!this.contains(resultMap, obj[0].toString())) {
                balanceSheet.add(new StatementEntry(obj[0].toString(), obj[1].toString(), "", BigDecimal.ZERO, BigDecimal.ZERO, false));
                continue;
            }
            List<Object[]> rowsForGlcode = this.getRowsForGlcode(resultMap, obj[0].toString());
            for (Object[] row : rowsForGlcode) {
                if (!balanceSheet.containsBalanceSheetEntry(row[2].toString())) {
                    StatementEntry balanceSheetEntry = new StatementEntry();
                    if (row[0] != null && row[1] != null) {
                        BigDecimal total = (BigDecimal)row[0];
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)(row[0] + "-----" + row[1] + "------------------------------" + total));
                        }
                        if (L.equalsIgnoreCase(type.toString())) {
                            total = total.multiply(NEGATIVE);
                        }
                        balanceSheetEntry.getFundWiseAmount().put(this.balanceSheetService.getFundNameForId(fundList, new Integer(row[1].toString())), this.balanceSheetService.divideAndRound(total, divisor));
                    }
                    if (row[2] != null) {
                        balanceSheetEntry.setGlCode(row[2].toString());
                    }
                    balanceSheetEntry.setAccountName(obj[1].toString());
                    balanceSheet.add(balanceSheetEntry);
                    continue;
                }
                for (int index = 0; index < balanceSheet.size(); ++index) {
                    BigDecimal amount = this.balanceSheetService.divideAndRound((BigDecimal)row[0], divisor);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)(row[0] + "-----" + row[1] + "------------------------------" + amount));
                    }
                    if (L.equalsIgnoreCase(type.toString())) {
                        amount = amount.multiply(NEGATIVE);
                    }
                    if (balanceSheet.get(index).getGlCode() == null || !row[2].toString().equals(balanceSheet.get(index).getGlCode())) continue;
                    String fundNameForId = this.balanceSheetService.getFundNameForId(fundList, new Integer(row[1].toString()));
                    if (balanceSheet.get(index).getFundWiseAmount().get(fundNameForId) == null) {
                        balanceSheet.get(index).getFundWiseAmount().put(this.balanceSheetService.getFundNameForId(fundList, new Integer(row[1].toString())), amount);
                        continue;
                    }
                    balanceSheet.get(index).getFundWiseAmount().put(this.balanceSheetService.getFundNameForId(fundList, new Integer(row[1].toString())), balanceSheet.get(index).getFundWiseAmount().get(this.balanceSheetService.getFundNameForId(fundList, new Integer(row[1].toString()))).add(amount));
                }
            }
        }
    }

    public void populateDataForAllSchedulesDetailed(Statement balanceSheet) {
        this.getAppConfigValueForRemoveEntrysWithZeroAmount();
        this.voucherStatusToExclude = this.getAppConfigValueFor("EGF", "statusexcludeReport");
        this.minorCodeLength = Integer.valueOf(this.balanceSheetService.getAppConfigValueFor("EGF", "coa_minorcode_length"));
        this.majorCodeLength = Integer.valueOf(this.balanceSheetService.getAppConfigValueFor("EGF", "coa_majorcode_length"));
        this.detailCodeLength = Integer.valueOf(this.balanceSheetService.getAppConfigValueFor("EGF", "coa_detailcode_length"));
        Date fromDate = this.balanceSheetService.getFromDate(balanceSheet);
        Date toDate = this.balanceSheetService.getToDate(balanceSheet);
        List<Fund> fundList = balanceSheet.getFunds();
        this.populateCurrentYearAmountForAllSchedulesDetailed(balanceSheet, fundList, this.amountPerFundQueryForAllSchedulesDetailed(this.balanceSheetService.getFilterQuery(balanceSheet), toDate, fromDate, BS));
        this.addCurrentOpeningBalancePerFund(balanceSheet, fundList, this.balanceSheetService.getTransactionQuery(balanceSheet));
        this.populatePreviousYearTotalsForScheduleForAllSchedulesDetailed(balanceSheet, this.balanceSheetService.getFilterQuery(balanceSheet), toDate, fromDate);
        this.addOpeningBalanceForPreviousYear(balanceSheet, this.balanceSheetService.getTransactionQuery(balanceSheet), fromDate);
        this.balanceSheetService.addExcessIEForCurrentYear(balanceSheet, fundList, this.getGlcodeForPurposeCode7DetailedCode(), this.balanceSheetService.getFilterQuery(balanceSheet), toDate, fromDate);
        this.balanceSheetService.addExcessIEForPreviousYear(balanceSheet, fundList, this.getGlcodeForPurposeCode7DetailedCode(), this.balanceSheetService.getFilterQuery(balanceSheet), toDate, fromDate);
        this.balanceSheetService.removeFundsWithNoData(balanceSheet);
        this.balanceSheetService.computeCurrentYearTotals(balanceSheet, "LIABILITIES", "ASSETS");
        this.computeAndAddTotals(balanceSheet);
        this.computeAndAddTotalsForSchedules(balanceSheet);
        if (this.removeEntrysWithZeroAmount.equalsIgnoreCase("Yes")) {
            this.balanceSheetService.removeScheduleEntrysWithZeroAmount(balanceSheet);
        }
    }

    public void populateDataForAllSchedules(Statement balanceSheet) {
        this.getAppConfigValueForRemoveEntrysWithZeroAmount();
        this.voucherStatusToExclude = this.getAppConfigValueFor("EGF", "statusexcludeReport");
        this.minorCodeLength = Integer.valueOf(this.balanceSheetService.getAppConfigValueFor("EGF", "coa_minorcode_length"));
        this.majorCodeLength = Integer.valueOf(this.balanceSheetService.getAppConfigValueFor("EGF", "coa_majorcode_length"));
        this.detailCodeLength = Integer.valueOf(this.balanceSheetService.getAppConfigValueFor("EGF", "coa_detailcode_length"));
        Date fromDate = this.balanceSheetService.getFromDate(balanceSheet);
        Date toDate = this.balanceSheetService.getToDate(balanceSheet);
        List<Fund> fundList = balanceSheet.getFunds();
        this.populateCurrentYearAmountForAllSchedules(balanceSheet, fundList, this.amountPerFundQueryForAllSchedules(this.balanceSheetService.getFilterQuery(balanceSheet), toDate, fromDate, BS));
        this.addCurrentOpeningBalancePerFund(balanceSheet, fundList, this.balanceSheetService.getTransactionQuery(balanceSheet));
        this.populatePreviousYearTotalsForScheduleForAllSchedules(balanceSheet, this.balanceSheetService.getFilterQuery(balanceSheet), toDate, fromDate);
        this.addOpeningBalanceForPreviousYear(balanceSheet, this.balanceSheetService.getTransactionQuery(balanceSheet), fromDate);
        this.balanceSheetService.addExcessIEForCurrentYear(balanceSheet, fundList, this.getGlcodeForPurposeCode7MinorCode(), this.balanceSheetService.getFilterQuery(balanceSheet), toDate, fromDate);
        this.balanceSheetService.addExcessIEForPreviousYear(balanceSheet, fundList, this.getGlcodeForPurposeCode7MinorCode(), this.balanceSheetService.getFilterQuery(balanceSheet), toDate, fromDate);
        this.balanceSheetService.removeFundsWithNoData(balanceSheet);
        this.balanceSheetService.computeCurrentYearTotals(balanceSheet, "LIABILITIES", "ASSETS");
        this.computeAndAddTotals(balanceSheet);
        if (this.removeEntrysWithZeroAmount.equalsIgnoreCase("Yes")) {
            this.balanceSheetService.removeScheduleEntrysWithZeroAmount(balanceSheet);
        }
    }

    private void populatePreviousYearTotalsForScheduleForAllSchedules(Statement balanceSheet, String filterQuery, Date toDate, Date fromDate) {
        Date formattedToDate = null;
        BigDecimal divisor = balanceSheet.getDivisor();
        if ("Yearly".equalsIgnoreCase(balanceSheet.getPeriod())) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(fromDate);
            cal.add(5, -1);
            formattedToDate = cal.getTime();
        } else {
            formattedToDate = this.balanceSheetService.getPreviousYearFor(toDate);
        }
        List<Object[]> resultMap = this.amountPerFundQueryForAllSchedules(filterQuery, formattedToDate, this.balanceSheetService.getPreviousYearFor(fromDate), BS);
        List<Object[]> allGlCodes = this.getAllGlCodesForAllSchedule(BS, "('A','L')");
        for (Object[] obj : allGlCodes) {
            for (Object[] row : resultMap) {
                String glCode = row[2].toString();
                if (!glCode.substring(1, this.majorCodeLength).equals(obj[0].toString())) continue;
                String type = obj[3].toString();
                if (!balanceSheet.containsBalanceSheetEntry(row[2].toString())) {
                    this.addRowToStatement(balanceSheet, row, glCode);
                    continue;
                }
                for (int index = 0; index < balanceSheet.size(); ++index) {
                    BigDecimal amount = this.balanceSheetService.divideAndRound((BigDecimal)row[0], divisor);
                    if (L.equalsIgnoreCase(type)) {
                        amount = amount.multiply(NEGATIVE);
                    }
                    if (balanceSheet.get(index).getGlCode() == null || !row[2].toString().equals(balanceSheet.get(index).getGlCode())) continue;
                    BigDecimal prevYrTotal = balanceSheet.get(index).getPreviousYearTotal();
                    prevYrTotal = prevYrTotal == null ? BigDecimal.ZERO : prevYrTotal;
                    balanceSheet.get(index).setPreviousYearTotal(prevYrTotal.add(amount));
                }
            }
        }
    }

    private void populatePreviousYearTotalsForScheduleForAllSchedulesDetailed(Statement balanceSheet, String filterQuery, Date toDate, Date fromDate) {
        Date formattedToDate = null;
        BigDecimal divisor = balanceSheet.getDivisor();
        if ("Yearly".equalsIgnoreCase(balanceSheet.getPeriod())) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(fromDate);
            cal.add(5, -1);
            formattedToDate = cal.getTime();
        } else {
            formattedToDate = this.balanceSheetService.getPreviousYearFor(toDate);
        }
        List<Object[]> resultMap = this.amountPerFundQueryForAllSchedulesDetailed(filterQuery, formattedToDate, this.balanceSheetService.getPreviousYearFor(fromDate), BS);
        List<Object[]> allGlCodes = this.getAllGlCodesForAllSchedule(BS, "('A','L')");
        for (Object[] obj : allGlCodes) {
            for (Object[] row : resultMap) {
                String glCode = row[2].toString();
                if (!glCode.substring(1, this.majorCodeLength).equals(obj[0].toString())) continue;
                String type = obj[3].toString();
                if (!balanceSheet.containsBalanceSheetEntry(row[2].toString())) {
                    this.addRowToStatement(balanceSheet, row, glCode);
                    continue;
                }
                for (int index = 0; index < balanceSheet.size(); ++index) {
                    BigDecimal amount = this.balanceSheetService.divideAndRound((BigDecimal)row[0], divisor);
                    if (L.equalsIgnoreCase(type)) {
                        amount = amount.multiply(NEGATIVE);
                    }
                    if (balanceSheet.get(index).getGlCode() == null || !row[2].toString().equals(balanceSheet.get(index).getGlCode())) continue;
                    BigDecimal prevYrTotal = balanceSheet.get(index).getPreviousYearTotal();
                    prevYrTotal = prevYrTotal == null ? BigDecimal.ZERO : prevYrTotal;
                    balanceSheet.get(index).setPreviousYearTotal(prevYrTotal.add(amount));
                }
            }
        }
    }

    private void populateCurrentYearAmountForAllSchedules(Statement balanceSheet, List<Fund> fundList, List<Object[]> currentYearAmounts) {
        BigDecimal divisor = balanceSheet.getDivisor();
        Map<String, Schedules> scheduleToGlCodeMap = this.getScheduleToGlCodeMap(BS, "('A','L')");
        for (Map.Entry<String, Schedules> entry : scheduleToGlCodeMap.entrySet()) {
            String scheduleNumber = entry.getValue().scheduleNumber;
            String scheduleName = entry.getValue().scheduleName;
            String type = entry.getValue().chartOfAccount.size() > 0 ? entry.getValue().chartOfAccount.iterator().next().type : "";
            balanceSheet.add(new StatementEntry(scheduleNumber, scheduleName, "", null, null, true));
            for (Object[] row : currentYearAmounts) {
                String glCode = row[2].toString();
                if (!entry.getValue().contains(glCode)) continue;
                if (!balanceSheet.containsBalanceSheetEntry(glCode)) {
                    StatementEntry balanceSheetEntry = new StatementEntry();
                    if (row[0] != null && row[1] != null) {
                        BigDecimal total = (BigDecimal)row[0];
                        if (L.equalsIgnoreCase(type)) {
                            total = total.multiply(NEGATIVE);
                        }
                        balanceSheetEntry.getFundWiseAmount().put(this.balanceSheetService.getFundNameForId(fundList, new Integer(row[1].toString())), this.balanceSheetService.divideAndRound(total, divisor));
                    }
                    balanceSheetEntry.setGlCode(glCode);
                    balanceSheetEntry.setAccountName(entry.getValue().getCoaName(glCode));
                    balanceSheet.add(balanceSheetEntry);
                    continue;
                }
                for (int index = 0; index < balanceSheet.size(); ++index) {
                    BigDecimal amount = this.balanceSheetService.divideAndRound((BigDecimal)row[0], divisor);
                    if (L.equalsIgnoreCase(type)) {
                        amount = amount.multiply(NEGATIVE);
                    }
                    if (balanceSheet.get(index).getGlCode() == null || !row[2].toString().equals(balanceSheet.get(index).getGlCode())) continue;
                    String fundNameForId = this.balanceSheetService.getFundNameForId(fundList, new Integer(row[1].toString()));
                    if (balanceSheet.get(index).getFundWiseAmount().get(fundNameForId) == null) {
                        balanceSheet.get(index).getFundWiseAmount().put(fundNameForId, amount);
                        continue;
                    }
                    balanceSheet.get(index).getFundWiseAmount().put(fundNameForId, balanceSheet.get(index).getFundWiseAmount().get(fundNameForId).add(amount));
                }
            }
            for (ChartOfAccount s : entry.getValue().chartOfAccount) {
                if (balanceSheet.containsBalanceSheetEntry(s.glCode)) continue;
                StatementEntry balanceSheetEntry = new StatementEntry();
                balanceSheetEntry.setGlCode(s.glCode);
                balanceSheetEntry.setAccountName(s.name);
                balanceSheet.add(balanceSheetEntry);
            }
        }
    }

    private void populateCurrentYearAmountForAllSchedulesDetailed(Statement balanceSheet, List<Fund> fundList, List<Object[]> currentYearAmounts) {
        BigDecimal divisor = balanceSheet.getDivisor();
        Map<String, Schedules> scheduleToGlCodeMap = this.getScheduleToGlCodeMapDetailed(BS, "('A','L')");
        for (Map.Entry<String, Schedules> entry : scheduleToGlCodeMap.entrySet()) {
            String scheduleNumber = entry.getValue().scheduleNumber;
            String scheduleName = entry.getValue().scheduleName;
            String type = entry.getValue().chartOfAccount.size() > 0 ? entry.getValue().chartOfAccount.iterator().next().type : "";
            balanceSheet.add(new StatementEntry(scheduleNumber, scheduleName, "", null, null, true));
            for (Object[] row : currentYearAmounts) {
                String glCode = row[2].toString();
                if (!entry.getValue().contains(glCode)) continue;
                if (!balanceSheet.containsBalanceSheetEntry(glCode)) {
                    StatementEntry balanceSheetEntry = new StatementEntry();
                    if (row[0] != null && row[1] != null) {
                        BigDecimal total = (BigDecimal)row[0];
                        if (L.equalsIgnoreCase(type)) {
                            total = total.multiply(NEGATIVE);
                        }
                        balanceSheetEntry.getFundWiseAmount().put(this.balanceSheetService.getFundNameForId(fundList, new Integer(row[1].toString())), this.balanceSheetService.divideAndRound(total, divisor));
                    }
                    balanceSheetEntry.setGlCode(glCode);
                    balanceSheetEntry.setAccountName(entry.getValue().getCoaName(glCode));
                    balanceSheet.add(balanceSheetEntry);
                    continue;
                }
                for (int index = 0; index < balanceSheet.size(); ++index) {
                    BigDecimal amount = this.balanceSheetService.divideAndRound((BigDecimal)row[0], divisor);
                    if (L.equalsIgnoreCase(type)) {
                        amount = amount.multiply(NEGATIVE);
                    }
                    if (balanceSheet.get(index).getGlCode() == null || !row[2].toString().equals(balanceSheet.get(index).getGlCode())) continue;
                    String fundNameForId = this.balanceSheetService.getFundNameForId(fundList, new Integer(row[1].toString()));
                    if (balanceSheet.get(index).getFundWiseAmount().get(fundNameForId) == null) {
                        balanceSheet.get(index).getFundWiseAmount().put(fundNameForId, amount);
                        continue;
                    }
                    balanceSheet.get(index).getFundWiseAmount().put(fundNameForId, balanceSheet.get(index).getFundWiseAmount().get(fundNameForId).add(amount));
                }
            }
            for (ChartOfAccount s : entry.getValue().chartOfAccount) {
                if (balanceSheet.containsBalanceSheetEntry(s.glCode)) continue;
                StatementEntry balanceSheetEntry = new StatementEntry();
                balanceSheetEntry.setGlCode(s.glCode);
                balanceSheetEntry.setAccountName(s.name);
                balanceSheet.add(balanceSheetEntry);
            }
            balanceSheet.add(new StatementEntry("", "Schedule Total", "", null, null, true));
        }
    }

    private void getAppConfigValueForRemoveEntrysWithZeroAmount() {
        try {
            List configValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "Remove Entries With Zero Amount in Report");
            for (AppConfigValues appConfigVal : configValues) {
                this.removeEntrysWithZeroAmount = appConfigVal.getValue();
            }
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Appconfig value for remove entries with zero amount in report is not defined in the system");
        }
    }

    public String getRemoveEntrysWithZeroAmount() {
        return this.removeEntrysWithZeroAmount;
    }

    public void setRemoveEntrysWithZeroAmount(String removeEntrysWithZeroAmount) {
        this.removeEntrysWithZeroAmount = removeEntrysWithZeroAmount;
    }
}

