/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.es.dashboard;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.egov.egf.bean.dashboard.FinancialsDetailResponse;
import org.egov.egf.bean.dashboard.FinancialsDetailsRequest;
import org.egov.egf.es.utils.FinancialsDashBoardUtils;
import org.egov.infra.utils.StringUtils;
import org.egov.utils.FinancialConstants;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHits;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.stereotype.Service;

@Service
public class FinancialsDashboardService {
    private static final String DEBITAMOUNT = "gldebitamount";
    private static final String CREDITAMOUNT = "glcreditamount";
    private static final String OBDEBITAMOUNT = "openingdebitbalance";
    private static final String OBCREDITAMOUNT = "openingcreditbalance";
    private static final String INCOME = "I";
    private static final String EXPENSE = "E";
    private static final String ASSETS = "A";
    private static final String LIABILITIES = "L";
    private static final String DETAILED_CODE = "glcode";
    private static final String AGGRFIELD = "aggrField";
    private static final String OBAGGRFIELD = "obAggrField";
    private static final String CURRENT_YEAR = "currentYear";
    private static final String LAST_YEAR = "lastYear";
    private static final String FINANCIALYEAR = "financialyear";
    private static final String MAJOR_CODE = "majorcode";
    private static final String MINOR_CODE = "minorcode";
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    public List<FinancialsDetailResponse> getFinancialsData(FinancialsDetailsRequest financialsDetailsRequest, BoolQueryBuilder boolQuery, String aggrField) {
        return this.getfinDetails(financialsDetailsRequest, boolQuery, aggrField);
    }

    private List<FinancialsDetailResponse> getfinDetails(FinancialsDetailsRequest financialsDetailsRequest, BoolQueryBuilder boolQuery, String aggrField) {
        List<Object> result = new ArrayList();
        BoolQueryBuilder boolQry = boolQuery;
        if (StringUtils.isBlank((String)financialsDetailsRequest.getDetailedCode()) && StringUtils.isBlank((String)financialsDetailsRequest.getMajorCode()) && StringUtils.isBlank((String)financialsDetailsRequest.getMinorCode())) {
            String coaType = INCOME;
            Map<String, SearchResponse> finSearchResponse = this.getVoucherSearchResponse(financialsDetailsRequest, boolQry, coaType, aggrField);
            Map<String, FinancialsDetailResponse> resultMap = this.getResponse(financialsDetailsRequest, finSearchResponse, coaType, aggrField);
            coaType = EXPENSE;
            finSearchResponse = this.getVoucherSearchResponse(financialsDetailsRequest, boolQry, coaType, aggrField);
            resultMap = this.getFinalResponse(financialsDetailsRequest, finSearchResponse, resultMap, coaType, aggrField);
            coaType = LIABILITIES;
            finSearchResponse = this.getVoucherSearchResponse(financialsDetailsRequest, boolQry, coaType, aggrField);
            resultMap = this.getFinalResponse(financialsDetailsRequest, finSearchResponse, resultMap, coaType, aggrField);
            coaType = ASSETS;
            finSearchResponse = this.getVoucherSearchResponse(financialsDetailsRequest, boolQry, coaType, aggrField);
            resultMap = this.getFinalResponse(financialsDetailsRequest, finSearchResponse, resultMap, coaType, aggrField);
            result = this.getFinalListOfData(resultMap);
        } else if (financialsDetailsRequest.getDetailedCode().startsWith("1") || financialsDetailsRequest.getMajorCode().startsWith("1") || financialsDetailsRequest.getMinorCode().startsWith("1")) {
            String coaType = INCOME;
            Map<String, SearchResponse> finSearchResponse = this.getVoucherSearchResponse(financialsDetailsRequest, boolQuery, coaType, aggrField);
            Map<String, FinancialsDetailResponse> resultMap = this.getResponse(financialsDetailsRequest, finSearchResponse, coaType, aggrField);
            result = this.getFinalListOfData(resultMap);
        } else if (financialsDetailsRequest.getDetailedCode().startsWith("2") || financialsDetailsRequest.getMajorCode().startsWith("2") || financialsDetailsRequest.getMinorCode().startsWith("2")) {
            String coaType = EXPENSE;
            Map<String, SearchResponse> finSearchResponse = this.getVoucherSearchResponse(financialsDetailsRequest, boolQuery, coaType, aggrField);
            Map<String, FinancialsDetailResponse> resultMap = this.getResponse(financialsDetailsRequest, finSearchResponse, coaType, aggrField);
            result = this.getFinalListOfData(resultMap);
        } else if (financialsDetailsRequest.getDetailedCode().startsWith("3") || financialsDetailsRequest.getMajorCode().startsWith("3") || financialsDetailsRequest.getMinorCode().startsWith("3")) {
            String coaType = LIABILITIES;
            Map<String, SearchResponse> finSearchResponse = this.getVoucherSearchResponse(financialsDetailsRequest, boolQuery, coaType, aggrField);
            Map<String, FinancialsDetailResponse> resultMap = this.getResponse(financialsDetailsRequest, finSearchResponse, coaType, aggrField);
            result = this.getFinalListOfData(resultMap);
        } else if (financialsDetailsRequest.getDetailedCode().startsWith("4") || financialsDetailsRequest.getMajorCode().startsWith("4") || financialsDetailsRequest.getMinorCode().startsWith("4")) {
            String coaType = ASSETS;
            Map<String, SearchResponse> finSearchResponse = this.getVoucherSearchResponse(financialsDetailsRequest, boolQuery, coaType, aggrField);
            Map<String, FinancialsDetailResponse> resultMap = this.getResponse(financialsDetailsRequest, finSearchResponse, coaType, aggrField);
            result = this.getFinalListOfData(resultMap);
        }
        return result;
    }

    private Map<String, SearchResponse> getVoucherSearchResponse(FinancialsDetailsRequest financialsDetailsRequest, BoolQueryBuilder boolQuery, String coaType, String aggrField) {
        HashMap<String, SearchResponse> response = new HashMap<String, SearchResponse>();
        BoolQueryBuilder boolQry = boolQuery;
        if (!aggrField.equalsIgnoreCase(DETAILED_CODE) && !aggrField.equalsIgnoreCase(MAJOR_CODE) && !aggrField.equalsIgnoreCase(MINOR_CODE) && StringUtils.isBlank((String)financialsDetailsRequest.getDetailedCode()) && StringUtils.isBlank((String)financialsDetailsRequest.getMajorCode()) && StringUtils.isBlank((String)financialsDetailsRequest.getMinorCode())) {
            boolQry = this.prepareQuery(financialsDetailsRequest, coaType);
        }
        boolQry.filter((QueryBuilder)QueryBuilders.matchQuery((String)"voucherstatusid", (Object)FinancialConstants.CREATEDVOUCHERSTATUS));
        SearchResponse currentYearResponse = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"financialsvoucherdata"}).setQuery((QueryBuilder)boolQry).addAggregation((AbstractAggregationBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)AGGRFIELD).field(aggrField)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)DEBITAMOUNT).field(DEBITAMOUNT))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)CREDITAMOUNT).field(CREDITAMOUNT))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)"finRecordsCy").addField("distname").addField("ulbname").addField("ulbgrade").addField("regname").setSize(1))).execute().actionGet();
        response.put(CURRENT_YEAR, currentYearResponse);
        financialsDetailsRequest.setFromDate("");
        financialsDetailsRequest.setToDate("");
        if (!aggrField.equalsIgnoreCase(DETAILED_CODE) && !aggrField.equalsIgnoreCase(MAJOR_CODE) && !aggrField.equalsIgnoreCase(MINOR_CODE) && StringUtils.isBlank((String)financialsDetailsRequest.getDetailedCode()) && StringUtils.isBlank((String)financialsDetailsRequest.getMajorCode()) && StringUtils.isBlank((String)financialsDetailsRequest.getMinorCode())) {
            boolQry = this.prepareQuery(financialsDetailsRequest, coaType);
        }
        boolQry = FinancialsDashBoardUtils.prepareWhereClause(financialsDetailsRequest).filter((QueryBuilder)QueryBuilders.matchQuery((String)FINANCIALYEAR, (Object)financialsDetailsRequest.getLastFinancialYear()));
        boolQry.filter((QueryBuilder)QueryBuilders.matchQuery((String)"voucherstatusid", (Object)FinancialConstants.CREATEDVOUCHERSTATUS));
        SearchResponse lastYearResponse = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"financialsvoucherdata"}).setQuery((QueryBuilder)boolQry).addAggregation((AbstractAggregationBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)AGGRFIELD).field(aggrField)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)DEBITAMOUNT).field(DEBITAMOUNT))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)CREDITAMOUNT).field(CREDITAMOUNT))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)"finRecordsLy").addField("distname").addField("ulbname").addField("ulbgrade").addField("regname").setSize(1))).execute().actionGet();
        response.put(LAST_YEAR, lastYearResponse);
        return response;
    }

    private SearchResponse getOpeningBlncSearchResponse(BoolQueryBuilder boolQuery, String aggrField) {
        return (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"financialsobdata"}).setQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)OBAGGRFIELD).field(aggrField)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)OBDEBITAMOUNT).field(OBDEBITAMOUNT))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)OBCREDITAMOUNT).field(OBCREDITAMOUNT))).execute().actionGet();
    }

    private BoolQueryBuilder prepareQuery(FinancialsDetailsRequest financialsDetailsRequest, String coaType) {
        BoolQueryBuilder boolquery = new BoolQueryBuilder();
        if (INCOME.equalsIgnoreCase(coaType)) {
            boolquery = FinancialsDashBoardUtils.prepareWhereClause(financialsDetailsRequest).filter((QueryBuilder)QueryBuilders.prefixQuery((String)DETAILED_CODE, (String)"1"));
        }
        if (EXPENSE.equalsIgnoreCase(coaType)) {
            boolquery = FinancialsDashBoardUtils.prepareWhereClause(financialsDetailsRequest).filter((QueryBuilder)QueryBuilders.prefixQuery((String)DETAILED_CODE, (String)"2"));
        }
        if (LIABILITIES.equalsIgnoreCase(coaType)) {
            boolquery = FinancialsDashBoardUtils.prepareWhereClause(financialsDetailsRequest).filter((QueryBuilder)QueryBuilders.prefixQuery((String)DETAILED_CODE, (String)"3"));
        }
        if (ASSETS.equalsIgnoreCase(coaType)) {
            boolquery = FinancialsDashBoardUtils.prepareWhereClause(financialsDetailsRequest).filter((QueryBuilder)QueryBuilders.prefixQuery((String)DETAILED_CODE, (String)"4"));
        }
        return boolquery;
    }

    private List<FinancialsDetailResponse> getFinalListOfData(Map<String, FinancialsDetailResponse> resultMap) {
        ArrayList<FinancialsDetailResponse> list = new ArrayList<FinancialsDetailResponse>();
        if (!resultMap.isEmpty()) {
            for (FinancialsDetailResponse response : resultMap.values()) {
                list.add(response);
            }
        }
        return list;
    }

    private Map<String, FinancialsDetailResponse> getResponse(FinancialsDetailsRequest financialsDetailsRequest, Map<String, SearchResponse> finSearchResponse, String coaType, String aggrField) {
        HashMap<String, FinancialsDetailResponse> openingBalanceLiablity = new HashMap();
        HashMap<String, FinancialsDetailResponse> openingBalanceAssets = new HashMap();
        HashMap<String, FinancialsDetailResponse> finMap = new HashMap<String, FinancialsDetailResponse>();
        for (String key : finSearchResponse.keySet()) {
            StringTerms aggr;
            if (CURRENT_YEAR.equalsIgnoreCase(key)) {
                if (ASSETS.equalsIgnoreCase(coaType) || LIABILITIES.equalsIgnoreCase(coaType)) {
                    openingBalanceLiablity = this.getOpeningBalance(financialsDetailsRequest, null, LIABILITIES, CURRENT_YEAR);
                    openingBalanceAssets = this.getOpeningBalance(financialsDetailsRequest, null, ASSETS, CURRENT_YEAR);
                }
                aggr = (StringTerms)finSearchResponse.get(CURRENT_YEAR).getAggregations().get(AGGRFIELD);
                for (Terms.Bucket entry : aggr.getBuckets()) {
                    Sum aggrDebit = (Sum)entry.getAggregations().get(DEBITAMOUNT);
                    Sum aggrCredit = (Sum)entry.getAggregations().get(CREDITAMOUNT);
                    TopHits topHits = (TopHits)entry.getAggregations().get("finRecordsCy");
                    if (finMap.isEmpty()) continue;
                    FinancialsDetailResponse financialsDetails = (FinancialsDetailResponse)finMap.get(entry.getKeyAsString());
                    if (financialsDetails == null) {
                        financialsDetails = new FinancialsDetailResponse();
                    }
                    if (aggrField.equalsIgnoreCase(DETAILED_CODE) || aggrField.equalsIgnoreCase(MAJOR_CODE) || aggrField.equalsIgnoreCase(MINOR_CODE)) {
                        coaType = this.verifyCoaType(entry.getKeyAsString());
                    }
                    if (INCOME.equalsIgnoreCase(coaType)) {
                        financialsDetails.setCyIncomeDebitAmount(BigDecimal.valueOf(aggrDebit.getValue()).setScale(0, 4));
                        financialsDetails.setCyIncomeCreditAmount(BigDecimal.valueOf(aggrCredit.getValue()).setScale(0, 4));
                        financialsDetails.setCyIncomeNetAmount(financialsDetails.getCyIncomeCreditAmount().subtract(financialsDetails.getCyIncomeDebitAmount()));
                    } else if (EXPENSE.equalsIgnoreCase(coaType)) {
                        financialsDetails.setCyExpenseDebitAmount(BigDecimal.valueOf(aggrDebit.getValue()).setScale(0, 4));
                        financialsDetails.setCyExpenseCreditAmount(BigDecimal.valueOf(aggrCredit.getValue()).setScale(0, 4));
                        financialsDetails.setCyExpenseNetAmount(financialsDetails.getCyExpenseDebitAmount().subtract(financialsDetails.getCyExpenseCreditAmount()));
                    }
                    if (LIABILITIES.equalsIgnoreCase(coaType)) {
                        this.calculateNetLiabilityForCurrentYear(entry.getKeyAsString(), openingBalanceLiablity, aggrDebit, aggrCredit, financialsDetails);
                    } else if (ASSETS.equalsIgnoreCase(coaType)) {
                        this.calculateNetAssetForCurrentYear(entry.getKeyAsString(), openingBalanceAssets, aggrDebit, aggrCredit, financialsDetails);
                    }
                    financialsDetails.setCyIeNetAmount(financialsDetails.getCyIncomeNetAmount().subtract(financialsDetails.getCyExpenseNetAmount()));
                    financialsDetails.setLyIeNetAmount(financialsDetails.getLyIncomeNetAmount().subtract(financialsDetails.getLyExpenseNetAmount()));
                    financialsDetails.setCyAlNetAmount(financialsDetails.getCyLiabilitiesNetAmount().subtract(financialsDetails.getCyAssetsNetAmount()));
                    financialsDetails.setLyAlNetAmount(financialsDetails.getLyLiabilitiesNetAmount().subtract(financialsDetails.getLyAssetsNetAmount()));
                    FinancialsDashBoardUtils.setValues(entry.getKeyAsString(), financialsDetails, aggrField, this.setResponseDetails(topHits));
                    if (finMap.containsKey(entry.getKeyAsString())) {
                        finMap.remove(entry.getKeyAsString());
                        finMap.put(entry.getKeyAsString(), financialsDetails);
                        continue;
                    }
                    finMap.put(entry.getKeyAsString(), financialsDetails);
                }
                continue;
            }
            if (!LAST_YEAR.equalsIgnoreCase(key)) continue;
            if (ASSETS.equalsIgnoreCase(coaType) || LIABILITIES.equalsIgnoreCase(coaType)) {
                openingBalanceLiablity = this.getOpeningBalance(financialsDetailsRequest, null, LIABILITIES, LAST_YEAR);
                openingBalanceAssets = this.getOpeningBalance(financialsDetailsRequest, null, ASSETS, LAST_YEAR);
            }
            aggr = (StringTerms)finSearchResponse.get(LAST_YEAR).getAggregations().get(AGGRFIELD);
            for (Terms.Bucket entry : aggr.getBuckets()) {
                FinancialsDetailResponse financialsDetail = new FinancialsDetailResponse();
                Sum aggrDebit = (Sum)entry.getAggregations().get(DEBITAMOUNT);
                Sum aggrCredit = (Sum)entry.getAggregations().get(CREDITAMOUNT);
                String keyName = entry.getKeyAsString();
                TopHits topHits = (TopHits)entry.getAggregations().get("finRecordsLy");
                if (aggrField.equalsIgnoreCase(DETAILED_CODE) || aggrField.equalsIgnoreCase(MAJOR_CODE) || aggrField.equalsIgnoreCase(MINOR_CODE)) {
                    coaType = this.verifyCoaType(keyName);
                }
                if (INCOME.equalsIgnoreCase(coaType)) {
                    financialsDetail.setLyIncomeDebitAmount(BigDecimal.valueOf(aggrDebit.getValue()).setScale(0, 4));
                    financialsDetail.setLyIncomeCreditAmount(BigDecimal.valueOf(aggrCredit.getValue()).setScale(0, 4));
                    financialsDetail.setLyIncomeNetAmount(financialsDetail.getLyIncomeCreditAmount().subtract(financialsDetail.getLyIncomeDebitAmount()));
                } else if (EXPENSE.equalsIgnoreCase(coaType)) {
                    financialsDetail.setLyExpenseDebitAmount(BigDecimal.valueOf(aggrDebit.getValue()).setScale(0, 4));
                    financialsDetail.setLyExpenseCreditAmount(BigDecimal.valueOf(aggrCredit.getValue()).setScale(0, 4));
                    financialsDetail.setLyExpenseNetAmount(financialsDetail.getLyExpenseDebitAmount().subtract(financialsDetail.getLyExpenseCreditAmount()));
                }
                if (LIABILITIES.equalsIgnoreCase(coaType)) {
                    this.calculateNetLiabilityForLastYear(entry.getKeyAsString(), openingBalanceLiablity, aggrDebit, aggrCredit, financialsDetail);
                } else if (ASSETS.equalsIgnoreCase(coaType)) {
                    this.calculateNetAssetForLastYear(entry.getKeyAsString(), openingBalanceAssets, aggrDebit, aggrCredit, financialsDetail);
                }
                FinancialsDashBoardUtils.setValues(keyName, financialsDetail, aggrField, this.setResponseDetails(topHits));
                this.setFinancialsDetails(financialsDetailsRequest, financialsDetail);
                finMap.put(entry.getKeyAsString(), financialsDetail);
            }
        }
        return finMap;
    }

    private String verifyCoaType(String keyName) {
        String coaType = keyName.startsWith("1") ? INCOME : (keyName.startsWith("2") ? EXPENSE : (keyName.startsWith("3") ? LIABILITIES : ASSETS));
        return coaType;
    }

    private Map<String, FinancialsDetailResponse> getOpeningBalance(FinancialsDetailsRequest financialsDetailsRequest, BoolQueryBuilder query, String coaType, String financialYear) {
        HashMap<String, FinancialsDetailResponse> finList;
        block8: {
            String aggrField;
            BoolQueryBuilder boolQuery;
            block7: {
                boolQuery = query;
                aggrField = FinancialsDashBoardUtils.getOpeningBlncAggrGroupingField(financialsDetailsRequest);
                finList = new HashMap<String, FinancialsDetailResponse>();
                if (query == null) {
                    boolQuery = FinancialsDashBoardUtils.prepareOpeningBlncWhereClause(financialsDetailsRequest);
                }
                if (!CURRENT_YEAR.equalsIgnoreCase(financialYear)) break block7;
                boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)FINANCIALYEAR, (Object)financialsDetailsRequest.getCurrentFinancialYear()));
                SearchResponse openingBalncSearchResponse = this.getOpeningBlncSearchResponse(boolQuery, aggrField);
                StringTerms distAggr = (StringTerms)openingBalncSearchResponse.getAggregations().get(OBAGGRFIELD);
                for (Terms.Bucket entry : distAggr.getBuckets()) {
                    FinancialsDetailResponse financialsDetail = new FinancialsDetailResponse();
                    Sum debit = (Sum)entry.getAggregations().get(OBDEBITAMOUNT);
                    Sum credit = (Sum)entry.getAggregations().get(OBCREDITAMOUNT);
                    if (LIABILITIES.equalsIgnoreCase(coaType)) {
                        financialsDetail.setCyLiabilitiesOpbAmount(BigDecimal.valueOf(debit.getValue()).setScale(0, 4).subtract(BigDecimal.valueOf(credit.getValue()).setScale(0, 4)));
                    }
                    if (ASSETS.equalsIgnoreCase(coaType)) {
                        financialsDetail.setCyAssetsOpbAmount(BigDecimal.valueOf(debit.getValue()).setScale(0, 4).subtract(BigDecimal.valueOf(credit.getValue()).setScale(0, 4)));
                    }
                    finList.put(entry.getKeyAsString(), financialsDetail);
                }
                break block8;
            }
            if (!LAST_YEAR.equalsIgnoreCase(financialYear)) break block8;
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)FINANCIALYEAR, (Object)financialsDetailsRequest.getLastFinancialYear()));
            SearchResponse openingBalncSearchResponse = this.getOpeningBlncSearchResponse(boolQuery, aggrField);
            StringTerms distAggr = (StringTerms)openingBalncSearchResponse.getAggregations().get(OBAGGRFIELD);
            for (Terms.Bucket entry : distAggr.getBuckets()) {
                FinancialsDetailResponse financialsDetail = new FinancialsDetailResponse();
                Sum debit = (Sum)entry.getAggregations().get(OBDEBITAMOUNT);
                Sum credit = (Sum)entry.getAggregations().get(OBCREDITAMOUNT);
                if (LIABILITIES.equalsIgnoreCase(coaType)) {
                    financialsDetail.setLyLiabilitiesOpbAmount(BigDecimal.valueOf(debit.getValue()).setScale(0, 4).subtract(BigDecimal.valueOf(credit.getValue()).setScale(0, 4)));
                }
                if (ASSETS.equalsIgnoreCase(coaType)) {
                    financialsDetail.setLyAssetsOpbAmount(BigDecimal.valueOf(debit.getValue()).setScale(0, 4).subtract(BigDecimal.valueOf(credit.getValue()).setScale(0, 4)));
                }
                finList.put(entry.getKeyAsString(), financialsDetail);
            }
        }
        return finList;
    }

    private Map<String, FinancialsDetailResponse> getFinalResponse(FinancialsDetailsRequest financialsDetailsRequest, Map<String, SearchResponse> finSearchResponse, Map<String, FinancialsDetailResponse> result, String coaType, String aggrField) {
        HashMap<String, FinancialsDetailResponse> openingBalanceLiability = new HashMap();
        HashMap<String, FinancialsDetailResponse> openingBalanceAsset = new HashMap();
        HashMap<String, FinancialsDetailResponse> response = new HashMap<String, FinancialsDetailResponse>();
        for (String key : finSearchResponse.keySet()) {
            FinancialsDetailResponse finDetail;
            TopHits topHits;
            Sum aggrCredit;
            Sum aggrDebit;
            StringTerms aggr;
            if (CURRENT_YEAR.equalsIgnoreCase(key)) {
                aggr = (StringTerms)finSearchResponse.get(CURRENT_YEAR).getAggregations().get(AGGRFIELD);
                if (LIABILITIES.equalsIgnoreCase(coaType) || ASSETS.equalsIgnoreCase(coaType)) {
                    openingBalanceLiability = this.getOpeningBalance(financialsDetailsRequest, FinancialsDashBoardUtils.prepareOpeningBlncWhereClause(financialsDetailsRequest).filter((QueryBuilder)QueryBuilders.prefixQuery((String)DETAILED_CODE, (String)"3")), LIABILITIES, CURRENT_YEAR);
                    openingBalanceAsset = this.getOpeningBalance(financialsDetailsRequest, FinancialsDashBoardUtils.prepareOpeningBlncWhereClause(financialsDetailsRequest).filter((QueryBuilder)QueryBuilders.prefixQuery((String)DETAILED_CODE, (String)"4")), ASSETS, CURRENT_YEAR);
                }
                for (Terms.Bucket entry : aggr.getBuckets()) {
                    aggrDebit = (Sum)entry.getAggregations().get(DEBITAMOUNT);
                    aggrCredit = (Sum)entry.getAggregations().get(CREDITAMOUNT);
                    topHits = (TopHits)entry.getAggregations().get("finRecordsCy");
                    if (response.isEmpty()) continue;
                    finDetail = (FinancialsDetailResponse)response.get(entry.getKeyAsString());
                    if (aggrField.equalsIgnoreCase(DETAILED_CODE) || aggrField.equalsIgnoreCase(MAJOR_CODE) || aggrField.equalsIgnoreCase(MINOR_CODE)) {
                        coaType = this.verifyCoaType(entry.getKeyAsString());
                    }
                    if (finDetail == null) {
                        finDetail = new FinancialsDetailResponse();
                    }
                    if (EXPENSE.equalsIgnoreCase(coaType)) {
                        finDetail.setCyExpenseDebitAmount(BigDecimal.valueOf(aggrDebit.getValue()).setScale(0, 4));
                        finDetail.setCyExpenseCreditAmount(BigDecimal.valueOf(aggrCredit.getValue()).setScale(0, 4));
                        finDetail.setCyExpenseNetAmount(finDetail.getCyExpenseDebitAmount().subtract(finDetail.getCyExpenseCreditAmount()));
                        finDetail.setCyIeNetAmount(finDetail.getCyIncomeNetAmount().subtract(finDetail.getCyExpenseNetAmount()));
                    } else if (LIABILITIES.equalsIgnoreCase(coaType)) {
                        this.calculateNetLiabilityForCurrentYear(entry.getKeyAsString(), openingBalanceLiability, aggrDebit, aggrCredit, finDetail);
                    } else if (ASSETS.equalsIgnoreCase(coaType)) {
                        this.calculateNetAssetForCurrentYear(entry.getKeyAsString(), openingBalanceAsset, aggrDebit, aggrCredit, finDetail);
                    }
                    FinancialsDashBoardUtils.setValues(entry.getKeyAsString(), finDetail, aggrField, this.setResponseDetails(topHits));
                    if (response.containsKey(entry.getKeyAsString())) {
                        response.remove(entry.getKeyAsString());
                        response.put(entry.getKeyAsString(), finDetail);
                        continue;
                    }
                    response.put(entry.getKeyAsString(), finDetail);
                }
                continue;
            }
            if (!LAST_YEAR.equalsIgnoreCase(key)) continue;
            aggr = (StringTerms)finSearchResponse.get(LAST_YEAR).getAggregations().get(AGGRFIELD);
            if (LIABILITIES.equalsIgnoreCase(coaType) || ASSETS.equalsIgnoreCase(coaType)) {
                openingBalanceLiability = this.getOpeningBalance(financialsDetailsRequest, FinancialsDashBoardUtils.prepareOpeningBlncWhereClause(financialsDetailsRequest).filter((QueryBuilder)QueryBuilders.prefixQuery((String)DETAILED_CODE, (String)"3")), LIABILITIES, LAST_YEAR);
                openingBalanceAsset = this.getOpeningBalance(financialsDetailsRequest, FinancialsDashBoardUtils.prepareOpeningBlncWhereClause(financialsDetailsRequest).filter((QueryBuilder)QueryBuilders.prefixQuery((String)DETAILED_CODE, (String)"4")), ASSETS, LAST_YEAR);
            }
            for (Terms.Bucket entry : aggr.getBuckets()) {
                aggrDebit = (Sum)entry.getAggregations().get(DEBITAMOUNT);
                aggrCredit = (Sum)entry.getAggregations().get(CREDITAMOUNT);
                topHits = (TopHits)entry.getAggregations().get("finRecordsLy");
                if (result.isEmpty()) continue;
                finDetail = result.get(entry.getKeyAsString());
                if (finDetail == null) {
                    finDetail = new FinancialsDetailResponse();
                }
                if (aggrField.equalsIgnoreCase(DETAILED_CODE) || aggrField.equalsIgnoreCase(MAJOR_CODE) || aggrField.equalsIgnoreCase(MINOR_CODE)) {
                    coaType = this.verifyCoaType(entry.getKeyAsString());
                }
                if (EXPENSE.equalsIgnoreCase(coaType)) {
                    finDetail.setLyExpenseDebitAmount(BigDecimal.valueOf(aggrDebit.getValue()).setScale(0, 4));
                    finDetail.setLyExpenseCreditAmount(BigDecimal.valueOf(aggrCredit.getValue()).setScale(0, 4));
                    finDetail.setLyExpenseNetAmount(finDetail.getLyExpenseDebitAmount().subtract(finDetail.getLyExpenseCreditAmount()));
                    finDetail.setLyIeNetAmount(finDetail.getLyIncomeNetAmount().subtract(finDetail.getLyExpenseNetAmount()));
                } else if (LIABILITIES.equalsIgnoreCase(coaType)) {
                    this.calculateNetLiabilityForLastYear(entry.getKeyAsString(), openingBalanceLiability, aggrDebit, aggrCredit, finDetail);
                } else if (ASSETS.equalsIgnoreCase(coaType)) {
                    this.calculateNetAssetForLastYear(entry.getKeyAsString(), openingBalanceAsset, aggrDebit, aggrCredit, finDetail);
                }
                FinancialsDashBoardUtils.setValues(entry.getKeyAsString(), finDetail, aggrField, this.setResponseDetails(topHits));
                if (response.containsKey(entry.getKeyAsString())) {
                    response.remove(entry.getKeyAsString());
                    response.put(entry.getKeyAsString(), finDetail);
                    continue;
                }
                response.put(entry.getKeyAsString(), finDetail);
            }
        }
        return response;
    }

    private FinancialsDetailResponse setResponseDetails(TopHits topHits) {
        FinancialsDetailResponse finResponse = new FinancialsDetailResponse();
        SearchHit[] hit = topHits.getHits().getHits();
        String district = (String)hit[0].field("distname").getValue();
        String ulbName = (String)hit[0].field("ulbname").getValue();
        String region = (String)hit[0].field("regname").getValue();
        String grade = (String)hit[0].field("ulbgrade").getValue();
        finResponse.setRegion(region);
        finResponse.setDistrict(district);
        finResponse.setGrade(grade);
        finResponse.setUlbName(ulbName);
        return finResponse;
    }

    private void calculateNetAssetForCurrentYear(String keyName, Map<String, FinancialsDetailResponse> openingBalanceAsset, Sum aggrDebit, Sum aggrCredit, FinancialsDetailResponse finDetail) {
        FinancialsDetailResponse finDetails = openingBalanceAsset.get(keyName);
        if (finDetail == null) {
            finDetail = new FinancialsDetailResponse();
        }
        if (finDetails != null) {
            finDetail.setCyAssetsDebitAmount(BigDecimal.valueOf(aggrDebit.getValue()).setScale(0, 4));
            finDetail.setCyAssetsCreditAmount(BigDecimal.valueOf(aggrCredit.getValue()).setScale(0, 4));
            finDetail.setCyAssetsNetAmount(finDetail.getCyAssetsDebitAmount().subtract(finDetail.getCyAssetsCreditAmount()).add(finDetails.getCyAssetsOpbAmount()));
            finDetail.setCyAlNetAmount(finDetail.getCyLiabilitiesNetAmount().subtract(finDetail.getCyAssetsNetAmount()));
            finDetail.setCyAssetsOpbAmount(finDetails.getCyAssetsOpbAmount());
        } else {
            finDetail.setCyAssetsDebitAmount(BigDecimal.valueOf(aggrDebit.getValue()).setScale(0, 4));
            finDetail.setCyAssetsCreditAmount(BigDecimal.valueOf(aggrCredit.getValue()).setScale(0, 4));
            finDetail.setCyAssetsNetAmount(finDetail.getCyAssetsDebitAmount().subtract(finDetail.getCyAssetsCreditAmount()).add(BigDecimal.ZERO));
            finDetail.setCyAlNetAmount(finDetail.getCyLiabilitiesNetAmount().subtract(finDetail.getCyAssetsNetAmount()));
            finDetail.setCyAssetsOpbAmount(BigDecimal.ZERO);
        }
    }

    private void calculateNetLiabilityForCurrentYear(String keyName, Map<String, FinancialsDetailResponse> openingBalanceLiability, Sum aggrDebit, Sum aggrCredit, FinancialsDetailResponse finDetail) {
        FinancialsDetailResponse finDetails = openingBalanceLiability.get(keyName);
        if (finDetail == null) {
            finDetail = new FinancialsDetailResponse();
        }
        if (finDetails != null) {
            finDetail.setCyLiabilitiesDebitAmount(BigDecimal.valueOf(aggrDebit.getValue()).setScale(0, 4));
            finDetail.setCyLiabilitiesCreditAmount(BigDecimal.valueOf(aggrCredit.getValue()).setScale(0, 4));
            finDetail.setCyLiabilitiesNetAmount(finDetail.getCyLiabilitiesCreditAmount().subtract(finDetail.getCyLiabilitiesDebitAmount()).add(finDetails.getCyLiabilitiesOpbAmount()).add(finDetail.getCyIeNetAmount()));
            finDetail.setCyLiabilitiesOpbAmount(finDetails.getCyLiabilitiesOpbAmount());
        } else {
            finDetail.setCyLiabilitiesDebitAmount(BigDecimal.valueOf(aggrDebit.getValue()).setScale(0, 4));
            finDetail.setCyLiabilitiesCreditAmount(BigDecimal.valueOf(aggrCredit.getValue()).setScale(0, 4));
            finDetail.setCyLiabilitiesNetAmount(finDetail.getCyLiabilitiesCreditAmount().subtract(finDetail.getCyLiabilitiesDebitAmount()).add(BigDecimal.ZERO).add(finDetail.getCyIeNetAmount()));
            finDetail.setCyLiabilitiesOpbAmount(BigDecimal.ZERO);
        }
    }

    private void calculateNetAssetForLastYear(String keyName, Map<String, FinancialsDetailResponse> openingBalanceAsset, Sum aggrDebit, Sum aggrCredit, FinancialsDetailResponse finDetail) {
        FinancialsDetailResponse finDetails = openingBalanceAsset.get(keyName);
        if (finDetail == null) {
            finDetail = new FinancialsDetailResponse();
        }
        if (finDetails != null) {
            finDetail.setLyAssetsDebitAmount(BigDecimal.valueOf(aggrDebit.getValue()).setScale(0, 4));
            finDetail.setLyAssetsCreditAmount(BigDecimal.valueOf(aggrCredit.getValue()).setScale(0, 4));
            finDetail.setLyAssetsNetAmount(finDetail.getLyAssetsDebitAmount().subtract(finDetail.getLyAssetsCreditAmount()).add(finDetails.getLyAssetsOpbAmount()));
            finDetail.setLyAlNetAmount(finDetail.getLyLiabilitiesNetAmount().subtract(finDetail.getLyAssetsNetAmount()));
            finDetail.setLyAssetsOpbAmount(finDetails.getLyAssetsOpbAmount());
        } else {
            finDetail.setLyAssetsDebitAmount(BigDecimal.valueOf(aggrDebit.getValue()).setScale(0, 4));
            finDetail.setLyAssetsCreditAmount(BigDecimal.valueOf(aggrCredit.getValue()).setScale(0, 4));
            finDetail.setLyAssetsNetAmount(finDetail.getLyAssetsDebitAmount().subtract(finDetail.getLyAssetsCreditAmount()).add(BigDecimal.ZERO));
            finDetail.setLyAlNetAmount(finDetail.getLyLiabilitiesNetAmount().subtract(finDetail.getLyAssetsNetAmount()));
            finDetail.setLyAssetsOpbAmount(BigDecimal.ZERO);
        }
    }

    private void calculateNetLiabilityForLastYear(String keyName, Map<String, FinancialsDetailResponse> openingBalanceLiability, Sum aggrDebit, Sum aggrCredit, FinancialsDetailResponse finDetail) {
        FinancialsDetailResponse finDetails = openingBalanceLiability.get(keyName);
        if (finDetail == null) {
            finDetail = new FinancialsDetailResponse();
        }
        if (finDetails != null) {
            finDetail.setLyLiabilitiesDebitAmount(BigDecimal.valueOf(aggrDebit.getValue()).setScale(0, 4));
            finDetail.setLyLiabilitiesCreditAmount(BigDecimal.valueOf(aggrCredit.getValue()).setScale(0, 4));
            finDetail.setLyLiabilitiesNetAmount(finDetail.getLyLiabilitiesCreditAmount().subtract(finDetail.getLyLiabilitiesDebitAmount()).add(finDetails.getLyLiabilitiesOpbAmount()).add(finDetail.getLyIeNetAmount()));
            finDetail.setLyLiabilitiesOpbAmount(finDetails.getLyLiabilitiesOpbAmount());
        } else {
            finDetail.setLyLiabilitiesDebitAmount(BigDecimal.valueOf(aggrDebit.getValue()).setScale(0, 4));
            finDetail.setLyLiabilitiesCreditAmount(BigDecimal.valueOf(aggrCredit.getValue()).setScale(0, 4));
            finDetail.setLyLiabilitiesNetAmount(finDetail.getLyLiabilitiesCreditAmount().subtract(finDetail.getLyLiabilitiesDebitAmount()).add(BigDecimal.ZERO).add(finDetail.getLyIeNetAmount()));
            finDetail.setLyLiabilitiesOpbAmount(BigDecimal.ZERO);
        }
    }

    private void setFinancialsDetails(FinancialsDetailsRequest financialsDetailsRequest, FinancialsDetailResponse financialsDetail) {
        if (StringUtils.isNotBlank((String)financialsDetailsRequest.getRegion())) {
            financialsDetail.setRegion(financialsDetailsRequest.getRegion());
        }
        if (StringUtils.isNotBlank((String)financialsDetailsRequest.getGrade())) {
            financialsDetail.setGrade(financialsDetailsRequest.getGrade());
        }
        if (StringUtils.isNotBlank((String)financialsDetailsRequest.getFromDate())) {
            financialsDetail.setFromDate(financialsDetailsRequest.getFromDate());
        }
        if (StringUtils.isNotBlank((String)financialsDetailsRequest.getToDate())) {
            financialsDetail.setToDate(financialsDetailsRequest.getToDate());
        }
        if (StringUtils.isNotBlank((String)financialsDetailsRequest.getFunctionCode())) {
            financialsDetail.setFunctionCode(financialsDetailsRequest.getFunctionCode());
        }
        if (StringUtils.isNotBlank((String)financialsDetailsRequest.getFundCode())) {
            financialsDetail.setFundCode(financialsDetailsRequest.getFundCode());
        }
        if (StringUtils.isNotBlank((String)financialsDetailsRequest.getFundSource())) {
            financialsDetail.setFundSource(financialsDetailsRequest.getFundSource());
        }
        if (StringUtils.isNotBlank((String)financialsDetailsRequest.getDepartmentCode())) {
            financialsDetail.setDepartmentCode(financialsDetailsRequest.getDepartmentCode());
        }
        if (StringUtils.isNotBlank((String)financialsDetailsRequest.getDetailedCode())) {
            financialsDetail.setDetailedCode(financialsDetailsRequest.getDetailedCode());
        }
        if (StringUtils.isNotBlank((String)financialsDetailsRequest.getSchemeCode())) {
            financialsDetail.setSchemeCode(financialsDetailsRequest.getSchemeCode());
        }
        if (StringUtils.isNotBlank((String)financialsDetailsRequest.getSubschemeCode())) {
            financialsDetail.setSubschemeCode(financialsDetailsRequest.getSubschemeCode());
        }
        if (StringUtils.isNotBlank((String)financialsDetailsRequest.getMajorCode())) {
            financialsDetail.setMajorCode(financialsDetailsRequest.getMajorCode());
        }
        if (StringUtils.isNotBlank((String)financialsDetailsRequest.getMinorCode())) {
            financialsDetail.setMinorCode(financialsDetailsRequest.getMinorCode());
        }
    }
}

