/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.closeperiod;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.egov.commons.CFinancialYear;
import org.egov.commons.service.CFinancialYearService;
import org.egov.commons.service.FinancialYearService;
import org.egov.egf.model.ClosedPeriod;
import org.egov.repository.closeperiod.ClosedPeriodRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ClosedPeriodService {
    @Autowired
    private final ClosedPeriodRepository closedPeriodRepository;
    private FinancialYearService financialYearService;
    @Autowired
    CFinancialYearService cFinancialYearService;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public ClosedPeriodService(ClosedPeriodRepository closedPeriodRepository) {
        this.closedPeriodRepository = closedPeriodRepository;
    }

    @Transactional
    public ClosedPeriod create(ClosedPeriod closedPeriod) {
        return (ClosedPeriod)this.closedPeriodRepository.save(closedPeriod);
    }

    @Transactional
    public ClosedPeriod update(ClosedPeriod closedPeriod) {
        List<ClosedPeriod> closePer = this.findAll();
        for (ClosedPeriod cp : closePer) {
            if (cp.getcFinancialYearId().getId() != closedPeriod.getcFinancialYearId().getId()) continue;
            this.closedPeriodRepository.delete(cp);
        }
        return (ClosedPeriod)this.closedPeriodRepository.save(closedPeriod);
    }

    @Transactional
    public void delete(ClosedPeriod closedPeriod) {
        this.closedPeriodRepository.delete(closedPeriod);
    }

    public List<ClosedPeriod> findAll() {
        return this.closedPeriodRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"cFinancialYearId"}));
    }

    public ClosedPeriod findOne(Long id) {
        List<ClosedPeriod> closePer = this.findAll();
        CFinancialYear c = this.cFinancialYearService.findOne(id);
        ClosedPeriod cc = new ClosedPeriod();
        for (ClosedPeriod cp : closePer) {
            if (cp.getcFinancialYearId().getId() != id) continue;
            cc.setIsClosed(cp.getIsClosed());
        }
        cc.setcFinancialYearId(c);
        return cc;
    }

    public List<ClosedPeriod> search(ClosedPeriod closedPeriod) {
        ClosedPeriod closedPeriodd = new ClosedPeriod();
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery createQuery = cb.createQuery(ClosedPeriod.class);
        Root closedPeriods = createQuery.from(ClosedPeriod.class);
        createQuery.select((Selection)closedPeriods);
        Metamodel m = this.entityManager.getMetamodel();
        EntityType ClosedPeriod_ = m.entity(ClosedPeriod.class);
        ArrayList predicates = new ArrayList();
        createQuery.where(predicates.toArray(new Predicate[0]));
        TypedQuery query = this.entityManager.createQuery(createQuery);
        if (closedPeriod.getcFinancialYearId() != null) {
            ClosedPeriod resultList1 = this.findOne(closedPeriod.getcFinancialYearId().getId());
            ArrayList<ClosedPeriod> resultList = new ArrayList<ClosedPeriod>();
            resultList.add(resultList1);
            return resultList;
        }
        List<ClosedPeriod> resultList = this.findAll();
        List findAll = this.cFinancialYearService.findAll();
        ArrayList<Long> finIds = new ArrayList<Long>();
        for (ClosedPeriod f : resultList) {
            finIds.add(f.getcFinancialYearId().getId());
        }
        for (ClosedPeriod f : findAll) {
            if (finIds.contains(f.getId())) continue;
            ClosedPeriod cp = new ClosedPeriod();
            cp.setcFinancialYearId((CFinancialYear)f);
            resultList.add(cp);
        }
        Collections.sort(resultList);
        return resultList;
    }
}

