/*
 * Decompiled with CFR 0.152.
 */
package org.egov.model.service;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.CChartOfAccounts;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.model.budget.BudgetGroup;
import org.egov.model.repository.BudgetingGroupRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;

@Service
@Transactional(readOnly=true)
public class BudgetingGroupService {
    private final BudgetingGroupRepository budgetGroupRepository;
    @Autowired
    private AppConfigValueService appConfigValueService;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource messageSource;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public BudgetingGroupService(BudgetingGroupRepository budgetGroupRepository) {
        this.budgetGroupRepository = budgetGroupRepository;
    }

    @Transactional
    public BudgetGroup create(BudgetGroup budgetGroup) {
        return (BudgetGroup)((Object)this.budgetGroupRepository.save((Object)budgetGroup));
    }

    @Transactional
    public BudgetGroup update(BudgetGroup budgetGroup) {
        return (BudgetGroup)((Object)this.budgetGroupRepository.save((Object)budgetGroup));
    }

    public List<BudgetGroup> findAll() {
        return this.budgetGroupRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public BudgetGroup findOne(Long id) {
        return (BudgetGroup)((Object)this.budgetGroupRepository.findOne(id));
    }

    public int getMajorCodeLength() {
        List appList = this.appConfigValueService.getConfigValuesByModuleAndKey("EGF", "coa_majorcode_length");
        return Integer.valueOf(((AppConfigValues)appList.get(0)).getValue());
    }

    public List<CChartOfAccounts> getMajorCodeList() {
        return this.budgetGroupRepository.findCOAByLength(this.getMajorCodeLength());
    }

    public List<BudgetGroup> getActiveBudgetGroups() {
        return this.budgetGroupRepository.findByIsActiveTrue();
    }

    public List<CChartOfAccounts> getMinCodeList() {
        String range = ((AppConfigValues)this.appConfigValueService.getConfigValuesByModuleAndKey("EGF", "budgetgroup_range_minor_or_detailed").get(0)).getValue();
        Integer minorCodeLength = 0;
        minorCodeLength = range.equalsIgnoreCase("minor") ? Integer.valueOf(((AppConfigValues)this.appConfigValueService.getConfigValuesByModuleAndKey("EGF", "coa_minorcode_length").get(0)).getValue()) : Integer.valueOf(((AppConfigValues)this.appConfigValueService.getConfigValuesByModuleAndKey("EGF", "coa_detailcode_length").get(0)).getValue());
        return this.budgetGroupRepository.findCOAByLength(minorCodeLength);
    }

    public String validate(BudgetGroup budgetGroup, BindingResult errors) {
        List bgList;
        String validationMessage = "";
        BudgetGroup bg = null;
        List<Object> bgCode = null;
        if (budgetGroup.getMajorCode() != null && budgetGroup.getId() == null) {
            bg = this.budgetGroupRepository.findByMajorCode_Id(budgetGroup.getMajorCode().getId());
        } else if (budgetGroup.getMajorCode() != null && budgetGroup.getId() != null) {
            bg = this.budgetGroupRepository.findByMajorCode_IdAndIdNotIn(budgetGroup.getMajorCode().getId(), budgetGroup.getId());
        }
        if (bg != null) {
            validationMessage = this.messageSource.getMessage("budgetgroup.invalid.majorcode", (Object[])new String[]{bg.getName()}, null);
        }
        if (!(bgCode = budgetGroup.getMinCode() != null && budgetGroup.getMaxCode() != null && budgetGroup.getId() == null ? this.budgetGroupRepository.findByMinCodeGlcodeLessThanEqualAndMaxCodeGlcodeGreaterThanEqual(budgetGroup.getMaxCode().getGlcode(), budgetGroup.getMinCode().getGlcode()) : (budgetGroup.getMinCode() != null && budgetGroup.getMaxCode() != null && budgetGroup.getId() != null ? this.budgetGroupRepository.findByMinCodeGlcodeLessThanEqualAndMaxCodeGlcodeGreaterThanEqualAndIdNotIn(budgetGroup.getMinCode().getGlcode(), budgetGroup.getMinCode().getGlcode(), budgetGroup.getId()) : Collections.emptyList())).isEmpty()) {
            validationMessage = this.messageSource.getMessage("budgetgroup.invalid.maxmincode", (Object[])new String[]{((BudgetGroup)((Object)bgCode.get(0))).getName()}, null, Locale.ENGLISH);
        }
        List<Object> list = bgList = budgetGroup.getMajorCode() != null ? this.budgetGroupRepository.getBudgetGroupForMappedMajorCode(budgetGroup.getMajorCode().getGlcode().length(), budgetGroup.getMajorCode().getGlcode()) : Collections.emptyList();
        if (!bgList.isEmpty()) {
            validationMessage = this.messageSource.getMessage("budgetgroup.invalid.majormincode", (Object[])new String[]{((BudgetGroup)((Object)bgList.get(0))).getName()}, null);
        }
        BudgetGroup budgetGroup2 = bg = budgetGroup.getMaxCode() != null ? this.budgetGroupRepository.getBudgetGroupForMinorCodesMajorCode(budgetGroup.getMaxCode().getGlcode().substring(0, this.getMajorCodeLength())) : null;
        if (bg != null) {
            validationMessage = this.messageSource.getMessage("budgetgroup.invalid.maxmajorcode", (Object[])new String[]{bg.getName()}, null, Locale.ENGLISH);
        }
        BudgetGroup budgetGroup3 = bg = budgetGroup.getMinCode() != null ? this.budgetGroupRepository.getBudgetGroupForMinorCodesMajorCode(budgetGroup.getMinCode().getGlcode().substring(0, this.getMajorCodeLength())) : null;
        if (bg != null) {
            validationMessage = this.messageSource.getMessage("budgetgroup.invalid.minmajorcode", (Object[])new String[]{bg.getName()}, null, Locale.ENGLISH);
        }
        return validationMessage;
    }

    public List<BudgetGroup> search(BudgetGroup budgetGroup) {
        if (budgetGroup.getName() != null) {
            return this.budgetGroupRepository.findBudgetGroupByNameLike(budgetGroup.getName());
        }
        return this.budgetGroupRepository.findAll();
    }
}

