/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.model;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class StatementEntry {
    private String glCode;
    private String accountName;
    private String scheduleNo;
    private String fundCode;
    private BigDecimal previousYearTotal = BigDecimal.ZERO;
    private BigDecimal currentYearTotal = BigDecimal.ZERO;
    private Map<String, BigDecimal> fundWiseAmount = new HashMap<String, BigDecimal>();
    private boolean displayBold = false;

    public boolean isDisplayBold() {
        return this.displayBold;
    }

    public void setDisplayBold(boolean displayBold) {
        this.displayBold = displayBold;
    }

    public StatementEntry() {
    }

    public void setGlCode(String accountCode) {
        this.glCode = accountCode;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public void setScheduleNo(String scheduleNo) {
        this.scheduleNo = scheduleNo;
    }

    public void setPreviousYearTotal(BigDecimal previousYearTotal) {
        this.previousYearTotal = previousYearTotal;
    }

    public void setCurrentYearTotal(BigDecimal currentYearTotal) {
        this.currentYearTotal = currentYearTotal;
    }

    public void setFundWiseAmount(Map<String, BigDecimal> fundWiseAmount) {
        this.fundWiseAmount = fundWiseAmount;
    }

    public StatementEntry(String accountCode, String accountName, String scheduleNo, BigDecimal previousYearTotal, BigDecimal currentYearTotal, boolean displayBold) {
        this.glCode = accountCode;
        this.accountName = accountName;
        this.scheduleNo = scheduleNo;
        this.previousYearTotal = previousYearTotal;
        this.currentYearTotal = currentYearTotal;
        this.displayBold = displayBold;
    }

    public StatementEntry(String accountCode, String accountName) {
        this.glCode = accountCode;
        this.accountName = accountName;
    }

    public StatementEntry(String accountName, Map<String, BigDecimal> fundWiseAmount, boolean displayBold) {
        this.accountName = accountName;
        this.fundWiseAmount = fundWiseAmount;
        this.displayBold = displayBold;
    }

    public String getGlCode() {
        return this.glCode;
    }

    public Map<String, BigDecimal> getFundWiseAmount() {
        return this.fundWiseAmount;
    }

    public void putFundWiseAmount(String fundName, BigDecimal amount) {
        this.fundWiseAmount.put(fundName, amount);
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getScheduleNo() {
        return this.scheduleNo;
    }

    public BigDecimal getPreviousYearTotal() {
        return this.previousYearTotal;
    }

    public BigDecimal getCurrentYearTotal() {
        return this.currentYearTotal;
    }

    public String getFundCode() {
        return this.fundCode;
    }

    public void setFundCode(String fundCode) {
        this.fundCode = fundCode;
    }
}

