/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.commons.bankaccount.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.egov.commons.Bankaccount;
import org.egov.commons.Bankbranch;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.service.ChartOfAccountsService;
import org.egov.egf.commons.bankaccount.repository.BankAccountRepository;
import org.egov.egf.commons.bankbranch.service.CreateBankBranchService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infstr.utils.EGovConfig;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CreateBankAccountService {
    private final String code = EGovConfig.getProperty((String)"egf_config.xml", (String)"glcodeMaxLength", (String)"", (String)"AccountCode");
    @PersistenceContext
    private EntityManager entityManager;
    private final BankAccountRepository bankAccountRepository;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    @Qualifier(value="chartOfAccountsService")
    private ChartOfAccountsService chartOfAccountsService;
    @Autowired
    private CreateBankBranchService createBankBranchService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public CreateBankAccountService(BankAccountRepository bankAccountRepository) {
        this.bankAccountRepository = bankAccountRepository;
    }

    public Bankaccount getById(Long id) {
        return (Bankaccount)this.bankAccountRepository.findOne(id);
    }

    public Bankaccount getByGlcode(String glcode) {
        return this.bankAccountRepository.findByChartofaccounts_Glcode(glcode);
    }

    public List<Bankaccount> getByBranchId(Integer branchId) {
        return this.bankAccountRepository.findByBankbranch_Id(branchId);
    }

    @Transactional
    public Bankaccount create(Bankaccount bankaccount) {
        if (this.autoBankAccountGLCodeEnabled().booleanValue()) {
            if (!bankaccount.getAccounttype().isEmpty()) {
                CChartOfAccounts coa = this.chartOfAccountsService.getByGlCode(bankaccount.getAccounttype().split("-")[0].trim());
                String newGLCode = this.prepareBankAccCode(bankaccount.getAccounttype().split("-")[0].trim(), this.code);
                Long coaID = this.postInChartOfAccounts(newGLCode, coa.getId(), bankaccount.getAccountnumber(), bankaccount.getBankbranch().getId());
                if (coaID != null) {
                    CChartOfAccounts chartofaccounts = this.chartOfAccountsService.getById(coaID);
                    bankaccount.setChartofaccounts(chartofaccounts);
                }
            }
        } else if (bankaccount.getChartofaccounts() != null && !bankaccount.getChartofaccounts().getGlcode().isEmpty()) {
            bankaccount.setChartofaccounts(this.chartOfAccountsService.getByGlCode(bankaccount.getChartofaccounts().getGlcode()));
        }
        bankaccount.setCreatedDate(new Date());
        bankaccount.setCreatedBy((User)this.getCurrentSession().load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
        return (Bankaccount)this.bankAccountRepository.save(bankaccount);
    }

    @Transactional
    public Bankaccount update(Bankaccount bankaccount) {
        bankaccount.setLastModifiedDate(new Date());
        bankaccount.setLastModifiedBy((User)this.getCurrentSession().load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
        return (Bankaccount)this.bankAccountRepository.save(bankaccount);
    }

    public List<Bankaccount> search(Bankaccount bankaccount) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery createQuery = cb.createQuery(Bankaccount.class);
        Root bankaccounts = createQuery.from(Bankaccount.class);
        createQuery.select((Selection)bankaccounts);
        Metamodel m = this.entityManager.getMetamodel();
        EntityType tempBankaccount = m.entity(Bankaccount.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (bankaccount.getAccountnumber() != null) {
            String accountnumber = "%" + bankaccount.getAccountnumber().toLowerCase() + "%";
            predicates.add(cb.isNotNull((Expression)bankaccounts.get("accountnumber")));
            predicates.add(cb.like(cb.lower((Expression)bankaccounts.get(tempBankaccount.getDeclaredSingularAttribute("accountnumber", String.class))), accountnumber));
        }
        if (bankaccount.getFund() != null && bankaccount.getFund().getId() != null) {
            predicates.add(cb.equal((Expression)bankaccounts.get("fund").get("id"), (Object)bankaccount.getFund().getId()));
        }
        if (bankaccount.getBankbranch() != null && bankaccount.getBankbranch().getBank() != null) {
            predicates.add(cb.equal((Expression)bankaccounts.get("bankbranch").get("bank").get("id"), (Object)bankaccount.getBankbranch().getBank().getId()));
        }
        if (bankaccount.getBankbranch() != null && bankaccount.getBankbranch().getId() != null) {
            predicates.add(cb.equal((Expression)bankaccounts.get("bankbranch").get("id"), (Object)bankaccount.getBankbranch().getId()));
        }
        if (bankaccount.getChartofaccounts() != null && bankaccount.getChartofaccounts().getGlcode() != null) {
            predicates.add(cb.equal((Expression)bankaccounts.get("chartofaccounts").get("glcode"), (Object)bankaccount.getChartofaccounts().getGlcode()));
        }
        if (bankaccount.getAccounttype() != null) {
            predicates.add(cb.equal((Expression)bankaccounts.get("accounttype"), (Object)bankaccount.getAccounttype()));
        }
        if (bankaccount.getPayTo() != null) {
            predicates.add(cb.equal((Expression)bankaccounts.get("payTo"), (Object)bankaccount.getPayTo()));
        }
        if (bankaccount.getType() != null) {
            predicates.add(cb.equal((Expression)bankaccounts.get("type"), (Object)bankaccount.getType()));
        }
        if (bankaccount.getNarration() != null) {
            predicates.add(cb.equal((Expression)bankaccounts.get("narration"), (Object)bankaccount.getNarration()));
        }
        if (bankaccount.getIsactive().booleanValue()) {
            predicates.add(cb.equal((Expression)bankaccounts.get("isactive"), (Object)true));
        }
        createQuery.where(predicates.toArray(new Predicate[0]));
        TypedQuery query = this.entityManager.createQuery(createQuery);
        return query.getResultList();
    }

    public Boolean autoBankAccountGLCodeEnabled() {
        AppConfigValues appConfigValue = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "auto_bankaccount_glcode").get(0);
        return "YES".equalsIgnoreCase(appConfigValue.getValue());
    }

    public String prepareBankAccCode(String glCode, String code) {
        Long tempCode;
        String subminorvalue = EGovConfig.getProperty((String)"egf_config.xml", (String)"subminorvalue", (String)"", (String)"AccountCode");
        String newGlCode = glCode.substring(0, Integer.parseInt(subminorvalue));
        CChartOfAccounts coa = this.chartOfAccountsService.getByGlCodeDesc(newGlCode);
        newGlCode = coa.getGlcode();
        String zero = EGovConfig.getProperty((String)"egf_config.xml", (String)"zerofill", (String)"", (String)"AccountCode");
        if (newGlCode.length() == Integer.parseInt(code)) {
            Long glcode = Long.parseLong(newGlCode);
            tempCode = glcode + 1L;
        } else {
            newGlCode = newGlCode + zero;
            Long glcode = Long.parseLong(newGlCode);
            tempCode = glcode + 1L;
        }
        newGlCode = Long.toString(tempCode);
        return newGlCode;
    }

    public Long postInChartOfAccounts(String glCode, Long parentId, String accNumber, Integer branchId) {
        Bankbranch bankBranch = this.createBankBranchService.getById(branchId);
        int majorCodeLength = Integer.valueOf(((AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "coa_majorcode_length").get(0)).getValue());
        CChartOfAccounts chart = new CChartOfAccounts();
        chart.setGlcode(glCode);
        chart.setName(bankBranch.getBank().getName() + " " + bankBranch.getBranchname() + " " + accNumber);
        chart.setParentId(parentId);
        chart.setType(Character.valueOf('A'));
        chart.setClassification(Long.valueOf(Long.parseLong("4")));
        chart.setIsActiveForPosting(Boolean.valueOf(true));
        chart.setMajorCode(chart.getGlcode().substring(0, majorCodeLength));
        this.chartOfAccountsService.persist((Object)chart);
        return chart.getId();
    }
}

