/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dao.budget;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.commons.dao.FunctionDAO;
import org.egov.dao.budget.BudgetGroupDAO;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.model.budget.BudgetGroup;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class BudgetGroupHibernateDAO
implements BudgetGroupDAO {
    @PersistenceContext
    private EntityManager entityManager;
    private static final Logger LOGGER = Logger.getLogger(BudgetGroupHibernateDAO.class);
    private Session session;
    private static final String EMPTY_STRING = "";
    @Autowired
    private FinancialYearDAO financialYearDAO;
    @Autowired
    private FunctionDAO functionDAO;

    @Override
    @Transactional
    public BudgetGroup update(BudgetGroup entity) {
        this.getCurrentSession().update((Object)entity);
        return entity;
    }

    @Override
    @Transactional
    public BudgetGroup create(BudgetGroup entity) {
        this.getCurrentSession().persist((Object)entity);
        return entity;
    }

    @Override
    @Transactional
    public void delete(BudgetGroup entity) {
        this.getCurrentSession().delete((Object)entity);
    }

    @Override
    public BudgetGroup findById(Number id, boolean lock) {
        return (BudgetGroup)((Object)this.getCurrentSession().load(BudgetGroup.class, (Serializable)id));
    }

    @Override
    public List<BudgetGroup> findAll() {
        return this.getCurrentSession().createCriteria(BudgetGroup.class).list();
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public BudgetGroup createBudgetGroup(BudgetGroup cbg) throws ValidationException {
        BudgetGroup budgetGroup = null;
        try {
            this.session = this.getCurrentSession();
            this.session.saveOrUpdate((Object)cbg);
            budgetGroup = (BudgetGroup)((Object)this.session.get(BudgetGroup.class, (Serializable)cbg.getId()));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("budgetGroup saved id" + budgetGroup.getName()));
            }
        }
        catch (ValidationException v) {
            LOGGER.error((Object)("Error in createBudgetGroup===" + v.getErrors()));
            throw new ValidationException(v.getErrors());
        }
        catch (Exception e) {
            LOGGER.error((Object)(e.getCause() + " Error in createBudgetGroup"));
            throw new ValidationException(EMPTY_STRING, "egovexception in creation of budgetGroup" + e, new String[0]);
        }
        return budgetGroup;
    }

    @Override
    public List<BudgetGroup> getBudgetHeadByDateAndFunction(String functionCode, Date date) throws ValidationException {
        List<BudgetGroup> budgetHeadList = new ArrayList();
        try {
            CFunction function = null;
            StringBuffer qryStr = new StringBuffer();
            CFinancialYear fiancialyear = this.financialYearDAO.getFinancialYearByDate(date);
            if (fiancialyear == null) {
                throw new ValidationException(EMPTY_STRING, "Date is not defined in the Financial year master", new String[0]);
            }
            qryStr.append("from BudgetGroup bg where  bg in ( select bd.budgetGroup from BudgetDetail bd  where bd.budget.financialYear=:financialYearId   ");
            if (functionCode != null && !functionCode.equals(EMPTY_STRING)) {
                function = this.functionDAO.getFunctionByCode(functionCode);
                if (function == null || function.getId() == null) {
                    throw new ValidationException(EMPTY_STRING, "Function Code is not defined in the system", new String[0]);
                }
                qryStr.append(" AND bd.function=:functionId ");
            }
            qryStr.append(" ) ");
            this.session = this.getCurrentSession();
            Query qry = this.session.createQuery(qryStr.toString());
            qry.setLong("financialYearId", Long.valueOf(fiancialyear.getId()).longValue());
            if (functionCode != null && !functionCode.equals(EMPTY_STRING)) {
                qry.setLong("functionId", function.getId().longValue());
            }
            if ((budgetHeadList = qry.list()).isEmpty() || budgetHeadList.size() == 0) {
                throw new ValidationException(EMPTY_STRING, "No budget defined for the year " + fiancialyear.getFinYearRange(), new String[0]);
            }
        }
        catch (ValidationException v) {
            LOGGER.error((Object)("Exception in getBudgetHeadByDateAndFunction API()" + v.getErrors()));
            throw new ValidationException(v.getErrors());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in getBudgetHeadByDateAndFunction API()=======" + e.getMessage()));
            throw new ValidationException(EMPTY_STRING, e.getMessage(), new String[0]);
        }
        return budgetHeadList;
    }

    @Override
    public BudgetGroup getBudgetHeadById(Long id) {
        this.session = this.getCurrentSession();
        Query qry = this.session.createQuery("from BudgetGroup bg where bg.id =:id");
        qry.setLong("id", id.longValue());
        return (BudgetGroup)((Object)qry.uniqueResult());
    }

    @Override
    public List<BudgetGroup> getBudgetGroupList() throws ValidationException {
        List budgetHeadList = null;
        try {
            this.session = this.getCurrentSession();
            Query qry = this.session.createQuery(" from BudgetGroup where isActive=true order by name");
            budgetHeadList = qry.list();
        }
        catch (ValidationException v) {
            LOGGER.error((Object)("Exception in getBudgetGroupList API()" + v.getErrors()));
            throw new ValidationException(v.getErrors());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in getBudgetGroupList API()=======" + e.getMessage()));
            throw new ValidationException(EMPTY_STRING, e.getMessage(), new String[0]);
        }
        return budgetHeadList;
    }

    @Override
    public List<BudgetGroup> getBudgetHeadByFunction(String functionCode) throws ValidationException {
        List<BudgetGroup> budgetHeadList = new ArrayList();
        try {
            CFunction function = null;
            StringBuffer qryStr = new StringBuffer();
            if (functionCode != null && !functionCode.equals(EMPTY_STRING)) {
                function = this.functionDAO.getFunctionByCode(functionCode);
                if (function == null || function.getId() == null) {
                    throw new ValidationException(EMPTY_STRING, "Function Code is not defined in the system", new String[0]);
                }
                qryStr.append("from BudgetGroup bg where  bg in ( select distinct bd.budgetGroup from BudgetDetail bd  where bd.function=:functionId ) order by bg.name");
            }
            this.session = this.getCurrentSession();
            Query qry = this.session.createQuery(qryStr.toString());
            if (functionCode != null && !functionCode.equals(EMPTY_STRING)) {
                qry.setLong("functionId", function.getId().longValue());
            }
            if ((budgetHeadList = qry.list()).isEmpty() || budgetHeadList.size() == 0) {
                throw new ValidationException(EMPTY_STRING, "No budget heads mapped for the function code - " + functionCode, new String[0]);
            }
        }
        catch (ValidationException v) {
            LOGGER.error((Object)("Exception in getBudgetHeadByFunction API()" + v.getErrors()));
            throw new ValidationException(v.getErrors());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in getBudgetHeadByFunction API()=======" + e.getMessage()));
            throw new ValidationException(EMPTY_STRING, e.getMessage(), new String[0]);
        }
        return budgetHeadList;
    }

    @Override
    public List<BudgetGroup> getBudgetHeadByCOAandFunction(String functionCode, List<CChartOfAccounts> chartOfAccountsList) throws ValidationException {
        List budgetHeadList = new ArrayList();
        try {
            if (!(functionCode == null || functionCode.equals(EMPTY_STRING) || chartOfAccountsList != null && chartOfAccountsList.size() != 0)) {
                return this.getBudgetHeadByFunction(functionCode);
            }
            if (chartOfAccountsList != null && chartOfAccountsList.size() > 0 && (functionCode == null || functionCode.equals(EMPTY_STRING))) {
                ArrayList<Long> coaIds = new ArrayList<Long>();
                for (CChartOfAccounts coa : chartOfAccountsList) {
                    coaIds.add(coa.getId());
                }
                int size = coaIds.size();
                if (size > 999) {
                    Query budgetHeadsQuery;
                    List newbudgetHeadList;
                    int fromIndex = 0;
                    int toIndex = 0;
                    int step = 1000;
                    while (size - 1000 >= 0) {
                        newbudgetHeadList = new ArrayList();
                        budgetHeadsQuery = this.getCurrentSession().createQuery(" from BudgetGroup bg where  bg.maxCode.id in ( :IDS1 ) and bg.minCode.id in ( :IDS2 )");
                        budgetHeadsQuery.setParameterList("IDS1", coaIds.subList(fromIndex, toIndex += 1000));
                        budgetHeadsQuery.setParameterList("IDS2", coaIds.subList(fromIndex, toIndex));
                        newbudgetHeadList = budgetHeadsQuery.list();
                        fromIndex = toIndex;
                        size -= 1000;
                        if (newbudgetHeadList == null) continue;
                        budgetHeadList.addAll(newbudgetHeadList);
                    }
                    if (size > 0) {
                        newbudgetHeadList = new ArrayList();
                        fromIndex = toIndex;
                        toIndex = fromIndex + size;
                        budgetHeadsQuery = this.getCurrentSession().createQuery(" from BudgetGroup bg where bg.maxCode.id in ( :IDS1 ) and bg.minCode.id in ( :IDS2 )");
                        budgetHeadsQuery.setParameterList("IDS1", coaIds.subList(fromIndex, toIndex));
                        budgetHeadsQuery.setParameterList("IDS2", coaIds.subList(fromIndex, toIndex));
                        newbudgetHeadList = budgetHeadsQuery.list();
                        if (newbudgetHeadList != null) {
                            budgetHeadList.addAll(newbudgetHeadList);
                        }
                    }
                } else {
                    Query budgetHeadsQuery = this.getCurrentSession().createQuery(" from BudgetGroup bg where  bg.maxCode.id in ( :IDS1 ) and bg.minCode.id in ( :IDS2 )");
                    budgetHeadsQuery.setParameterList("IDS1", coaIds);
                    budgetHeadsQuery.setParameterList("IDS2", coaIds);
                    budgetHeadList = budgetHeadsQuery.list();
                }
                if (budgetHeadList.isEmpty() || budgetHeadList.size() == 0) {
                    throw new ValidationException(EMPTY_STRING, "No budget heads mapped for the function code - " + functionCode, new String[0]);
                }
                return budgetHeadList;
            }
            if (chartOfAccountsList != null && chartOfAccountsList.size() > 0 && functionCode != null && !functionCode.equals(EMPTY_STRING)) {
                ArrayList<Long> coaIds = new ArrayList<Long>();
                CFunction function = null;
                if (!(functionCode == null || functionCode.equals(EMPTY_STRING) || (function = this.functionDAO.getFunctionByCode(functionCode)) != null && function.getId() != null)) {
                    throw new ValidationException(EMPTY_STRING, "Function Code is not defined in the system", new String[0]);
                }
                for (CChartOfAccounts coa : chartOfAccountsList) {
                    coaIds.add(coa.getId());
                }
                int size = coaIds.size();
                if (size > 999) {
                    Query budgetHeadsQuery;
                    List newbudgetHeadList;
                    int fromIndex = 0;
                    int toIndex = 0;
                    int step = 1000;
                    while (size - 1000 >= 0) {
                        newbudgetHeadList = new ArrayList();
                        budgetHeadsQuery = this.getCurrentSession().createQuery(" from BudgetGroup bg where bg.maxCode.id in ( :IDS1 ) and bg.minCode.id in ( :IDS2 ) and bg in ( select bd.budgetGroup from BudgetDetail bd  where bd.function=:functionId ) order by bg.name");
                        budgetHeadsQuery.setParameterList("IDS1", coaIds.subList(fromIndex, toIndex += 1000));
                        budgetHeadsQuery.setParameterList("IDS2", coaIds.subList(fromIndex, toIndex));
                        if (functionCode != null && !functionCode.equals(EMPTY_STRING)) {
                            budgetHeadsQuery.setLong("functionId", function.getId().longValue());
                        }
                        newbudgetHeadList = budgetHeadsQuery.list();
                        fromIndex = toIndex;
                        size -= 1000;
                        if (newbudgetHeadList == null) continue;
                        budgetHeadList.addAll(newbudgetHeadList);
                    }
                    if (size > 0) {
                        newbudgetHeadList = new ArrayList();
                        fromIndex = toIndex;
                        toIndex = fromIndex + size;
                        budgetHeadsQuery = this.getCurrentSession().createQuery(" from BudgetGroup bg where  bg.maxCode.id in ( :IDS1 ) and bg.minCode.id in ( :IDS2 ) and bg in ( select bd.budgetGroup from BudgetDetail bd  where bd.function=:functionId ) order by bg.name");
                        budgetHeadsQuery.setParameterList("IDS1", coaIds.subList(fromIndex, toIndex));
                        budgetHeadsQuery.setParameterList("IDS2", coaIds.subList(fromIndex, toIndex));
                        if (functionCode != null && !functionCode.equals(EMPTY_STRING)) {
                            budgetHeadsQuery.setLong("functionId", function.getId().longValue());
                        }
                        if ((newbudgetHeadList = budgetHeadsQuery.list()) != null) {
                            budgetHeadList.addAll(newbudgetHeadList);
                        }
                    }
                } else {
                    Query budgetHeadsQuery = this.getCurrentSession().createQuery(" from BudgetGroup bg where  bg.maxCode.id in ( :IDS1 ) and bg.minCode.id in ( :IDS2 ) and bg in ( select bd.budgetGroup from BudgetDetail bd  where bd.function=:functionId ) order by bg.name ");
                    budgetHeadsQuery.setParameterList("IDS1", coaIds);
                    budgetHeadsQuery.setParameterList("IDS2", coaIds);
                    if (functionCode != null && !functionCode.equals(EMPTY_STRING)) {
                        budgetHeadsQuery.setLong("functionId", function.getId().longValue());
                    }
                    budgetHeadList = budgetHeadsQuery.list();
                }
                if (budgetHeadList.isEmpty() || budgetHeadList.size() == 0) {
                    throw new ValidationException(EMPTY_STRING, "No budget heads mapped for the function code - " + functionCode, new String[0]);
                }
                return budgetHeadList;
            }
            StringBuffer qryStr = new StringBuffer();
            qryStr.append("from BudgetGroup bg order by bg.name");
            this.session = this.getCurrentSession();
            Query qry = this.session.createQuery(qryStr.toString());
            budgetHeadList = qry.list();
        }
        catch (ValidationException v) {
            LOGGER.error((Object)("Exception in getBudgetHeadByFunction API()" + v.getErrors()));
            throw new ValidationException(v.getErrors());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in getBudgetHeadByFunction API()=======" + e.getMessage()));
            throw new ValidationException(EMPTY_STRING, e.getMessage(), new String[0]);
        }
        return budgetHeadList;
    }

    @Override
    public List<BudgetGroup> getBudgetGroupsByFundFunctionDeptAndAccountType(Integer fund, Long dept, Long function, String accountType) throws ValidationException {
        List<BudgetGroup> budgetHeadList = new ArrayList();
        try {
            StringBuffer qryStr = new StringBuffer();
            StringBuffer filtersQryStr = new StringBuffer();
            StringBuffer accountTypeQryStr = new StringBuffer();
            if (fund != null) {
                filtersQryStr.append(" and bd.fund.id =:fund ");
            }
            if (dept != null) {
                filtersQryStr.append(" and bd.executingDepartment.id =:dept ");
            }
            if (function != null) {
                filtersQryStr.append(" and bd.function.id =:function ");
            }
            if (accountType != null) {
                accountTypeQryStr.append(" and bg.accountType =:accountType ");
            }
            qryStr.append("from BudgetGroup bg where  bg in ( select distinct bd.budgetGroup from BudgetDetail bd  where bd.id is not null ");
            qryStr.append(filtersQryStr);
            qryStr.append(" ) ");
            qryStr.append(accountTypeQryStr);
            qryStr.append("order by bg.name");
            this.session = this.getCurrentSession();
            Query qry = this.session.createQuery(qryStr.toString());
            if (fund != null) {
                qry.setInteger("fund", fund.intValue());
            }
            if (dept != null) {
                qry.setLong("dept", dept.longValue());
            }
            if (function != null) {
                qry.setLong("function", function.longValue());
            }
            if (accountType != null) {
                qry.setString("accountType", accountType);
            }
            if ((budgetHeadList = qry.list()).isEmpty() || budgetHeadList.size() == 0) {
                throw new ValidationException(EMPTY_STRING, "No budget heads mapped for the given fund,department,function and account type ", new String[0]);
            }
        }
        catch (ValidationException v) {
            LOGGER.error((Object)("Exception in getBudgetGroupsByFundFunctionDeptAndAccountType API()" + v.getErrors()));
            throw new ValidationException(v.getErrors());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in getBudgetGroupsByFundFunctionDeptAndAccountType API()=======" + e.getMessage()));
            throw new ValidationException(EMPTY_STRING, e.getMessage(), new String[0]);
        }
        return budgetHeadList;
    }
}

