/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dao.bills;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.commons.CVoucherHeader;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.bills.EgBillregister;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Repository
public class EgBillRegisterHibernateDAO {
    @PersistenceContext
    private EntityManager entityManager;
    private final Logger LOGGER = Logger.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService<EgBillregister, Long> egBillRegisterService;
    private Session session;

    @Transactional
    public EgBillregister update(EgBillregister entity) {
        this.getCurrentSession().update((Object)entity);
        return entity;
    }

    @Transactional
    public EgBillregister create(EgBillregister entity) {
        this.getCurrentSession().persist((Object)entity);
        return entity;
    }

    @Transactional
    public void delete(EgBillregister entity) {
        this.getCurrentSession().delete((Object)entity);
    }

    public EgBillregister findById(Long id, boolean lock) {
        return (EgBillregister)this.getCurrentSession().load(EgBillregister.class, (Serializable)id);
    }

    public List<EgBillregister> findAll() {
        return this.getCurrentSession().createCriteria(EgBillregister.class).list();
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<String> getDistinctEXpType() {
        this.session = this.getCurrentSession();
        List list = this.session.createQuery("select DISTINCT (expendituretype) from EgBillregister egbills").list();
        return list;
    }

    public String getBillTypeforVoucher(CVoucherHeader voucherHeader) throws ValidationException {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"EgBillRegisterHibernateDAO | getBillTypeforVoucher");
        }
        if (null == voucherHeader) {
            throw new ValidationException(Arrays.asList(new ValidationError("voucher header null", "VoucherHeader supplied is null")));
        }
        this.session = this.getCurrentSession();
        Query qry = this.session.createQuery("from  EgBillregister br where br.egBillregistermis.voucherHeader.id=:voucherId");
        qry.setLong("voucherId", voucherHeader.getId().longValue());
        EgBillregister billRegister = (EgBillregister)qry.uniqueResult();
        return billRegister == null ? null : billRegister.getExpendituretype();
    }

    public String getBillSubTypeforVoucher(CVoucherHeader voucherHeader) throws ValidationException {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"EgBillRegisterHibernateDAO | getBillTypeforVoucher");
        }
        if (null == voucherHeader) {
            throw new ValidationException(Arrays.asList(new ValidationError("voucher header null", "VoucherHeader supplied is null")));
        }
        this.session = this.getCurrentSession();
        Query qry = this.session.createQuery("from  EgBillregister br where br.egBillregistermis.voucherHeader.id=:voucherId");
        qry.setLong("voucherId", voucherHeader.getId().longValue());
        EgBillregister billRegister = (EgBillregister)qry.uniqueResult();
        return billRegister == null ? "General" : (billRegister.getEgBillregistermis().getEgBillSubType() == null ? billRegister.getExpendituretype() : billRegister.getEgBillregistermis().getEgBillSubType().getName());
    }
}

