/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.exility.pagemanager;

import com.exilant.exility.common.DataCollection;
import com.exilant.exility.common.MessageList;
import com.exilant.exility.pagemanager.FieldMap;
import com.exilant.exility.pagemanager.GridMap;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class PageMap {
    private static final Logger LOGGER = Logger.getLogger(PageMap.class);
    public String type;
    public String name;
    public FieldMap[] fieldMaps;
    public GridMap[] gridMaps;

    public String toJavaScript(DataCollection dc) {
        String nam;
        Object iter;
        StringBuffer sbf = new StringBuffer();
        sbf.append("var dc=new Object();\n");
        sbf.append("dc.values=new Object();\n");
        sbf.append("dc.grids=new Object();\n");
        sbf.append("dc.messages=new Array();\n");
        sbf.append("dc.success=true;\n");
        if (this.type == null) {
            iter = dc.getFieldNames();
            while (iter.hasNext()) {
                nam = (String)iter.next();
                String formattedStr = dc.getValue(nam);
                formattedStr = formattedStr.replaceAll("\n", " ");
                formattedStr = formattedStr.replaceAll("\r", " ");
                this.addValue(sbf, nam, formattedStr);
            }
        } else {
            for (FieldMap fieldMap : this.fieldMaps) {
                nam = fieldMap.serverFieldName != null ? fieldMap.serverFieldName : fieldMap.name;
                String val = dc.getValue(nam);
                if (val == null) {
                    val = "";
                }
                val = val.replaceAll("\n", " ");
                val = val.replaceAll("\r", " ");
                this.addValue(sbf, fieldMap.name, val);
            }
        }
        sbf.append("\n");
        if (this.type == null) {
            iter = dc.getGridNames();
            while (iter.hasNext()) {
                nam = (String)iter.next();
                this.addGrid(sbf, dc.getGrid(nam), nam);
            }
        } else {
            for (GridMap gridMap : this.gridMaps) {
                sbf.append(gridMap.toJavaScript(dc, "dc"));
            }
        }
        sbf.append("\n");
        MessageList ml = dc.getMessageList();
        int messageSize = ml.size();
        for (int i = 0; i < messageSize; ++i) {
            sbf.append("dc.messages[");
            sbf.append(i);
            sbf.append("]='");
            sbf.append(ml.getMessage(i).replaceAll("'", "\\'").replaceAll("\n", " "));
            sbf.append("';\n");
        }
        if (dc.getSevirity() > 3) {
            sbf.append("dc.success=false;\n");
        }
        return sbf.toString();
    }

    private void addValue(StringBuffer sbf, String nam, String val) {
        sbf.append("dc.values['");
        sbf.append(nam);
        sbf.append("']='");
        sbf.append(val.replaceAll("'", "\\\\'"));
        sbf.append("';\n");
    }

    private void addGrid(StringBuffer sbf, String[][] grid, String nam) {
        if (0 != grid.length) {
            sbf.append("dc.grids['");
            sbf.append(nam);
            sbf.append("']=[['");
            sbf.append(grid[0][0]);
            for (int i = 1; i < grid[0].length; ++i) {
                sbf.append("','");
                sbf.append(grid[0][i].replaceAll("'", "\\\\'"));
            }
            sbf.append("']\n");
            for (int j = 1; j < grid.length; ++j) {
                sbf.append(",['");
                sbf.append(grid[j][0].replaceAll("'", "\\\\'"));
                for (int i = 1; i < grid[j].length; ++i) {
                    sbf.append("','");
                    sbf.append(grid[j][i].replaceAll("'", "\\\\'"));
                }
                sbf.append("']\n");
            }
            sbf.append("];\n");
        }
    }

    public DataCollection createDataCollection(HttpServletRequest req) {
        DataCollection dc = new DataCollection();
        if (this.fieldMaps == null) {
            Enumeration params = req.getParameterNames();
            while (params.hasMoreElements()) {
                String param = (String)params.nextElement();
                String[] values = req.getParameterValues(param);
                if (values == null) continue;
                if (values.length == 1) {
                    dc.addValue(param, values[0]);
                    continue;
                }
                dc.addValueList(param, values);
            }
        } else {
            for (FieldMap fieldMap : this.fieldMaps) {
                Object obj = req.getAttribute(fieldMap.name);
                String val = obj == null ? "" : obj.toString();
                String nam = fieldMap.serverFieldName == "" ? fieldMap.name : fieldMap.serverFieldName;
                val = val.replaceAll("\n", " ");
                val = val.replaceAll("\r", " ");
                dc.addValue(nam, val);
            }
        }
        if (this.gridMaps != null) {
            for (GridMap gridMap : this.gridMaps) {
                gridMap.addGrid(dc, req);
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"addedn in createdatacoolection\\\\\\\\\\");
        }
        return dc;
    }
}

