/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.exility.pagemanager;

import com.exilant.exility.common.DataCollection;
import com.exilant.exility.pagemanager.FieldMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class GridMap {
    private static final Logger LOGGER = Logger.getLogger(GridMap.class);
    public String name;
    public String serverFieldName;
    public boolean containsNames;
    public FieldMap[] columnMaps;

    public String toJavaScript(DataCollection dc, String dcName) {
        int start;
        int i;
        String nam = this.serverFieldName == null ? this.name : this.serverFieldName;
        String[][] grid = dc.getGrid(nam);
        if (grid == null || grid.length == 0 || grid[0].length == 0 || this.columnMaps == null || this.columnMaps.length == 0) {
            return "";
        }
        int serverCols = grid[0].length;
        int clientCols = this.columnMaps.length;
        int[] indexes = new int[clientCols];
        if (this.containsNames) {
            block2: for (i = 0; i < clientCols; ++i) {
                indexes[i] = 0;
                for (int j = 0; j < serverCols; ++j) {
                    String n;
                    String string = n = this.columnMaps[i].serverFieldName == null ? this.columnMaps[i].name : this.columnMaps[i].serverFieldName;
                    if (!grid[0][j].equalsIgnoreCase(n)) continue;
                    indexes[i] = j;
                    continue block2;
                }
            }
        } else {
            for (i = 0; i < clientCols; ++i) {
                try {
                    indexes[i] = Integer.parseInt(this.columnMaps[i].serverFieldName);
                    if (indexes[i] < serverCols) continue;
                    indexes[i] = 0;
                    continue;
                }
                catch (NumberFormatException e) {
                    indexes[i] = 0;
                    LOGGER.error((Object)("Error in retriving index" + e.getMessage()));
                }
            }
        }
        StringBuffer sbf = new StringBuffer();
        sbf.append(dcName);
        sbf.append(".grids['");
        sbf.append(this.name);
        sbf.append("'] = [\n");
        sbf.append("['");
        sbf.append(this.columnMaps[0].name);
        for (int i2 = 1; i2 < clientCols; ++i2) {
            sbf.append("','");
            sbf.append(this.columnMaps[i2].name);
        }
        sbf.append("']\n");
        for (int i3 = start = this.containsNames ? 1 : 0; i3 < grid.length; ++i3) {
            sbf.append(",['");
            sbf.append(grid[i3][indexes[0]]);
            for (int j = 1; j < clientCols; ++j) {
                sbf.append("','");
                sbf.append(grid[i3][indexes[j]]);
            }
            sbf.append("']\n");
        }
        sbf.append("];\n");
        return sbf.toString();
    }

    public void addGrid(DataCollection dc, HttpServletRequest req) {
        String nam;
        String string = nam = this.serverFieldName == null ? this.name : this.serverFieldName;
        if (this.columnMaps == null || this.columnMaps.length == 0) {
            dc.addGrid(nam, new String[0][0]);
            return;
        }
        FieldMap fm = this.columnMaps[0];
        int ncols = this.columnMaps.length;
        String[] col = req.getParameterValues(fm.name);
        if (col == null) {
            dc.addGrid(nam, new String[0][0]);
            return;
        }
        int nrows = col.length;
        String[][] grid = new String[nrows][ncols];
        for (int i = 0; i < ncols; ++i) {
            fm = this.columnMaps[i];
            col = req.getParameterValues(fm.name);
            if (col == null || col.length != nrows) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("Error in form Design " + this.name + " is not defined or has different number of values than the rest in the form"));
                continue;
            }
            for (int k = 0; k < nrows; ++k) {
                grid[k][i] = col[k];
            }
        }
        dc.addGrid(nam, grid);
    }
}

