/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.exility.common;

import com.exilant.exility.common.ObjectGetSetter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLLoader
extends DefaultHandler {
    Stack openNodes;
    Object rootObject;
    private static final Logger LOGGER = Logger.getLogger(XMLLoader.class);

    public void load(String fileName, Object root) {
        this.rootObject = root;
        this.openNodes = new Stack();
        this.load(fileName);
        this.rootObject = null;
        this.openNodes = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(String fileName) {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(false);
            spf.setValidating(false);
            SAXParser saxParser = spf.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(this);
            xmlReader.setErrorHandler(new MyErrorHandler(System.err));
            xmlReader.parse(fileName);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error((Object)("Exp=" + e.getMessage()));
        }
        catch (SAXException e) {
            LOGGER.error((Object)("Exp=" + e.getMessage()));
        }
        catch (IOException e) {
            LOGGER.error((Object)("Exp=" + e.getMessage()));
        }
        finally {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Finally in load");
            }
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Object objectToLoad = null;
        objectToLoad = this.openNodes.size() == 0 ? this.rootObject : this.createChild(qName, atts);
        if (objectToLoad != null) {
            if (atts.getIndex("type") < 0) {
                ObjectGetSetter.set(objectToLoad, "type", qName);
            }
            ObjectGetSetter.setAll(objectToLoad, atts);
        }
        this.openNodes.push(new StackedObject(objectToLoad));
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        StackedObject so = (StackedObject)this.openNodes.pop();
        Object endingObject = so.object;
        if (endingObject == null) {
            return;
        }
        if (so.childInfos != null && so.childInfos.size() > 0) {
            Iterator iter = so.childInfos.values().iterator();
            while (iter.hasNext()) {
                ((ChildInfo)iter.next()).endChild(endingObject);
            }
        }
    }

    private Object createChild(String tag, Attributes atts) {
        String key;
        ChildInfo childInfo;
        Object parentObject;
        block15: {
            block14: {
                if (this.openNodes.size() == 0) {
                    return null;
                }
                StackedObject stackedObject = (StackedObject)this.openNodes.peek();
                parentObject = stackedObject.object;
                if (null == stackedObject.childInfos) {
                    stackedObject.childInfos = new HashMap();
                }
                childInfo = null;
                if (stackedObject.childInfos.size() > 0) {
                    try {
                        childInfo = (ChildInfo)stackedObject.childInfos.get(tag);
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("Error in getting child info" + e.getMessage()));
                    }
                }
                if (null == childInfo) {
                    childInfo = new ChildInfo(tag);
                    childInfo.addInfo(parentObject);
                    stackedObject.childInfos.put(tag, childInfo);
                }
                key = null;
                try {
                    key = atts.getValue("id");
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Exp=" + e.getMessage()));
                }
                if (null == key) {
                    try {
                        key = atts.getValue("key");
                    }
                    catch (Exception e) {
                        if (!LOGGER.isDebugEnabled()) break block14;
                        LOGGER.debug((Object)("Exp=" + e.getMessage()));
                    }
                }
            }
            if (null == key) {
                try {
                    key = atts.getValue("name");
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block15;
                    LOGGER.debug((Object)("Exp=" + e.getMessage()));
                }
            }
        }
        return childInfo.createChild(parentObject, key);
    }

    private class StackedObject {
        Object object;
        HashMap childInfos;

        StackedObject(Object object) {
            this.object = object;
            this.childInfos = null;
        }
    }

    private class ChildInfo {
        String tag;
        int storageType = 0;
        Field field = null;
        Class fieldType = null;
        Object collectionObject = null;
        Method addMethod = null;
        boolean addRequiresKey = false;
        Method newChildMethod = null;
        Method endChildMethod = null;

        ChildInfo(String tag) {
            this.tag = tag;
        }

        public void addInfo(Object parentObject) {
            Class[] stringClass = new Class[]{String.class};
            Class[] stringClass2 = new Class[]{String.class, String.class};
            Class[] objClass = new Class[]{Object.class};
            Class[] objClass2 = new Class[]{Object.class, Object.class};
            try {
                this.newChildMethod = parentObject.getClass().getMethod("newChild", stringClass2);
                this.collectionObject = parentObject;
                this.addRequiresKey = true;
                this.storageType = 1;
                try {
                    this.endChildMethod = parentObject.getClass().getMethod("endChild", stringClass);
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Exp=" + e.getMessage()));
                }
                return;
            }
            catch (Exception e) {
                block14: {
                    LOGGER.error((Object)("Exp=" + e.getMessage()));
                    try {
                        this.field = ObjectGetSetter.getField(parentObject, this.tag);
                        this.field.setAccessible(true);
                        this.fieldType = this.field.getType();
                        this.storageType = 2;
                    }
                    catch (Exception e2) {
                        LOGGER.error((Object)("Exp=" + e2.getMessage()));
                    }
                    try {
                        Field f = ObjectGetSetter.getField(parentObject, this.tag + 's');
                        Class<?> c = f.getType();
                        if (c.isArray()) {
                            this.storageType = 3;
                            this.collectionObject = new ArrayList();
                            this.addRequiresKey = false;
                            this.addMethod = ArrayList.class.getMethod("add", objClass);
                            this.field = f;
                            this.fieldType = c.getComponentType();
                            break block14;
                        }
                        Object o = f.get(parentObject);
                        if (null == o) {
                            o = c.newInstance();
                            f.setAccessible(true);
                            f.set(parentObject, o);
                        }
                        try {
                            this.addMethod = c.getMethod("add", objClass);
                            this.collectionObject = o;
                            this.addRequiresKey = false;
                            this.storageType = 4;
                        }
                        catch (Exception e3) {
                            try {
                                this.addMethod = c.getMethod("put", objClass2);
                                this.collectionObject = o;
                                this.addRequiresKey = true;
                                this.storageType = 4;
                            }
                            catch (Exception e1) {
                                LOGGER.error((Object)("Exp=" + e1.getMessage()));
                            }
                            LOGGER.error((Object)("Exp ObjectGetSetter=" + e3.getMessage()));
                        }
                    }
                    catch (Exception e4) {
                        LOGGER.error((Object)("Exp=" + e4.getMessage()));
                    }
                }
                return;
            }
        }

        public Object createChild(Object parentObject, String key) {
            Object childObject = null;
            Object[] arr1 = new Object[]{null};
            Object[] arr2 = new Object[]{null, null};
            switch (this.storageType) {
                case 1: {
                    try {
                        arr2[0] = this.tag;
                        arr2[1] = key;
                        childObject = this.newChildMethod.invoke(parentObject, arr2);
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("Exp=" + e.getMessage()));
                    }
                    break;
                }
                case 2: {
                    try {
                        childObject = this.field.get(parentObject);
                        if (childObject != null) break;
                        childObject = this.fieldType.newInstance();
                        this.field.set(parentObject, childObject);
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("Exp=" + e.getMessage()));
                    }
                    break;
                }
                case 3: 
                case 4: {
                    try {
                        childObject = this.fieldType.newInstance();
                        if (this.addRequiresKey) {
                            arr2[0] = key;
                            arr2[1] = childObject;
                            this.addMethod.invoke(this.collectionObject, arr2);
                            break;
                        }
                        arr1[0] = childObject;
                        this.addMethod.invoke(this.collectionObject, arr1);
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("Exp=" + e.getMessage()));
                    }
                    break;
                }
            }
            return childObject;
        }

        void endChild(Object parentObject) {
            switch (this.storageType) {
                case 1: {
                    if (this.endChildMethod == null) break;
                    try {
                        Object[] a = new Object[]{this.tag};
                        this.endChildMethod.invoke(parentObject, a);
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("Exp in endChild=" + e.getMessage()));
                    }
                    break;
                }
                case 3: {
                    try {
                        ArrayList al = (ArrayList)this.collectionObject;
                        int len = al.size();
                        int[] a = new int[]{len};
                        Object o = Array.newInstance(this.fieldType, a);
                        for (int i = 0; i < len; ++i) {
                            Array.set(o, i, al.get(i));
                        }
                        this.field.setAccessible(true);
                        this.field.set(parentObject, o);
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("Exp in end Child=" + e.getMessage()));
                    }
                    break;
                }
            }
        }
    }

    private class MyErrorHandler
    implements ErrorHandler {
        private final PrintStream out;

        MyErrorHandler(PrintStream out) {
            this.out = out;
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        @Override
        public void warning(SAXParseException spe) throws SAXException {
            this.out.println("Warning: " + this.getParseExceptionInfo(spe));
        }

        @Override
        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }
    }
}

