/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.eGov.src.transactions;

import com.exilant.eGov.src.transactions.CommonMethodsI;
import com.exilant.exility.common.TaskFailedException;
import java.io.Serializable;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.commons.CFiscalPeriod;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.infstr.services.PersistenceService;
import org.egov.utils.VoucherHelper;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class CommonMethodsImpl
implements CommonMethodsI {
    Query pst;
    Connection connection;
    List<Object[]> rset;
    private static final Logger LOGGER = Logger.getLogger(CommonMethodsImpl.class);
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;

    @Override
    public String getCashInHand(int BoundaryId, Connection connection) throws Exception {
        String cashinHandCode = "";
        try {
            String query = " SELECT a.glcode FROM CHARTOFACCOUNTS a,EG_BOUNDARY b,eg_boundary_type c  WHERE id=(SELECT cashinhand FROM CODEMAPPING WHERE EG_BOUNDARYID= ? )  and b.ID_BNDRY_TYPE=c.ID_BNDRY_TYPE and b.ID_BNDRY= ?";
            this.pst = this.persistenceService.getSession().createSQLQuery(" SELECT a.glcode FROM CHARTOFACCOUNTS a,EG_BOUNDARY b,eg_boundary_type c  WHERE id=(SELECT cashinhand FROM CODEMAPPING WHERE EG_BOUNDARYID= ? )  and b.ID_BNDRY_TYPE=c.ID_BNDRY_TYPE and b.ID_BNDRY= ?");
            this.pst.setInteger(0, BoundaryId);
            this.pst.setInteger(1, BoundaryId);
            this.rset = this.pst.list();
            for (Object[] element : this.rset) {
                cashinHandCode = element[0].toString();
            }
            if (this.rset == null || this.rset.size() == 0) {
                throw new Exception();
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)(">>>cashinHandCode " + cashinHandCode));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)(" Glcode for cashinhand not found " + e.toString()), (Throwable)e);
            throw new Exception(e.toString());
        }
        return cashinHandCode;
    }

    @Override
    public String getChequeInHand(int BoundaryId, Connection connection) throws Exception {
        String chequeinHandCode = "";
        try {
            String query = " SELECT a.glcode FROM CHARTOFACCOUNTS a,EG_BOUNDARY b,eg_boundary_type c  WHERE id=(SELECT chequeinhand FROM CODEMAPPING WHERE EG_BOUNDARYID= ? )  and b.ID_BNDRY_TYPE=c.ID_BNDRY_TYPE and b.ID_BNDRY= ?";
            this.pst = this.persistenceService.getSession().createSQLQuery(" SELECT a.glcode FROM CHARTOFACCOUNTS a,EG_BOUNDARY b,eg_boundary_type c  WHERE id=(SELECT chequeinhand FROM CODEMAPPING WHERE EG_BOUNDARYID= ? )  and b.ID_BNDRY_TYPE=c.ID_BNDRY_TYPE and b.ID_BNDRY= ?");
            this.pst.setInteger(0, BoundaryId);
            this.pst.setInteger(1, BoundaryId);
            this.rset = this.pst.list();
            for (Object[] element : this.rset) {
                chequeinHandCode = element[0].toString();
            }
            if (this.rset == null || this.rset.size() == 0) {
                throw new Exception("Chequeinhand Code not Found");
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)(">>>chequeinHandCode " + chequeinHandCode));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)" Glcode for chequeinHandCode not found ", (Throwable)e);
            throw new Exception(e.toString());
        }
        return chequeinHandCode;
    }

    @Override
    public String getPTCode(String forYear, Connection connection) throws Exception {
        String ptCodeAndName = "";
        try {
            if (!forYear.equalsIgnoreCase("")) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("  forYear  " + forYear));
                }
                String query1 = "select financialyear from financialyear  where ? between startingdate and endingdate";
                this.pst = this.persistenceService.getSession().createSQLQuery("select financialyear from financialyear  where ? between startingdate and endingdate");
                this.pst.setString(0, forYear);
                this.rset = this.pst.list();
                String fId = "";
                String isOld = "";
                for (Object[] objectArray : this.rset) {
                    fId = objectArray[0].toString();
                }
                if (this.rset == null || this.rset.size() == 0) {
                    String query2 = "select a.glcode,a.name from chartofaccounts a,egf_tax_account_mapping b where b.glcodeid=a.id and upper(b.financialyear)=upper('old')";
                    this.pst = this.persistenceService.getSession().createSQLQuery("select a.glcode,a.name from chartofaccounts a,egf_tax_account_mapping b where b.glcodeid=a.id and upper(b.financialyear)=upper('old')");
                    this.rset = this.pst.list();
                    for (Object[] element : this.rset) {
                        ptCodeAndName = element[0].toString();
                        ptCodeAndName = ptCodeAndName + "#" + element[1].toString();
                        if (!LOGGER.isInfoEnabled()) continue;
                        LOGGER.info((Object)(">>>ptCodeAndName " + ptCodeAndName));
                    }
                }
                if (!fId.equalsIgnoreCase("")) {
                    String query3 = "select a.isold from egf_tax_account_mapping a,egf_tax_code b,financialyear c where a.taxcodeid=b.id and b.code='PT' and a.financialyear=c.financialyear and c.financialyear= ?";
                    this.pst = this.persistenceService.getSession().createSQLQuery("select a.isold from egf_tax_account_mapping a,egf_tax_code b,financialyear c where a.taxcodeid=b.id and b.code='PT' and a.financialyear=c.financialyear and c.financialyear= ?");
                    this.pst.setString(0, fId);
                    this.rset = this.pst.list();
                    for (Object[] element : this.rset) {
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info((Object)"   inside 2    ");
                        }
                        isOld = element[0].toString();
                    }
                    if (isOld != null && isOld.equals("1")) {
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info((Object)"   inside 4    ");
                        }
                        String string = "select a.glcode,a.name from chartofaccounts a,egf_tax_account_mapping b where b.glcodeid=a.id and upper(b.financialyear)=upper('old')";
                        this.pst = this.persistenceService.getSession().createSQLQuery("select a.glcode,a.name from chartofaccounts a,egf_tax_account_mapping b where b.glcodeid=a.id and upper(b.financialyear)=upper('old')");
                        this.rset = this.pst.list();
                        for (Object[] element : this.rset) {
                            ptCodeAndName = element[0].toString();
                            ptCodeAndName = ptCodeAndName + "#" + element[1].toString();
                            if (!LOGGER.isInfoEnabled()) continue;
                            LOGGER.info((Object)(">>>ptCodeAndName** " + ptCodeAndName));
                        }
                    } else {
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info((Object)"   inside 5   ");
                        }
                        String string = "select a.glcode,a.name from chartofaccounts a,egf_tax_account_mapping b,egf_tax_code c,financialyear d where b.taxcodeid=c.id and c.code='PT' and b.glcodeid=a.id and b.financialyear=d.financialyear and d.financialyear= ?";
                        this.pst = this.persistenceService.getSession().createSQLQuery("select a.glcode,a.name from chartofaccounts a,egf_tax_account_mapping b,egf_tax_code c,financialyear d where b.taxcodeid=c.id and c.code='PT' and b.glcodeid=a.id and b.financialyear=d.financialyear and d.financialyear= ?");
                        this.pst.setString(0, fId);
                        this.rset = this.pst.list();
                        for (Object[] element : this.rset) {
                            ptCodeAndName = element[0].toString();
                            ptCodeAndName = ptCodeAndName + "#" + element[1].toString();
                            if (!LOGGER.isInfoEnabled()) continue;
                            LOGGER.info((Object)(">>>ptCodeAndName " + ptCodeAndName));
                        }
                        if (this.rset == null || this.rset.size() == 0) {
                            throw new Exception("Property Tax code not Found for " + forYear);
                        }
                    }
                }
            } else {
                String query = "select a.glcode, a.name from chartofaccounts a,egf_accountcode_purpose b where a.purposeid=b.id and upper(b.name)=upper('SuspenseCode')";
                this.pst = this.persistenceService.getSession().createSQLQuery("select a.glcode, a.name from chartofaccounts a,egf_accountcode_purpose b where a.purposeid=b.id and upper(b.name)=upper('SuspenseCode')");
                this.rset = this.pst.list();
                for (Object[] element : this.rset) {
                    ptCodeAndName = element[0].toString();
                    ptCodeAndName = ptCodeAndName + "#" + element[1].toString();
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info((Object)(">>>ptCodeAndName1 " + ptCodeAndName));
                }
                if (this.rset == null || this.rset.size() == 0) {
                    throw new Exception("Property Tax code not Found for " + forYear);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)(" PT code not found " + e.toString()), (Throwable)e);
            throw new Exception(e.toString());
        }
        return ptCodeAndName;
    }

    @Override
    public String getBankCode(int bankAccountId, Connection connection) throws Exception {
        String bankCodeAndName = "";
        try {
            String query = "select glcode,name from chartofaccounts where id=(select glcodeid from bankaccount where id= ?)";
            this.pst = this.persistenceService.getSession().createSQLQuery("select glcode,name from chartofaccounts where id=(select glcodeid from bankaccount where id= ?)");
            this.pst.setInteger(0, bankAccountId);
            this.rset = this.pst.list();
            for (Object[] element : this.rset) {
                bankCodeAndName = element[0].toString();
                bankCodeAndName = bankCodeAndName + "#" + element[1].toString();
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info((Object)(">>>bankCodeAndName " + bankCodeAndName));
            }
            if (this.rset == null || this.rset.size() == 0) {
                throw new Exception("BAnk Code Not Found");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)(" Bank code not found " + e.toString()), (Throwable)e);
            throw new Exception(e.toString());
        }
        return bankCodeAndName;
    }

    @Override
    public String getFiscalPeriod(String vDate, Connection connection) throws TaskFailedException, Exception {
        String fiscalPeriodID = "null";
        try {
            String query = "select id from fiscalperiod  where ? between startingdate and endingdate";
            this.pst = this.persistenceService.getSession().createSQLQuery("select id from fiscalperiod  where ? between startingdate and endingdate");
            this.pst.setString(0, vDate);
            this.rset = this.pst.list();
            for (Object[] element : this.rset) {
                fiscalPeriodID = element[0].toString();
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info((Object)(">>>fiscalPeriodID " + fiscalPeriodID));
            }
            if (this.rset == null || this.rset.size() == 0) {
                throw new TaskFailedException("fiscal Period Not Found");
            }
        }
        catch (TaskFailedException e) {
            LOGGER.error((Object)("fiscal Period Not Found=" + e.getMessage()), (Throwable)e);
            throw new TaskFailedException("fiscal Period Not Found");
        }
        catch (Exception e) {
            LOGGER.error((Object)("failed to get fiscalperiodId " + e.toString()), (Throwable)e);
            throw new Exception(e.toString());
        }
        return fiscalPeriodID;
    }

    @Override
    public String getBankId(int bankAccountId, Connection connection) throws Exception {
        String bankAndBranchId = "null";
        try {
            String sql = "select b.id,c.id from bankaccount a,bankbranch b,bank c where a.branchid=b.id and b.bankid=c.id and a.id= ?";
            this.pst = this.persistenceService.getSession().createSQLQuery("select b.id,c.id from bankaccount a,bankbranch b,bank c where a.branchid=b.id and b.bankid=c.id and a.id= ?");
            this.pst.setInteger(0, bankAccountId);
            this.rset = this.pst.list();
            for (Object[] element : this.rset) {
                bankAndBranchId = element[0].toString();
                bankAndBranchId = bankAndBranchId + "#" + element[1].toString();
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info((Object)(">>>bankAndBranchId " + bankAndBranchId));
            }
            if (this.rset == null || this.rset.size() == 0) {
                throw new Exception("Bank Code Not Found");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)(" Bank Id not found " + e.toString()), (Throwable)e);
            throw new Exception(e.toString());
        }
        return bankAndBranchId;
    }

    @Override
    public double getAccountBalance(int bankAccountId, String vcDate, Connection connection) throws Exception {
        double opeAvailable = 0.0;
        double totalAvailable = 0.0;
        try {
            String str = "SELECT case when sum(openingDebitBalance) = null then 0 ELSE sum(openingDebitBalance) end - case when sum(openingCreditBalance) = null then 0 else sum(openingCreditBalance) end AS \"openingBalance\" FROM transactionSummary WHERE financialYearId=( SELECT id FROM financialYear WHERE startingDate <= ?AND endingDate >= ?)  AND glCodeId =(select glcodeid from bankaccount where id= ?)";
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"SELECT case when sum(openingDebitBalance) = null then 0 ELSE sum(openingDebitBalance) end - case when sum(openingCreditBalance) = null then 0 else sum(openingCreditBalance) end AS \"openingBalance\" FROM transactionSummary WHERE financialYearId=( SELECT id FROM financialYear WHERE startingDate <= ?AND endingDate >= ?)  AND glCodeId =(select glcodeid from bankaccount where id= ?)");
            }
            this.pst = this.persistenceService.getSession().createSQLQuery("SELECT case when sum(openingDebitBalance) = null then 0 ELSE sum(openingDebitBalance) end - case when sum(openingCreditBalance) = null then 0 else sum(openingCreditBalance) end AS \"openingBalance\" FROM transactionSummary WHERE financialYearId=( SELECT id FROM financialYear WHERE startingDate <= ?AND endingDate >= ?)  AND glCodeId =(select glcodeid from bankaccount where id= ?)");
            this.pst.setString(0, vcDate);
            this.pst.setString(1, vcDate);
            this.pst.setInteger(2, bankAccountId);
            this.rset = this.pst.list();
            for (Object[] element : this.rset) {
                opeAvailable = Double.parseDouble(element[0].toString());
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("opening balance  " + opeAvailable));
            }
            String str1 = "SELECT (case when sum(gl.debitAmount) = null then 0 else sum(gl.debitAmount) end - case when sum(gl.creditAmount)  = null then 0 else sum(gl.creditAmount) end) + " + opeAvailable + " as \"totalAmount\" FROM   generalLedger gl, voucherHeader vh WHERE vh.id = gl.voucherHeaderId AND gl.glCodeid = (select glcodeid from bankaccount where id= ?) AND   vh.voucherDate >=( SELECT TO_CHAR(startingDate, 'dd-Mon-yyyy') FROM financialYear WHERE startingDate <= ? AND endingDate >= ?) AND vh.voucherDate <= ?";
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)str1);
            }
            this.pst = this.persistenceService.getSession().createSQLQuery(str1);
            this.pst.setInteger(0, bankAccountId);
            this.pst.setString(1, vcDate);
            this.pst.setString(2, vcDate);
            this.pst.setString(3, vcDate);
            this.rset = this.pst.list();
            for (Object[] element : this.rset) {
                totalAvailable = Double.parseDouble(element[0].toString());
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info((Object)("total balance  " + totalAvailable));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)(" could not get Bankbalance  " + e.toString()), (Throwable)e);
            throw new Exception(e.toString());
        }
        return totalAvailable;
    }

    @Override
    public String getCodeName(String purposeId) throws Exception {
        String codeAndName = "null";
        try {
            String query = "select a.glcode, a.name from chartofaccounts a,egf_accountcode_purpose b where a.purposeid=b.id and b.id= ?";
            this.pst = this.persistenceService.getSession().createSQLQuery("select a.glcode, a.name from chartofaccounts a,egf_accountcode_purpose b where a.purposeid=b.id and b.id= ?");
            this.pst.setString(0, purposeId);
            this.rset = this.pst.list();
            for (Object[] element : this.rset) {
                codeAndName = element[0].toString();
                codeAndName = codeAndName + "#" + element[1].toString();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)(" code not found for purpose id " + e.toString()), (Throwable)e);
            throw new Exception(e.toString());
        }
        return codeAndName;
    }

    @Override
    public String getNameFromCode(String glcode, Connection connection) throws Exception {
        String codeName = "null";
        try {
            String query = "select name from chartofaccounts where glcode= ?";
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"  query   select name from chartofaccounts where glcode= ?");
            }
            this.pst = this.persistenceService.getSession().createSQLQuery("select name from chartofaccounts where glcode= ?");
            this.pst.setString(0, glcode);
            this.rset = this.pst.list();
            for (Object[] element : this.rset) {
                codeName = element[0].toString();
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info((Object)("  codeName   " + codeName));
            }
            if (this.rset == null || this.rset.size() == 0) {
                throw new Exception("code not found");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)(" code not found " + e.toString()), (Throwable)e);
            throw new Exception(e.toString());
        }
        return codeName;
    }

    @Override
    public String getGlCode(String glCodeId, Connection connection) throws Exception {
        String glCode = "null";
        try {
            String query = "select glcode from chartofaccounts where id= ?";
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"  query   select glcode from chartofaccounts where id= ?");
            }
            this.pst = this.persistenceService.getSession().createSQLQuery("select glcode from chartofaccounts where id= ?");
            this.pst.setString(0, glCodeId);
            this.rset = this.pst.list();
            for (Object[] element : this.rset) {
                glCode = element[0].toString();
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info((Object)("  glCode   " + glCode));
            }
            if (this.rset == null || this.rset.size() == 0) {
                throw new Exception("id not found");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)(" id not found " + e.toString()), (Throwable)e);
            throw new Exception(e.toString());
        }
        return glCode;
    }

    @Override
    public String checkRecordIdInLog(String recordId, int userId, Connection connection) throws Exception {
        String cgn = null;
        try {
            String query = "SELECT VOUCHERNUMBER FROM integrationlog WHERE RECORDID= ? and USERID= ? order by id desc";
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"  query   SELECT VOUCHERNUMBER FROM integrationlog WHERE RECORDID= ? and USERID= ? order by id desc");
            }
            this.pst = this.persistenceService.getSession().createSQLQuery("SELECT VOUCHERNUMBER FROM integrationlog WHERE RECORDID= ? and USERID= ? order by id desc");
            this.pst.setString(0, recordId);
            this.pst.setInteger(1, userId);
            this.rset = this.pst.list();
            for (Object[] element : this.rset) {
                cgn = element[0].toString();
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info((Object)("  cgn in log  " + cgn));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exp=" + e.getMessage()), (Throwable)e);
            throw new Exception(e.toString());
        }
        return cgn;
    }

    @Override
    public String getDivisionCode(Integer divid, Connection connection) throws Exception {
        String divCode = null;
        String sql = "SELECT distinct BNDRY_NUM FROM EG_BOUNDARY where ID_BNDRY= ?";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Divisio code query-->>>>>>>> SELECT distinct BNDRY_NUM FROM EG_BOUNDARY where ID_BNDRY= ?");
        }
        try {
            this.pst = this.persistenceService.getSession().createSQLQuery("SELECT distinct BNDRY_NUM FROM EG_BOUNDARY where ID_BNDRY= ?");
            this.pst.setInteger(0, divid.intValue());
            this.rset = this.pst.list();
            for (Object[] element : this.rset) {
                divCode = element[0].toString();
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("divCode >>>>>>>" + divCode));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exp=" + e.getMessage()), (Throwable)e);
            throw new Exception(e.toString());
        }
        return divCode;
    }

    @Override
    public Integer getDivisionId(Integer fieldId, Connection connection) throws Exception {
        Integer divId = null;
        String sql = "Select PARENT from EG_BOUNDARY where ID_BNDRY='" + fieldId + "'";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Division id query-->>>>>>>> " + sql));
        }
        try {
            this.pst = this.persistenceService.getSession().createSQLQuery(sql);
            this.rset = this.pst.list();
            for (Object[] element : this.rset) {
                divId = Integer.parseInt(element[0].toString());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Division id is >>>>>>>" + divId));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exp=" + e.getMessage()));
            throw new Exception(e.toString());
        }
        return divId;
    }

    @Override
    public String getFinacialYear(String vDate, Connection connection) throws Exception {
        String finYear = "null";
        String sql = "select FINANCIALYEAR from FINANCIALYEAR  where '" + vDate + "' between startingdate and endingdate";
        try {
            this.pst = this.persistenceService.getSession().createSQLQuery(sql);
            this.rset = this.pst.list();
            for (Object[] element : this.rset) {
                finYear = element[0].toString();
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("finYear id>>>>>>>" + finYear));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exp=" + e.getMessage()));
            throw new Exception(e.toString());
        }
        return finYear;
    }

    @Override
    public String getGlCodeId(String glCode, Connection connection) throws Exception {
        String glCodeId = "null";
        try {
            String query = "select id from chartofaccounts where glCode like ?";
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"  query   select id from chartofaccounts where glCode like ?");
            }
            this.pst = this.persistenceService.getSession().createSQLQuery("select id from chartofaccounts where glCode like ?");
            this.pst.setString(0, glCode);
            this.rset = this.pst.list();
            for (Object[] element : this.rset) {
                glCodeId = element[0].toString();
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("  glCodeId   " + glCodeId));
            }
            if (this.rset == null || this.rset.size() == 0) {
                throw new Exception("id not found");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)(" id not found " + e.toString()), (Throwable)e);
            throw new Exception(e.toString());
        }
        return glCodeId;
    }

    @Override
    public String getTxnNumber(String txnType, String vDate) throws Exception {
        String finYear = "";
        String fiscalPeriod = "";
        String retVal = "";
        String[] month = vDate.split("/");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)(" The month :" + month[1]));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
        String txndate = formatter.format(sdf.parse(vDate));
        String sql = "select a.FINANCIALYEAR,b.id from FINANCIALYEAR a,fiscalperiod b  where a.id=b.financialyearid AND ? between b.startingdate and b.endingdate";
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"select a.FINANCIALYEAR,b.id from FINANCIALYEAR a,fiscalperiod b  where a.id=b.financialyearid AND ? between b.startingdate and b.endingdate");
        }
        try {
            this.pst = this.persistenceService.getSession().createSQLQuery("select a.FINANCIALYEAR,b.id from FINANCIALYEAR a,fiscalperiod b  where a.id=b.financialyearid AND ? between b.startingdate and b.endingdate");
            this.pst.setString(0, txndate);
            this.rset = this.pst.list();
            for (Object[] element : this.rset) {
                finYear = element[0].toString();
                fiscalPeriod = element[1].toString();
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info((Object)("finYear id>>>>>>>" + finYear + " fiscalPeriod :" + fiscalPeriod));
            }
            if (this.rset == null || this.rset.size() == 0) {
                throw new Exception("Year is not defined in the system");
            }
            String year = finYear.substring(2, 4) + finYear.substring(finYear.length() - 2, finYear.length());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)(" The year String :" + year));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)" In CommonMethodsImpl :getTxnNumber method ");
            }
            CFiscalPeriod fiscalPeriodObj = (CFiscalPeriod)this.persistenceService.find("from CFiscalPeriod where id=?", new Object[]{Long.parseLong(fiscalPeriod)});
            String sequenceName = VoucherHelper.sequenceNameFor(txnType, fiscalPeriodObj.getName());
            Serializable runningNumber = this.applicationSequenceNumberGenerator.getNextSequence(sequenceName);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("----- Txn Number : " + runningNumber));
            }
            retVal = txnType + runningNumber.toString() + "/" + month[1] + "/" + year;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Return value is :" + retVal));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exp=" + e.getMessage()), (Throwable)e);
            throw new Exception(e.toString());
        }
        return retVal;
    }

    @Override
    public String getTxnNumber(String fundId, String txnType, String vDate, Connection con) throws Exception {
        if (txnType == null || txnType.equals("")) {
            throw new Exception("Configuration setting for voucher numbering is not done");
        }
        String fType = "";
        String finYear = "";
        String fiscalPeriod = "";
        String retVal = "";
        String[] month = vDate.split("/");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)(" The month :" + month[1]));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
        String txndate = formatter.format(sdf.parse(vDate));
        String sql = "select a.FINANCIALYEAR,b.id from FINANCIALYEAR a,fiscalperiod b  where a.id=b.financialyearid AND '" + txndate + "' between b.startingdate and b.endingdate";
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)sql);
        }
        try {
            String query = "SELECT identifier as \"fund_identi\" from fund where id= ?";
            this.pst = this.persistenceService.getSession().createSQLQuery("SELECT identifier as \"fund_identi\" from fund where id= ?");
            this.pst.setString(0, fundId);
            this.rset = this.pst.list();
            for (Object[] element : this.rset) {
                fType = element[0].toString();
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info((Object)("Fund Id--->" + fundId + " Fund Type---->" + fType));
            }
            if (this.rset == null || this.rset.size() == 0) {
                throw new Exception("Fund is not defined in the system");
            }
            this.pst = this.persistenceService.getSession().createSQLQuery(sql);
            this.rset = this.pst.list();
            for (Object[] element : this.rset) {
                finYear = element[0].toString();
                fiscalPeriod = element[1].toString();
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info((Object)("finYear id>>>>>>>" + finYear + " fiscalPeriod :" + fiscalPeriod));
            }
            if (this.rset == null || this.rset.size() == 0) {
                throw new Exception("Year is not defined in the system");
            }
            String year = finYear.substring(2, 4) + finYear.substring(finYear.length() - 2, finYear.length());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)(" The year String :" + year));
            }
            txnType = fType.concat(txnType);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)" In CommonMethodsImpl :getTxnNumber method ");
            }
            CFiscalPeriod fiscalPeriodObj = (CFiscalPeriod)this.persistenceService.find("from CFiscalPeriod where id=?", new Object[]{Long.parseLong(fiscalPeriod)});
            String sequenceName = VoucherHelper.sequenceNameFor(txnType, fiscalPeriodObj.getName());
            Serializable runningNumber = this.applicationSequenceNumberGenerator.getNextSequence(sequenceName);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("----- Txn Number : " + runningNumber));
            }
            retVal = txnType + "/" + runningNumber.toString() + "/" + month[1] + "/" + year;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Return value is :" + retVal));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exp=" + e.getMessage()), (Throwable)e);
            throw new Exception(e.toString());
        }
        return retVal;
    }

    @Override
    public String getTransRunningNumber(String fundId, String txnType, String vDate, Connection con) throws Exception {
        if (txnType == null || txnType.equals("")) {
            throw new Exception("Configuration setting for voucher numbering is not done");
        }
        String fType = "";
        String finYear = "";
        String fiscalPeriod = "";
        String retVal = "";
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
        String txndate = formatter.format(sdf.parse(vDate));
        String sql = "select a.FINANCIALYEAR,b.id from FINANCIALYEAR a,fiscalperiod b  where a.id=b.financialyearid AND '" + txndate + "' between b.startingdate and b.endingdate";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("sql in getTransRunningNumber() :" + sql));
        }
        try {
            String query = "SELECT identifier as \"fund_identi\" from fund where id= ?";
            this.pst = this.persistenceService.getSession().createSQLQuery("SELECT identifier as \"fund_identi\" from fund where id= ?");
            this.pst.setString(0, fundId);
            this.rset = this.pst.list();
            for (Object[] element : this.rset) {
                fType = element[0].toString();
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info((Object)("Fund Id  :--->" + fundId + " Fund Type  :---->" + fType));
            }
            if (this.rset == null || this.rset.size() == 0) {
                throw new Exception("Fund is not defined in the system");
            }
            this.pst = this.persistenceService.getSession().createSQLQuery(sql);
            this.rset = this.pst.list();
            for (Object[] element : this.rset) {
                finYear = element[0].toString();
                fiscalPeriod = element[1].toString();
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("finYear id>>>>>>>" + finYear + " fiscalPeriod :" + fiscalPeriod));
            }
            if (this.rset == null || this.rset.size() == 0) {
                throw new Exception("Year is not defined in the system");
            }
            txnType = fType.concat(txnType);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)" In CommonMethodsImpl :getTxnNumber method ");
            }
            CFiscalPeriod fiscalPeriodObj = (CFiscalPeriod)this.persistenceService.find("from CFiscalPeriod where id=?", new Object[]{Long.parseLong(fiscalPeriod)});
            String sequenceName = VoucherHelper.sequenceNameFor(txnType, fiscalPeriodObj.getName());
            Serializable runningNumber = this.applicationSequenceNumberGenerator.getNextSequence(sequenceName);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("----- Running Number : " + runningNumber));
            }
            retVal = runningNumber.toString();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Return value is in getTransRunningNumber() :" + retVal));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exp occured in getTransRunningNumber() :" + e.getMessage()), (Throwable)e);
            throw new Exception(e.toString());
        }
        return retVal;
    }

    @Override
    public Integer getDivisionIdFromCode(String divisionCode, Connection connection) throws Exception {
        Integer divId = null;
        String sql = "Select id_bndry from EG_BOUNDARY where BNDRY_NUM= ? and is_bndry_active=1 order by id_bndry_type desc";
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Sub Field id query-->>>>>>>> Select id_bndry from EG_BOUNDARY where BNDRY_NUM= ? and is_bndry_active=1 order by id_bndry_type desc");
        }
        this.pst = this.persistenceService.getSession().createSQLQuery("Select id_bndry from EG_BOUNDARY where BNDRY_NUM= ? and is_bndry_active=1 order by id_bndry_type desc");
        this.pst.setString(0, divisionCode);
        this.rset = this.pst.list();
        for (Object[] element : this.rset) {
            divId = Integer.parseInt(element[0].toString());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Sub Feild id is >>>>>>>" + divId));
        }
        return divId;
    }
}

