/*
 * Decompiled with CFR 0.152.
 */
package org.egov.utils;

import com.exilant.eGov.src.common.EGovernCommon;
import com.exilant.exility.common.TaskFailedException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.CFiscalPeriod;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.Fund;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.commons.dao.FiscalPeriodHibernateDAO;
import org.egov.commons.dao.FundHibernateDAO;
import org.egov.eis.entity.EmployeeView;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.infra.persistence.utils.DBSequenceGenerator;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.egov.infra.script.service.ScriptService;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.bills.EgBillregister;
import org.egov.model.voucher.VoucherDetails;
import org.egov.pims.service.EisUtilService;
import org.egov.utils.Constants;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;

public class VoucherHelper {
    private static final Logger LOGGER = Logger.getLogger(VoucherHelper.class);
    public static final String DEFAULT_SEQUENCE_PREFIX = "SQ_";
    private PersistenceService persistenceService;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private FundHibernateDAO fundDAO;
    @Autowired
    private ScriptService scriptService;
    @Autowired
    private EGovernCommon eGovernCommon;
    @Autowired
    private FiscalPeriodHibernateDAO fiscalPeriodHibernateDAO;
    @Autowired
    private FinancialYearHibernateDAO financialYearDAO;
    @Autowired
    private DBSequenceGenerator dbSequenceGenerator;
    @Autowired
    private SequenceNumberGenerator sequenceNumberGenerator;
    @Autowired
    ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;
    public static final List<String> VOUCHER_TYPES = new ArrayList<String>(){
        private static final long serialVersionUID = -9199043129962242423L;
        {
            this.add("Contra");
            this.add("Payment");
            this.add("Receipt");
            this.add("Journal Voucher");
        }
    };
    public static final List<String> EXPENDITURE_TYPES = new ArrayList<String>(){
        private static final long serialVersionUID = -1656096571931607572L;
        {
            this.add("Expense");
            this.add("Works");
            this.add("Purchase");
            this.add("Advance");
        }
    };
    public static final List<String> CONTRAVOUCHER_NAMES = new ArrayList<String>(){
        private static final long serialVersionUID = -8773307498671866960L;
        {
            this.add("BankToBank");
            this.add("Pay in slip");
            this.add("InterFundTransfer");
        }
    };
    public static final List<String> PAYMENTVOUCHER_NAMES = new ArrayList<String>(){
        private static final long serialVersionUID = 1404413607001795999L;
        {
            this.add("Bill Payment");
            this.add("Direct Bank Payment");
            this.add("Remittance Payment");
            this.add("Salary Bill Payment");
            this.add("Pension Bill Payment");
            this.add("Advance Payment");
        }
    };
    public static final List<String> JOURNALVOUCHER_NAMES = new ArrayList<String>(){
        private static final long serialVersionUID = -5257979039834154425L;
        {
            this.add("JVGeneral");
            this.add("Supplier Journal");
            this.add("Contractor Journal");
            this.add("Salary Journal");
            this.add("Expense Journal");
            this.add("Pension Journal");
            this.add("Issue");
            this.add("Supplier Receipt");
            this.add("LE-Demand-Voucher");
            this.add("Receipt Reversal");
            this.add("Advance Journal");
        }
    };
    public static final List<String> RECEIPT_NAMES = new ArrayList<String>(){
        private static final long serialVersionUID = -911416421181673151L;
        {
            this.add("Direct");
            this.add("Payment Reversal");
            this.add("Other Receipts");
        }
    };
    public static final Map<String, List<String>> VOUCHER_TYPE_NAMES = new HashMap<String, List<String>>(){
        private static final long serialVersionUID = -7593762823617257861L;
        {
            this.put(VOUCHER_TYPES.get(0), CONTRAVOUCHER_NAMES);
            this.put(VOUCHER_TYPES.get(1), PAYMENTVOUCHER_NAMES);
            this.put(VOUCHER_TYPES.get(2), RECEIPT_NAMES);
            this.put(VOUCHER_TYPES.get(3), JOURNALVOUCHER_NAMES);
        }
    };
    public static final List<String> TNEB_REGIONS = new ArrayList<String>(){
        private static final long serialVersionUID = 409633391340882378L;
        {
            this.add("SE/CEDC/NORTH");
            this.add("SE/CEDC/SOUTH");
            this.add("SE/CEDC/CENTRAL");
            this.add("SE/CEDC/EAST");
            this.add("SE/CEDC/WEST");
        }
    };

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public static String getMisQuery(CVoucherHeader voucherHeader) {
        StringBuffer misQuery = new StringBuffer();
        if (null != voucherHeader && null != voucherHeader.getVouchermis()) {
            if (null != voucherHeader.getVouchermis().getDepartmentid()) {
                misQuery.append(" and mis.departmentid.id=");
                misQuery.append(voucherHeader.getVouchermis().getDepartmentid().getId());
            }
            if (null != voucherHeader.getVouchermis().getFunctionary()) {
                misQuery.append(" and mis.functionary.id=");
                misQuery.append(voucherHeader.getVouchermis().getFunctionary().getId());
            }
            if (null != voucherHeader.getVouchermis().getSchemeid()) {
                misQuery.append(" and mis.schemeid.id=");
                misQuery.append(voucherHeader.getVouchermis().getSchemeid().getId());
            }
            if (null != voucherHeader.getVouchermis().getSubschemeid()) {
                misQuery.append(" and mis.subschemeid.id=");
                misQuery.append(voucherHeader.getVouchermis().getSubschemeid().getId());
            }
            if (null != voucherHeader.getVouchermis().getFundsource()) {
                misQuery.append(" and mis.fundsource.id=");
                misQuery.append(voucherHeader.getVouchermis().getFundsource().getId());
            }
            if (null != voucherHeader.getVouchermis().getDivisionid()) {
                misQuery.append(" and mis.divisionid.id=");
                misQuery.append(voucherHeader.getVouchermis().getDivisionid().getId());
            }
        }
        return misQuery.toString();
    }

    public static String getVoucherNumDateQuery(String voucherNumFrom, String voucherNumTo, String voucherDateFrom, String voucherDateTo) {
        StringBuffer numDateQuery = new StringBuffer();
        try {
            if (null != voucherNumFrom && StringUtils.isNotEmpty((String)voucherNumFrom)) {
                numDateQuery.append(" and vh.voucherNumber >'");
                numDateQuery.append(voucherNumFrom).append("'");
            }
            if (null != voucherNumTo && StringUtils.isNotEmpty((String)voucherNumTo)) {
                numDateQuery.append(" and vh.voucherNumber <'");
                numDateQuery.append(voucherNumTo).append("'");
            }
            if (null != voucherDateFrom && StringUtils.isNotEmpty((String)voucherDateFrom)) {
                numDateQuery.append(" and vh.voucherDate>='").append(Constants.DDMMYYYYFORMAT1.format(Constants.DDMMYYYYFORMAT2.parse(voucherDateFrom))).append("'");
            }
            if (null != voucherDateTo && StringUtils.isNotEmpty((String)voucherDateTo)) {
                numDateQuery.append(" and vh.voucherDate<='").append(Constants.DDMMYYYYFORMAT1.format(Constants.DDMMYYYYFORMAT2.parse(voucherDateTo))).append("'");
            }
        }
        catch (ParseException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Exception occured while parsing date" + e));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            throw new ApplicationRuntimeException("Error occured while executing search instrument query");
        }
        return numDateQuery.toString();
    }

    public static String getBillMisQuery(EgBillregister egBillRegister) {
        StringBuffer misQuery = new StringBuffer(300);
        if (null != egBillRegister && null != egBillRegister.getEgBillregistermis()) {
            if (null != egBillRegister.getEgBillregistermis().getFund()) {
                misQuery.append(" and billmis.fund.id=").append(egBillRegister.getEgBillregistermis().getFund().getId());
            }
            if (null != egBillRegister.getEgBillregistermis().getEgDepartment()) {
                misQuery.append(" and billmis.egDepartment.id=");
                misQuery.append(egBillRegister.getEgBillregistermis().getEgDepartment().getId());
            }
            if (null != egBillRegister.getEgBillregistermis().getFunctionaryid()) {
                misQuery.append(" and billmis.functionaryid.id=");
                misQuery.append(egBillRegister.getEgBillregistermis().getFunctionaryid().getId());
            }
            if (null != egBillRegister.getEgBillregistermis().getScheme()) {
                misQuery.append(" and billmis.scheme.id=");
                misQuery.append(egBillRegister.getEgBillregistermis().getScheme().getId());
            }
            if (null != egBillRegister.getEgBillregistermis().getSubScheme()) {
                misQuery.append(" and billmis.subScheme.id=");
                misQuery.append(egBillRegister.getEgBillregistermis().getSubScheme().getId());
            }
            if (null != egBillRegister.getEgBillregistermis().getFundsource()) {
                misQuery.append(" and billmis.fundsource.id=");
                misQuery.append(egBillRegister.getEgBillregistermis().getFundsource().getId());
            }
            if (null != egBillRegister.getEgBillregistermis().getFieldid()) {
                misQuery.append(" and billmis.fieldid.id=");
                misQuery.append(egBillRegister.getEgBillregistermis().getFieldid().getId());
            }
            if (null != egBillRegister.getBillnumber() && !egBillRegister.getBillnumber().equalsIgnoreCase("")) {
                misQuery.append(" and br.billnumber=");
                misQuery.append("'" + egBillRegister.getBillnumber() + "'");
            }
        }
        return misQuery.toString();
    }

    public static String sequenceNameFor(String voucherType, String fiscalPeriodName) {
        return DEFAULT_SEQUENCE_PREFIX + voucherType + ApplicationSequenceNumberGenerator.WORD_SEPARATOR_FOR_NAME + fiscalPeriodName;
    }

    public static String getBillDateQuery(String billDateFrom, String billDateTo) {
        StringBuffer numDateQuery = new StringBuffer();
        try {
            if (null != billDateFrom && StringUtils.isNotEmpty((String)billDateFrom)) {
                numDateQuery.append(" and br.billdate>='").append(Constants.DDMMYYYYFORMAT1.format(Constants.DDMMYYYYFORMAT2.parse(billDateFrom))).append("'");
            }
            if (null != billDateTo && StringUtils.isNotEmpty((String)billDateTo)) {
                numDateQuery.append(" and br.billdate<='").append(Constants.DDMMYYYYFORMAT1.format(Constants.DDMMYYYYFORMAT2.parse(billDateTo))).append("'");
            }
        }
        catch (ParseException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Exception occured while parsing date" + e));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            throw new ApplicationRuntimeException("Error occured while executing search instrument query");
        }
        return numDateQuery.toString();
    }

    public String getEg_Voucher(String vouType, String fiscalPeriodIdStr) throws TaskFailedException, Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)" In EGovernCommon :getEg_Voucher method ");
        }
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select name from fiscalperiod where id=" + Integer.parseInt(fiscalPeriodIdStr) + "");
        List fc = query.list();
        String sequenceName = VoucherHelper.sequenceNameFor(vouType, ((String)fc.get(0)).toString());
        Serializable sequenceNumber = this.applicationSequenceNumberGenerator.getNextSequence(sequenceName);
        return sequenceNumber.toString();
    }

    public String getGeneratedVoucherNumber(Integer fundId, String voucherType, Date voucherDate, String vNumGenMode, String voucherNumber) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("fundId | in getGeneratedVoucherNumber      :" + fundId));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("voucherType | in getGeneratedVoucherNumber :" + voucherType));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("voucherDate | in getGeneratedVoucherNumber :" + voucherDate));
        }
        String vDate = Constants.DDMMYYYYFORMAT2.format(voucherDate);
        String vDateTemp = Constants.DDMMYYYYFORMAT1.format(voucherDate);
        CFiscalPeriod fiscalPeriod = this.fiscalPeriodHibernateDAO.getFiscalPeriodByDate(voucherDate);
        if (fiscalPeriod == null) {
            throw new ApplicationRuntimeException("Fiscal period is not defined for the voucher date");
        }
        Fund vFund = this.fundDAO.fundById(fundId, false);
        String fundIdentifier = vFund.getIdentifier().toString();
        String sequenceName = VoucherHelper.sequenceNameFor(fundIdentifier + "/" + voucherType, fiscalPeriod.getName());
        String transNumber = "";
        if (vNumGenMode == null) {
            vNumGenMode = "Auto";
        }
        if (voucherNumber == null) {
            voucherNumber = "";
        }
        if (voucherType == null) {
            voucherType = "";
        }
        String fVoucherNumber = null;
        if (vNumGenMode.equalsIgnoreCase("Auto")) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)" before transNumber................");
            }
            String[] monthArr = vDate.split("/");
            String month = monthArr[1];
            String scriptName = "voucherheader.vouchernumber";
            this.scriptService.getByName("voucherheader.vouchernumber");
            ScriptContext scriptContext = ScriptService.createContext((Object[])new Object[]{"fundIdentity", fundIdentifier, "voucherType", voucherType, "transNumber", "", "vNumGenMode", vNumGenMode, "date", voucherDate, "month", month, "commonsService", this.financialYearDAO, "dbSequenceGenerator", this.dbSequenceGenerator, "sequenceNumberGenerator", this.applicationSequenceNumberGenerator, "voucherNumber", voucherNumber, "sequenceName", sequenceName});
            fVoucherNumber = (String)this.scriptService.executeScript("voucherheader.vouchernumber", scriptContext);
        } else {
            fVoucherNumber = fundIdentifier + "/" + voucherType + "/" + voucherNumber;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("fVoucherNumber | fVoucherNumber in getGeneratedVoucherNumber :" + fVoucherNumber));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("unique checking for voucher number :- " + fVoucherNumber));
        }
        if (!this.eGovernCommon.isUniqueVN(fVoucherNumber, vDateTemp, null)) {
            throw new ApplicationRuntimeException("Trying to create Duplicate Voucher Number");
        }
        return fVoucherNumber;
    }

    public static List<String> getRepeatedGlcodes(List<VoucherDetails> billDetailslist) {
        ArrayList<String> list = new ArrayList<String>();
        HashMap<String, String> map = new HashMap<String, String>();
        for (VoucherDetails voucherDetail : billDetailslist) {
            String glCodeIdDetail = voucherDetail.getGlcodeIdDetail().toString();
            if (map.containsKey(glCodeIdDetail)) {
                list.add(glCodeIdDetail);
                continue;
            }
            map.put(glCodeIdDetail, glCodeIdDetail);
        }
        return list;
    }

    public List<Department> getAllAssgnDeptforUser() {
        new HashMap();
        ArrayList listEmployeeView = new ArrayList();
        ArrayList<Department> departmentList = new ArrayList<Department>();
        for (EmployeeView employeeView : listEmployeeView) {
            employeeView.getDepartment().getName();
            if (employeeView.getPrimary().booleanValue()) {
                departmentList.add(0, employeeView.getDepartment());
                continue;
            }
            departmentList.add(employeeView.getDepartment());
        }
        return departmentList;
    }

    public EisCommonService getEisCommonService() {
        return this.eisCommonService;
    }

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }

    public void setEisUtilService(EisUtilService eisUtilService) {
    }

    public EGovernCommon geteGovernCommon() {
        return this.eGovernCommon;
    }

    public void seteGovernCommon(EGovernCommon eGovernCommon) {
        this.eGovernCommon = eGovernCommon;
    }

    public FiscalPeriodHibernateDAO getFiscalPeriodHibernateDAO() {
        return this.fiscalPeriodHibernateDAO;
    }

    public void setFiscalPeriodHibernateDAO(FiscalPeriodHibernateDAO fiscalPeriodHibernateDAO) {
        this.fiscalPeriodHibernateDAO = fiscalPeriodHibernateDAO;
    }
}

