/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.report;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.egf.model.CommonReportBean;
import org.egov.egf.model.FunctionwiseIE;
import org.egov.egf.model.FunctionwiseIEEntry;
import org.egov.egf.model.ReportSearch;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.utils.Constants;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.BooleanType;
import org.hibernate.type.LongType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class FunctionwiseIEService {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    AppConfigValueService appConfigValuesService;
    protected SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy", Constants.LOCALE);
    protected SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy", Constants.LOCALE);
    private static final Logger LOGGER = Logger.getLogger(FunctionwiseIEService.class);
    private String capExpCodeCond = "";
    private String capExpCodesWithQuotesCond = "";

    public String getFilterQueryVoucher(ReportSearch reportSearch) throws ApplicationException, ParseException {
        String excludeStatus = ((AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("finance", "statusexcludeReport").get(0)).getValue();
        String appendQry = "";
        appendQry = " AND vh.voucherdate>=TO_DATE('" + this.formatter.format(this.sdf.parse(reportSearch.getStartDate())) + "') ";
        appendQry = appendQry + " AND vh.voucherdate<=TO_DATE('" + this.formatter.format(this.sdf.parse(reportSearch.getEndDate())) + "') ";
        appendQry = this.getFiltersExcludingDate(reportSearch, excludeStatus, appendQry);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("appendQry==" + appendQry));
        }
        return appendQry;
    }

    public String getFilterQueryVoucherAsOnDate(ReportSearch reportSearch) throws ApplicationException, ParseException {
        String excludeStatus = ((AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("finance", "statusexcludeReport").get(0)).getValue();
        String appendQry = "";
        appendQry = " AND vh.voucherdate>=TO_DATE('" + this.formatter.format(reportSearch.getYearStartDate()) + "') ";
        appendQry = appendQry + " AND vh.voucherdate<=TO_DATE('" + this.formatter.format(reportSearch.getAsOnDate()) + "') ";
        appendQry = this.getFiltersExcludingDate(reportSearch, excludeStatus, appendQry);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("appendQry==" + appendQry));
        }
        return appendQry;
    }

    public String getFilterQueryVoucherAsOnPreviousYearDate(ReportSearch reportSearch) throws ApplicationException, ParseException {
        String excludeStatus = ((AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("finance", "statusexcludeReport").get(0)).getValue();
        String appendQry = "";
        appendQry = " AND vh.voucherdate>=TO_DATE('" + this.formatter.format(reportSearch.getPreviousYearStartDate()) + "') ";
        appendQry = appendQry + " AND vh.voucherdate<=TO_DATE('" + this.formatter.format(reportSearch.getPreviousYearDate()) + "') ";
        appendQry = this.getFiltersExcludingDate(reportSearch, excludeStatus, appendQry);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("appendQry==" + appendQry));
        }
        return appendQry;
    }

    private String getFiltersExcludingDate(ReportSearch reportSearch, String excludeStatus, String appendQry) {
        appendQry = appendQry + " AND vh.status NOT IN (" + excludeStatus + ")";
        if (reportSearch.getFund() != null && reportSearch.getFund().getId() != null) {
            appendQry = appendQry + " AND vh.fundid =" + reportSearch.getFund().getId();
        }
        if (reportSearch.getFundsource() != null && reportSearch.getFundsource().getId() != null) {
            appendQry = appendQry + " AND vh.fundsourceid =" + reportSearch.getFundsource().getId();
        }
        if (reportSearch.getDepartment() != null && reportSearch.getDepartment().getId() != null) {
            appendQry = appendQry + " AND vmis.departmentid =" + reportSearch.getDepartment().getId();
        }
        if (reportSearch.getField() != null && reportSearch.getField().getId() != null) {
            appendQry = appendQry + " AND vmis.divisionid =" + reportSearch.getField().getId();
        }
        if (reportSearch.getScheme() != null && reportSearch.getScheme().getId() != null) {
            appendQry = appendQry + " AND vmis.schemeid =" + reportSearch.getScheme().getId();
        }
        if (reportSearch.getSubScheme() != null && reportSearch.getSubScheme().getId() != null) {
            appendQry = appendQry + " AND vmis.subschemeid =" + reportSearch.getSubScheme().getId();
        }
        if (reportSearch.getFunctionary() != null && reportSearch.getFunctionary().getId() != null) {
            appendQry = appendQry + " AND vmis.functionaryid =" + reportSearch.getFunctionary().getId();
        }
        return appendQry;
    }

    public String getFilterQueryGL(ReportSearch reportSearch) {
        String appendQry = "";
        if (reportSearch.getFunction() != null && reportSearch.getFunction().getId() != null) {
            appendQry = appendQry + " AND gl.functionid =" + reportSearch.getFunction().getId();
        }
        return appendQry;
    }

    public void getMajorCodeList(FunctionwiseIE functionwiseIE, ReportSearch reportSearch) throws ApplicationException, ParseException {
        ArrayList<String> majorCodeList = new ArrayList<String>();
        String filterQuery = this.getFilterQueryVoucher(reportSearch);
        String sql = "select distinct SUBSTR(gl.glcode,1," + reportSearch.getMinorCodeLen() + "),coa.name from CHARTOFACCOUNTS coa,GENERALLEDGER gl WHERE gl.functionid is not null and gl.voucherheaderid IN (SELECT vh.id FROM VOUCHERHEADER vh,vouchermis vmis WHERE vh.id=vmis.voucherheaderid " + filterQuery + " AND coa.TYPE='" + reportSearch.getIncExp() + "' AND SUBSTR(gl.glcode,1," + reportSearch.getMajorCodeLen() + ")=coa.glcode) " + this.getFilterQueryGL(reportSearch) + " ORDER BY 1";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("sql====================" + sql));
        }
        SQLQuery query = this.persistenceService.getSession().createSQLQuery(sql);
        List list = query.list();
        for (Object[] obj : list) {
            majorCodeList.add(obj[0].toString() + "-" + obj[1].toString());
        }
        functionwiseIE.setMajorCodeList(majorCodeList);
    }

    public List<String> getMinorCodeList(ReportSearch reportSearch) throws ApplicationException, ParseException {
        ArrayList<String> minorCodeList = new ArrayList<String>();
        String filterQuery = this.getFilterQueryVoucher(reportSearch);
        String sql = "select distinct SUBSTR(gl.glcode,1," + reportSearch.getMinorCodeLen() + "),coa.name from CHARTOFACCOUNTS coa,GENERALLEDGER gl WHERE gl.functionid is not null and gl.voucherheaderid IN (SELECT vh.id FROM VOUCHERHEADER vh,vouchermis vmis WHERE vh.id=vmis.voucherheaderid " + filterQuery + " AND coa.TYPE='" + reportSearch.getIncExp() + "' AND SUBSTR(gl.glcode,1," + reportSearch.getMinorCodeLen() + ")=coa.glcode) " + this.getFilterQueryGL(reportSearch) + " ORDER BY 1";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("sql====================" + sql));
        }
        SQLQuery query = this.persistenceService.getSession().createSQLQuery(sql);
        List list = query.list();
        for (Object[] obj : list) {
            minorCodeList.add(obj[0].toString() + "-" + obj[1].toString());
        }
        return minorCodeList;
    }

    public List<CommonReportBean> getMinorAndMajorCodeList(ReportSearch reportSearch) throws ApplicationException, ParseException {
        String sql = "";
        sql = reportSearch.getByDepartment() && reportSearch.getByDetailCode() ? " select coa.glcode as accCode,coa.name as name,null as schedule,null as FIEscheduleId,0 as isMajor from Chartofaccounts coa where  coa.type=:type and length(coa.glcode)=" + reportSearch.getMinorCodeLen() + " and coa.glcode like :glcode and classification=4 and isActiveForPosting=true order by 1 " : (reportSearch.getByDepartment() ? " select coa.glcode as accCode,coa.name as name,mp.schedule as schedule,mp.id as FIEscheduleId,0 as isMajor from Chartofaccounts coa,Schedulemapping mp where coa.FIEscheduleId=mp.id and coa.type=:type and length(coa.glcode)=" + reportSearch.getMinorCodeLen() + " and coa.FIEscheduleId=:FIEscheduleId  order by 1" : " select coa.glcode as accCode,coa.name as name,mp.schedule as schedule,mp.id as FIEscheduleId, 0 as isMajor from Chartofaccounts coa,Schedulemapping mp where coa.FIEscheduleId=mp.id and coa.type=:type and length(coa.glcode)=" + reportSearch.getMinorCodeLen() + " Union " + " select coa.glcode as accCode,coa.name as name,null as schedule,null as FIEscheduleId ,1 as isMajor from Chartofaccounts coa" + " where  coa.type=:type and length(coa.glcode)=" + reportSearch.getMajorCodeLen() + " order by 1");
        Query query = this.persistenceService.getSession().createSQLQuery(sql).addScalar("accCode", (Type)StringType.INSTANCE).addScalar("name", (Type)StringType.INSTANCE).addScalar("schedule", (Type)StringType.INSTANCE).addScalar("FIEscheduleId", (Type)LongType.INSTANCE).addScalar("isMajor", (Type)BooleanType.INSTANCE).setString("type", reportSearch.getIncExp()).setResultTransformer(Transformers.aliasToBean(CommonReportBean.class));
        if (reportSearch.getByDetailCode()) {
            query.setString("glcode", reportSearch.getGlcode() + "%");
        } else if (reportSearch.getByDepartment()) {
            query.setLong("FIEscheduleId", reportSearch.getFIEscheduleId().longValue());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("----------------" + sql));
        }
        return query.list();
    }

    public List<CommonReportBean> getMinorAndMajorCodeListForCapitalExp(ReportSearch reportSearch) throws ApplicationException, ParseException {
        String sql = "";
        sql = reportSearch.getByDepartment() && reportSearch.getByDetailCode() ? " select coa.glcode as accCode,coa.name as name,null as schedule,null as FIEscheduleId,0 as isMajor from Chartofaccounts coa where  coa.type=:type and length(coa.glcode)=" + reportSearch.getMinorCodeLen() + " and coa.glcode like :glcode and classification=4 and isActiveForPosting=true order by 1 " : (reportSearch.getByDepartment() ? " select coa.glcode as accCode,coa.name as name,mp.schedule as schedule,mp.id as FIEscheduleId,0 as isMajor from Chartofaccounts coa,Schedulemapping mp where coa.FIEscheduleId=mp.id and coa.type=:type and length(coa.glcode)=" + reportSearch.getMinorCodeLen() + " and coa.FIEscheduleId=:FIEscheduleId  order by 1" : " select coa.glcode as accCode,coa.name as name,mp.schedule as schedule,mp.id as FIEscheduleId, 0 as isMajor from Chartofaccounts coa,Schedulemapping mp where coa.FIEscheduleId=mp.id and coa.type=:type and length(coa.glcode)=" + reportSearch.getMinorCodeLen() + " Union " + " select coa.glcode as accCode,coa.name as name,null as schedule,null as FIEscheduleId ,1 as isMajor from Chartofaccounts coa" + " where  coa.type=:type and length(coa.glcode)=" + reportSearch.getMajorCodeLen() + "and coa.glcode in (" + this.capExpCodesWithQuotesCond + ")" + " order by 1");
        Query query = this.persistenceService.getSession().createSQLQuery(sql).addScalar("accCode", (Type)StringType.INSTANCE).addScalar("name", (Type)StringType.INSTANCE).addScalar("schedule", (Type)StringType.INSTANCE).addScalar("FIEscheduleId", (Type)LongType.INSTANCE).addScalar("isMajor", (Type)BooleanType.INSTANCE).setString("type", "A").setResultTransformer(Transformers.aliasToBean(CommonReportBean.class));
        if (reportSearch.getByDetailCode()) {
            query.setString("glcode", reportSearch.getGlcode() + "%");
        } else if (reportSearch.getByDepartment()) {
            query.setLong("FIEscheduleId", reportSearch.getFIEscheduleId().longValue());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("----------------" + sql));
        }
        return query.list();
    }

    public List<CommonReportBean> getIncomeMinorAndMajorCodeList(ReportSearch reportSearch) throws ApplicationException, ParseException {
        String sql = "";
        sql = reportSearch.getByDepartment() && reportSearch.getByDetailCode() ? " select coa.glcode as accCode,coa.name as name,null as schedule,null as FIEscheduleId,0 as isMajor from Chartofaccounts coa where  coa.type=:type and length(coa.glcode)=" + reportSearch.getMinorCodeLen() + " and coa.glcode like :glcode and classification=4 and isActiveForPosting=true order by 1 " : (reportSearch.getByDepartment() ? " select coa.glcode as accCode,coa.name as name,mp.schedule as schedule,mp.id as FIEscheduleId,0 as isMajor from Chartofaccounts coa,Schedulemapping mp where coa.FIEscheduleId=mp.id and coa.type=:type and length(coa.glcode)=" + reportSearch.getMinorCodeLen() + " and coa.FIEscheduleId=:FIEscheduleId  order by 1" : " select coa.glcode as accCode,coa.name as name,mp.schedule as schedule,mp.id as FIEscheduleId, 0 as isMajor from Chartofaccounts coa,Schedulemapping mp where coa.FIEscheduleId=mp.id and coa.type=:type and length(coa.glcode)=" + reportSearch.getMinorCodeLen() + " Union " + " select coa.glcode as accCode,coa.name as name,null as schedule,null as FIEscheduleId ,1 as isMajor from Chartofaccounts coa" + " where  coa.type=:type and length(coa.glcode)=" + reportSearch.getMajorCodeLen() + " order by 1");
        Query query = this.persistenceService.getSession().createSQLQuery(sql).addScalar("accCode", (Type)StringType.INSTANCE).addScalar("name", (Type)StringType.INSTANCE).addScalar("schedule", (Type)StringType.INSTANCE).addScalar("FIEscheduleId", (Type)LongType.INSTANCE).addScalar("isMajor", (Type)BooleanType.INSTANCE).setString("type", reportSearch.getIncExp()).setResultTransformer(Transformers.aliasToBean(CommonReportBean.class));
        if (reportSearch.getByDetailCode()) {
            query.setString("glcode", reportSearch.getGlcode() + "%");
        } else if (reportSearch.getByDepartment()) {
            query.setLong("FIEscheduleId", reportSearch.getFIEscheduleId().longValue());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("----------------" + sql));
        }
        return query.list();
    }

    public void getAmountList(FunctionwiseIE functionwiseIE, ReportSearch reportSearch) throws ApplicationException, ParseException {
        String sql = "SELECT fn.code,fn.name,CONCAT(CONCAT(coa.majorcode,'-'),coa.name),case '" + reportSearch.getIncExp() + "' when  'I' then (SUM(gl.creditamount)-SUM(gl.debitamount)) when 'E' then (SUM(gl.debitamount)-SUM(gl.creditamount)) else 0 end AS amt " + " FROM GENERALLEDGER gl,FUNCTION fn,VOUCHERHEADER vh, CHARTOFACCOUNTS coa,vouchermis vmis " + " WHERE vh.id=vmis.voucherheaderid and vh.ID=gl.voucherheaderid AND SUBSTR(gl.glcode,1," + reportSearch.getMajorCodeLen() + ")=coa.glcode AND coa.TYPE='" + reportSearch.getIncExp() + "' " + " AND fn.id = gl.functionid " + this.getFilterQueryVoucher(reportSearch) + this.getFilterQueryGL(reportSearch) + " GROUP BY fn.code,fn.name,CONCAT(CONCAT(coa.majorcode,'-'),coa.name) order by 1,3";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("sql===" + sql));
        }
        SQLQuery query = this.persistenceService.getSession().createSQLQuery(sql);
        List list = query.list();
        FunctionwiseIEEntry entry = new FunctionwiseIEEntry();
        HashMap<String, BigDecimal> majorcodeWiseAmount = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> totalAmountMap = new HashMap<String, BigDecimal>();
        String tempFunctionCode = "";
        BigDecimal totalIncome = BigDecimal.ZERO;
        BigDecimal grandTotal = BigDecimal.ZERO;
        int i = 1;
        for (Object[] obj : list) {
            if (tempFunctionCode.equals(obj[0].toString())) {
                if (functionwiseIE.getMajorCodeList().contains(obj[2].toString())) {
                    majorcodeWiseAmount.put(obj[2].toString(), this.round((BigDecimal)obj[3]));
                    totalIncome = totalIncome.add((BigDecimal)obj[3]);
                }
            } else {
                if (!majorcodeWiseAmount.isEmpty()) {
                    entry.setTotalIncome(this.round(totalIncome));
                    entry.setMajorcodeWiseAmount(majorcodeWiseAmount);
                    functionwiseIE.add(entry);
                    totalIncome = BigDecimal.ZERO;
                }
                entry = new FunctionwiseIEEntry();
                entry.setSlNo(String.valueOf(i++));
                entry.setFunctionCode(obj[0].toString());
                entry.setFunctionName(obj[1].toString());
                majorcodeWiseAmount = new HashMap();
                if (functionwiseIE.getMajorCodeList().contains(obj[2].toString())) {
                    majorcodeWiseAmount.put(obj[2].toString(), this.round((BigDecimal)obj[3]));
                    totalIncome = totalIncome.add((BigDecimal)obj[3]);
                }
            }
            if (totalAmountMap.containsKey(obj[2].toString())) {
                totalAmountMap.put(obj[2].toString(), ((BigDecimal)totalAmountMap.get(obj[2].toString())).add((BigDecimal)obj[3]));
            } else {
                totalAmountMap.put(obj[2].toString(), (BigDecimal)obj[3]);
            }
            grandTotal = grandTotal.add((BigDecimal)obj[3]);
            tempFunctionCode = obj[0].toString();
        }
        if (!majorcodeWiseAmount.isEmpty()) {
            entry.setTotalIncome(this.round(totalIncome));
            entry.setMajorcodeWiseAmount(majorcodeWiseAmount);
            functionwiseIE.add(entry);
            entry = new FunctionwiseIEEntry();
            entry.setSlNo("");
            entry.setFunctionName("Total for the Period");
            entry.setTotalIncome(this.round(grandTotal));
            majorcodeWiseAmount = new HashMap();
            Iterator it = totalAmountMap.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                majorcodeWiseAmount.put(key, this.round((BigDecimal)totalAmountMap.get(key)));
            }
            entry.setMajorcodeWiseAmount(majorcodeWiseAmount);
            functionwiseIE.add(entry);
        }
    }

    public List<CommonReportBean> getAmountListForMinorCode(FunctionwiseIE functionwiseIE, ReportSearch reportSearch) throws ApplicationException, ParseException {
        String sql = "";
        Query query = null;
        if (reportSearch.getByDetailCode()) {
            sql = reportSearch.getIncExp().equalsIgnoreCase("E") ? "SELECT SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + ") as accCode,d.dept_name as deptName ,(SUM(gl.debitamount)-SUM(gl.creditamount)) AS amount,0 as isMajor " : "SELECT SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + ") as accCode,d.dept_name as deptName ,(SUM(gl.creditamount)-SUM(gl.debitamount)) AS amount,0 as isMajor ";
            sql = reportSearch.getIncExp().equalsIgnoreCase("E") ? sql + " FROM GENERALLEDGER gl,FUNCTION fn,VOUCHERHEADER vh, CHARTOFACCOUNTS coa,vouchermis vmis,eg_department d  " + " WHERE vh.id=vmis.voucherheaderid and vh.ID=gl.voucherheaderid AND SUBSTR(gl.glcode,1," + reportSearch.getMinorCodeLen() + ")=coa.glcode AND (coa.TYPE='" + reportSearch.getIncExp() + "' " + this.capExpCodeCond + ")" + " and d.dept_name=:deptName and coa.glcode like :glcode AND fn.id = gl.functionid  and vmis.departmentid=d.id_dept " + this.getFilterQueryVoucherAsOnDate(reportSearch) + this.getFilterQueryGL(reportSearch) + " GROUP BY  SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + "),d.dept_name " : sql + " FROM GENERALLEDGER gl,FUNCTION fn,VOUCHERHEADER vh, CHARTOFACCOUNTS coa,vouchermis vmis,eg_department d  " + " WHERE vh.id=vmis.voucherheaderid and vh.ID=gl.voucherheaderid AND SUBSTR(gl.glcode,1," + reportSearch.getMinorCodeLen() + ")=coa.glcode AND coa.TYPE='" + reportSearch.getIncExp() + "' " + " and d.dept_name=:deptName and coa.glcode like :glcode AND fn.id = gl.functionid  and vmis.departmentid=d.id_dept " + this.getFilterQueryVoucherAsOnDate(reportSearch) + this.getFilterQueryGL(reportSearch) + " GROUP BY  SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + "),d.dept_name ";
            sql = sql + "order by 2,1 ";
            query = this.persistenceService.getSession().createSQLQuery(sql).addScalar("accCode", (Type)StringType.INSTANCE).addScalar("amount", (Type)BigDecimalType.INSTANCE).addScalar("isMajor", (Type)BooleanType.INSTANCE).addScalar("deptName", (Type)StringType.INSTANCE).setString("glcode", reportSearch.getGlcode() + "%").setString("deptName", reportSearch.getDepartment().getName()).setResultTransformer(Transformers.aliasToBean(CommonReportBean.class));
        } else if (reportSearch.getByDepartment()) {
            sql = reportSearch.getIncExp().equalsIgnoreCase("E") ? "SELECT SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + ") as accCode,d.dept_name as deptName ,(SUM(gl.debitamount)-SUM(gl.creditamount)) AS amount,0 as isMajor " : "SELECT SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + ") as accCode,d.dept_name as deptName ,(SUM(gl.creditamount)-SUM(gl.debitamount)) AS amount,0 as isMajor ";
            sql = reportSearch.getIncExp().equalsIgnoreCase("E") ? sql + " FROM GENERALLEDGER gl,FUNCTION fn,VOUCHERHEADER vh, CHARTOFACCOUNTS coa,vouchermis vmis,eg_department d  " + " WHERE vh.id=vmis.voucherheaderid and vh.ID=gl.voucherheaderid AND SUBSTR(gl.glcode,1," + reportSearch.getMinorCodeLen() + ")=coa.glcode AND (coa.TYPE='" + reportSearch.getIncExp() + "'" + this.capExpCodeCond + ")" + " AND fn.id = gl.functionid  and vmis.departmentid=d.id_dept " + this.getFilterQueryVoucherAsOnDate(reportSearch) + this.getFilterQueryGL(reportSearch) + " GROUP BY  SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + "),d.dept_name " : sql + " FROM GENERALLEDGER gl,FUNCTION fn,VOUCHERHEADER vh, CHARTOFACCOUNTS coa,vouchermis vmis,eg_department d  " + " WHERE vh.id=vmis.voucherheaderid and vh.ID=gl.voucherheaderid AND SUBSTR(gl.glcode,1," + reportSearch.getMinorCodeLen() + ")=coa.glcode AND coa.TYPE='" + reportSearch.getIncExp() + "' " + " AND fn.id = gl.functionid  and vmis.departmentid=d.id_dept " + this.getFilterQueryVoucherAsOnDate(reportSearch) + this.getFilterQueryGL(reportSearch) + " GROUP BY  SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + "),d.dept_name ";
            sql = sql + "order by 2,1 ";
            query = this.persistenceService.getSession().createSQLQuery(sql).addScalar("accCode", (Type)StringType.INSTANCE).addScalar("amount", (Type)BigDecimalType.INSTANCE).addScalar("isMajor", (Type)BooleanType.INSTANCE).addScalar("deptName", (Type)StringType.INSTANCE).setResultTransformer(Transformers.aliasToBean(CommonReportBean.class));
        } else {
            sql = reportSearch.getIncExp().equalsIgnoreCase("E") ? "SELECT coa.majorcode as accCode,coa.name as accName,(SUM(gl.debitamount)-SUM(gl.creditamount)) AS amount,1 as isMajor " : "SELECT coa.majorcode as accCode,coa.name as accName,(SUM(gl.creditamount)-SUM(gl.debitamount)) AS amount,1 as isMajor ";
            sql = reportSearch.getIncExp().equalsIgnoreCase("E") ? sql + " FROM GENERALLEDGER gl,FUNCTION fn,VOUCHERHEADER vh, CHARTOFACCOUNTS coa,vouchermis vmis  " + " WHERE vh.id=vmis.voucherheaderid and vh.ID=gl.voucherheaderid AND SUBSTR(gl.glcode,1," + reportSearch.getMajorCodeLen() + ")=coa.glcode AND (coa.TYPE='" + reportSearch.getIncExp() + "'" + this.capExpCodeCond + ")" + " AND fn.id = gl.functionid " + this.getFilterQueryVoucherAsOnDate(reportSearch) + this.getFilterQueryGL(reportSearch) + " GROUP BY coa.majorcode,coa.name " : sql + " FROM GENERALLEDGER gl,FUNCTION fn,VOUCHERHEADER vh, CHARTOFACCOUNTS coa,vouchermis vmis  " + " WHERE vh.id=vmis.voucherheaderid and vh.ID=gl.voucherheaderid AND SUBSTR(gl.glcode,1," + reportSearch.getMajorCodeLen() + ")=coa.glcode AND coa.TYPE='" + reportSearch.getIncExp() + "' " + " AND fn.id = gl.functionid " + this.getFilterQueryVoucherAsOnDate(reportSearch) + this.getFilterQueryGL(reportSearch) + " GROUP BY coa.majorcode,coa.name ";
            sql = reportSearch.getIncExp().equalsIgnoreCase("E") ? sql + " Union SELECT SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + ") as accCode, coa.name  as accName,(SUM(gl.debitamount)-SUM(gl.creditamount)) AS amount ,0 as isMajor " : sql + " Union SELECT SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + ") as accCode, coa.name  as accName,(SUM(gl.creditamount)-SUM(gl.debitamount)) AS amount ,0 as isMajor ";
            sql = reportSearch.getIncExp().equalsIgnoreCase("E") ? sql + " FROM GENERALLEDGER gl,FUNCTION fn,VOUCHERHEADER vh, CHARTOFACCOUNTS coa,vouchermis vmis " + " WHERE vh.id=vmis.voucherheaderid and vh.ID=gl.voucherheaderid AND SUBSTR(gl.glcode,1," + reportSearch.getMinorCodeLen() + ")=coa.glcode AND (coa.TYPE='" + reportSearch.getIncExp() + "'" + this.capExpCodeCond + ")" + " AND fn.id = gl.functionid " + this.getFilterQueryVoucherAsOnDate(reportSearch) + this.getFilterQueryGL(reportSearch) + " GROUP BY SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + "),coa.name order by 1,2 " : sql + " FROM GENERALLEDGER gl,FUNCTION fn,VOUCHERHEADER vh, CHARTOFACCOUNTS coa,vouchermis vmis " + " WHERE vh.id=vmis.voucherheaderid and vh.ID=gl.voucherheaderid AND SUBSTR(gl.glcode,1," + reportSearch.getMinorCodeLen() + ")=coa.glcode AND coa.TYPE='" + reportSearch.getIncExp() + "' " + " AND fn.id = gl.functionid " + this.getFilterQueryVoucherAsOnDate(reportSearch) + this.getFilterQueryGL(reportSearch) + " GROUP BY SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + "),coa.name order by 1,2 ";
            query = this.persistenceService.getSession().createSQLQuery(sql).addScalar("accCode", (Type)StringType.INSTANCE).addScalar("amount", (Type)BigDecimalType.INSTANCE).addScalar("isMajor", (Type)BooleanType.INSTANCE).setResultTransformer(Transformers.aliasToBean(CommonReportBean.class));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("sql===" + sql));
        }
        List list = query.list();
        return list;
    }

    public List<CommonReportBean> getPreviousYearAmountListForMinorCode(FunctionwiseIE functionwiseIE, ReportSearch reportSearch) throws ApplicationException, ParseException {
        String sql = "";
        Query query = null;
        if (reportSearch.getByDetailCode()) {
            sql = reportSearch.getIncExp().equalsIgnoreCase("E") ? "SELECT SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + ") as accCode,d.dept_name as deptName ,(SUM(gl.debitamount)-SUM(gl.creditamount)) AS amount,0 as isMajor " : "SELECT SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + ") as accCode,d.dept_name as deptName ,(SUM(gl.creditamount)-SUM(gl.debitamount)) AS amount,0 as isMajor ";
            sql = sql + " FROM GENERALLEDGER gl,FUNCTION fn,VOUCHERHEADER vh, CHARTOFACCOUNTS coa,vouchermis vmis,eg_department d  " + " WHERE vh.id=vmis.voucherheaderid and vh.ID=gl.voucherheaderid AND SUBSTR(gl.glcode,1," + reportSearch.getMinorCodeLen() + ")=coa.glcode AND coa.TYPE='" + reportSearch.getIncExp() + "' " + " and d.dept_name=:deptName and coa.glcode like :glcode AND fn.id = gl.functionid  and vmis.departmentid=d.id_dept " + this.getFilterQueryVoucherAsOnPreviousYearDate(reportSearch) + this.getFilterQueryGL(reportSearch) + " GROUP BY  SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + "),d.dept_name ";
            sql = sql + "order by 2,1 ";
            query = this.persistenceService.getSession().createSQLQuery(sql).addScalar("accCode", (Type)StringType.INSTANCE).addScalar("amount", (Type)BigDecimalType.INSTANCE).addScalar("isMajor", (Type)BooleanType.INSTANCE).addScalar("deptName", (Type)StringType.INSTANCE).setString("glcode", reportSearch.getGlcode() + "%").setString("deptName", reportSearch.getDepartment().getName()).setResultTransformer(Transformers.aliasToBean(CommonReportBean.class));
        } else if (reportSearch.getByDepartment()) {
            sql = reportSearch.getIncExp().equalsIgnoreCase("E") ? "SELECT SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + ") as accCode,d.dept_name as deptName ,(SUM(gl.debitamount)-SUM(gl.creditamount)) AS amount,0 as isMajor " : "SELECT SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + ") as accCode,d.dept_name as deptName ,(SUM(gl.creditamount)-SUM(gl.debitamount)) AS amount,0 as isMajor ";
            sql = sql + " FROM GENERALLEDGER gl,FUNCTION fn,VOUCHERHEADER vh, CHARTOFACCOUNTS coa,vouchermis vmis,eg_department d  " + " WHERE vh.id=vmis.voucherheaderid and vh.ID=gl.voucherheaderid AND SUBSTR(gl.glcode,1," + reportSearch.getMinorCodeLen() + ")=coa.glcode AND coa.TYPE='" + reportSearch.getIncExp() + "' " + " AND fn.id = gl.functionid  and vmis.departmentid=d.id_dept " + this.getFilterQueryVoucherAsOnPreviousYearDate(reportSearch) + this.getFilterQueryGL(reportSearch) + " GROUP BY  SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + "),d.dept_name ";
            sql = sql + "order by 2,1 ";
            query = this.persistenceService.getSession().createSQLQuery(sql).addScalar("accCode", (Type)StringType.INSTANCE).addScalar("amount", (Type)BigDecimalType.INSTANCE).addScalar("isMajor", (Type)BooleanType.INSTANCE).addScalar("deptName", (Type)StringType.INSTANCE).setResultTransformer(Transformers.aliasToBean(CommonReportBean.class));
        } else {
            sql = reportSearch.getIncExp().equalsIgnoreCase("E") ? "SELECT coa.majorcode as accCode,coa.name as accName,(SUM(gl.debitamount)-SUM(gl.creditamount)) AS amount,1 as isMajor " : "SELECT coa.majorcode as accCode,coa.name as accName,(SUM(gl.creditamount)-SUM(gl.debitamount)) AS amount,1 as isMajor ";
            sql = sql + " FROM GENERALLEDGER gl,FUNCTION fn,VOUCHERHEADER vh, CHARTOFACCOUNTS coa,vouchermis vmis  " + " WHERE vh.id=vmis.voucherheaderid and vh.ID=gl.voucherheaderid AND SUBSTR(gl.glcode,1," + reportSearch.getMajorCodeLen() + ")=coa.glcode AND coa.TYPE='" + reportSearch.getIncExp() + "' " + " AND fn.id = gl.functionid " + this.getFilterQueryVoucherAsOnPreviousYearDate(reportSearch) + this.getFilterQueryGL(reportSearch) + " GROUP BY coa.majorcode,coa.name ";
            sql = reportSearch.getIncExp().equalsIgnoreCase("E") ? sql + " Union SELECT SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + ") as accCode, coa.name  as accName,(SUM(gl.debitamount)-SUM(gl.creditamount)) AS amount ,0 as isMajor " : sql + " Union SELECT SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + ") as accCode, coa.name  as accName,(SUM(gl.creditamount)-SUM(gl.debitamount)) AS amount ,0 as isMajor ";
            sql = sql + " FROM GENERALLEDGER gl,FUNCTION fn,VOUCHERHEADER vh, CHARTOFACCOUNTS coa,vouchermis vmis " + " WHERE vh.id=vmis.voucherheaderid and vh.ID=gl.voucherheaderid AND SUBSTR(gl.glcode,1," + reportSearch.getMinorCodeLen() + ")=coa.glcode AND coa.TYPE='" + reportSearch.getIncExp() + "' " + " AND fn.id = gl.functionid " + this.getFilterQueryVoucherAsOnPreviousYearDate(reportSearch) + this.getFilterQueryGL(reportSearch) + " GROUP BY SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + "),coa.name order by 1,2 ";
            query = this.persistenceService.getSession().createSQLQuery(sql).addScalar("accCode", (Type)StringType.INSTANCE).addScalar("amount", (Type)BigDecimalType.INSTANCE).addScalar("isMajor", (Type)BooleanType.INSTANCE).setResultTransformer(Transformers.aliasToBean(CommonReportBean.class));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("sql===" + sql));
        }
        List list = query.list();
        return list;
    }

    public void populateData(FunctionwiseIE functionwiseIE, ReportSearch reportSearch) throws ApplicationException, ParseException {
        this.getMajorCodeList(functionwiseIE, reportSearch);
        this.getAmountList(functionwiseIE, reportSearch);
    }

    public List<CommonReportBean> populateDataWithBudget(FunctionwiseIE functionwiseIE, ReportSearch reportSearch) throws ApplicationException, ParseException {
        String capExpCode = ((AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "coa_major_capital_exp_fie_report").get(0)).getValue();
        String[] temp = capExpCode.split(",");
        String capExpCodes = "";
        for (String element : temp) {
            capExpCodes = capExpCodes + " or coa.glcode like '" + element + "%'";
        }
        this.capExpCodeCond = capExpCodes;
        String capExpCodesWithQuotes = "";
        for (int i = 0; i < temp.length; ++i) {
            capExpCodesWithQuotes = capExpCodesWithQuotes + "'" + temp[i] + "'";
            if (i == temp.length - 1) continue;
            capExpCodesWithQuotes = capExpCodesWithQuotes + ",";
        }
        this.capExpCodesWithQuotesCond = capExpCodesWithQuotes;
        List<CommonReportBean> minorAndMajorCodeList = this.getMinorAndMajorCodeList(reportSearch);
        if (reportSearch.getIncExp().equalsIgnoreCase("E")) {
            List<CommonReportBean> minorAndMajorCodeListForCapitalExp = this.getMinorAndMajorCodeListForCapitalExp(reportSearch);
            minorAndMajorCodeList.addAll(minorAndMajorCodeListForCapitalExp);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"deptName\t Acccode\t Name\t Amount");
        }
        List<CommonReportBean> amountListForMinorCode = this.getAmountListForMinorCode(functionwiseIE, reportSearch);
        List<CommonReportBean> amountPreviousyearListForMinorCode = this.getPreviousYearAmountListForMinorCode(functionwiseIE, reportSearch);
        this.print(amountListForMinorCode);
        StringBuffer queryStr = this.getBudgetQueryForMinorCodes(reportSearch);
        List<CommonReportBean> beAmountListForMinorCode = this.getBudgetAmountListForMinorCode(reportSearch, "BE", queryStr.toString());
        this.print(beAmountListForMinorCode);
        List<CommonReportBean> reAmountListForMinorCode = this.getBudgetAmountListForMinorCode(reportSearch, "RE", queryStr.toString());
        this.print(reAmountListForMinorCode);
        StringBuffer reappQueryStr = this.getBudgetReappQueryForMinorCodes(reportSearch);
        List<CommonReportBean> beappAmountListForMinorCode = this.getBudgetApprAmountListForMinorCode(reportSearch, "BE", reappQueryStr.toString());
        List<CommonReportBean> reappAmountListForMinorCode = this.getBudgetApprAmountListForMinorCode(reportSearch, "RE", reappQueryStr.toString());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"beappAmountListForMinorCode---------------------------------------------------------------------------------------");
        }
        this.print(beappAmountListForMinorCode);
        Map<String, CommonReportBean> minorCodeAmountMap = this.loadIntoMap(amountListForMinorCode, reportSearch);
        Map<String, CommonReportBean> beAmountMap = this.loadIntoMap(beAmountListForMinorCode, reportSearch);
        Map<String, CommonReportBean> reAmountMap = this.loadIntoMap(reAmountListForMinorCode, reportSearch);
        Map<String, CommonReportBean> reAppAmountMap = this.loadIntoMap(reappAmountListForMinorCode, reportSearch);
        Map<String, CommonReportBean> beAppAmountMap = this.loadIntoMap(beappAmountListForMinorCode, reportSearch);
        Map<String, CommonReportBean> prevousAmountMap = this.loadIntoMap(amountPreviousyearListForMinorCode, reportSearch);
        new ArrayList();
        BigDecimal beSum = BigDecimal.ZERO;
        BigDecimal reSum = BigDecimal.ZERO;
        BigDecimal beAppSum = BigDecimal.ZERO;
        BigDecimal reAppSum = BigDecimal.ZERO;
        BigDecimal amountSum = BigDecimal.ZERO;
        BigDecimal pyAmountSum = BigDecimal.ZERO;
        if (reportSearch.getByDepartment() && !reportSearch.getByDetailCode()) {
            ArrayList<CommonReportBean> deptWiseWithBudgetList = new ArrayList<CommonReportBean>();
            for (Department dept : reportSearch.getDeptList()) {
                for (CommonReportBean bean : minorAndMajorCodeList) {
                    String accCode = dept.getName() + "-" + bean.getAccCode();
                    CommonReportBean crb = new CommonReportBean();
                    crb.setName(bean.getName());
                    crb.setDeptName(dept.getName());
                    crb.setAccCode(bean.getAccCode());
                    CommonReportBean glCRB = minorCodeAmountMap.get(accCode);
                    CommonReportBean pyglCRB = prevousAmountMap.get(accCode);
                    CommonReportBean beCRB = beAmountMap.get(accCode);
                    CommonReportBean reCRB = reAmountMap.get(accCode);
                    CommonReportBean reAppCRB = reAppAmountMap.get(accCode);
                    CommonReportBean beAppCRB = beAppAmountMap.get(accCode);
                    if (glCRB != null) {
                        crb.setAmount(glCRB.getAmount());
                        if (!glCRB.getIsMajor().booleanValue()) {
                            BigDecimal bigDecimal = amountSum = glCRB.getAmount() == null ? amountSum.add(BigDecimal.ZERO) : amountSum.add(glCRB.getAmount());
                        }
                    }
                    if (pyglCRB != null) {
                        crb.setPyAmount(pyglCRB.getAmount());
                        if (!pyglCRB.getIsMajor().booleanValue()) {
                            BigDecimal bigDecimal = pyAmountSum = pyglCRB.getAmount() == null ? pyAmountSum.add(BigDecimal.ZERO) : pyAmountSum.add(pyglCRB.getAmount());
                        }
                    }
                    if (beCRB != null) {
                        crb.setBeAmount(beCRB.getAmount());
                        if (!beCRB.getIsMajor().booleanValue()) {
                            BigDecimal bigDecimal = beSum = beCRB.getAmount() == null ? beSum.add(BigDecimal.ZERO) : beSum.add(beCRB.getAmount());
                        }
                    }
                    if (reCRB != null) {
                        crb.setReAmount(reCRB.getAmount());
                        if (!reCRB.getIsMajor().booleanValue()) {
                            BigDecimal bigDecimal = reSum = reCRB.getAmount() == null ? reSum.add(BigDecimal.ZERO) : reSum.add(reCRB.getAmount());
                        }
                    }
                    if (reAppCRB != null) {
                        crb.setReAppAmount(reAppCRB.getAmount());
                        if (!reAppCRB.getIsMajor().booleanValue()) {
                            BigDecimal bigDecimal = reAppSum = reAppCRB.getAmount() == null ? reAppSum.add(BigDecimal.ZERO) : reAppSum.add(reAppCRB.getAmount());
                        }
                    }
                    if (beAppCRB != null) {
                        crb.setBeAppAmount(beAppCRB.getAmount());
                        if (!beAppCRB.getIsMajor().booleanValue()) {
                            beAppSum = beAppCRB.getAmount() == null ? beAppSum.add(BigDecimal.ZERO) : beAppSum.add(beAppCRB.getAmount());
                        }
                    }
                    deptWiseWithBudgetList.add(crb);
                }
            }
            CommonReportBean totalCrb = new CommonReportBean("", "TOTAL", beSum, reSum, beAppSum, reAppSum, amountSum, pyAmountSum);
            deptWiseWithBudgetList.add(totalCrb);
            return deptWiseWithBudgetList;
        }
        for (CommonReportBean crb : minorAndMajorCodeList) {
            String accCode = crb.getAccCode();
            CommonReportBean glCRB = minorCodeAmountMap.get(accCode);
            CommonReportBean pyglCRB = prevousAmountMap.get(accCode);
            CommonReportBean beCRB = beAmountMap.get(accCode);
            CommonReportBean reCRB = reAmountMap.get(accCode);
            CommonReportBean reAppCRB = reAppAmountMap.get(accCode);
            CommonReportBean beAppCRB = beAppAmountMap.get(accCode);
            if (glCRB != null) {
                crb.setAmount(glCRB.getAmount());
                if (!glCRB.getIsMajor().booleanValue()) {
                    BigDecimal bigDecimal = amountSum = glCRB.getAmount() == null ? amountSum.add(BigDecimal.ZERO) : amountSum.add(glCRB.getAmount());
                }
            }
            if (pyglCRB != null) {
                crb.setPyAmount(pyglCRB.getAmount());
                if (!pyglCRB.getIsMajor().booleanValue()) {
                    BigDecimal bigDecimal = pyAmountSum = pyglCRB.getAmount() == null ? pyAmountSum.add(BigDecimal.ZERO) : pyAmountSum.add(pyglCRB.getAmount());
                }
            }
            if (beCRB != null) {
                crb.setBeAmount(beCRB.getAmount());
                if (!beCRB.getIsMajor().booleanValue()) {
                    BigDecimal bigDecimal = beSum = beCRB.getAmount() == null ? beSum.add(BigDecimal.ZERO) : beSum.add(beCRB.getAmount());
                }
            }
            if (reCRB != null) {
                crb.setReAmount(reCRB.getAmount());
                if (!reCRB.getIsMajor().booleanValue()) {
                    BigDecimal bigDecimal = reSum = reCRB.getAmount() == null ? reSum.add(BigDecimal.ZERO) : reSum.add(reCRB.getAmount());
                }
            }
            if (reAppCRB != null) {
                crb.setReAppAmount(reAppCRB.getAmount());
                if (!reAppCRB.getIsMajor().booleanValue()) {
                    BigDecimal bigDecimal = reAppSum = reAppCRB.getAmount() == null ? reAppSum.add(BigDecimal.ZERO) : reAppSum.add(reAppCRB.getAmount());
                }
            }
            if (beAppCRB == null) continue;
            crb.setBeAppAmount(beAppCRB.getAmount());
            if (beAppCRB.getIsMajor().booleanValue()) continue;
            beAppSum = beAppCRB.getAmount() == null ? beAppSum.add(BigDecimal.ZERO) : beAppSum.add(beAppCRB.getAmount());
        }
        CommonReportBean totalCrb = new CommonReportBean("", "TOTAL", beSum, reSum, beAppSum, reAppSum, amountSum, pyAmountSum);
        minorAndMajorCodeList.add(totalCrb);
        return minorAndMajorCodeList;
    }

    public List<CommonReportBean> populateIncomeDataWithBudget(FunctionwiseIE functionwiseIE, ReportSearch reportSearch) throws ApplicationException, ParseException {
        List<CommonReportBean> minorAndMajorCodeList = this.getIncomeMinorAndMajorCodeList(reportSearch);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"deptName\t Acccode\t Name\t Amount");
        }
        List<CommonReportBean> amountListForMinorCode = this.getAmountListForMinorCode(functionwiseIE, reportSearch);
        List<CommonReportBean> amountPreviousyearListForMinorCode = this.getPreviousYearAmountListForMinorCode(functionwiseIE, reportSearch);
        StringBuffer queryStr = this.getBudgetQueryForMinorCodes(reportSearch);
        List<CommonReportBean> beAmountListForMinorCode = this.getBudgetAmountListForMinorCode(reportSearch, "BE", queryStr.toString());
        List<CommonReportBean> reAmountListForMinorCode = this.getBudgetAmountListForMinorCode(reportSearch, "RE", queryStr.toString());
        Map<String, CommonReportBean> minorCodeAmountMap = this.loadIntoMap(amountListForMinorCode, reportSearch);
        Map<String, CommonReportBean> beAmountMap = this.loadIntoMap(beAmountListForMinorCode, reportSearch);
        Map<String, CommonReportBean> reAmountMap = this.loadIntoMap(reAmountListForMinorCode, reportSearch);
        Map<String, CommonReportBean> prevousAmountMap = this.loadIntoMap(amountPreviousyearListForMinorCode, reportSearch);
        new ArrayList();
        BigDecimal beTotal = BigDecimal.ZERO;
        BigDecimal reTotal = BigDecimal.ZERO;
        BigDecimal previousSum = BigDecimal.ZERO;
        BigDecimal amountSum = BigDecimal.ZERO;
        if (reportSearch.getByDepartment() && !reportSearch.getByDetailCode()) {
            ArrayList<CommonReportBean> deptWiseWithBudgetList = new ArrayList<CommonReportBean>();
            for (Department dept : reportSearch.getDeptList()) {
                for (CommonReportBean bean : minorAndMajorCodeList) {
                    String accCode = dept.getName() + "-" + bean.getAccCode();
                    CommonReportBean crb = new CommonReportBean();
                    crb.setName(bean.getName());
                    crb.setDeptName(dept.getName());
                    crb.setAccCode(bean.getAccCode());
                    CommonReportBean glCRB = minorCodeAmountMap.get(accCode);
                    CommonReportBean pyglCRB = prevousAmountMap.get(accCode);
                    CommonReportBean objBE = beAmountMap.get(accCode);
                    CommonReportBean objRE = reAmountMap.get(accCode);
                    if (glCRB != null) {
                        crb.setAmount(glCRB.getAmount());
                        if (!glCRB.getIsMajor().booleanValue()) {
                            BigDecimal bigDecimal = amountSum = glCRB.getAmount() == null ? amountSum.add(BigDecimal.ZERO) : amountSum.add(glCRB.getAmount());
                        }
                    }
                    if (pyglCRB != null) {
                        crb.setPyAmount(pyglCRB.getAmount());
                        if (!pyglCRB.getIsMajor().booleanValue()) {
                            BigDecimal bigDecimal = previousSum = pyglCRB.getAmount() == null ? previousSum.add(BigDecimal.ZERO) : previousSum.add(pyglCRB.getAmount());
                        }
                    }
                    if (objBE != null) {
                        crb.setBeAmount(objBE.getAmount());
                        if (!objBE.getIsMajor().booleanValue()) {
                            BigDecimal bigDecimal = beTotal = objBE.getAmount() == null ? beTotal.add(BigDecimal.ZERO) : beTotal.add(objBE.getAmount());
                        }
                    }
                    if (objRE != null) {
                        crb.setReAmount(objRE.getAmount());
                        if (!objRE.getIsMajor().booleanValue()) {
                            reTotal = objRE.getAmount() == null ? reTotal.add(BigDecimal.ZERO) : reTotal.add(objRE.getAmount());
                        }
                    }
                    deptWiseWithBudgetList.add(crb);
                }
            }
            CommonReportBean totalCrb = new CommonReportBean("", "TOTAL", beTotal, reTotal, null, null, amountSum, previousSum);
            deptWiseWithBudgetList.add(totalCrb);
            return deptWiseWithBudgetList;
        }
        for (CommonReportBean crb : minorAndMajorCodeList) {
            String accCode = crb.getAccCode();
            CommonReportBean glCRB = minorCodeAmountMap.get(accCode);
            CommonReportBean pyglCRB = prevousAmountMap.get(accCode);
            CommonReportBean objBE = beAmountMap.get(accCode);
            CommonReportBean objRE = reAmountMap.get(accCode);
            if (glCRB != null) {
                crb.setAmount(glCRB.getAmount());
                if (!glCRB.getIsMajor().booleanValue()) {
                    BigDecimal bigDecimal = amountSum = glCRB.getAmount() == null ? amountSum.add(BigDecimal.ZERO) : amountSum.add(glCRB.getAmount());
                }
            }
            if (pyglCRB != null) {
                crb.setPyAmount(pyglCRB.getAmount());
                if (!pyglCRB.getIsMajor().booleanValue()) {
                    BigDecimal bigDecimal = previousSum = pyglCRB.getAmount() == null ? previousSum.add(BigDecimal.ZERO) : previousSum.add(pyglCRB.getAmount());
                }
            }
            if (objBE != null) {
                crb.setBeAmount(objBE.getAmount());
                if (!objBE.getIsMajor().booleanValue()) {
                    BigDecimal bigDecimal = beTotal = objBE.getAmount() == null ? beTotal.add(BigDecimal.ZERO) : beTotal.add(objBE.getAmount());
                }
            }
            if (objRE == null) continue;
            crb.setReAmount(objRE.getAmount());
            if (objRE.getIsMajor().booleanValue()) continue;
            reTotal = objRE.getAmount() == null ? reTotal.add(BigDecimal.ZERO) : reTotal.add(objRE.getAmount());
        }
        CommonReportBean totalCrb = new CommonReportBean("", "TOTAL", beTotal, reTotal, null, null, amountSum, previousSum);
        minorAndMajorCodeList.add(totalCrb);
        return minorAndMajorCodeList;
    }

    private Map<String, CommonReportBean> loadIntoMap(List<CommonReportBean> amountList, ReportSearch reportSearch) {
        LinkedHashMap<String, CommonReportBean> amountMap = new LinkedHashMap<String, CommonReportBean>();
        for (CommonReportBean crb : amountList) {
            if (reportSearch.getByDepartment() && !reportSearch.getByDetailCode()) {
                amountMap.put(crb.getDeptName() + "-" + crb.getAccCode(), crb);
                continue;
            }
            amountMap.put(crb.getAccCode(), crb);
        }
        return amountMap;
    }

    private void print(List<CommonReportBean> crbList) {
        if (LOGGER.isDebugEnabled()) {
            for (CommonReportBean crb : crbList) {
                if (crb.isZero() || !LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)crb.toString());
            }
        }
    }

    private List<CommonReportBean> getBudgetApprAmountListForMinorCode(ReportSearch reportSearch, String isBeRe, String queryStr) {
        Query query = null;
        if (reportSearch.getAsOnDate().getMonth() == 2 && reportSearch.getAsOnDate().getDate() == 31) {
            if (reportSearch.getByDepartment()) {
                query = this.persistenceService.getSession().createSQLQuery(queryStr).addScalar("accCode", (Type)StringType.INSTANCE).addScalar("amount", (Type)BigDecimalType.INSTANCE).addScalar("isMajor", (Type)BooleanType.INSTANCE).addScalar("deptName", (Type)StringType.INSTANCE).setString("isBeRe", isBeRe).setLong("finYearId", reportSearch.getFinYearId().longValue()).setInteger("fundId", reportSearch.getFund().getId().intValue()).setResultTransformer(Transformers.aliasToBean(CommonReportBean.class));
                if (reportSearch.getFunction() != null && reportSearch.getFunction().getId() != null && reportSearch.getFunction().getId() != -1L) {
                    query.setLong("functionId", reportSearch.getFunction().getId().longValue());
                }
                if (reportSearch.getByDetailCode()) {
                    query.setString("deptName", reportSearch.getDepartment().getName());
                    query.setString("glcode", reportSearch.getGlcode() + "%");
                } else {
                    query.setLong("FIEscheduleId", reportSearch.getFIEscheduleId().longValue());
                }
            } else {
                query = this.persistenceService.getSession().createSQLQuery(queryStr).addScalar("accCode", (Type)StringType.INSTANCE).addScalar("amount", (Type)BigDecimalType.INSTANCE).addScalar("isMajor", (Type)BooleanType.INSTANCE).setString("isBeRe", isBeRe).setLong("finYearId", reportSearch.getFinYearId().longValue()).setInteger("fundId", reportSearch.getFund().getId().intValue()).setResultTransformer(Transformers.aliasToBean(CommonReportBean.class));
                if (reportSearch.getFunction() != null && reportSearch.getFunction().getId() != null && reportSearch.getFunction().getId() != -1L) {
                    query.setLong("functionId", reportSearch.getFunction().getId().longValue());
                }
            }
        } else if (reportSearch.getByDepartment()) {
            query = this.persistenceService.getSession().createSQLQuery(queryStr).addScalar("accCode", (Type)StringType.INSTANCE).addScalar("amount", (Type)BigDecimalType.INSTANCE).addScalar("isMajor", (Type)BooleanType.INSTANCE).addScalar("deptName", (Type)StringType.INSTANCE).setString("isBeRe", isBeRe).setDate("asOnDate", reportSearch.getAsOnDate()).setLong("finYearId", reportSearch.getFinYearId().longValue()).setInteger("fundId", reportSearch.getFund().getId().intValue()).setResultTransformer(Transformers.aliasToBean(CommonReportBean.class));
            if (reportSearch.getFunction() != null && reportSearch.getFunction().getId() != null && reportSearch.getFunction().getId() != -1L) {
                query.setLong("functionId", reportSearch.getFunction().getId().longValue());
            }
            if (reportSearch.getByDetailCode()) {
                query.setString("deptName", reportSearch.getDepartment().getName());
                query.setString("glcode", reportSearch.getGlcode() + "%");
            } else {
                query.setLong("FIEscheduleId", reportSearch.getFIEscheduleId().longValue());
            }
        } else {
            query = this.persistenceService.getSession().createSQLQuery(queryStr).addScalar("accCode", (Type)StringType.INSTANCE).addScalar("amount", (Type)BigDecimalType.INSTANCE).addScalar("isMajor", (Type)BooleanType.INSTANCE).setString("isBeRe", isBeRe).setDate("asOnDate", reportSearch.getAsOnDate()).setLong("finYearId", reportSearch.getFinYearId().longValue()).setInteger("fundId", reportSearch.getFund().getId().intValue()).setResultTransformer(Transformers.aliasToBean(CommonReportBean.class));
            if (reportSearch.getFunction() != null && reportSearch.getFunction().getId() != null && reportSearch.getFunction().getId() != -1L) {
                query.setLong("functionId", reportSearch.getFunction().getId().longValue());
            }
        }
        return query.list();
    }

    private List<CommonReportBean> getBudgetAmountListForMinorCode(ReportSearch reportSearch, String isBeRe, String queryStr) {
        Query query = null;
        if (reportSearch.getByDepartment()) {
            query = this.persistenceService.getSession().createSQLQuery(queryStr).addScalar("accCode", (Type)StringType.INSTANCE).addScalar("amount", (Type)BigDecimalType.INSTANCE).addScalar("isMajor", (Type)BooleanType.INSTANCE).addScalar("deptName", (Type)StringType.INSTANCE).setString("isBeRe", isBeRe).setDate("asOnDate", reportSearch.getAsOnDate()).setLong("finYearId", reportSearch.getFinYearId().longValue()).setInteger("fundId", reportSearch.getFund().getId().intValue()).setResultTransformer(Transformers.aliasToBean(CommonReportBean.class));
            if (reportSearch.getFunction() != null && reportSearch.getFunction().getId() != null && reportSearch.getFunction().getId() != -1L) {
                query.setLong("functionId", reportSearch.getFunction().getId().longValue());
            }
            if (reportSearch.getByDetailCode()) {
                query.setString("deptName", reportSearch.getDepartment().getName());
                query.setString("glcode", reportSearch.getGlcode() + "%");
            } else {
                query.setLong("FIEscheduleId", reportSearch.getFIEscheduleId().longValue());
            }
        } else {
            query = this.persistenceService.getSession().createSQLQuery(queryStr).addScalar("accCode", (Type)StringType.INSTANCE).addScalar("amount", (Type)BigDecimalType.INSTANCE).addScalar("isMajor", (Type)BooleanType.INSTANCE).setString("isBeRe", isBeRe).setDate("asOnDate", reportSearch.getAsOnDate()).setLong("finYearId", reportSearch.getFinYearId().longValue()).setInteger("fundId", reportSearch.getFund().getId().intValue()).setResultTransformer(Transformers.aliasToBean(CommonReportBean.class));
            if (reportSearch.getFunction() != null && reportSearch.getFunction().getId() != null && reportSearch.getFunction().getId() != -1L) {
                query.setLong("functionId", reportSearch.getFunction().getId().longValue());
            }
        }
        return query.list();
    }

    private StringBuffer getBudgetQueryForMinorCodes(ReportSearch reportSearch) {
        StringBuffer queryStr = new StringBuffer(1024);
        queryStr.append(" select SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + ") as accCode, sum(bd.approvedamount) as amount ,0 as isMajor ");
        if (reportSearch.getByDepartment()) {
            queryStr.append(",d.dept_name  as deptName ");
        }
        queryStr.append(" from egf_budgetdetail bd , egf_budgetgroup bg,egf_budget b, chartofaccounts coa, eg_wf_states wfs");
        if (reportSearch.getByDetailCode()) {
            queryStr.append(",eg_department d");
        } else if (reportSearch.getByDepartment()) {
            queryStr.append(",eg_department d, chartofaccounts minorcoa");
        }
        queryStr.append(" where ((bg.maxcode<=coa.id and bg.mincode>=coa.id) or bg.majorcode=coa.id ) and bd.budgetgroup= bg.id   and bd.state_id=wfs.id and wfs.created_date<=:asOnDate and wfs.value='END' ");
        queryStr.append(" and bd.budget=b.id and b.isbere=:isBeRe and b.financialyearid=:finYearId and bd.fund=:fundId ");
        if (reportSearch.getByDetailCode()) {
            queryStr.append(" and d.id_dept=bd.executing_department and d.dept_name=:deptName and coa.glcode like :glcode ");
        } else if (reportSearch.getByDepartment()) {
            queryStr.append(" and d.id_dept=bd.executing_department  and minorcoa.FIEscheduleId=:FIEscheduleId and  SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + ")=minorcoa.glcode ");
        }
        if (reportSearch.getFunction() != null && reportSearch.getFunction().getId() != null && reportSearch.getFunction().getId() != -1L) {
            queryStr.append("  and bd.function=:functionId ");
        }
        if (reportSearch.getIncExp().equals("E")) {
            queryStr.append(" and (coa.type='E'" + this.capExpCodeCond + ") group by SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + ")");
        } else {
            queryStr.append(" and (coa.type='I') group by SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + ")");
        }
        if (reportSearch.getByDepartment()) {
            queryStr.append(" ,d.dept_name ");
        }
        if (!reportSearch.getByDepartment()) {
            queryStr.append(" UNION ");
            queryStr.append(" select coa.majorCode as accCode, sum(bd.approvedamount) as amount,1 as isMajor ");
            if (reportSearch.getByDepartment()) {
                queryStr.append(",d.dept_name  as deptName ");
            }
            queryStr.append(" from egf_budgetdetail bd , egf_budgetgroup bg,egf_budget b, chartofaccounts coa, eg_wf_states wfs ");
            if (reportSearch.getByDepartment()) {
                queryStr.append(",eg_department d");
            }
            queryStr.append("where ((bg.maxcode<=coa.id and bg.mincode>=coa.id) or bg.majorcode=coa.id ) and bd.budgetgroup= bg.id  and bd.budget=b.id and  bd.state_id=wfs.id and wfs.created_date<=:asOnDate and wfs.value='END'  and b.isbere=:isBeRe and b.financialyearid=:finYearId and bd.fund=:fundId  ");
            if (reportSearch.getByDepartment()) {
                queryStr.append(" and d.id_dept=bd.executing_department and coa.FIEscheduleId=:FIEscheduleId ");
            }
            if (reportSearch.getFunction() != null && reportSearch.getFunction().getId() != null && reportSearch.getFunction().getId() != -1L) {
                queryStr.append("  and bd.function=:functionId ");
            }
            if (reportSearch.getIncExp().equals("E")) {
                queryStr.append(" and (coa.type='E'" + this.capExpCodeCond + ") and coa.majorcode is not null  group by coa.majorCode ");
            } else {
                queryStr.append(" and (coa.type='I') and coa.majorcode is not null  group by coa.majorCode ");
            }
            if (reportSearch.getByDepartment()) {
                queryStr.append(" d.dept_name");
            }
        }
        queryStr.append(" order by 3,1");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("query is " + queryStr.toString()));
        }
        return queryStr;
    }

    private StringBuffer getBudgetReappQueryForMinorCodes(ReportSearch reportSearch) {
        StringBuffer queryStr = new StringBuffer(1024);
        queryStr.append(" select SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + ") as accCode, sum(bdr.addition_amount- bdr.deduction_amount) as amount ,0 as isMajor ");
        if (reportSearch.getByDepartment()) {
            queryStr.append(",d.dept_name  as deptName ");
        }
        queryStr.append(" from egf_budgetdetail bd , egf_budgetgroup bg,egf_budget b, chartofaccounts coa, egf_budget_reappropriation bdr,eg_wf_states wfs");
        if (reportSearch.getByDetailCode()) {
            queryStr.append(",eg_department d");
        } else if (reportSearch.getByDepartment()) {
            queryStr.append(",eg_department d,chartofaccounts minorcoa ");
        }
        queryStr.append(" where ((bg.maxcode<=coa.id and bg.mincode>=coa.id) or bg.majorcode=coa.id ) and bd.budgetgroup= bg.id  and bdr.budgetdetail=bd.id and bdr.state_id=wfs.id and wfs.value='END' ");
        if (reportSearch.getAsOnDate().getMonth() != 2 || reportSearch.getAsOnDate().getDate() != 31) {
            queryStr.append(" and wfs.created_date<=:asOnDate ");
        }
        queryStr.append(" and bd.budget=b.id and b.isbere=:isBeRe and b.financialyearid=:finYearId and bd.fund=:fundId ");
        if (reportSearch.getFunction() != null && reportSearch.getFunction().getId() != null && reportSearch.getFunction().getId() != -1L) {
            queryStr.append("  and bd.function=:functionId ");
        }
        if (reportSearch.getByDetailCode()) {
            queryStr.append(" and d.id_dept=bd.executing_department and d.dept_name=:deptName and coa.glcode like :glcode   ");
        } else if (reportSearch.getByDepartment()) {
            queryStr.append(" and d.id_dept=bd.executing_department and minorcoa.FIEscheduleId=:FIEscheduleId and  SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + ")=minorcoa.glcode ");
        }
        queryStr.append(" and (coa.type='E'" + this.capExpCodeCond + ") group by SUBSTR(coa.glcode,1," + reportSearch.getMinorCodeLen() + ")");
        if (reportSearch.getByDepartment()) {
            queryStr.append(" ,d.dept_name ");
        }
        if (!reportSearch.getByDepartment()) {
            queryStr.append(" UNION ");
            queryStr.append(" select SUBSTR(coa.glcode,1," + reportSearch.getMajorCodeLen() + ") as accCode, sum(bdr.addition_amount- bdr.deduction_amount) as amount,1 as isMajor ");
            if (reportSearch.getByDepartment()) {
                queryStr.append(",bd.executing_derpartment  as deptName ");
            }
            queryStr.append(" from egf_budgetdetail bd , egf_budgetgroup bg,egf_budget b, chartofaccounts coa,eg_wf_states wfs,egf_budget_reappropriation bdr where ((bg.maxcode<=coa.id and bg.mincode>=coa.id) or bg.majorcode=coa.id ) and bd.budgetgroup= bg.id   and bdr.budgetdetail=bd.id and bd.budget=b.id and bdr.state_id=wfs.id  and wfs.value='END' and b.isbere=:isBeRe and b.financialyearid=:finYearId and bd.fund=:fundId ");
            if (reportSearch.getAsOnDate().getMonth() != 2 || reportSearch.getAsOnDate().getDate() != 31) {
                queryStr.append(" and wfs.created_date<=:asOnDate ");
            }
            if (reportSearch.getFunction() != null && reportSearch.getFunction().getId() != null && reportSearch.getFunction().getId() != -1L) {
                queryStr.append("  and bd.function=:functionId ");
            }
            queryStr.append(" and (coa.type='E'" + this.capExpCodeCond + ") group by SUBSTR(coa.glcode,1," + reportSearch.getMajorCodeLen() + ")");
            if (reportSearch.getByDepartment()) {
                queryStr.append(" bd.executing_derpartment ");
            }
        }
        queryStr.append(" order by 1 desc");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("query is " + queryStr.toString()));
        }
        return queryStr;
    }

    public void setReportSearch(ReportSearch reportSearch) {
    }

    public BigDecimal round(BigDecimal value) {
        BigDecimal val = value.setScale(2, 4);
        return val;
    }
}

